# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkPeeringArgs', 'NetworkPeering']

@pulumi.input_type
class NetworkPeeringArgs:
    def __init__(__self__, *,
                 peer_network: pulumi.Input[str],
                 peer_network_type: pulumi.Input[str],
                 vmware_engine_network: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 export_custom_routes: Optional[pulumi.Input[bool]] = None,
                 export_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkPeering resource.
        :param pulumi.Input[str] peer_network: The relative resource name of the network to peer with a standard VMware Engine network.
               The provided network can be a consumer VPC network or another standard VMware Engine network.
        :param pulumi.Input[str] peer_network_type: The type of the network to peer with the VMware Engine network.
               Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        :param pulumi.Input[str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[str] description: User-provided description for this network peering.
        :param pulumi.Input[bool] export_custom_routes: True if custom routes are exported to the peered network; false otherwise.
        :param pulumi.Input[bool] export_custom_routes_with_public_ip: True if all subnet routes with a public IP address range are exported; false otherwise.
        :param pulumi.Input[bool] import_custom_routes: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[bool] import_custom_routes_with_public_ip: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[str] name: The ID of the Network Peering.
               
               
               - - -
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "peer_network", peer_network)
        pulumi.set(__self__, "peer_network_type", peer_network_type)
        pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export_custom_routes is not None:
            pulumi.set(__self__, "export_custom_routes", export_custom_routes)
        if export_custom_routes_with_public_ip is not None:
            pulumi.set(__self__, "export_custom_routes_with_public_ip", export_custom_routes_with_public_ip)
        if import_custom_routes is not None:
            pulumi.set(__self__, "import_custom_routes", import_custom_routes)
        if import_custom_routes_with_public_ip is not None:
            pulumi.set(__self__, "import_custom_routes_with_public_ip", import_custom_routes_with_public_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="peerNetwork")
    def peer_network(self) -> pulumi.Input[str]:
        """
        The relative resource name of the network to peer with a standard VMware Engine network.
        The provided network can be a consumer VPC network or another standard VMware Engine network.
        """
        return pulumi.get(self, "peer_network")

    @peer_network.setter
    def peer_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_network", value)

    @property
    @pulumi.getter(name="peerNetworkType")
    def peer_network_type(self) -> pulumi.Input[str]:
        """
        The type of the network to peer with the VMware Engine network.
        Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        """
        return pulumi.get(self, "peer_network_type")

    @peer_network_type.setter
    def peer_network_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_network_type", value)

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> pulumi.Input[str]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @vmware_engine_network.setter
    def vmware_engine_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmware_engine_network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description for this network peering.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exportCustomRoutes")
    def export_custom_routes(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are exported to the peered network; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes")

    @export_custom_routes.setter
    def export_custom_routes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "export_custom_routes", value)

    @property
    @pulumi.getter(name="exportCustomRoutesWithPublicIp")
    def export_custom_routes_with_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        True if all subnet routes with a public IP address range are exported; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes_with_public_ip")

    @export_custom_routes_with_public_ip.setter
    def export_custom_routes_with_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "export_custom_routes_with_public_ip", value)

    @property
    @pulumi.getter(name="importCustomRoutes")
    def import_custom_routes(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes")

    @import_custom_routes.setter
    def import_custom_routes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_custom_routes", value)

    @property
    @pulumi.getter(name="importCustomRoutesWithPublicIp")
    def import_custom_routes_with_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes_with_public_ip")

    @import_custom_routes_with_public_ip.setter
    def import_custom_routes_with_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_custom_routes_with_public_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Network Peering.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _NetworkPeeringState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_custom_routes: Optional[pulumi.Input[bool]] = None,
                 export_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_network: Optional[pulumi.Input[str]] = None,
                 peer_network_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 state_details: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[str]] = None,
                 vmware_engine_network_canonical: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkPeering resources.
        :param pulumi.Input[str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: User-provided description for this network peering.
        :param pulumi.Input[bool] export_custom_routes: True if custom routes are exported to the peered network; false otherwise.
        :param pulumi.Input[bool] export_custom_routes_with_public_ip: True if all subnet routes with a public IP address range are exported; false otherwise.
        :param pulumi.Input[bool] import_custom_routes: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[bool] import_custom_routes_with_public_ip: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[str] name: The ID of the Network Peering.
               
               
               - - -
        :param pulumi.Input[str] peer_network: The relative resource name of the network to peer with a standard VMware Engine network.
               The provided network can be a consumer VPC network or another standard VMware Engine network.
        :param pulumi.Input[str] peer_network_type: The type of the network to peer with the VMware Engine network.
               Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: State of the network peering.
               This field has a value of 'ACTIVE' when there's a matching configuration in the peer network.
               New values may be added to this enum when appropriate.
        :param pulumi.Input[str] state_details: Details about the current state of the network peering.
        :param pulumi.Input[str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[str] vmware_engine_network_canonical: The canonical name of the VMware Engine network in the form:
               projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export_custom_routes is not None:
            pulumi.set(__self__, "export_custom_routes", export_custom_routes)
        if export_custom_routes_with_public_ip is not None:
            pulumi.set(__self__, "export_custom_routes_with_public_ip", export_custom_routes_with_public_ip)
        if import_custom_routes is not None:
            pulumi.set(__self__, "import_custom_routes", import_custom_routes)
        if import_custom_routes_with_public_ip is not None:
            pulumi.set(__self__, "import_custom_routes_with_public_ip", import_custom_routes_with_public_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_network is not None:
            pulumi.set(__self__, "peer_network", peer_network)
        if peer_network_type is not None:
            pulumi.set(__self__, "peer_network_type", peer_network_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_details is not None:
            pulumi.set(__self__, "state_details", state_details)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if vmware_engine_network is not None:
            pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if vmware_engine_network_canonical is not None:
            pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description for this network peering.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exportCustomRoutes")
    def export_custom_routes(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are exported to the peered network; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes")

    @export_custom_routes.setter
    def export_custom_routes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "export_custom_routes", value)

    @property
    @pulumi.getter(name="exportCustomRoutesWithPublicIp")
    def export_custom_routes_with_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        True if all subnet routes with a public IP address range are exported; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes_with_public_ip")

    @export_custom_routes_with_public_ip.setter
    def export_custom_routes_with_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "export_custom_routes_with_public_ip", value)

    @property
    @pulumi.getter(name="importCustomRoutes")
    def import_custom_routes(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes")

    @import_custom_routes.setter
    def import_custom_routes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_custom_routes", value)

    @property
    @pulumi.getter(name="importCustomRoutesWithPublicIp")
    def import_custom_routes_with_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes_with_public_ip")

    @import_custom_routes_with_public_ip.setter
    def import_custom_routes_with_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_custom_routes_with_public_ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Network Peering.


        - - -
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerNetwork")
    def peer_network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the network to peer with a standard VMware Engine network.
        The provided network can be a consumer VPC network or another standard VMware Engine network.
        """
        return pulumi.get(self, "peer_network")

    @peer_network.setter
    def peer_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_network", value)

    @property
    @pulumi.getter(name="peerNetworkType")
    def peer_network_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the network to peer with the VMware Engine network.
        Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        """
        return pulumi.get(self, "peer_network_type")

    @peer_network_type.setter
    def peer_network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_network_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the network peering.
        This field has a value of 'ACTIVE' when there's a matching configuration in the peer network.
        New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the network peering.
        """
        return pulumi.get(self, "state_details")

    @state_details.setter
    def state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_details", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @vmware_engine_network.setter
    def vmware_engine_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_engine_network", value)

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical name of the VMware Engine network in the form:
        projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")

    @vmware_engine_network_canonical.setter
    def vmware_engine_network_canonical(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_engine_network_canonical", value)


class NetworkPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_custom_routes: Optional[pulumi.Input[bool]] = None,
                 export_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_network: Optional[pulumi.Input[str]] = None,
                 peer_network_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Represents a network peering resource. Network peerings are global resources.

        To get more information about NetworkPeering, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks/addPeering)

        ## Example Usage

        ### Vmware Engine Network Peering Ven

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_peering_nw = gcp.vmwareengine.Network("network-peering-nw",
            name="default-np-nw",
            location="global",
            type="STANDARD")
        network_peering_peer_nw = gcp.vmwareengine.Network("network-peering-peer-nw",
            name="peer-np-nw",
            location="global",
            type="STANDARD")
        vmw_engine_network_peering = gcp.vmwareengine.NetworkPeering("vmw-engine-network-peering",
            name="sample-network-peering",
            description="Sample description",
            vmware_engine_network=network_peering_nw.id,
            peer_network=network_peering_peer_nw.id,
            peer_network_type="VMWARE_ENGINE_NETWORK",
            export_custom_routes=False,
            import_custom_routes=False,
            export_custom_routes_with_public_ip=False,
            import_custom_routes_with_public_ip=False)
        ```
        ### Vmware Engine Network Peering Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_peering_vpc = gcp.compute.Network("network-peering-vpc", name="default-vpc")
        network_peering_standard_nw = gcp.vmwareengine.Network("network-peering-standard-nw",
            name="default-standard-nw-np",
            location="global",
            type="STANDARD")
        vmw_engine_network_peering = gcp.vmwareengine.NetworkPeering("vmw-engine-network-peering",
            name="sample-network-peering",
            description="Sample description",
            peer_network=network_peering_vpc.id,
            peer_network_type="STANDARD",
            vmware_engine_network=network_peering_standard_nw.id)
        ```

        ## Import

        NetworkPeering can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/networkPeerings/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, NetworkPeering can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default projects/{{project}}/locations/global/networkPeerings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: User-provided description for this network peering.
        :param pulumi.Input[bool] export_custom_routes: True if custom routes are exported to the peered network; false otherwise.
        :param pulumi.Input[bool] export_custom_routes_with_public_ip: True if all subnet routes with a public IP address range are exported; false otherwise.
        :param pulumi.Input[bool] import_custom_routes: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[bool] import_custom_routes_with_public_ip: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[str] name: The ID of the Network Peering.
               
               
               - - -
        :param pulumi.Input[str] peer_network: The relative resource name of the network to peer with a standard VMware Engine network.
               The provided network can be a consumer VPC network or another standard VMware Engine network.
        :param pulumi.Input[str] peer_network_type: The type of the network to peer with the VMware Engine network.
               Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a network peering resource. Network peerings are global resources.

        To get more information about NetworkPeering, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks/addPeering)

        ## Example Usage

        ### Vmware Engine Network Peering Ven

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_peering_nw = gcp.vmwareengine.Network("network-peering-nw",
            name="default-np-nw",
            location="global",
            type="STANDARD")
        network_peering_peer_nw = gcp.vmwareengine.Network("network-peering-peer-nw",
            name="peer-np-nw",
            location="global",
            type="STANDARD")
        vmw_engine_network_peering = gcp.vmwareengine.NetworkPeering("vmw-engine-network-peering",
            name="sample-network-peering",
            description="Sample description",
            vmware_engine_network=network_peering_nw.id,
            peer_network=network_peering_peer_nw.id,
            peer_network_type="VMWARE_ENGINE_NETWORK",
            export_custom_routes=False,
            import_custom_routes=False,
            export_custom_routes_with_public_ip=False,
            import_custom_routes_with_public_ip=False)
        ```
        ### Vmware Engine Network Peering Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_peering_vpc = gcp.compute.Network("network-peering-vpc", name="default-vpc")
        network_peering_standard_nw = gcp.vmwareengine.Network("network-peering-standard-nw",
            name="default-standard-nw-np",
            location="global",
            type="STANDARD")
        vmw_engine_network_peering = gcp.vmwareengine.NetworkPeering("vmw-engine-network-peering",
            name="sample-network-peering",
            description="Sample description",
            peer_network=network_peering_vpc.id,
            peer_network_type="STANDARD",
            vmware_engine_network=network_peering_standard_nw.id)
        ```

        ## Import

        NetworkPeering can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/networkPeerings/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, NetworkPeering can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default projects/{{project}}/locations/global/networkPeerings/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:vmwareengine/networkPeering:NetworkPeering default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 export_custom_routes: Optional[pulumi.Input[bool]] = None,
                 export_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes: Optional[pulumi.Input[bool]] = None,
                 import_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_network: Optional[pulumi.Input[str]] = None,
                 peer_network_type: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 vmware_engine_network: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPeeringArgs.__new__(NetworkPeeringArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["export_custom_routes"] = export_custom_routes
            __props__.__dict__["export_custom_routes_with_public_ip"] = export_custom_routes_with_public_ip
            __props__.__dict__["import_custom_routes"] = import_custom_routes
            __props__.__dict__["import_custom_routes_with_public_ip"] = import_custom_routes_with_public_ip
            __props__.__dict__["name"] = name
            if peer_network is None and not opts.urn:
                raise TypeError("Missing required property 'peer_network'")
            __props__.__dict__["peer_network"] = peer_network
            if peer_network_type is None and not opts.urn:
                raise TypeError("Missing required property 'peer_network_type'")
            __props__.__dict__["peer_network_type"] = peer_network_type
            __props__.__dict__["project"] = project
            if vmware_engine_network is None and not opts.urn:
                raise TypeError("Missing required property 'vmware_engine_network'")
            __props__.__dict__["vmware_engine_network"] = vmware_engine_network
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_details"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["vmware_engine_network_canonical"] = None
        super(NetworkPeering, __self__).__init__(
            'gcp:vmwareengine/networkPeering:NetworkPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            export_custom_routes: Optional[pulumi.Input[bool]] = None,
            export_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
            import_custom_routes: Optional[pulumi.Input[bool]] = None,
            import_custom_routes_with_public_ip: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            peer_network: Optional[pulumi.Input[str]] = None,
            peer_network_type: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            state_details: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            vmware_engine_network: Optional[pulumi.Input[str]] = None,
            vmware_engine_network_canonical: Optional[pulumi.Input[str]] = None) -> 'NetworkPeering':
        """
        Get an existing NetworkPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Creation time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
               up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] description: User-provided description for this network peering.
        :param pulumi.Input[bool] export_custom_routes: True if custom routes are exported to the peered network; false otherwise.
        :param pulumi.Input[bool] export_custom_routes_with_public_ip: True if all subnet routes with a public IP address range are exported; false otherwise.
        :param pulumi.Input[bool] import_custom_routes: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[bool] import_custom_routes_with_public_ip: True if custom routes are imported from the peered network; false otherwise.
        :param pulumi.Input[str] name: The ID of the Network Peering.
               
               
               - - -
        :param pulumi.Input[str] peer_network: The relative resource name of the network to peer with a standard VMware Engine network.
               The provided network can be a consumer VPC network or another standard VMware Engine network.
        :param pulumi.Input[str] peer_network_type: The type of the network to peer with the VMware Engine network.
               Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] state: State of the network peering.
               This field has a value of 'ACTIVE' when there's a matching configuration in the peer network.
               New values may be added to this enum when appropriate.
        :param pulumi.Input[str] state_details: Details about the current state of the network peering.
        :param pulumi.Input[str] uid: System-generated unique identifier for the resource.
        :param pulumi.Input[str] update_time: Last updated time of this resource.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
               fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] vmware_engine_network: The relative resource name of the VMware Engine network. Specify the name in the following form:
               projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
               can either be a project number or a project ID.
        :param pulumi.Input[str] vmware_engine_network_canonical: The canonical name of the VMware Engine network in the form:
               projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPeeringState.__new__(_NetworkPeeringState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["export_custom_routes"] = export_custom_routes
        __props__.__dict__["export_custom_routes_with_public_ip"] = export_custom_routes_with_public_ip
        __props__.__dict__["import_custom_routes"] = import_custom_routes
        __props__.__dict__["import_custom_routes_with_public_ip"] = import_custom_routes_with_public_ip
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_network"] = peer_network
        __props__.__dict__["peer_network_type"] = peer_network_type
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        __props__.__dict__["state_details"] = state_details
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["vmware_engine_network"] = vmware_engine_network
        __props__.__dict__["vmware_engine_network_canonical"] = vmware_engine_network_canonical
        return NetworkPeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and
        up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-provided description for this network peering.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exportCustomRoutes")
    def export_custom_routes(self) -> pulumi.Output[Optional[bool]]:
        """
        True if custom routes are exported to the peered network; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes")

    @property
    @pulumi.getter(name="exportCustomRoutesWithPublicIp")
    def export_custom_routes_with_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        True if all subnet routes with a public IP address range are exported; false otherwise.
        """
        return pulumi.get(self, "export_custom_routes_with_public_ip")

    @property
    @pulumi.getter(name="importCustomRoutes")
    def import_custom_routes(self) -> pulumi.Output[Optional[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes")

    @property
    @pulumi.getter(name="importCustomRoutesWithPublicIp")
    def import_custom_routes_with_public_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        True if custom routes are imported from the peered network; false otherwise.
        """
        return pulumi.get(self, "import_custom_routes_with_public_ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The ID of the Network Peering.


        - - -
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerNetwork")
    def peer_network(self) -> pulumi.Output[str]:
        """
        The relative resource name of the network to peer with a standard VMware Engine network.
        The provided network can be a consumer VPC network or another standard VMware Engine network.
        """
        return pulumi.get(self, "peer_network")

    @property
    @pulumi.getter(name="peerNetworkType")
    def peer_network_type(self) -> pulumi.Output[str]:
        """
        The type of the network to peer with the VMware Engine network.
        Possible values are: `STANDARD`, `VMWARE_ENGINE_NETWORK`, `PRIVATE_SERVICES_ACCESS`, `NETAPP_CLOUD_VOLUMES`, `THIRD_PARTY_SERVICE`, `DELL_POWERSCALE`.
        """
        return pulumi.get(self, "peer_network_type")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the network peering.
        This field has a value of 'ACTIVE' when there's a matching configuration in the peer network.
        New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the network peering.
        """
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        System-generated unique identifier for the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Last updated time of this resource.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine
        fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> pulumi.Output[str]:
        """
        The relative resource name of the VMware Engine network. Specify the name in the following form:
        projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId} where {project}
        can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> pulumi.Output[str]:
        """
        The canonical name of the VMware Engine network in the form:
        projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")

