# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterNodeTypeConfig',
    'ExternalAccessRuleDestinationIpRange',
    'ExternalAccessRuleSourceIpRange',
    'NetworkPolicyExternalIp',
    'NetworkPolicyInternetAccess',
    'NetworkVpcNetwork',
    'PrivateCloudHcx',
    'PrivateCloudManagementCluster',
    'PrivateCloudManagementClusterNodeTypeConfig',
    'PrivateCloudManagementClusterStretchedClusterConfig',
    'PrivateCloudNetworkConfig',
    'PrivateCloudNsx',
    'PrivateCloudVcenter',
    'SubnetDhcpAddressRange',
    'GetClusterNodeTypeConfigResult',
    'GetExternalAccessRuleDestinationIpRangeResult',
    'GetExternalAccessRuleSourceIpRangeResult',
    'GetNetworkPolicyExternalIpResult',
    'GetNetworkPolicyInternetAccessResult',
    'GetNetworkVpcNetworkResult',
    'GetPrivateCloudHcxResult',
    'GetPrivateCloudManagementClusterResult',
    'GetPrivateCloudManagementClusterNodeTypeConfigResult',
    'GetPrivateCloudManagementClusterStretchedClusterConfigResult',
    'GetPrivateCloudNetworkConfigResult',
    'GetPrivateCloudNsxResult',
    'GetPrivateCloudVcenterResult',
    'GetSubnetDhcpAddressRangeResult',
]

@pulumi.output_type
class ClusterNodeTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "customCoreCount":
            suggest = "custom_core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: int,
                 node_type_id: str,
                 custom_core_count: Optional[int] = None):
        """
        :param int node_count: The number of nodes of this type in the cluster.
        :param str node_type_id: The identifier for this object. Format specified above.
        :param int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of `nodeType.availableCustomCoreCounts`.
               If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
               Once the customer is created then corecount cannot be changed.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)
        if custom_core_count is not None:
            pulumi.set(__self__, "custom_core_count", custom_core_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> Optional[int]:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of `nodeType.availableCustomCoreCounts`.
        If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
        Once the customer is created then corecount cannot be changed.
        """
        return pulumi.get(self, "custom_core_count")


@pulumi.output_type
class ExternalAccessRuleDestinationIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalAddress":
            suggest = "external_address"
        elif key == "ipAddressRange":
            suggest = "ip_address_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalAccessRuleDestinationIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalAccessRuleDestinationIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalAccessRuleDestinationIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_address: Optional[str] = None,
                 ip_address_range: Optional[str] = None):
        """
        :param str external_address: The name of an `ExternalAddress` resource.
               
               - - -
        :param str ip_address_range: An IP address range in the CIDR format.
        """
        if external_address is not None:
            pulumi.set(__self__, "external_address", external_address)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> Optional[str]:
        """
        The name of an `ExternalAddress` resource.

        - - -
        """
        return pulumi.get(self, "external_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[str]:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class ExternalAccessRuleSourceIpRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipAddressRange":
            suggest = "ip_address_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExternalAccessRuleSourceIpRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExternalAccessRuleSourceIpRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExternalAccessRuleSourceIpRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 ip_address_range: Optional[str] = None):
        """
        :param str ip_address: A single IP address.
        :param str ip_address_range: An IP address range in the CIDR format.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_range is not None:
            pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        A single IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> Optional[str]:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class NetworkPolicyExternalIp(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 state: Optional[str] = None):
        """
        :param bool enabled: True if the service is enabled; false otherwise.
        :param str state: (Output)
               State of the service. New values may be added to this enum when appropriate.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class NetworkPolicyInternetAccess(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 state: Optional[str] = None):
        """
        :param bool enabled: True if the service is enabled; false otherwise.
        :param str state: (Output)
               State of the service. New values may be added to this enum when appropriate.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class NetworkVpcNetwork(dict):
    def __init__(__self__, *,
                 network: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str network: (Output)
               The relative resource name of the service VPC network this VMware Engine network is attached to.
               For example: projects/123123/global/networks/my-network
        :param str type: VMware Engine network type.
               Possible values are: `LEGACY`, `STANDARD`.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        (Output)
        The relative resource name of the service VPC network this VMware Engine network is attached to.
        For example: projects/123123/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        VMware Engine network type.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateCloudHcx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudHcx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudHcx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudHcx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 internal_ip: Optional[str] = None,
                 state: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PrivateCloudManagementCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "nodeTypeConfigs":
            suggest = "node_type_configs"
        elif key == "stretchedClusterConfig":
            suggest = "stretched_cluster_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: str,
                 node_type_configs: Optional[Sequence['outputs.PrivateCloudManagementClusterNodeTypeConfig']] = None,
                 stretched_cluster_config: Optional['outputs.PrivateCloudManagementClusterStretchedClusterConfig'] = None):
        """
        :param str cluster_id: The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
               * Only contains 1-63 alphanumeric characters and hyphens
               * Begins with an alphabetical character
               * Ends with a non-hyphen character
               * Not formatted as a UUID
               * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        :param Sequence['PrivateCloudManagementClusterNodeTypeConfigArgs'] node_type_configs: The map of cluster node types in this cluster,
               where the key is canonical identifier of the node type (corresponds to the NodeType).
               Structure is documented below.
        :param 'PrivateCloudManagementClusterStretchedClusterConfigArgs' stretched_cluster_config: The stretched cluster configuration for the private cloud.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if node_type_configs is not None:
            pulumi.set(__self__, "node_type_configs", node_type_configs)
        if stretched_cluster_config is not None:
            pulumi.set(__self__, "stretched_cluster_config", stretched_cluster_config)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
        * Only contains 1-63 alphanumeric characters and hyphens
        * Begins with an alphabetical character
        * Ends with a non-hyphen character
        * Not formatted as a UUID
        * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="nodeTypeConfigs")
    def node_type_configs(self) -> Optional[Sequence['outputs.PrivateCloudManagementClusterNodeTypeConfig']]:
        """
        The map of cluster node types in this cluster,
        where the key is canonical identifier of the node type (corresponds to the NodeType).
        Structure is documented below.
        """
        return pulumi.get(self, "node_type_configs")

    @property
    @pulumi.getter(name="stretchedClusterConfig")
    def stretched_cluster_config(self) -> Optional['outputs.PrivateCloudManagementClusterStretchedClusterConfig']:
        """
        The stretched cluster configuration for the private cloud.
        Structure is documented below.
        """
        return pulumi.get(self, "stretched_cluster_config")


@pulumi.output_type
class PrivateCloudManagementClusterNodeTypeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeTypeId":
            suggest = "node_type_id"
        elif key == "customCoreCount":
            suggest = "custom_core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterNodeTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterNodeTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterNodeTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_count: int,
                 node_type_id: str,
                 custom_core_count: Optional[int] = None):
        """
        :param int node_count: The number of nodes of this type in the cluster.
        :param str node_type_id: The identifier for this object. Format specified above.
        :param int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of `nodeType.availableCustomCoreCounts`.
               If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
               This cannot be changed once the PrivateCloud is created.
        """
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)
        if custom_core_count is not None:
            pulumi.set(__self__, "custom_core_count", custom_core_count)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "node_type_id")

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> Optional[int]:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of `nodeType.availableCustomCoreCounts`.
        If zero is provided max value from `nodeType.availableCustomCoreCounts` will be used.
        This cannot be changed once the PrivateCloud is created.
        """
        return pulumi.get(self, "custom_core_count")


@pulumi.output_type
class PrivateCloudManagementClusterStretchedClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preferredLocation":
            suggest = "preferred_location"
        elif key == "secondaryLocation":
            suggest = "secondary_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudManagementClusterStretchedClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudManagementClusterStretchedClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudManagementClusterStretchedClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preferred_location: Optional[str] = None,
                 secondary_location: Optional[str] = None):
        """
        :param str preferred_location: Zone that will remain operational when connection between the two zones is lost.
        :param str secondary_location: Additional zone for a higher level of availability and load balancing.
               
               - - -
        """
        if preferred_location is not None:
            pulumi.set(__self__, "preferred_location", preferred_location)
        if secondary_location is not None:
            pulumi.set(__self__, "secondary_location", secondary_location)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> Optional[str]:
        """
        Zone that will remain operational when connection between the two zones is lost.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> Optional[str]:
        """
        Additional zone for a higher level of availability and load balancing.

        - - -
        """
        return pulumi.get(self, "secondary_location")


@pulumi.output_type
class PrivateCloudNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managementCidr":
            suggest = "management_cidr"
        elif key == "dnsServerIp":
            suggest = "dns_server_ip"
        elif key == "managementIpAddressLayoutVersion":
            suggest = "management_ip_address_layout_version"
        elif key == "vmwareEngineNetwork":
            suggest = "vmware_engine_network"
        elif key == "vmwareEngineNetworkCanonical":
            suggest = "vmware_engine_network_canonical"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 management_cidr: str,
                 dns_server_ip: Optional[str] = None,
                 management_ip_address_layout_version: Optional[int] = None,
                 vmware_engine_network: Optional[str] = None,
                 vmware_engine_network_canonical: Optional[str] = None):
        """
        :param str management_cidr: Management CIDR used by VMware management appliances.
        :param str dns_server_ip: (Output)
               DNS Server IP of the Private Cloud.
        :param int management_ip_address_layout_version: (Output)
               The IP address layout version of the management IP address range.
               Possible versions include:
               * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
               as it does not support all features.
               * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
               used by all newly created private clouds. This version supports all current features.
        :param str vmware_engine_network: The relative resource name of the VMware Engine network attached to the private cloud.
               Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
               where {project} can either be a project number or a project ID.
        :param str vmware_engine_network_canonical: (Output)
               The canonical name of the VMware Engine network in
               the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        pulumi.set(__self__, "management_cidr", management_cidr)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if management_ip_address_layout_version is not None:
            pulumi.set(__self__, "management_ip_address_layout_version", management_ip_address_layout_version)
        if vmware_engine_network is not None:
            pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        if vmware_engine_network_canonical is not None:
            pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="managementCidr")
    def management_cidr(self) -> str:
        """
        Management CIDR used by VMware management appliances.
        """
        return pulumi.get(self, "management_cidr")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[str]:
        """
        (Output)
        DNS Server IP of the Private Cloud.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="managementIpAddressLayoutVersion")
    def management_ip_address_layout_version(self) -> Optional[int]:
        """
        (Output)
        The IP address layout version of the management IP address range.
        Possible versions include:
        * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
        as it does not support all features.
        * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
        used by all newly created private clouds. This version supports all current features.
        """
        return pulumi.get(self, "management_ip_address_layout_version")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> Optional[str]:
        """
        The relative resource name of the VMware Engine network attached to the private cloud.
        Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        where {project} can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> Optional[str]:
        """
        (Output)
        The canonical name of the VMware Engine network in
        the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")


@pulumi.output_type
class PrivateCloudNsx(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudNsx. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudNsx.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudNsx.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 internal_ip: Optional[str] = None,
                 state: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PrivateCloudVcenter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "internalIp":
            suggest = "internal_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateCloudVcenter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateCloudVcenter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateCloudVcenter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: Optional[str] = None,
                 internal_ip: Optional[str] = None,
                 state: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance.
               Possible values are: `ACTIVE`, `CREATING`.
        :param str version: Version of the appliance.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if internal_ip is not None:
            pulumi.set(__self__, "internal_ip", internal_ip)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[str]:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> Optional[str]:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        State of the appliance.
        Possible values are: `ACTIVE`, `CREATING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SubnetDhcpAddressRange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firstAddress":
            suggest = "first_address"
        elif key == "lastAddress":
            suggest = "last_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubnetDhcpAddressRange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubnetDhcpAddressRange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubnetDhcpAddressRange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 first_address: Optional[str] = None,
                 last_address: Optional[str] = None):
        """
        :param str first_address: (Output)
               The first IP address of the range.
        :param str last_address: (Output)
               The last IP address of the range.
        """
        if first_address is not None:
            pulumi.set(__self__, "first_address", first_address)
        if last_address is not None:
            pulumi.set(__self__, "last_address", last_address)

    @property
    @pulumi.getter(name="firstAddress")
    def first_address(self) -> Optional[str]:
        """
        (Output)
        The first IP address of the range.
        """
        return pulumi.get(self, "first_address")

    @property
    @pulumi.getter(name="lastAddress")
    def last_address(self) -> Optional[str]:
        """
        (Output)
        The last IP address of the range.
        """
        return pulumi.get(self, "last_address")


@pulumi.output_type
class GetClusterNodeTypeConfigResult(dict):
    def __init__(__self__, *,
                 custom_core_count: int,
                 node_count: int,
                 node_type_id: str):
        """
        :param int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of 'nodeType.availableCustomCoreCounts'.
               If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
               Once the customer is created then corecount cannot be changed.
        :param int node_count: The number of nodes of this type in the cluster.
        """
        pulumi.set(__self__, "custom_core_count", custom_core_count)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> int:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of 'nodeType.availableCustomCoreCounts'.
        If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
        Once the customer is created then corecount cannot be changed.
        """
        return pulumi.get(self, "custom_core_count")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> str:
        return pulumi.get(self, "node_type_id")


@pulumi.output_type
class GetExternalAccessRuleDestinationIpRangeResult(dict):
    def __init__(__self__, *,
                 external_address: str,
                 ip_address_range: str):
        """
        :param str external_address: The name of an 'ExternalAddress' resource.
        :param str ip_address_range: An IP address range in the CIDR format.
        """
        pulumi.set(__self__, "external_address", external_address)
        pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> str:
        """
        The name of an 'ExternalAddress' resource.
        """
        return pulumi.get(self, "external_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> str:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class GetExternalAccessRuleSourceIpRangeResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 ip_address_range: str):
        """
        :param str ip_address: A single IP address.
        :param str ip_address_range: An IP address range in the CIDR format.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_address_range", ip_address_range)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        A single IP address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> str:
        """
        An IP address range in the CIDR format.
        """
        return pulumi.get(self, "ip_address_range")


@pulumi.output_type
class GetNetworkPolicyExternalIpResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 state: str):
        """
        :param bool enabled: True if the service is enabled; false otherwise.
        :param str state: State of the service. New values may be added to this enum when appropriate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetNetworkPolicyInternetAccessResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 state: str):
        """
        :param bool enabled: True if the service is enabled; false otherwise.
        :param str state: State of the service. New values may be added to this enum when appropriate.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if the service is enabled; false otherwise.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the service. New values may be added to this enum when appropriate.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetNetworkVpcNetworkResult(dict):
    def __init__(__self__, *,
                 network: str,
                 type: str):
        """
        :param str network: The relative resource name of the service VPC network this VMware Engine network is attached to.
               For example: projects/123123/global/networks/my-network
        :param str type: Type of VPC network (INTRANET, INTERNET, or GOOGLE_CLOUD)
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The relative resource name of the service VPC network this VMware Engine network is attached to.
        For example: projects/123123/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of VPC network (INTRANET, INTERNET, or GOOGLE_CLOUD)
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPrivateCloudHcxResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 internal_ip: str,
                 state: str,
                 version: str):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPrivateCloudManagementClusterResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 node_type_configs: Sequence['outputs.GetPrivateCloudManagementClusterNodeTypeConfigResult'],
                 stretched_cluster_configs: Sequence['outputs.GetPrivateCloudManagementClusterStretchedClusterConfigResult']):
        """
        :param str cluster_id: The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
                 * Only contains 1-63 alphanumeric characters and hyphens
                 * Begins with an alphabetical character
                 * Ends with a non-hyphen character
                 * Not formatted as a UUID
                 * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        :param Sequence['GetPrivateCloudManagementClusterNodeTypeConfigArgs'] node_type_configs: The map of cluster node types in this cluster,
               where the key is canonical identifier of the node type (corresponds to the NodeType).
        :param Sequence['GetPrivateCloudManagementClusterStretchedClusterConfigArgs'] stretched_cluster_configs: The stretched cluster configuration for the private cloud.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "node_type_configs", node_type_configs)
        pulumi.set(__self__, "stretched_cluster_configs", stretched_cluster_configs)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The user-provided identifier of the new Cluster. The identifier must meet the following requirements:
          * Only contains 1-63 alphanumeric characters and hyphens
          * Begins with an alphabetical character
          * Ends with a non-hyphen character
          * Not formatted as a UUID
          * Complies with RFC 1034 (https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="nodeTypeConfigs")
    def node_type_configs(self) -> Sequence['outputs.GetPrivateCloudManagementClusterNodeTypeConfigResult']:
        """
        The map of cluster node types in this cluster,
        where the key is canonical identifier of the node type (corresponds to the NodeType).
        """
        return pulumi.get(self, "node_type_configs")

    @property
    @pulumi.getter(name="stretchedClusterConfigs")
    def stretched_cluster_configs(self) -> Sequence['outputs.GetPrivateCloudManagementClusterStretchedClusterConfigResult']:
        """
        The stretched cluster configuration for the private cloud.
        """
        return pulumi.get(self, "stretched_cluster_configs")


@pulumi.output_type
class GetPrivateCloudManagementClusterNodeTypeConfigResult(dict):
    def __init__(__self__, *,
                 custom_core_count: int,
                 node_count: int,
                 node_type_id: str):
        """
        :param int custom_core_count: Customized number of cores available to each node of the type.
               This number must always be one of 'nodeType.availableCustomCoreCounts'.
               If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
               This cannot be changed once the PrivateCloud is created.
        :param int node_count: The number of nodes of this type in the cluster.
        """
        pulumi.set(__self__, "custom_core_count", custom_core_count)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_type_id", node_type_id)

    @property
    @pulumi.getter(name="customCoreCount")
    def custom_core_count(self) -> int:
        """
        Customized number of cores available to each node of the type.
        This number must always be one of 'nodeType.availableCustomCoreCounts'.
        If zero is provided max value from 'nodeType.availableCustomCoreCounts' will be used.
        This cannot be changed once the PrivateCloud is created.
        """
        return pulumi.get(self, "custom_core_count")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes of this type in the cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeTypeId")
    def node_type_id(self) -> str:
        return pulumi.get(self, "node_type_id")


@pulumi.output_type
class GetPrivateCloudManagementClusterStretchedClusterConfigResult(dict):
    def __init__(__self__, *,
                 preferred_location: str,
                 secondary_location: str):
        """
        :param str preferred_location: Zone that will remain operational when connection between the two zones is lost.
        :param str secondary_location: Additional zone for a higher level of availability and load balancing.
        """
        pulumi.set(__self__, "preferred_location", preferred_location)
        pulumi.set(__self__, "secondary_location", secondary_location)

    @property
    @pulumi.getter(name="preferredLocation")
    def preferred_location(self) -> str:
        """
        Zone that will remain operational when connection between the two zones is lost.
        """
        return pulumi.get(self, "preferred_location")

    @property
    @pulumi.getter(name="secondaryLocation")
    def secondary_location(self) -> str:
        """
        Additional zone for a higher level of availability and load balancing.
        """
        return pulumi.get(self, "secondary_location")


@pulumi.output_type
class GetPrivateCloudNetworkConfigResult(dict):
    def __init__(__self__, *,
                 dns_server_ip: str,
                 management_cidr: str,
                 management_ip_address_layout_version: int,
                 vmware_engine_network: str,
                 vmware_engine_network_canonical: str):
        """
        :param str dns_server_ip: DNS Server IP of the Private Cloud.
        :param str management_cidr: Management CIDR used by VMware management appliances.
        :param int management_ip_address_layout_version: The IP address layout version of the management IP address range.
               Possible versions include:
               * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
               as it does not support all features.
               * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
               used by all newly created private clouds. This version supports all current features.
        :param str vmware_engine_network: The relative resource name of the VMware Engine network attached to the private cloud.
               Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
               where {project} can either be a project number or a project ID.
        :param str vmware_engine_network_canonical: The canonical name of the VMware Engine network in
               the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        pulumi.set(__self__, "management_cidr", management_cidr)
        pulumi.set(__self__, "management_ip_address_layout_version", management_ip_address_layout_version)
        pulumi.set(__self__, "vmware_engine_network", vmware_engine_network)
        pulumi.set(__self__, "vmware_engine_network_canonical", vmware_engine_network_canonical)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> str:
        """
        DNS Server IP of the Private Cloud.
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="managementCidr")
    def management_cidr(self) -> str:
        """
        Management CIDR used by VMware management appliances.
        """
        return pulumi.get(self, "management_cidr")

    @property
    @pulumi.getter(name="managementIpAddressLayoutVersion")
    def management_ip_address_layout_version(self) -> int:
        """
        The IP address layout version of the management IP address range.
        Possible versions include:
        * managementIpAddressLayoutVersion=1: Indicates the legacy IP address layout used by some existing private clouds. This is no longer supported for new private clouds
        as it does not support all features.
        * managementIpAddressLayoutVersion=2: Indicates the latest IP address layout
        used by all newly created private clouds. This version supports all current features.
        """
        return pulumi.get(self, "management_ip_address_layout_version")

    @property
    @pulumi.getter(name="vmwareEngineNetwork")
    def vmware_engine_network(self) -> str:
        """
        The relative resource name of the VMware Engine network attached to the private cloud.
        Specify the name in the following form: projects/{project}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        where {project} can either be a project number or a project ID.
        """
        return pulumi.get(self, "vmware_engine_network")

    @property
    @pulumi.getter(name="vmwareEngineNetworkCanonical")
    def vmware_engine_network_canonical(self) -> str:
        """
        The canonical name of the VMware Engine network in
        the form: projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmwareEngineNetworkId}
        """
        return pulumi.get(self, "vmware_engine_network_canonical")


@pulumi.output_type
class GetPrivateCloudNsxResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 internal_ip: str,
                 state: str,
                 version: str):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPrivateCloudVcenterResult(dict):
    def __init__(__self__, *,
                 fqdn: str,
                 internal_ip: str,
                 state: str,
                 version: str):
        """
        :param str fqdn: Fully qualified domain name of the appliance.
        :param str internal_ip: Internal IP address of the appliance.
        :param str state: State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        :param str version: Version of the appliance.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def fqdn(self) -> str:
        """
        Fully qualified domain name of the appliance.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        Internal IP address of the appliance.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the appliance. Possible values: ["ACTIVE", "CREATING"]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the appliance.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetSubnetDhcpAddressRangeResult(dict):
    def __init__(__self__, *,
                 first_address: str,
                 last_address: str):
        """
        :param str first_address: The first IP address of the range.
        :param str last_address: The last IP address of the range.
        """
        pulumi.set(__self__, "first_address", first_address)
        pulumi.set(__self__, "last_address", last_address)

    @property
    @pulumi.getter(name="firstAddress")
    def first_address(self) -> str:
        """
        The first IP address of the range.
        """
        return pulumi.get(self, "first_address")

    @property
    @pulumi.getter(name="lastAddress")
    def last_address(self) -> str:
        """
        The last IP address of the range.
        """
        return pulumi.get(self, "last_address")


