# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceGceSetup',
    'InstanceGceSetupAcceleratorConfig',
    'InstanceGceSetupBootDisk',
    'InstanceGceSetupContainerImage',
    'InstanceGceSetupDataDisks',
    'InstanceGceSetupNetworkInterface',
    'InstanceGceSetupNetworkInterfaceAccessConfig',
    'InstanceGceSetupServiceAccount',
    'InstanceGceSetupShieldedInstanceConfig',
    'InstanceGceSetupVmImage',
    'InstanceHealthInfo',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'InstanceUpgradeHistory',
]

@pulumi.output_type
class InstanceGceSetup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorConfigs":
            suggest = "accelerator_configs"
        elif key == "bootDisk":
            suggest = "boot_disk"
        elif key == "containerImage":
            suggest = "container_image"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "disablePublicIp":
            suggest = "disable_public_ip"
        elif key == "enableIpForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "networkInterfaces":
            suggest = "network_interfaces"
        elif key == "serviceAccounts":
            suggest = "service_accounts"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "vmImage":
            suggest = "vm_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_configs: Optional[Sequence['outputs.InstanceGceSetupAcceleratorConfig']] = None,
                 boot_disk: Optional['outputs.InstanceGceSetupBootDisk'] = None,
                 container_image: Optional['outputs.InstanceGceSetupContainerImage'] = None,
                 data_disks: Optional['outputs.InstanceGceSetupDataDisks'] = None,
                 disable_public_ip: Optional[bool] = None,
                 enable_ip_forwarding: Optional[bool] = None,
                 machine_type: Optional[str] = None,
                 metadata: Optional[Mapping[str, str]] = None,
                 network_interfaces: Optional[Sequence['outputs.InstanceGceSetupNetworkInterface']] = None,
                 service_accounts: Optional[Sequence['outputs.InstanceGceSetupServiceAccount']] = None,
                 shielded_instance_config: Optional['outputs.InstanceGceSetupShieldedInstanceConfig'] = None,
                 tags: Optional[Sequence[str]] = None,
                 vm_image: Optional['outputs.InstanceGceSetupVmImage'] = None):
        """
        :param Sequence['InstanceGceSetupAcceleratorConfigArgs'] accelerator_configs: The hardware accelerators used on this instance. If you use accelerators, make sure that your configuration has
               [enough vCPUs and memory to support the `machine_type` you have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
               Currently supports only one accelerator configuration.
               Structure is documented below.
        :param 'InstanceGceSetupBootDiskArgs' boot_disk: The definition of a boot disk.
               Structure is documented below.
        :param 'InstanceGceSetupContainerImageArgs' container_image: Use a container image to start the workbench instance.
               Structure is documented below.
        :param 'InstanceGceSetupDataDisksArgs' data_disks: Data disks attached to the VM instance. Currently supports only one data disk.
               Structure is documented below.
        :param bool disable_public_ip: Optional. If true, no external IP will be assigned to this VM instance.
        :param bool enable_ip_forwarding: Optional. Flag to enable ip forwarding or not, default false/off.
               https://cloud.google.com/vpc/docs/using-routes#canipforward
        :param str machine_type: Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
        :param Mapping[str, str] metadata: Optional. Custom metadata to apply to this instance.
        :param Sequence['InstanceGceSetupNetworkInterfaceArgs'] network_interfaces: The network interfaces for the VM. Supports only one interface.
               Structure is documented below.
        :param Sequence['InstanceGceSetupServiceAccountArgs'] service_accounts: The service account that serves as an identity for the VM instance. Currently supports only one service account.
               Structure is documented below.
        :param 'InstanceGceSetupShieldedInstanceConfigArgs' shielded_instance_config: A set of Shielded Instance options. See [Images using supported Shielded
               VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
               Not all combinations are valid.
               Structure is documented below.
        :param Sequence[str] tags: Optional. The Compute Engine tags to add to instance (see [Tagging
               instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param 'InstanceGceSetupVmImageArgs' vm_image: Definition of a custom Compute Engine virtual machine image for starting
               a workbench instance with the environment installed directly on the VM.
               Structure is documented below.
        """
        if accelerator_configs is not None:
            pulumi.set(__self__, "accelerator_configs", accelerator_configs)
        if boot_disk is not None:
            pulumi.set(__self__, "boot_disk", boot_disk)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if disable_public_ip is not None:
            pulumi.set(__self__, "disable_public_ip", disable_public_ip)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if service_accounts is not None:
            pulumi.set(__self__, "service_accounts", service_accounts)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter(name="acceleratorConfigs")
    def accelerator_configs(self) -> Optional[Sequence['outputs.InstanceGceSetupAcceleratorConfig']]:
        """
        The hardware accelerators used on this instance. If you use accelerators, make sure that your configuration has
        [enough vCPUs and memory to support the `machine_type` you have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
        Currently supports only one accelerator configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerator_configs")

    @property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> Optional['outputs.InstanceGceSetupBootDisk']:
        """
        The definition of a boot disk.
        Structure is documented below.
        """
        return pulumi.get(self, "boot_disk")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional['outputs.InstanceGceSetupContainerImage']:
        """
        Use a container image to start the workbench instance.
        Structure is documented below.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional['outputs.InstanceGceSetupDataDisks']:
        """
        Data disks attached to the VM instance. Currently supports only one data disk.
        Structure is documented below.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="disablePublicIp")
    def disable_public_ip(self) -> Optional[bool]:
        """
        Optional. If true, no external IP will be assigned to this VM instance.
        """
        return pulumi.get(self, "disable_public_ip")

    @property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> Optional[bool]:
        """
        Optional. Flag to enable ip forwarding or not, default false/off.
        https://cloud.google.com/vpc/docs/using-routes#canipforward
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        Optional. The machine type of the VM instance. https://cloud.google.com/compute/docs/machine-resource
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, str]]:
        """
        Optional. Custom metadata to apply to this instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.InstanceGceSetupNetworkInterface']]:
        """
        The network interfaces for the VM. Supports only one interface.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> Optional[Sequence['outputs.InstanceGceSetupServiceAccount']]:
        """
        The service account that serves as an identity for the VM instance. Currently supports only one service account.
        Structure is documented below.
        """
        return pulumi.get(self, "service_accounts")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.InstanceGceSetupShieldedInstanceConfig']:
        """
        A set of Shielded Instance options. See [Images using supported Shielded
        VM features](https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        Not all combinations are valid.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Optional. The Compute Engine tags to add to instance (see [Tagging
        instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional['outputs.InstanceGceSetupVmImage']:
        """
        Definition of a custom Compute Engine virtual machine image for starting
        a workbench instance with the environment installed directly on the VM.
        Structure is documented below.
        """
        return pulumi.get(self, "vm_image")


@pulumi.output_type
class InstanceGceSetupAcceleratorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "coreCount":
            suggest = "core_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupAcceleratorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupAcceleratorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupAcceleratorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 core_count: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str core_count: Optional. Count of cores of this accelerator.
        :param str type: Optional. Type of this accelerator.
               Possible values are: `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_A100`, `NVIDIA_A100_80GB`, `NVIDIA_L4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`.
        """
        if core_count is not None:
            pulumi.set(__self__, "core_count", core_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="coreCount")
    def core_count(self) -> Optional[str]:
        """
        Optional. Count of cores of this accelerator.
        """
        return pulumi.get(self, "core_count")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Optional. Type of this accelerator.
        Possible values are: `NVIDIA_TESLA_P100`, `NVIDIA_TESLA_V100`, `NVIDIA_TESLA_P4`, `NVIDIA_TESLA_T4`, `NVIDIA_TESLA_A100`, `NVIDIA_A100_80GB`, `NVIDIA_L4`, `NVIDIA_TESLA_T4_VWS`, `NVIDIA_TESLA_P100_VWS`, `NVIDIA_TESLA_P4_VWS`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceGceSetupBootDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryption":
            suggest = "disk_encryption"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupBootDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupBootDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupBootDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption: Optional[str] = None,
                 disk_size_gb: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 kms_key: Optional[str] = None):
        """
        :param str disk_encryption: Optional. Input only. Disk encryption method used on the boot and
               data disks, defaults to GMEK.
               Possible values are: `GMEK`, `CMEK`.
        :param str disk_size_gb: Optional. The size of the boot disk in GB attached to this instance,
               up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
               recommended value of 150GB.
        :param str disk_type: Optional. Indicates the type of the disk.
               Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        :param str kms_key: 'Optional. The KMS key used to encrypt the disks, only
               applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
               Learn more about using your own encryption keys.'
        """
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[str]:
        """
        Optional. Input only. Disk encryption method used on the boot and
        data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[str]:
        """
        Optional. The size of the boot disk in GB attached to this instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to the
        recommended value of 150GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Optional. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        'Optional. The KMS key used to encrypt the disks, only
        applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class InstanceGceSetupContainerImage(dict):
    def __init__(__self__, *,
                 repository: str,
                 tag: Optional[str] = None):
        """
        :param str repository: The path to the container image repository.
               For example: gcr.io/{project_id}/{imageName}
        :param str tag: The tag of the container image. If not specified, this defaults to the latest tag.
        """
        pulumi.set(__self__, "repository", repository)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The path to the container image repository.
        For example: gcr.io/{project_id}/{imageName}
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The tag of the container image. If not specified, this defaults to the latest tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class InstanceGceSetupDataDisks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryption":
            suggest = "disk_encryption"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupDataDisks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupDataDisks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupDataDisks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption: Optional[str] = None,
                 disk_size_gb: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 kms_key: Optional[str] = None):
        """
        :param str disk_encryption: Optional. Input only. Disk encryption method used on the boot
               and data disks, defaults to GMEK.
               Possible values are: `GMEK`, `CMEK`.
        :param str disk_size_gb: Optional. The size of the disk in GB attached to this VM instance,
               up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
               100.
        :param str disk_type: Optional. Input only. Indicates the type of the disk.
               Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        :param str kms_key: 'Optional. The KMS key used to encrypt the disks,
               only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
               Learn more about using your own encryption keys.'
        """
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[str]:
        """
        Optional. Input only. Disk encryption method used on the boot
        and data disks, defaults to GMEK.
        Possible values are: `GMEK`, `CMEK`.
        """
        return pulumi.get(self, "disk_encryption")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[str]:
        """
        Optional. The size of the disk in GB attached to this VM instance,
        up to a maximum of 64000 GB (64 TB). If not specified, this defaults to
        100.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Optional. Input only. Indicates the type of the disk.
        Possible values are: `PD_STANDARD`, `PD_SSD`, `PD_BALANCED`, `PD_EXTREME`.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[str]:
        """
        'Optional. The KMS key used to encrypt the disks,
        only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
        Learn more about using your own encryption keys.'
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class InstanceGceSetupNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessConfigs":
            suggest = "access_configs"
        elif key == "nicType":
            suggest = "nic_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_configs: Optional[Sequence['outputs.InstanceGceSetupNetworkInterfaceAccessConfig']] = None,
                 network: Optional[str] = None,
                 nic_type: Optional[str] = None,
                 subnet: Optional[str] = None):
        """
        :param Sequence['InstanceGceSetupNetworkInterfaceAccessConfigArgs'] access_configs: Optional. An array of configurations for this interface. Currently, only one access
               config, ONE_TO_ONE_NAT, is supported. If no accessConfigs specified, the
               instance will have an external internet access through an ephemeral
               external IP address.
               Structure is documented below.
        :param str network: Optional. The name of the VPC that this VM instance is in.
        :param str nic_type: Optional. The type of vNIC to be used on this interface. This
               may be gVNIC or VirtioNet.
               Possible values are: `VIRTIO_NET`, `GVNIC`.
        :param str subnet: Optional. The name of the subnet that this VM instance is in.
        """
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if nic_type is not None:
            pulumi.set(__self__, "nic_type", nic_type)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[Sequence['outputs.InstanceGceSetupNetworkInterfaceAccessConfig']]:
        """
        Optional. An array of configurations for this interface. Currently, only one access
        config, ONE_TO_ONE_NAT, is supported. If no accessConfigs specified, the
        instance will have an external internet access through an ephemeral
        external IP address.
        Structure is documented below.
        """
        return pulumi.get(self, "access_configs")

    @property
    @pulumi.getter
    def network(self) -> Optional[str]:
        """
        Optional. The name of the VPC that this VM instance is in.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> Optional[str]:
        """
        Optional. The type of vNIC to be used on this interface. This
        may be gVNIC or VirtioNet.
        Possible values are: `VIRTIO_NET`, `GVNIC`.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        Optional. The name of the subnet that this VM instance is in.
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class InstanceGceSetupNetworkInterfaceAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalIp":
            suggest = "external_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupNetworkInterfaceAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupNetworkInterfaceAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupNetworkInterfaceAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_ip: str):
        """
        :param str external_ip: An external IP address associated with this instance. Specify an unused
               static external IP address available to the project or leave this field
               undefined to use an IP from a shared ephemeral IP address pool. If you
               specify a static external IP address, it must live in the same region as
               the zone of the instance.
        """
        pulumi.set(__self__, "external_ip", external_ip)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        An external IP address associated with this instance. Specify an unused
        static external IP address available to the project or leave this field
        undefined to use an IP from a shared ephemeral IP address pool. If you
        specify a static external IP address, it must live in the same region as
        the zone of the instance.
        """
        return pulumi.get(self, "external_ip")


@pulumi.output_type
class InstanceGceSetupServiceAccount(dict):
    def __init__(__self__, *,
                 email: Optional[str] = None,
                 scopes: Optional[Sequence[str]] = None):
        """
        :param str email: Optional. Email address of the service account.
        :param Sequence[str] scopes: (Output)
               Output only. The list of scopes to be made available for this
               service account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        Optional. Email address of the service account.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        (Output)
        Output only. The list of scopes to be made available for this
        service account. Set by the CLH to https://www.googleapis.com/auth/cloud-platform
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class InstanceGceSetupShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGceSetupShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGceSetupShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGceSetupShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[bool] = None,
                 enable_secure_boot: Optional[bool] = None,
                 enable_vtpm: Optional[bool] = None):
        """
        :param bool enable_integrity_monitoring: Optional. Defines whether the VM instance has integrity monitoring
               enabled. Enables monitoring and attestation of the boot integrity of the VM
               instance. The attestation is performed against the integrity policy baseline.
               This baseline is initially derived from the implicitly trusted boot image
               when the VM instance is created. Enabled by default.
        :param bool enable_secure_boot: Optional. Defines whether the VM instance has Secure Boot enabled.
               Secure Boot helps ensure that the system only runs authentic software by verifying
               the digital signature of all boot components, and halting the boot process
               if signature verification fails. Disabled by default.
        :param bool enable_vtpm: Optional. Defines whether the VM instance has the vTPM enabled.
               Enabled by default.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[bool]:
        """
        Optional. Defines whether the VM instance has integrity monitoring
        enabled. Enables monitoring and attestation of the boot integrity of the VM
        instance. The attestation is performed against the integrity policy baseline.
        This baseline is initially derived from the implicitly trusted boot image
        when the VM instance is created. Enabled by default.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[bool]:
        """
        Optional. Defines whether the VM instance has Secure Boot enabled.
        Secure Boot helps ensure that the system only runs authentic software by verifying
        the digital signature of all boot components, and halting the boot process
        if signature verification fails. Disabled by default.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[bool]:
        """
        Optional. Defines whether the VM instance has the vTPM enabled.
        Enabled by default.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class InstanceGceSetupVmImage(dict):
    def __init__(__self__, *,
                 family: Optional[str] = None,
                 name: Optional[str] = None,
                 project: Optional[str] = None):
        """
        :param str family: Optional. Use this VM image family to find the image; the newest
               image in this family will be used.
        :param str name: Optional. Use VM image name to find the image.
        :param str project: The name of the Google Cloud project that this VM image belongs to.
               Format: {project_id}
        """
        if family is not None:
            pulumi.set(__self__, "family", family)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def family(self) -> Optional[str]:
        """
        Optional. Use this VM image family to find the image; the newest
        image in this family will be used.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Optional. Use VM image name to find the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The name of the Google Cloud project that this VM image belongs to.
        Format: {project_id}
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class InstanceHealthInfo(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceUpgradeHistory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "targetVersion":
            suggest = "target_version"
        elif key == "vmImage":
            suggest = "vm_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceUpgradeHistory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceUpgradeHistory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceUpgradeHistory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 container_image: Optional[str] = None,
                 create_time: Optional[str] = None,
                 framework: Optional[str] = None,
                 snapshot: Optional[str] = None,
                 state: Optional[str] = None,
                 target_version: Optional[str] = None,
                 version: Optional[str] = None,
                 vm_image: Optional[str] = None):
        """
        :param str action: Optional. Action. Rolloback or Upgrade.
        :param str container_image: Optional. The container image before this instance upgrade.
        :param str create_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param str framework: Optional. The framework of this workbench instance.
        :param str snapshot: Optional. The snapshot of the boot disk of this workbench instance before upgrade.
        :param str state: (Output)
               Output only. The state of this instance upgrade history entry.
        :param str target_version: Optional. Target VM Version, like m63.
        :param str version: Optional. The version of the workbench instance before this upgrade.
        :param str vm_image: Optional. The VM image before this instance upgrade.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if container_image is not None:
            pulumi.set(__self__, "container_image", container_image)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if framework is not None:
            pulumi.set(__self__, "framework", framework)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Optional. Action. Rolloback or Upgrade.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> Optional[str]:
        """
        Optional. The container image before this instance upgrade.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def framework(self) -> Optional[str]:
        """
        Optional. The framework of this workbench instance.
        """
        return pulumi.get(self, "framework")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[str]:
        """
        Optional. The snapshot of the boot disk of this workbench instance before upgrade.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Output)
        Output only. The state of this instance upgrade history entry.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[str]:
        """
        Optional. Target VM Version, like m63.
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Optional. The version of the workbench instance before this upgrade.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[str]:
        """
        Optional. The VM image before this instance upgrade.
        """
        return pulumi.get(self, "vm_image")


