# Retab

<div align="center" style="margin-bottom: 1em;">

<img src="https://raw.githubusercontent.com/Retab-dev/retab/refs/heads/main/assets/retab-logo.png" alt="Retab Logo" width="150">


  *The AI Automation Platform*

Made with love by the team at [Retab](https://retab.com) 🤍.

[Our Website](https://retab.com) | [Documentation](https://docs.retab.com/get-started/introduction) | [Discord](https://discord.com/invite/vc5tWRPqag) | [Twitter](https://x.com/retabdev)


</div>

---

### What is Retab?

Retab solves all the major challenges in document processing with Large Language Models:

1. **Universal Document Preprocessing**: Convert any file type (PDFs, Excel, emails, etc.) into LLM-ready format without writing custom parsers
2. **Structured, Schema-driven Extraction**: Get consistent, reliable outputs using schema-based prompt engineering
3. **Processors**: Publish a live, stable, shareable document processor.
4. **Automations**: Create document processing workflows that can be triggered by events (mailbox, upload link, endpoint, outlook plugin).
5. **Projects**: Evaluate the performance of models against annotated datasets
6. **Optimizations**: Identify the most used processors and help you finetune models to reduce costs and improve performance

We are offering you all the software-defined primitives to build your own document processing solutions. We see it as **Stripe** for document processing.

Our goal is to make the process of analyzing documents and unstructured data as **easy** and **transparent** as possible.

**A new, lighter paradigm**
Large Language Models collapse entire layers of legacy OCR pipelines into a single, elegant abstraction. When a model can read, reason, and structure text natively, we no longer need brittle heuristics, handcrafted parsers, or heavyweight ETL jobs. Instead, we can expose a small, principled API: "give me the document, tell me the schema, and get back structured truth." Complexity evaporates, reliability rises, speed follows, and costs fall—because every component you remove is one that can no longer break. LLM‑first design lets us focus less on plumbing and more on the questions we actually want answered.

Many people haven't yet realized how powerful LLMs have become at document processing tasks - we're here to help **unlock these capabilities**.

---

## Go further

* [Quickstart](/get-started/quickstart)
* [API Reference](/api-reference/introduction)

---

## Code examples

You can check our Github repository to see code examples: [python examples](https://github.com/Retab-dev/retab/tree/main/examples) and [jupyter notebooks](https://github.com/Retab-dev/retab-nodejs/tree/main/notebooks).

## Community

Let's create the future of document processing together!

Join our [discord community](https://discord.com/invite/vc5tWRPqag) to share tips, discuss best practices, and showcase what you build. Or just [tweet](https://x.com/retabdev) at us.

We can't wait to see how you'll use Retab.

* [Discord](https://discord.com/invite/vc5tWRPqag)
* [Twitter](https://x.com/retabdev)

---

## Roadmap

We share our roadmap publicly on [Github](https://github.com/Retab-dev/retab)

Among the features we're working on:

* [ ] Node.js SDK
* [ ] Schema optimization autopilot
* [ ] Sources API

