# Generated by Django 4.2.1 on 2023-05-12 15:32

import datetime

import django.core.validators
import django.db.models.deletion
import django_enum.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Playlist",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, default="", max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="Wave",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("file", models.FileField(upload_to="uploads/")),
                ("name", models.CharField(blank=True, default="", max_length=255)),
                (
                    "duration",
                    models.DurationField(
                        blank=True, default=None, editable=False, null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PlaylistWave",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("order", models.PositiveSmallIntegerField(default=0)),
                (
                    "playlist",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="etc_player.playlist",
                    ),
                ),
                (
                    "wave",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="etc_player.wave",
                    ),
                ),
            ],
            options={
                "ordering": ["order"],
            },
        ),
        migrations.AddField(
            model_name="playlist",
            name="waves",
            field=models.ManyToManyField(
                through="etc_player.PlaylistWave", to="etc_player.wave"
            ),
        ),
        migrations.CreateModel(
            name="PlaybackTimeRange",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "day_of_week",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[
                            (1, "Monday"),
                            (2, "Tuesday"),
                            (3, "Wednesday"),
                            (4, "Thursday"),
                            (5, "Friday"),
                            (6, "Saturday"),
                            (7, "Sunday"),
                        ],
                        unique=True,
                    ),
                ),
                ("start", models.TimeField(db_index=True)),
                ("end", models.TimeField(db_index=True)),
                (
                    "playlist",
                    models.ForeignKey(
                        blank=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="etc_player.playlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Schedule",
                "verbose_name_plural": "Schedule",
                "ordering": ["day_of_week", "start"],
            },
        ),
        migrations.CreateModel(
            name="PlaybackSettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "volume",
                    models.PositiveSmallIntegerField(
                        default=50,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "default_playlist",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="etc_player.playlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Playback Settings",
                "verbose_name_plural": "Playback Settings",
            },
        ),
        migrations.CreateModel(
            name="ManualOverride",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "operation",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(0, "Play"), (1, "Stop")]
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        blank=True, db_index=True, default=datetime.datetime.now
                    ),
                ),
                (
                    "playlist",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="etc_player.playlist",
                    ),
                ),
            ],
            options={
                "verbose_name": "Manual Override",
                "verbose_name_plural": "Manual Overrides",
                "ordering": ["-timestamp"],
            },
        ),
        migrations.AddConstraint(
            model_name="playbacktimerange",
            constraint=models.CheckConstraint(
                check=models.Q(("start__lt", models.F("end"))),
                name="etc_player_playbacktimerange_start_lt_end",
            ),
        ),
    ]
