import os
from itertools import product
from pathlib import Path

from bella_companion.utils import submit_job


def run_beast():
    base_output_dir = Path(os.environ["BELLA_BEAST_OUTPUT_DIR"])
    output_dir = base_output_dir / "eucovid"
    os.makedirs(output_dir, exist_ok=True)

    base_log_dir = Path(os.environ["BELLA_SBATCH_LOG_DIR"]) / "eucovid"
    data_dir = Path(__file__).parent / "data"
    beast_configs_dir = Path(__file__).parent / "beast_configs"

    for seed, model in product(range(3), ["GLM", "MLP"]):
        extra_data = '-D layersRange="0,1,2",nodes="16 8"' if model == "MLP" else ""
        os.makedirs(output_dir / model, exist_ok=True)
        submit_job(
            " ".join(
                [
                    *os.environ["BELLA_RUN_BEAST_CMD"],
                    f"-seed {seed}",
                    f"-D msa_file={data_dir / 'msa.fasta'}",
                    f"-D changeTimesFile={data_dir / 'changetimes.csv'}",
                    f"-D flightsPredictorFile={data_dir / 'flights.csv'}",
                    extra_data,
                    f"-prefix {output_dir / model}{os.sep}{seed}-",
                    str(beast_configs_dir / f"{model}.xml"),
                ]
            ),
            base_log_dir / model / str(seed),
            cpus=128,
            mem_per_cpu=12000,
        )
