from dataclasses import dataclass


@dataclass
class Feature:
    is_binary: bool
    is_relevant: bool | None = None

    @property
    def color(self) -> str:
        if self.is_relevant is None:
            return "purple"
        return "#E74C3C" if self.is_relevant else "gray"
