from typing import Any, TypeGuard

import numpy as np
from bella_lumiere.typing import Weights


def is_list(obj: Any) -> TypeGuard[list[Any]]:
    return isinstance(obj, list)


def is_weights(obj: Any) -> TypeGuard[Weights]:
    return is_list(obj) and all(isinstance(layer, np.ndarray) for layer in obj)


def is_weights_list(weights: Any) -> TypeGuard[list[Weights]]:
    return is_list(weights) and all(is_weights(w) for w in weights)


def is_nested_weights_list(weights: Any) -> TypeGuard[list[list[Weights]]]:
    return is_list(weights) and all(is_weights_list(w) for w in weights)
