"""Module for searchcontext for collection of cases."""

from ._search_context import SearchContext


class Cases(SearchContext):
    def __init__(self, sc, uuids):
        super().__init__(sc._sumo, must=[{"ids": {"values": uuids}}])
        self._hits = uuids
        return

    def _maybe_prefetch(self, index):
        return

    async def _maybe_prefetch_async(self, index):
        return

    def filter(self, **kwargs):
        sc = super().filter(**kwargs)
        uuids = sc.get_field_values("fmu.case.uuid.keyword")
        return Cases(sc, uuids)

    @property
    def names(self):
        return self.get_field_values("fmu.case.name.keyword")
