# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.4, generator: @autorest/python@6.34.2)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class BodyAuthGetOidcToken(_serialization.Model):
    """Body_auth_get_oidc_token.

    All required parameters must be populated in order to send to server.

    :ivar grant_type: OAuth2 Grant type. Required.
    :vartype grant_type: ~_generated.models.BodyAuthGetOidcTokenGrantType
    :ivar client_id: OAuth2 client id. Required.
    :vartype client_id: str
    :ivar device_code: device code for OAuth2 device flow.
    :vartype device_code: str
    :ivar code: Code for OAuth2 authorization code flow.
    :vartype code: str
    :ivar redirect_uri: redirect_uri used with OAuth2 authorization code flow.
    :vartype redirect_uri: str
    :ivar code_verifier: Verifier for the code challenge for the OAuth2 authorization flow with
     PKCE.
    :vartype code_verifier: str
    :ivar refresh_token: Refresh token used with OAuth2 refresh token flow.
    :vartype refresh_token: str
    """

    _validation = {
        "grant_type": {"required": True},
        "client_id": {"required": True},
    }

    _attribute_map = {
        "grant_type": {"key": "grant_type", "type": "BodyAuthGetOidcTokenGrantType"},
        "client_id": {"key": "client_id", "type": "str"},
        "device_code": {"key": "device_code", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "redirect_uri": {"key": "redirect_uri", "type": "str"},
        "code_verifier": {"key": "code_verifier", "type": "str"},
        "refresh_token": {"key": "refresh_token", "type": "str"},
    }

    def __init__(
        self,
        *,
        grant_type: "_models.BodyAuthGetOidcTokenGrantType",
        client_id: str,
        device_code: Optional[str] = None,
        code: Optional[str] = None,
        redirect_uri: Optional[str] = None,
        code_verifier: Optional[str] = None,
        refresh_token: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword grant_type: OAuth2 Grant type. Required.
        :paramtype grant_type: ~_generated.models.BodyAuthGetOidcTokenGrantType
        :keyword client_id: OAuth2 client id. Required.
        :paramtype client_id: str
        :keyword device_code: device code for OAuth2 device flow.
        :paramtype device_code: str
        :keyword code: Code for OAuth2 authorization code flow.
        :paramtype code: str
        :keyword redirect_uri: redirect_uri used with OAuth2 authorization code flow.
        :paramtype redirect_uri: str
        :keyword code_verifier: Verifier for the code challenge for the OAuth2 authorization flow with
         PKCE.
        :paramtype code_verifier: str
        :keyword refresh_token: Refresh token used with OAuth2 refresh token flow.
        :paramtype refresh_token: str
        """
        super().__init__(**kwargs)
        self.grant_type = grant_type
        self.client_id = client_id
        self.device_code = device_code
        self.code = code
        self.redirect_uri = redirect_uri
        self.code_verifier = code_verifier
        self.refresh_token = refresh_token


class BodyAuthGetOidcTokenGrantType(_serialization.Model):
    """OAuth2 Grant type."""


class BodyAuthRevokeRefreshTokenByRefreshToken(_serialization.Model):
    """Body_auth_revoke_refresh_token_by_refresh_token.

    All required parameters must be populated in order to send to server.

    :ivar token: The refresh token to revoke. Required.
    :vartype token: str
    :ivar token_type_hint: Hint for the type of token being revoked.
    :vartype token_type_hint: str
    :ivar client_id: The client ID of the application requesting the revocation.
    :vartype client_id: str
    """

    _validation = {
        "token": {"required": True},
    }

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
        "token_type_hint": {"key": "token_type_hint", "type": "str"},
        "client_id": {"key": "client_id", "type": "str"},
    }

    def __init__(
        self, *, token: str, token_type_hint: Optional[str] = None, client_id: str = "myDIRACClientID", **kwargs: Any
    ) -> None:
        """
        :keyword token: The refresh token to revoke. Required.
        :paramtype token: str
        :keyword token_type_hint: Hint for the type of token being revoked.
        :paramtype token_type_hint: str
        :keyword client_id: The client ID of the application requesting the revocation.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.token = token
        self.token_type_hint = token_type_hint
        self.client_id = client_id


class BodyJobsRescheduleJobs(_serialization.Model):
    """Body_jobs_reschedule_jobs.

    All required parameters must be populated in order to send to server.

    :ivar job_ids: Job Ids. Required.
    :vartype job_ids: list[int]
    """

    _validation = {
        "job_ids": {"required": True},
    }

    _attribute_map = {
        "job_ids": {"key": "job_ids", "type": "[int]"},
    }

    def __init__(self, *, job_ids: List[int], **kwargs: Any) -> None:
        """
        :keyword job_ids: Job Ids. Required.
        :paramtype job_ids: list[int]
        """
        super().__init__(**kwargs)
        self.job_ids = job_ids


class BodyJobsUnassignBulkJobsSandboxes(_serialization.Model):
    """Body_jobs_unassign_bulk_jobs_sandboxes.

    All required parameters must be populated in order to send to server.

    :ivar job_ids: Job Ids. Required.
    :vartype job_ids: list[int]
    """

    _validation = {
        "job_ids": {"required": True},
    }

    _attribute_map = {
        "job_ids": {"key": "job_ids", "type": "[int]"},
    }

    def __init__(self, *, job_ids: List[int], **kwargs: Any) -> None:
        """
        :keyword job_ids: Job Ids. Required.
        :paramtype job_ids: list[int]
        """
        super().__init__(**kwargs)
        self.job_ids = job_ids


class ExtendedMetadata(_serialization.Model):
    """ExtendedMetadata.

    All required parameters must be populated in order to send to server.

    :ivar virtual_organizations: Virtual Organizations. Required.
    :vartype virtual_organizations: dict[str, ~_generated.models.VOInfo]
    :ivar gubbins_secrets: Gubbins Secrets. Required.
    :vartype gubbins_secrets: str
    :ivar gubbins_user_info: Gubbins User Info. Required.
    :vartype gubbins_user_info: dict[str, list[str]]
    """

    _validation = {
        "virtual_organizations": {"required": True},
        "gubbins_secrets": {"required": True},
        "gubbins_user_info": {"required": True},
    }

    _attribute_map = {
        "virtual_organizations": {"key": "virtual_organizations", "type": "{VOInfo}"},
        "gubbins_secrets": {"key": "gubbins_secrets", "type": "str"},
        "gubbins_user_info": {"key": "gubbins_user_info", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        virtual_organizations: Dict[str, "_models.VOInfo"],
        gubbins_secrets: str,
        gubbins_user_info: Dict[str, List[str]],
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_organizations: Virtual Organizations. Required.
        :paramtype virtual_organizations: dict[str, ~_generated.models.VOInfo]
        :keyword gubbins_secrets: Gubbins Secrets. Required.
        :paramtype gubbins_secrets: str
        :keyword gubbins_user_info: Gubbins User Info. Required.
        :paramtype gubbins_user_info: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.virtual_organizations = virtual_organizations
        self.gubbins_secrets = gubbins_secrets
        self.gubbins_user_info = gubbins_user_info


class GroupInfo(_serialization.Model):
    """GroupInfo.

    All required parameters must be populated in order to send to server.

    :ivar properties: Properties. Required.
    :vartype properties: list[str]
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "properties": {"key": "properties", "type": "[str]"},
    }

    def __init__(self, *, properties: List[str], **kwargs: Any) -> None:
        """
        :keyword properties: Properties. Required.
        :paramtype properties: list[str]
        """
        super().__init__(**kwargs)
        self.properties = properties


class HeartbeatData(_serialization.Model):
    """HeartbeatData.

    :ivar load_average: Loadaverage.
    :vartype load_average: float
    :ivar memory_used: Memoryused.
    :vartype memory_used: float
    :ivar vsize: Vsize.
    :vartype vsize: float
    :ivar available_disk_space: Availablediskspace.
    :vartype available_disk_space: float
    :ivar cpu_consumed: Cpuconsumed.
    :vartype cpu_consumed: float
    :ivar wall_clock_time: Wallclocktime.
    :vartype wall_clock_time: float
    :ivar standard_output: Standardoutput.
    :vartype standard_output: str
    """

    _attribute_map = {
        "load_average": {"key": "LoadAverage", "type": "float"},
        "memory_used": {"key": "MemoryUsed", "type": "float"},
        "vsize": {"key": "Vsize", "type": "float"},
        "available_disk_space": {"key": "AvailableDiskSpace", "type": "float"},
        "cpu_consumed": {"key": "CPUConsumed", "type": "float"},
        "wall_clock_time": {"key": "WallClockTime", "type": "float"},
        "standard_output": {"key": "StandardOutput", "type": "str"},
    }

    def __init__(
        self,
        *,
        load_average: Optional[float] = None,
        memory_used: Optional[float] = None,
        vsize: Optional[float] = None,
        available_disk_space: Optional[float] = None,
        cpu_consumed: Optional[float] = None,
        wall_clock_time: Optional[float] = None,
        standard_output: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword load_average: Loadaverage.
        :paramtype load_average: float
        :keyword memory_used: Memoryused.
        :paramtype memory_used: float
        :keyword vsize: Vsize.
        :paramtype vsize: float
        :keyword available_disk_space: Availablediskspace.
        :paramtype available_disk_space: float
        :keyword cpu_consumed: Cpuconsumed.
        :paramtype cpu_consumed: float
        :keyword wall_clock_time: Wallclocktime.
        :paramtype wall_clock_time: float
        :keyword standard_output: Standardoutput.
        :paramtype standard_output: str
        """
        super().__init__(**kwargs)
        self.load_average = load_average
        self.memory_used = memory_used
        self.vsize = vsize
        self.available_disk_space = available_disk_space
        self.cpu_consumed = cpu_consumed
        self.wall_clock_time = wall_clock_time
        self.standard_output = standard_output


class HTTPValidationError(_serialization.Model):
    """HTTPValidationError.

    :ivar detail: Detail.
    :vartype detail: list[~_generated.models.ValidationError]
    """

    _attribute_map = {
        "detail": {"key": "detail", "type": "[ValidationError]"},
    }

    def __init__(self, *, detail: Optional[List["_models.ValidationError"]] = None, **kwargs: Any) -> None:
        """
        :keyword detail: Detail.
        :paramtype detail: list[~_generated.models.ValidationError]
        """
        super().__init__(**kwargs)
        self.detail = detail


class InitiateDeviceFlowResponse(_serialization.Model):
    """Response for the device flow initiation.

    All required parameters must be populated in order to send to server.

    :ivar user_code: User Code. Required.
    :vartype user_code: str
    :ivar device_code: Device Code. Required.
    :vartype device_code: str
    :ivar verification_uri_complete: Verification Uri Complete. Required.
    :vartype verification_uri_complete: str
    :ivar verification_uri: Verification Uri. Required.
    :vartype verification_uri: str
    :ivar expires_in: Expires In. Required.
    :vartype expires_in: int
    """

    _validation = {
        "user_code": {"required": True},
        "device_code": {"required": True},
        "verification_uri_complete": {"required": True},
        "verification_uri": {"required": True},
        "expires_in": {"required": True},
    }

    _attribute_map = {
        "user_code": {"key": "user_code", "type": "str"},
        "device_code": {"key": "device_code", "type": "str"},
        "verification_uri_complete": {"key": "verification_uri_complete", "type": "str"},
        "verification_uri": {"key": "verification_uri", "type": "str"},
        "expires_in": {"key": "expires_in", "type": "int"},
    }

    def __init__(
        self,
        *,
        user_code: str,
        device_code: str,
        verification_uri_complete: str,
        verification_uri: str,
        expires_in: int,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_code: User Code. Required.
        :paramtype user_code: str
        :keyword device_code: Device Code. Required.
        :paramtype device_code: str
        :keyword verification_uri_complete: Verification Uri Complete. Required.
        :paramtype verification_uri_complete: str
        :keyword verification_uri: Verification Uri. Required.
        :paramtype verification_uri: str
        :keyword expires_in: Expires In. Required.
        :paramtype expires_in: int
        """
        super().__init__(**kwargs)
        self.user_code = user_code
        self.device_code = device_code
        self.verification_uri_complete = verification_uri_complete
        self.verification_uri = verification_uri
        self.expires_in = expires_in


class InsertedJob(_serialization.Model):
    """InsertedJob.

    All required parameters must be populated in order to send to server.

    :ivar job_id: Jobid. Required.
    :vartype job_id: int
    :ivar status: Status. Required.
    :vartype status: str
    :ivar minor_status: Minorstatus. Required.
    :vartype minor_status: str
    :ivar time_stamp: Timestamp. Required.
    :vartype time_stamp: ~datetime.datetime
    """

    _validation = {
        "job_id": {"required": True},
        "status": {"required": True},
        "minor_status": {"required": True},
        "time_stamp": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "JobID", "type": "int"},
        "status": {"key": "Status", "type": "str"},
        "minor_status": {"key": "MinorStatus", "type": "str"},
        "time_stamp": {"key": "TimeStamp", "type": "iso-8601"},
    }

    def __init__(
        self, *, job_id: int, status: str, minor_status: str, time_stamp: datetime.datetime, **kwargs: Any
    ) -> None:
        """
        :keyword job_id: Jobid. Required.
        :paramtype job_id: int
        :keyword status: Status. Required.
        :paramtype status: str
        :keyword minor_status: Minorstatus. Required.
        :paramtype minor_status: str
        :keyword time_stamp: Timestamp. Required.
        :paramtype time_stamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.status = status
        self.minor_status = minor_status
        self.time_stamp = time_stamp


class JobCommand(_serialization.Model):
    """JobCommand.

    All required parameters must be populated in order to send to server.

    :ivar job_id: Job Id. Required.
    :vartype job_id: int
    :ivar command: Command. Required.
    :vartype command: str
    :ivar arguments: Arguments.
    :vartype arguments: str
    """

    _validation = {
        "job_id": {"required": True},
        "command": {"required": True},
    }

    _attribute_map = {
        "job_id": {"key": "job_id", "type": "int"},
        "command": {"key": "command", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(self, *, job_id: int, command: str, arguments: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword job_id: Job Id. Required.
        :paramtype job_id: int
        :keyword command: Command. Required.
        :paramtype command: str
        :keyword arguments: Arguments.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.job_id = job_id
        self.command = command
        self.arguments = arguments


class JobMetaData(_serialization.Model):
    """A model that combines both JobAttributes and JobParameters.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar timestamp: Timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar cpu_normalization_factor: Cpunormalizationfactor.
    :vartype cpu_normalization_factor: int
    :ivar norm_cpu_time_s: Normcputime(S).
    :vartype norm_cpu_time_s: int
    :ivar total_cpu_time_s: Totalcputime(S).
    :vartype total_cpu_time_s: int
    :ivar host_name: Hostname.
    :vartype host_name: str
    :ivar grid_ce: Gridce.
    :vartype grid_ce: str
    :ivar model_name: Modelname.
    :vartype model_name: str
    :ivar pilot_agent: Pilotagent.
    :vartype pilot_agent: str
    :ivar pilot_reference: Pilot Reference.
    :vartype pilot_reference: str
    :ivar memory_mb: Memory(Mb).
    :vartype memory_mb: int
    :ivar local_account: Localaccount.
    :vartype local_account: str
    :ivar payload_pid: Payloadpid.
    :vartype payload_pid: int
    :ivar ce_queue: Cequeue.
    :vartype ce_queue: str
    :ivar batch_system: Batchsystem.
    :vartype batch_system: str
    :ivar job_type: Jobtype.
    :vartype job_type: str
    :ivar job_status: Jobstatus.
    :vartype job_status: str
    :ivar job_group: Jobgroup.
    :vartype job_group: str
    :ivar site: Site.
    :vartype site: str
    :ivar job_name: Jobname.
    :vartype job_name: str
    :ivar owner: Owner.
    :vartype owner: str
    :ivar owner_group: Ownergroup.
    :vartype owner_group: str
    :ivar vo: Vo.
    :vartype vo: str
    :ivar submission_time: Submissiontime.
    :vartype submission_time: ~datetime.datetime
    :ivar reschedule_time: Rescheduletime.
    :vartype reschedule_time: ~datetime.datetime
    :ivar last_update_time: Lastupdatetime.
    :vartype last_update_time: ~datetime.datetime
    :ivar start_exec_time: Startexectime.
    :vartype start_exec_time: ~datetime.datetime
    :ivar heart_beat_time: Heartbeattime.
    :vartype heart_beat_time: ~datetime.datetime
    :ivar end_exec_time: Endexectime.
    :vartype end_exec_time: ~datetime.datetime
    :ivar status: Status.
    :vartype status: str
    :ivar minor_status: Minorstatus.
    :vartype minor_status: str
    :ivar application_status: Applicationstatus.
    :vartype application_status: str
    :ivar user_priority: Userpriority.
    :vartype user_priority: int
    :ivar reschedule_counter: Reschedulecounter.
    :vartype reschedule_counter: int
    :ivar verified_flag: Verifiedflag.
    :vartype verified_flag: bool
    :ivar accounted_flag: Accountedflag.
    :vartype accounted_flag: ~_generated.models.JobMetaDataAccountedFlag
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "cpu_normalization_factor": {"key": "CPUNormalizationFactor", "type": "int"},
        "norm_cpu_time_s": {"key": "NormCPUTime(s)", "type": "int"},
        "total_cpu_time_s": {"key": "TotalCPUTime(s)", "type": "int"},
        "host_name": {"key": "HostName", "type": "str"},
        "grid_ce": {"key": "GridCE", "type": "str"},
        "model_name": {"key": "ModelName", "type": "str"},
        "pilot_agent": {"key": "PilotAgent", "type": "str"},
        "pilot_reference": {"key": "Pilot_Reference", "type": "str"},
        "memory_mb": {"key": "Memory(MB)", "type": "int"},
        "local_account": {"key": "LocalAccount", "type": "str"},
        "payload_pid": {"key": "PayloadPID", "type": "int"},
        "ce_queue": {"key": "CEQueue", "type": "str"},
        "batch_system": {"key": "BatchSystem", "type": "str"},
        "job_type": {"key": "JobType", "type": "str"},
        "job_status": {"key": "JobStatus", "type": "str"},
        "job_group": {"key": "JobGroup", "type": "str"},
        "site": {"key": "Site", "type": "str"},
        "job_name": {"key": "JobName", "type": "str"},
        "owner": {"key": "Owner", "type": "str"},
        "owner_group": {"key": "OwnerGroup", "type": "str"},
        "vo": {"key": "VO", "type": "str"},
        "submission_time": {"key": "SubmissionTime", "type": "iso-8601"},
        "reschedule_time": {"key": "RescheduleTime", "type": "iso-8601"},
        "last_update_time": {"key": "LastUpdateTime", "type": "iso-8601"},
        "start_exec_time": {"key": "StartExecTime", "type": "iso-8601"},
        "heart_beat_time": {"key": "HeartBeatTime", "type": "iso-8601"},
        "end_exec_time": {"key": "EndExecTime", "type": "iso-8601"},
        "status": {"key": "Status", "type": "str"},
        "minor_status": {"key": "MinorStatus", "type": "str"},
        "application_status": {"key": "ApplicationStatus", "type": "str"},
        "user_priority": {"key": "UserPriority", "type": "int"},
        "reschedule_counter": {"key": "RescheduleCounter", "type": "int"},
        "verified_flag": {"key": "VerifiedFlag", "type": "bool"},
        "accounted_flag": {"key": "AccountedFlag", "type": "JobMetaDataAccountedFlag"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        timestamp: Optional[datetime.datetime] = None,
        cpu_normalization_factor: Optional[int] = None,
        norm_cpu_time_s: Optional[int] = None,
        total_cpu_time_s: Optional[int] = None,
        host_name: Optional[str] = None,
        grid_ce: Optional[str] = None,
        model_name: Optional[str] = None,
        pilot_agent: Optional[str] = None,
        pilot_reference: Optional[str] = None,
        memory_mb: Optional[int] = None,
        local_account: Optional[str] = None,
        payload_pid: Optional[int] = None,
        ce_queue: Optional[str] = None,
        batch_system: Optional[str] = None,
        job_type: Optional[str] = None,
        job_status: Optional[str] = None,
        job_group: Optional[str] = None,
        site: Optional[str] = None,
        job_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_group: Optional[str] = None,
        vo: Optional[str] = None,
        submission_time: Optional[datetime.datetime] = None,
        reschedule_time: Optional[datetime.datetime] = None,
        last_update_time: Optional[datetime.datetime] = None,
        start_exec_time: Optional[datetime.datetime] = None,
        heart_beat_time: Optional[datetime.datetime] = None,
        end_exec_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        minor_status: Optional[str] = None,
        application_status: Optional[str] = None,
        user_priority: Optional[int] = None,
        reschedule_counter: Optional[int] = None,
        verified_flag: Optional[bool] = None,
        accounted_flag: Optional["_models.JobMetaDataAccountedFlag"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword timestamp: Timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword cpu_normalization_factor: Cpunormalizationfactor.
        :paramtype cpu_normalization_factor: int
        :keyword norm_cpu_time_s: Normcputime(S).
        :paramtype norm_cpu_time_s: int
        :keyword total_cpu_time_s: Totalcputime(S).
        :paramtype total_cpu_time_s: int
        :keyword host_name: Hostname.
        :paramtype host_name: str
        :keyword grid_ce: Gridce.
        :paramtype grid_ce: str
        :keyword model_name: Modelname.
        :paramtype model_name: str
        :keyword pilot_agent: Pilotagent.
        :paramtype pilot_agent: str
        :keyword pilot_reference: Pilot Reference.
        :paramtype pilot_reference: str
        :keyword memory_mb: Memory(Mb).
        :paramtype memory_mb: int
        :keyword local_account: Localaccount.
        :paramtype local_account: str
        :keyword payload_pid: Payloadpid.
        :paramtype payload_pid: int
        :keyword ce_queue: Cequeue.
        :paramtype ce_queue: str
        :keyword batch_system: Batchsystem.
        :paramtype batch_system: str
        :keyword job_type: Jobtype.
        :paramtype job_type: str
        :keyword job_status: Jobstatus.
        :paramtype job_status: str
        :keyword job_group: Jobgroup.
        :paramtype job_group: str
        :keyword site: Site.
        :paramtype site: str
        :keyword job_name: Jobname.
        :paramtype job_name: str
        :keyword owner: Owner.
        :paramtype owner: str
        :keyword owner_group: Ownergroup.
        :paramtype owner_group: str
        :keyword vo: Vo.
        :paramtype vo: str
        :keyword submission_time: Submissiontime.
        :paramtype submission_time: ~datetime.datetime
        :keyword reschedule_time: Rescheduletime.
        :paramtype reschedule_time: ~datetime.datetime
        :keyword last_update_time: Lastupdatetime.
        :paramtype last_update_time: ~datetime.datetime
        :keyword start_exec_time: Startexectime.
        :paramtype start_exec_time: ~datetime.datetime
        :keyword heart_beat_time: Heartbeattime.
        :paramtype heart_beat_time: ~datetime.datetime
        :keyword end_exec_time: Endexectime.
        :paramtype end_exec_time: ~datetime.datetime
        :keyword status: Status.
        :paramtype status: str
        :keyword minor_status: Minorstatus.
        :paramtype minor_status: str
        :keyword application_status: Applicationstatus.
        :paramtype application_status: str
        :keyword user_priority: Userpriority.
        :paramtype user_priority: int
        :keyword reschedule_counter: Reschedulecounter.
        :paramtype reschedule_counter: int
        :keyword verified_flag: Verifiedflag.
        :paramtype verified_flag: bool
        :keyword accounted_flag: Accountedflag.
        :paramtype accounted_flag: ~_generated.models.JobMetaDataAccountedFlag
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.timestamp = timestamp
        self.cpu_normalization_factor = cpu_normalization_factor
        self.norm_cpu_time_s = norm_cpu_time_s
        self.total_cpu_time_s = total_cpu_time_s
        self.host_name = host_name
        self.grid_ce = grid_ce
        self.model_name = model_name
        self.pilot_agent = pilot_agent
        self.pilot_reference = pilot_reference
        self.memory_mb = memory_mb
        self.local_account = local_account
        self.payload_pid = payload_pid
        self.ce_queue = ce_queue
        self.batch_system = batch_system
        self.job_type = job_type
        self.job_status = job_status
        self.job_group = job_group
        self.site = site
        self.job_name = job_name
        self.owner = owner
        self.owner_group = owner_group
        self.vo = vo
        self.submission_time = submission_time
        self.reschedule_time = reschedule_time
        self.last_update_time = last_update_time
        self.start_exec_time = start_exec_time
        self.heart_beat_time = heart_beat_time
        self.end_exec_time = end_exec_time
        self.status = status
        self.minor_status = minor_status
        self.application_status = application_status
        self.user_priority = user_priority
        self.reschedule_counter = reschedule_counter
        self.verified_flag = verified_flag
        self.accounted_flag = accounted_flag


class JobMetaDataAccountedFlag(_serialization.Model):
    """Accountedflag."""


class JobStatusUpdate(_serialization.Model):
    """JobStatusUpdate.

    :ivar status: JobStatus. Known values are: "Submitting", "Received", "Checking", "Staging",
     "Waiting", "Matched", "Running", "Stalled", "Completing", "Done", "Completed", "Failed",
     "Deleted", "Killed", and "Rescheduled".
    :vartype status: str or ~_generated.models.JobStatus
    :ivar minor_status: Minorstatus.
    :vartype minor_status: str
    :ivar application_status: Applicationstatus.
    :vartype application_status: str
    :ivar source: Source.
    :vartype source: str
    """

    _attribute_map = {
        "status": {"key": "Status", "type": "str"},
        "minor_status": {"key": "MinorStatus", "type": "str"},
        "application_status": {"key": "ApplicationStatus", "type": "str"},
        "source": {"key": "Source", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.JobStatus"]] = None,
        minor_status: Optional[str] = None,
        application_status: Optional[str] = None,
        source: str = "Unknown",
        **kwargs: Any
    ) -> None:
        """
        :keyword status: JobStatus. Known values are: "Submitting", "Received", "Checking", "Staging",
         "Waiting", "Matched", "Running", "Stalled", "Completing", "Done", "Completed", "Failed",
         "Deleted", "Killed", and "Rescheduled".
        :paramtype status: str or ~_generated.models.JobStatus
        :keyword minor_status: Minorstatus.
        :paramtype minor_status: str
        :keyword application_status: Applicationstatus.
        :paramtype application_status: str
        :keyword source: Source.
        :paramtype source: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.minor_status = minor_status
        self.application_status = application_status
        self.source = source


class OpenIDConfiguration(_serialization.Model):
    """OpenIDConfiguration.

    All required parameters must be populated in order to send to server.

    :ivar issuer: Issuer. Required.
    :vartype issuer: str
    :ivar token_endpoint: Token Endpoint. Required.
    :vartype token_endpoint: str
    :ivar userinfo_endpoint: Userinfo Endpoint. Required.
    :vartype userinfo_endpoint: str
    :ivar authorization_endpoint: Authorization Endpoint. Required.
    :vartype authorization_endpoint: str
    :ivar device_authorization_endpoint: Device Authorization Endpoint. Required.
    :vartype device_authorization_endpoint: str
    :ivar revocation_endpoint: Revocation Endpoint. Required.
    :vartype revocation_endpoint: str
    :ivar jwks_uri: Jwks Uri. Required.
    :vartype jwks_uri: str
    :ivar grant_types_supported: Grant Types Supported. Required.
    :vartype grant_types_supported: list[str]
    :ivar scopes_supported: Scopes Supported. Required.
    :vartype scopes_supported: list[str]
    :ivar response_types_supported: Response Types Supported. Required.
    :vartype response_types_supported: list[str]
    :ivar token_endpoint_auth_signing_alg_values_supported: Token Endpoint Auth Signing Alg Values
     Supported. Required.
    :vartype token_endpoint_auth_signing_alg_values_supported: list[str]
    :ivar token_endpoint_auth_methods_supported: Token Endpoint Auth Methods Supported. Required.
    :vartype token_endpoint_auth_methods_supported: list[str]
    :ivar code_challenge_methods_supported: Code Challenge Methods Supported. Required.
    :vartype code_challenge_methods_supported: list[str]
    """

    _validation = {
        "issuer": {"required": True},
        "token_endpoint": {"required": True},
        "userinfo_endpoint": {"required": True},
        "authorization_endpoint": {"required": True},
        "device_authorization_endpoint": {"required": True},
        "revocation_endpoint": {"required": True},
        "jwks_uri": {"required": True},
        "grant_types_supported": {"required": True},
        "scopes_supported": {"required": True},
        "response_types_supported": {"required": True},
        "token_endpoint_auth_signing_alg_values_supported": {"required": True},
        "token_endpoint_auth_methods_supported": {"required": True},
        "code_challenge_methods_supported": {"required": True},
    }

    _attribute_map = {
        "issuer": {"key": "issuer", "type": "str"},
        "token_endpoint": {"key": "token_endpoint", "type": "str"},
        "userinfo_endpoint": {"key": "userinfo_endpoint", "type": "str"},
        "authorization_endpoint": {"key": "authorization_endpoint", "type": "str"},
        "device_authorization_endpoint": {"key": "device_authorization_endpoint", "type": "str"},
        "revocation_endpoint": {"key": "revocation_endpoint", "type": "str"},
        "jwks_uri": {"key": "jwks_uri", "type": "str"},
        "grant_types_supported": {"key": "grant_types_supported", "type": "[str]"},
        "scopes_supported": {"key": "scopes_supported", "type": "[str]"},
        "response_types_supported": {"key": "response_types_supported", "type": "[str]"},
        "token_endpoint_auth_signing_alg_values_supported": {
            "key": "token_endpoint_auth_signing_alg_values_supported",
            "type": "[str]",
        },
        "token_endpoint_auth_methods_supported": {"key": "token_endpoint_auth_methods_supported", "type": "[str]"},
        "code_challenge_methods_supported": {"key": "code_challenge_methods_supported", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        issuer: str,
        token_endpoint: str,
        userinfo_endpoint: str,
        authorization_endpoint: str,
        device_authorization_endpoint: str,
        revocation_endpoint: str,
        jwks_uri: str,
        grant_types_supported: List[str],
        scopes_supported: List[str],
        response_types_supported: List[str],
        token_endpoint_auth_signing_alg_values_supported: List[str],
        token_endpoint_auth_methods_supported: List[str],
        code_challenge_methods_supported: List[str],
        **kwargs: Any
    ) -> None:
        """
        :keyword issuer: Issuer. Required.
        :paramtype issuer: str
        :keyword token_endpoint: Token Endpoint. Required.
        :paramtype token_endpoint: str
        :keyword userinfo_endpoint: Userinfo Endpoint. Required.
        :paramtype userinfo_endpoint: str
        :keyword authorization_endpoint: Authorization Endpoint. Required.
        :paramtype authorization_endpoint: str
        :keyword device_authorization_endpoint: Device Authorization Endpoint. Required.
        :paramtype device_authorization_endpoint: str
        :keyword revocation_endpoint: Revocation Endpoint. Required.
        :paramtype revocation_endpoint: str
        :keyword jwks_uri: Jwks Uri. Required.
        :paramtype jwks_uri: str
        :keyword grant_types_supported: Grant Types Supported. Required.
        :paramtype grant_types_supported: list[str]
        :keyword scopes_supported: Scopes Supported. Required.
        :paramtype scopes_supported: list[str]
        :keyword response_types_supported: Response Types Supported. Required.
        :paramtype response_types_supported: list[str]
        :keyword token_endpoint_auth_signing_alg_values_supported: Token Endpoint Auth Signing Alg
         Values Supported. Required.
        :paramtype token_endpoint_auth_signing_alg_values_supported: list[str]
        :keyword token_endpoint_auth_methods_supported: Token Endpoint Auth Methods Supported.
         Required.
        :paramtype token_endpoint_auth_methods_supported: list[str]
        :keyword code_challenge_methods_supported: Code Challenge Methods Supported. Required.
        :paramtype code_challenge_methods_supported: list[str]
        """
        super().__init__(**kwargs)
        self.issuer = issuer
        self.token_endpoint = token_endpoint
        self.userinfo_endpoint = userinfo_endpoint
        self.authorization_endpoint = authorization_endpoint
        self.device_authorization_endpoint = device_authorization_endpoint
        self.revocation_endpoint = revocation_endpoint
        self.jwks_uri = jwks_uri
        self.grant_types_supported = grant_types_supported
        self.scopes_supported = scopes_supported
        self.response_types_supported = response_types_supported
        self.token_endpoint_auth_signing_alg_values_supported = token_endpoint_auth_signing_alg_values_supported
        self.token_endpoint_auth_methods_supported = token_endpoint_auth_methods_supported
        self.code_challenge_methods_supported = code_challenge_methods_supported


class SandboxDownloadResponse(_serialization.Model):
    """SandboxDownloadResponse.

    All required parameters must be populated in order to send to server.

    :ivar url: Url. Required.
    :vartype url: str
    :ivar expires_in: Expires In. Required.
    :vartype expires_in: int
    """

    _validation = {
        "url": {"required": True},
        "expires_in": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "expires_in": {"key": "expires_in", "type": "int"},
    }

    def __init__(self, *, url: str, expires_in: int, **kwargs: Any) -> None:
        """
        :keyword url: Url. Required.
        :paramtype url: str
        :keyword expires_in: Expires In. Required.
        :paramtype expires_in: int
        """
        super().__init__(**kwargs)
        self.url = url
        self.expires_in = expires_in


class SandboxInfo(_serialization.Model):
    """SandboxInfo.

    All required parameters must be populated in order to send to server.

    :ivar checksum_algorithm: ChecksumAlgorithm. Required. "sha256"
    :vartype checksum_algorithm: str or ~_generated.models.ChecksumAlgorithm
    :ivar checksum: Checksum. Required.
    :vartype checksum: str
    :ivar size: Size. Required.
    :vartype size: int
    :ivar format: SandboxFormat. Required. Known values are: "tar.bz2" and "tar.zst".
    :vartype format: str or ~_generated.models.SandboxFormat
    """

    _validation = {
        "checksum_algorithm": {"required": True},
        "checksum": {"required": True, "pattern": r"^[0-9a-fA-F]{64}$"},
        "size": {"required": True, "minimum": 1},
        "format": {"required": True},
    }

    _attribute_map = {
        "checksum_algorithm": {"key": "checksum_algorithm", "type": "str"},
        "checksum": {"key": "checksum", "type": "str"},
        "size": {"key": "size", "type": "int"},
        "format": {"key": "format", "type": "str"},
    }

    def __init__(
        self,
        *,
        checksum_algorithm: Union[str, "_models.ChecksumAlgorithm"],
        checksum: str,
        size: int,
        format: Union[str, "_models.SandboxFormat"],
        **kwargs: Any
    ) -> None:
        """
        :keyword checksum_algorithm: ChecksumAlgorithm. Required. "sha256"
        :paramtype checksum_algorithm: str or ~_generated.models.ChecksumAlgorithm
        :keyword checksum: Checksum. Required.
        :paramtype checksum: str
        :keyword size: Size. Required.
        :paramtype size: int
        :keyword format: SandboxFormat. Required. Known values are: "tar.bz2" and "tar.zst".
        :paramtype format: str or ~_generated.models.SandboxFormat
        """
        super().__init__(**kwargs)
        self.checksum_algorithm = checksum_algorithm
        self.checksum = checksum
        self.size = size
        self.format = format


class SandboxUploadResponse(_serialization.Model):
    """SandboxUploadResponse.

    All required parameters must be populated in order to send to server.

    :ivar pfn: Pfn. Required.
    :vartype pfn: str
    :ivar url: Url.
    :vartype url: str
    :ivar fields: Fields.
    :vartype fields: dict[str, str]
    """

    _validation = {
        "pfn": {"required": True},
    }

    _attribute_map = {
        "pfn": {"key": "pfn", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "fields": {"key": "fields", "type": "{str}"},
    }

    def __init__(
        self, *, pfn: str, url: Optional[str] = None, fields: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword pfn: Pfn. Required.
        :paramtype pfn: str
        :keyword url: Url.
        :paramtype url: str
        :keyword fields: Fields.
        :paramtype fields: dict[str, str]
        """
        super().__init__(**kwargs)
        self.pfn = pfn
        self.url = url
        self.fields = fields


class ScalarSearchSpec(_serialization.Model):
    """ScalarSearchSpec.

    All required parameters must be populated in order to send to server.

    :ivar parameter: Parameter. Required.
    :vartype parameter: str
    :ivar operator: ScalarSearchOperator. Required. Known values are: "eq", "neq", "gt", "lt",
     "like", "not like", and "regex".
    :vartype operator: str or ~_generated.models.ScalarSearchOperator
    :ivar value: Value. Required.
    :vartype value: ~_generated.models.ScalarSearchSpecValue
    """

    _validation = {
        "parameter": {"required": True},
        "operator": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "parameter": {"key": "parameter", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "value": {"key": "value", "type": "ScalarSearchSpecValue"},
    }

    def __init__(
        self,
        *,
        parameter: str,
        operator: Union[str, "_models.ScalarSearchOperator"],
        value: "_models.ScalarSearchSpecValue",
        **kwargs: Any
    ) -> None:
        """
        :keyword parameter: Parameter. Required.
        :paramtype parameter: str
        :keyword operator: ScalarSearchOperator. Required. Known values are: "eq", "neq", "gt", "lt",
         "like", "not like", and "regex".
        :paramtype operator: str or ~_generated.models.ScalarSearchOperator
        :keyword value: Value. Required.
        :paramtype value: ~_generated.models.ScalarSearchSpecValue
        """
        super().__init__(**kwargs)
        self.parameter = parameter
        self.operator = operator
        self.value = value


class ScalarSearchSpecValue(_serialization.Model):
    """Value."""


class SearchParams(_serialization.Model):
    """SearchParams.

    :ivar parameters: Parameters.
    :vartype parameters: list[str]
    :ivar search: Search.
    :vartype search: list[~_generated.models.SearchParamsSearchItem]
    :ivar sort: Sort.
    :vartype sort: list[~_generated.models.SortSpec]
    :ivar distinct: Distinct.
    :vartype distinct: bool
    """

    _attribute_map = {
        "parameters": {"key": "parameters", "type": "[str]"},
        "search": {"key": "search", "type": "[SearchParamsSearchItem]"},
        "sort": {"key": "sort", "type": "[SortSpec]"},
        "distinct": {"key": "distinct", "type": "bool"},
    }

    def __init__(
        self,
        *,
        parameters: Optional[List[str]] = None,
        search: List["_models.SearchParamsSearchItem"] = [],
        sort: List["_models.SortSpec"] = [],
        distinct: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword parameters: Parameters.
        :paramtype parameters: list[str]
        :keyword search: Search.
        :paramtype search: list[~_generated.models.SearchParamsSearchItem]
        :keyword sort: Sort.
        :paramtype sort: list[~_generated.models.SortSpec]
        :keyword distinct: Distinct.
        :paramtype distinct: bool
        """
        super().__init__(**kwargs)
        self.parameters = parameters
        self.search = search
        self.sort = sort
        self.distinct = distinct


class SearchParamsSearchItem(_serialization.Model):
    """SearchParamsSearchItem."""


class SetJobStatusReturn(_serialization.Model):
    """SetJobStatusReturn.

    All required parameters must be populated in order to send to server.

    :ivar success: Success. Required.
    :vartype success: dict[str, ~_generated.models.SetJobStatusReturnSuccess]
    :ivar failed: Failed. Required.
    :vartype failed: dict[str, dict[str, str]]
    """

    _validation = {
        "success": {"required": True},
        "failed": {"required": True},
    }

    _attribute_map = {
        "success": {"key": "success", "type": "{SetJobStatusReturnSuccess}"},
        "failed": {"key": "failed", "type": "{{str}}"},
    }

    def __init__(
        self,
        *,
        success: Dict[str, "_models.SetJobStatusReturnSuccess"],
        failed: Dict[str, Dict[str, str]],
        **kwargs: Any
    ) -> None:
        """
        :keyword success: Success. Required.
        :paramtype success: dict[str, ~_generated.models.SetJobStatusReturnSuccess]
        :keyword failed: Failed. Required.
        :paramtype failed: dict[str, dict[str, str]]
        """
        super().__init__(**kwargs)
        self.success = success
        self.failed = failed


class SetJobStatusReturnSuccess(_serialization.Model):
    """Successful new status change.

    :ivar status: JobStatus. Known values are: "Submitting", "Received", "Checking", "Staging",
     "Waiting", "Matched", "Running", "Stalled", "Completing", "Done", "Completed", "Failed",
     "Deleted", "Killed", and "Rescheduled".
    :vartype status: str or ~_generated.models.JobStatus
    :ivar minor_status: Minorstatus.
    :vartype minor_status: str
    :ivar application_status: Applicationstatus.
    :vartype application_status: str
    :ivar heart_beat_time: Heartbeattime.
    :vartype heart_beat_time: ~datetime.datetime
    :ivar start_exec_time: Startexectime.
    :vartype start_exec_time: ~datetime.datetime
    :ivar end_exec_time: Endexectime.
    :vartype end_exec_time: ~datetime.datetime
    :ivar last_update_time: Lastupdatetime.
    :vartype last_update_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "Status", "type": "str"},
        "minor_status": {"key": "MinorStatus", "type": "str"},
        "application_status": {"key": "ApplicationStatus", "type": "str"},
        "heart_beat_time": {"key": "HeartBeatTime", "type": "iso-8601"},
        "start_exec_time": {"key": "StartExecTime", "type": "iso-8601"},
        "end_exec_time": {"key": "EndExecTime", "type": "iso-8601"},
        "last_update_time": {"key": "LastUpdateTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.JobStatus"]] = None,
        minor_status: Optional[str] = None,
        application_status: Optional[str] = None,
        heart_beat_time: Optional[datetime.datetime] = None,
        start_exec_time: Optional[datetime.datetime] = None,
        end_exec_time: Optional[datetime.datetime] = None,
        last_update_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: JobStatus. Known values are: "Submitting", "Received", "Checking", "Staging",
         "Waiting", "Matched", "Running", "Stalled", "Completing", "Done", "Completed", "Failed",
         "Deleted", "Killed", and "Rescheduled".
        :paramtype status: str or ~_generated.models.JobStatus
        :keyword minor_status: Minorstatus.
        :paramtype minor_status: str
        :keyword application_status: Applicationstatus.
        :paramtype application_status: str
        :keyword heart_beat_time: Heartbeattime.
        :paramtype heart_beat_time: ~datetime.datetime
        :keyword start_exec_time: Startexectime.
        :paramtype start_exec_time: ~datetime.datetime
        :keyword end_exec_time: Endexectime.
        :paramtype end_exec_time: ~datetime.datetime
        :keyword last_update_time: Lastupdatetime.
        :paramtype last_update_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.minor_status = minor_status
        self.application_status = application_status
        self.heart_beat_time = heart_beat_time
        self.start_exec_time = start_exec_time
        self.end_exec_time = end_exec_time
        self.last_update_time = last_update_time


class SortSpec(_serialization.Model):
    """SortSpec.

    All required parameters must be populated in order to send to server.

    :ivar parameter: Parameter. Required.
    :vartype parameter: str
    :ivar direction: SortDirection. Required. Known values are: "asc" and "desc".
    :vartype direction: str or ~_generated.models.SortDirection
    """

    _validation = {
        "parameter": {"required": True},
        "direction": {"required": True},
    }

    _attribute_map = {
        "parameter": {"key": "parameter", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(self, *, parameter: str, direction: Union[str, "_models.SortDirection"], **kwargs: Any) -> None:
        """
        :keyword parameter: Parameter. Required.
        :paramtype parameter: str
        :keyword direction: SortDirection. Required. Known values are: "asc" and "desc".
        :paramtype direction: str or ~_generated.models.SortDirection
        """
        super().__init__(**kwargs)
        self.parameter = parameter
        self.direction = direction


class SummaryParams(_serialization.Model):
    """SummaryParams.

    All required parameters must be populated in order to send to server.

    :ivar grouping: Grouping. Required.
    :vartype grouping: list[str]
    :ivar search: Search.
    :vartype search: list[~_generated.models.SummaryParamsSearchItem]
    """

    _validation = {
        "grouping": {"required": True},
    }

    _attribute_map = {
        "grouping": {"key": "grouping", "type": "[str]"},
        "search": {"key": "search", "type": "[SummaryParamsSearchItem]"},
    }

    def __init__(
        self, *, grouping: List[str], search: List["_models.SummaryParamsSearchItem"] = [], **kwargs: Any
    ) -> None:
        """
        :keyword grouping: Grouping. Required.
        :paramtype grouping: list[str]
        :keyword search: Search.
        :paramtype search: list[~_generated.models.SummaryParamsSearchItem]
        """
        super().__init__(**kwargs)
        self.grouping = grouping
        self.search = search


class SummaryParamsSearchItem(_serialization.Model):
    """SummaryParamsSearchItem."""


class SupportInfo(_serialization.Model):
    """SupportInfo.

    All required parameters must be populated in order to send to server.

    :ivar message: Message. Required.
    :vartype message: str
    :ivar webpage: Webpage. Required.
    :vartype webpage: str
    :ivar email: Email. Required.
    :vartype email: str
    """

    _validation = {
        "message": {"required": True},
        "webpage": {"required": True},
        "email": {"required": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "webpage": {"key": "webpage", "type": "str"},
        "email": {"key": "email", "type": "str"},
    }

    def __init__(self, *, message: str, webpage: str, email: str, **kwargs: Any) -> None:
        """
        :keyword message: Message. Required.
        :paramtype message: str
        :keyword webpage: Webpage. Required.
        :paramtype webpage: str
        :keyword email: Email. Required.
        :paramtype email: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.webpage = webpage
        self.email = email


class TokenResponse(_serialization.Model):
    """TokenResponse.

    All required parameters must be populated in order to send to server.

    :ivar access_token: Access Token. Required.
    :vartype access_token: str
    :ivar expires_in: Expires In. Required.
    :vartype expires_in: int
    :ivar token_type: Token Type.
    :vartype token_type: str
    :ivar refresh_token: Refresh Token.
    :vartype refresh_token: str
    """

    _validation = {
        "access_token": {"required": True},
        "expires_in": {"required": True},
    }

    _attribute_map = {
        "access_token": {"key": "access_token", "type": "str"},
        "expires_in": {"key": "expires_in", "type": "int"},
        "token_type": {"key": "token_type", "type": "str"},
        "refresh_token": {"key": "refresh_token", "type": "str"},
    }

    def __init__(
        self,
        *,
        access_token: str,
        expires_in: int,
        token_type: str = "Bearer",
        refresh_token: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword access_token: Access Token. Required.
        :paramtype access_token: str
        :keyword expires_in: Expires In. Required.
        :paramtype expires_in: int
        :keyword token_type: Token Type.
        :paramtype token_type: str
        :keyword refresh_token: Refresh Token.
        :paramtype refresh_token: str
        """
        super().__init__(**kwargs)
        self.access_token = access_token
        self.expires_in = expires_in
        self.token_type = token_type
        self.refresh_token = refresh_token


class UserInfoResponse(_serialization.Model):
    """Response for the userinfo endpoint.

    All required parameters must be populated in order to send to server.

    :ivar sub: Sub. Required.
    :vartype sub: str
    :ivar vo: Vo. Required.
    :vartype vo: str
    :ivar dirac_group: Dirac Group. Required.
    :vartype dirac_group: str
    :ivar policies: Policies. Required.
    :vartype policies: dict[str, any]
    :ivar properties: Properties. Required.
    :vartype properties: list[str]
    :ivar preferred_username: Preferred Username. Required.
    :vartype preferred_username: str
    """

    _validation = {
        "sub": {"required": True},
        "vo": {"required": True},
        "dirac_group": {"required": True},
        "policies": {"required": True},
        "properties": {"required": True},
        "preferred_username": {"required": True},
    }

    _attribute_map = {
        "sub": {"key": "sub", "type": "str"},
        "vo": {"key": "vo", "type": "str"},
        "dirac_group": {"key": "dirac_group", "type": "str"},
        "policies": {"key": "policies", "type": "{object}"},
        "properties": {"key": "properties", "type": "[str]"},
        "preferred_username": {"key": "preferred_username", "type": "str"},
    }

    def __init__(
        self,
        *,
        sub: str,
        vo: str,
        dirac_group: str,
        policies: Dict[str, Any],
        properties: List[str],
        preferred_username: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword sub: Sub. Required.
        :paramtype sub: str
        :keyword vo: Vo. Required.
        :paramtype vo: str
        :keyword dirac_group: Dirac Group. Required.
        :paramtype dirac_group: str
        :keyword policies: Policies. Required.
        :paramtype policies: dict[str, any]
        :keyword properties: Properties. Required.
        :paramtype properties: list[str]
        :keyword preferred_username: Preferred Username. Required.
        :paramtype preferred_username: str
        """
        super().__init__(**kwargs)
        self.sub = sub
        self.vo = vo
        self.dirac_group = dirac_group
        self.policies = policies
        self.properties = properties
        self.preferred_username = preferred_username


class ValidationError(_serialization.Model):
    """ValidationError.

    All required parameters must be populated in order to send to server.

    :ivar loc: Location. Required.
    :vartype loc: list[~_generated.models.ValidationErrorLocItem]
    :ivar msg: Message. Required.
    :vartype msg: str
    :ivar type: Error Type. Required.
    :vartype type: str
    """

    _validation = {
        "loc": {"required": True},
        "msg": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "loc": {"key": "loc", "type": "[ValidationErrorLocItem]"},
        "msg": {"key": "msg", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, loc: List["_models.ValidationErrorLocItem"], msg: str, type: str, **kwargs: Any) -> None:
        """
        :keyword loc: Location. Required.
        :paramtype loc: list[~_generated.models.ValidationErrorLocItem]
        :keyword msg: Message. Required.
        :paramtype msg: str
        :keyword type: Error Type. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.loc = loc
        self.msg = msg
        self.type = type


class ValidationErrorLocItem(_serialization.Model):
    """ValidationErrorLocItem."""


class VectorSearchSpec(_serialization.Model):
    """VectorSearchSpec.

    All required parameters must be populated in order to send to server.

    :ivar parameter: Parameter. Required.
    :vartype parameter: str
    :ivar operator: VectorSearchOperator. Required. Known values are: "in" and "not in".
    :vartype operator: str or ~_generated.models.VectorSearchOperator
    :ivar values: Values. Required.
    :vartype values: ~_generated.models.VectorSearchSpecValues
    """

    _validation = {
        "parameter": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "parameter": {"key": "parameter", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "VectorSearchSpecValues"},
    }

    def __init__(
        self,
        *,
        parameter: str,
        operator: Union[str, "_models.VectorSearchOperator"],
        values: "_models.VectorSearchSpecValues",
        **kwargs: Any
    ) -> None:
        """
        :keyword parameter: Parameter. Required.
        :paramtype parameter: str
        :keyword operator: VectorSearchOperator. Required. Known values are: "in" and "not in".
        :paramtype operator: str or ~_generated.models.VectorSearchOperator
        :keyword values: Values. Required.
        :paramtype values: ~_generated.models.VectorSearchSpecValues
        """
        super().__init__(**kwargs)
        self.parameter = parameter
        self.operator = operator
        self.values = values


class VectorSearchSpecValues(_serialization.Model):
    """Values."""


class VOInfo(_serialization.Model):
    """VOInfo.

    All required parameters must be populated in order to send to server.

    :ivar groups: Groups. Required.
    :vartype groups: dict[str, ~_generated.models.GroupInfo]
    :ivar support: SupportInfo. Required.
    :vartype support: ~_generated.models.SupportInfo
    :ivar default_group: Default Group. Required.
    :vartype default_group: str
    """

    _validation = {
        "groups": {"required": True},
        "support": {"required": True},
        "default_group": {"required": True},
    }

    _attribute_map = {
        "groups": {"key": "groups", "type": "{GroupInfo}"},
        "support": {"key": "support", "type": "SupportInfo"},
        "default_group": {"key": "default_group", "type": "str"},
    }

    def __init__(
        self,
        *,
        groups: Dict[str, "_models.GroupInfo"],
        support: "_models.SupportInfo",
        default_group: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword groups: Groups. Required.
        :paramtype groups: dict[str, ~_generated.models.GroupInfo]
        :keyword support: SupportInfo. Required.
        :paramtype support: ~_generated.models.SupportInfo
        :keyword default_group: Default Group. Required.
        :paramtype default_group: str
        """
        super().__init__(**kwargs)
        self.groups = groups
        self.support = support
        self.default_group = default_group
