# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MembershipAttachmentArgs', 'MembershipAttachment']

@pulumi.input_type
class MembershipAttachmentArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.str],
                 sub_cluster_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a MembershipAttachment resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster to which the membership is being attached.
        :param pulumi.Input[_builtins.str] sub_cluster_id: The ID of the member being attached to the cluster.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "sub_cluster_id", sub_cluster_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the cluster to which the membership is being attached.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="subClusterId")
    def sub_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the member being attached to the cluster.
        """
        return pulumi.get(self, "sub_cluster_id")

    @sub_cluster_id.setter
    def sub_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sub_cluster_id", value)


@pulumi.input_type
class _MembershipAttachmentState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MembershipAttachment resources.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster to which the membership is being attached.
        :param pulumi.Input[_builtins.str] sub_cluster_id: The ID of the member being attached to the cluster.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if sub_cluster_id is not None:
            pulumi.set(__self__, "sub_cluster_id", sub_cluster_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the cluster to which the membership is being attached.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="subClusterId")
    def sub_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the member being attached to the cluster.
        """
        return pulumi.get(self, "sub_cluster_id")

    @sub_cluster_id.setter
    def sub_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_cluster_id", value)


@pulumi.type_token("alicloud:ackone/membershipAttachment:MembershipAttachment")
class MembershipAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Ack One Membership Attachment resource. Fleet Manager Membership Attachment.

        For information about Ack One Membership Attachment and how to use it, see [How to attach cluster tp hub](https://www.alibabacloud.com/help/en/ack/distributed-cloud-container-platform-for-kubernetes/developer-reference/api-adcp-2022-01-01-attachclustertohub).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        key_name = config.get("keyName")
        if key_name is None:
            key_name = "%s"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker",
            system_disk_category="cloud_efficiency")
        default = alicloud.vpc.Network("default", cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            cidr_block="10.4.0.0/24",
            vpc_id=default.id,
            zone_id=enhanced.zones[0].zone_id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            cluster_spec="ack.pro.small",
            vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True,
            is_enterprise_security_group=True)
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=key_name)
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1")
        default_cluster = alicloud.ackone.Cluster("default",
            network={
                "vpc_id": default.id,
                "vswitches": [default_switch.id],
            },
            argocd_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default_managed_kubernetes]))
        default_membership_attachment = alicloud.ackone.MembershipAttachment("default",
            cluster_id=default_cluster.id,
            sub_cluster_id=default_managed_kubernetes.id)
        ```

        ## Import

        Ack One Membership Attachment can be imported using the id, which consists of cluster_id and sub_cluster_id, e.g.

        ```sh
        $ pulumi import alicloud:ackone/membershipAttachment:MembershipAttachment example <cluster_id>:<sub_cluster_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster to which the membership is being attached.
        :param pulumi.Input[_builtins.str] sub_cluster_id: The ID of the member being attached to the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MembershipAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Ack One Membership Attachment resource. Fleet Manager Membership Attachment.

        For information about Ack One Membership Attachment and how to use it, see [How to attach cluster tp hub](https://www.alibabacloud.com/help/en/ack/distributed-cloud-container-platform-for-kubernetes/developer-reference/api-adcp-2022-01-01-attachclustertohub).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        key_name = config.get("keyName")
        if key_name is None:
            key_name = "%s"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        cloud_efficiency = alicloud.ecs.get_instance_types(availability_zone=enhanced.zones[0].zone_id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker",
            system_disk_category="cloud_efficiency")
        default = alicloud.vpc.Network("default", cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            cidr_block="10.4.0.0/24",
            vpc_id=default.id,
            zone_id=enhanced.zones[0].zone_id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            cluster_spec="ack.pro.small",
            vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True,
            is_enterprise_security_group=True)
        default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=key_name)
        default_node_pool = alicloud.cs.NodePool("default",
            node_pool_name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[cloud_efficiency.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            key_name=default_key_pair.key_pair_name,
            desired_size="1")
        default_cluster = alicloud.ackone.Cluster("default",
            network={
                "vpc_id": default.id,
                "vswitches": [default_switch.id],
            },
            argocd_enabled=False,
            opts = pulumi.ResourceOptions(depends_on=[default_managed_kubernetes]))
        default_membership_attachment = alicloud.ackone.MembershipAttachment("default",
            cluster_id=default_cluster.id,
            sub_cluster_id=default_managed_kubernetes.id)
        ```

        ## Import

        Ack One Membership Attachment can be imported using the id, which consists of cluster_id and sub_cluster_id, e.g.

        ```sh
        $ pulumi import alicloud:ackone/membershipAttachment:MembershipAttachment example <cluster_id>:<sub_cluster_id>
        ```

        :param str resource_name: The name of the resource.
        :param MembershipAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MembershipAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MembershipAttachmentArgs.__new__(MembershipAttachmentArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if sub_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'sub_cluster_id'")
            __props__.__dict__["sub_cluster_id"] = sub_cluster_id
        super(MembershipAttachment, __self__).__init__(
            'alicloud:ackone/membershipAttachment:MembershipAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            sub_cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MembershipAttachment':
        """
        Get an existing MembershipAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The ID of the cluster to which the membership is being attached.
        :param pulumi.Input[_builtins.str] sub_cluster_id: The ID of the member being attached to the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MembershipAttachmentState.__new__(_MembershipAttachmentState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["sub_cluster_id"] = sub_cluster_id
        return MembershipAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the cluster to which the membership is being attached.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="subClusterId")
    def sub_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the member being attached to the cluster.
        """
        return pulumi.get(self, "sub_cluster_id")

