# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AdvancedQueryTemplateArgs', 'AdvancedQueryTemplate']

@pulumi.input_type
class AdvancedQueryTemplateArgs:
    def __init__(__self__, *,
                 simple_query: pulumi.Input[_builtins.bool],
                 template_sql: pulumi.Input[_builtins.str],
                 template_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AdvancedQueryTemplate resource.
        :param pulumi.Input[_builtins.bool] simple_query: Distinguish whether the current template is a simple query
        :param pulumi.Input[_builtins.str] template_sql: SQL content saved on behalf of the current template
        :param pulumi.Input[_builtins.str] template_name: The name of the resource
        """
        pulumi.set(__self__, "simple_query", simple_query)
        pulumi.set(__self__, "template_sql", template_sql)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="simpleQuery")
    def simple_query(self) -> pulumi.Input[_builtins.bool]:
        """
        Distinguish whether the current template is a simple query
        """
        return pulumi.get(self, "simple_query")

    @simple_query.setter
    def simple_query(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "simple_query", value)

    @_builtins.property
    @pulumi.getter(name="templateSql")
    def template_sql(self) -> pulumi.Input[_builtins.str]:
        """
        SQL content saved on behalf of the current template
        """
        return pulumi.get(self, "template_sql")

    @template_sql.setter
    def template_sql(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "template_sql", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)


@pulumi.input_type
class _AdvancedQueryTemplateState:
    def __init__(__self__, *,
                 simple_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_sql: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AdvancedQueryTemplate resources.
        :param pulumi.Input[_builtins.bool] simple_query: Distinguish whether the current template is a simple query
        :param pulumi.Input[_builtins.str] template_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_sql: SQL content saved on behalf of the current template
        """
        if simple_query is not None:
            pulumi.set(__self__, "simple_query", simple_query)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_sql is not None:
            pulumi.set(__self__, "template_sql", template_sql)

    @_builtins.property
    @pulumi.getter(name="simpleQuery")
    def simple_query(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Distinguish whether the current template is a simple query
        """
        return pulumi.get(self, "simple_query")

    @simple_query.setter
    def simple_query(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "simple_query", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)

    @_builtins.property
    @pulumi.getter(name="templateSql")
    def template_sql(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SQL content saved on behalf of the current template
        """
        return pulumi.get(self, "template_sql")

    @template_sql.setter
    def template_sql(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_sql", value)


@pulumi.type_token("alicloud:actiontrail/advancedQueryTemplate:AdvancedQueryTemplate")
class AdvancedQueryTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 simple_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_sql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Actiontrail Advanced Query Template resource.

        sql template of advanced query.

        For information about Actiontrail Advanced Query Template and how to use it, see [What is Advanced Query Template](https://next.api.alibabacloud.com/document/Actiontrail/2020-07-06/CreateAdvancedQueryTemplate).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.actiontrail.AdvancedQueryTemplate("default",
            simple_query=True,
            template_name="exampleTemplateName",
            template_sql="*")
        ```

        ## Import

        Actiontrail Advanced Query Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:actiontrail/advancedQueryTemplate:AdvancedQueryTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] simple_query: Distinguish whether the current template is a simple query
        :param pulumi.Input[_builtins.str] template_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_sql: SQL content saved on behalf of the current template
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdvancedQueryTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Actiontrail Advanced Query Template resource.

        sql template of advanced query.

        For information about Actiontrail Advanced Query Template and how to use it, see [What is Advanced Query Template](https://next.api.alibabacloud.com/document/Actiontrail/2020-07-06/CreateAdvancedQueryTemplate).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.actiontrail.AdvancedQueryTemplate("default",
            simple_query=True,
            template_name="exampleTemplateName",
            template_sql="*")
        ```

        ## Import

        Actiontrail Advanced Query Template can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:actiontrail/advancedQueryTemplate:AdvancedQueryTemplate example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AdvancedQueryTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdvancedQueryTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 simple_query: Optional[pulumi.Input[_builtins.bool]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_sql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdvancedQueryTemplateArgs.__new__(AdvancedQueryTemplateArgs)

            if simple_query is None and not opts.urn:
                raise TypeError("Missing required property 'simple_query'")
            __props__.__dict__["simple_query"] = simple_query
            __props__.__dict__["template_name"] = template_name
            if template_sql is None and not opts.urn:
                raise TypeError("Missing required property 'template_sql'")
            __props__.__dict__["template_sql"] = template_sql
        super(AdvancedQueryTemplate, __self__).__init__(
            'alicloud:actiontrail/advancedQueryTemplate:AdvancedQueryTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            simple_query: Optional[pulumi.Input[_builtins.bool]] = None,
            template_name: Optional[pulumi.Input[_builtins.str]] = None,
            template_sql: Optional[pulumi.Input[_builtins.str]] = None) -> 'AdvancedQueryTemplate':
        """
        Get an existing AdvancedQueryTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] simple_query: Distinguish whether the current template is a simple query
        :param pulumi.Input[_builtins.str] template_name: The name of the resource
        :param pulumi.Input[_builtins.str] template_sql: SQL content saved on behalf of the current template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdvancedQueryTemplateState.__new__(_AdvancedQueryTemplateState)

        __props__.__dict__["simple_query"] = simple_query
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["template_sql"] = template_sql
        return AdvancedQueryTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="simpleQuery")
    def simple_query(self) -> pulumi.Output[_builtins.bool]:
        """
        Distinguish whether the current template is a simple query
        """
        return pulumi.get(self, "simple_query")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "template_name")

    @_builtins.property
    @pulumi.getter(name="templateSql")
    def template_sql(self) -> pulumi.Output[_builtins.str]:
        """
        SQL content saved on behalf of the current template
        """
        return pulumi.get(self, "template_sql")

