# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ListenerAclAttachmentArgs', 'ListenerAclAttachment']

@pulumi.input_type
class ListenerAclAttachmentArgs:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[_builtins.str],
                 acl_type: pulumi.Input[_builtins.str],
                 listener_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ListenerAclAttachment resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID list of the access policy group bound by the listener.
        :param pulumi.Input[_builtins.str] acl_type: Access control type:
               - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
               - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        :param pulumi.Input[_builtins.str] listener_id: Listener instance ID.
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "acl_type", acl_type)
        pulumi.set(__self__, "listener_id", listener_id)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID list of the access policy group bound by the listener.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Input[_builtins.str]:
        """
        Access control type:
        - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
        - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "acl_type", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[_builtins.str]:
        """
        Listener instance ID.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "listener_id", value)


@pulumi.input_type
class _ListenerAclAttachmentState:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ListenerAclAttachment resources.
        :param pulumi.Input[_builtins.str] acl_id: The ID list of the access policy group bound by the listener.
        :param pulumi.Input[_builtins.str] acl_type: Access control type:
               - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
               - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        :param pulumi.Input[_builtins.str] listener_id: Listener instance ID.
        :param pulumi.Input[_builtins.str] status: Listener Status.
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if acl_type is not None:
            pulumi.set(__self__, "acl_type", acl_type)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID list of the access policy group bound by the listener.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_id", value)

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access control type:
        - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
        - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        """
        return pulumi.get(self, "acl_type")

    @acl_type.setter
    def acl_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acl_type", value)

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listener instance ID.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Listener Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:alb/listenerAclAttachment:ListenerAclAttachment")
class ListenerAclAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a ALB Listener Acl Attachment resource. Associating ACL to listening.

        For information about ALB Listener Acl Attachment and how to use it, see [What is Listener Acl Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateaclswithlistener).

        > **NOTE:** Available since v1.163.0.

        > **NOTE:** You can associate at most three ACLs with a listener.

        > **NOTE:** You can only configure either a whitelist or a blacklist for listener, not at the same time.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.alb.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=std.format(input="10.4.%d.0/24",
                    args=[range["value"] + 1]).result,
                zone_id=default.zones[range["value"] + 3].id,
                vswitch_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            vpc_id=default_network.id,
            address_type="Internet",
            address_allocated_mode="Fixed",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            resource_group_id=default_get_resource_groups.groups[0].id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            tags={
                "Created": "TF",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch[0].id,
                    "zone_id": default_switch[0].zone_id,
                },
                {
                    "vswitch_id": default_switch[1].id,
                    "zone_id": default_switch[1].zone_id,
                },
            ])
        default_server_group = alicloud.alb.ServerGroup("default",
            protocol="HTTP",
            vpc_id=default_network.id,
            server_group_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": False,
            },
            tags={
                "Created": "TF",
            })
        default_listener = alicloud.alb.Listener("default",
            load_balancer_id=default_load_balancer.id,
            listener_protocol="HTTP",
            listener_port=80,
            listener_description=name,
            default_actions=[{
                "type": "ForwardGroup",
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
            }])
        default_acl = alicloud.alb.Acl("default",
            acl_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id)
        default_acl_entry_attachment = alicloud.alb.AclEntryAttachment("default",
            acl_id=default_acl.id,
            entry="10.0.0.0/24",
            description=name)
        default_listener_acl_attachment = alicloud.alb.ListenerAclAttachment("default",
            acl_id=default_acl.id,
            listener_id=default_listener.id,
            acl_type="White")
        ```

        ## Import

        ALB Listener Acl Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/listenerAclAttachment:ListenerAclAttachment example <listener_id>:<acl_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID list of the access policy group bound by the listener.
        :param pulumi.Input[_builtins.str] acl_type: Access control type:
               - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
               - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        :param pulumi.Input[_builtins.str] listener_id: Listener instance ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerAclAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ALB Listener Acl Attachment resource. Associating ACL to listening.

        For information about ALB Listener Acl Attachment and how to use it, see [What is Listener Acl Attachment](https://www.alibabacloud.com/help/en/slb/application-load-balancer/developer-reference/api-alb-2020-06-16-associateaclswithlistener).

        > **NOTE:** Available since v1.163.0.

        > **NOTE:** You can associate at most three ACLs with a listener.

        > **NOTE:** You can only configure either a whitelist or a blacklist for listener, not at the same time.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.alb.get_zones()
        default_get_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_switch.append(alicloud.vpc.Switch(f"default-{range['value']}",
                vpc_id=default_network.id,
                cidr_block=std.format(input="10.4.%d.0/24",
                    args=[range["value"] + 1]).result,
                zone_id=default.zones[range["value"] + 3].id,
                vswitch_name=std.format(input=f"{name}_%d",
                    args=[range["value"] + 1]).result))
        default_load_balancer = alicloud.alb.LoadBalancer("default",
            vpc_id=default_network.id,
            address_type="Internet",
            address_allocated_mode="Fixed",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            resource_group_id=default_get_resource_groups.groups[0].id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            tags={
                "Created": "TF",
            },
            zone_mappings=[
                {
                    "vswitch_id": default_switch[0].id,
                    "zone_id": default_switch[0].zone_id,
                },
                {
                    "vswitch_id": default_switch[1].id,
                    "zone_id": default_switch[1].zone_id,
                },
            ])
        default_server_group = alicloud.alb.ServerGroup("default",
            protocol="HTTP",
            vpc_id=default_network.id,
            server_group_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id,
            health_check_config={
                "health_check_enabled": False,
            },
            sticky_session_config={
                "sticky_session_enabled": False,
            },
            tags={
                "Created": "TF",
            })
        default_listener = alicloud.alb.Listener("default",
            load_balancer_id=default_load_balancer.id,
            listener_protocol="HTTP",
            listener_port=80,
            listener_description=name,
            default_actions=[{
                "type": "ForwardGroup",
                "forward_group_config": {
                    "server_group_tuples": [{
                        "server_group_id": default_server_group.id,
                    }],
                },
            }])
        default_acl = alicloud.alb.Acl("default",
            acl_name=name,
            resource_group_id=default_get_resource_groups.groups[0].id)
        default_acl_entry_attachment = alicloud.alb.AclEntryAttachment("default",
            acl_id=default_acl.id,
            entry="10.0.0.0/24",
            description=name)
        default_listener_acl_attachment = alicloud.alb.ListenerAclAttachment("default",
            acl_id=default_acl.id,
            listener_id=default_listener.id,
            acl_type="White")
        ```

        ## Import

        ALB Listener Acl Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/listenerAclAttachment:ListenerAclAttachment example <listener_id>:<acl_id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerAclAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerAclAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 acl_type: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerAclAttachmentArgs.__new__(ListenerAclAttachmentArgs)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            if acl_type is None and not opts.urn:
                raise TypeError("Missing required property 'acl_type'")
            __props__.__dict__["acl_type"] = acl_type
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["status"] = None
        super(ListenerAclAttachment, __self__).__init__(
            'alicloud:alb/listenerAclAttachment:ListenerAclAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[_builtins.str]] = None,
            acl_type: Optional[pulumi.Input[_builtins.str]] = None,
            listener_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ListenerAclAttachment':
        """
        Get an existing ListenerAclAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] acl_id: The ID list of the access policy group bound by the listener.
        :param pulumi.Input[_builtins.str] acl_type: Access control type:
               - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
               - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        :param pulumi.Input[_builtins.str] listener_id: Listener instance ID.
        :param pulumi.Input[_builtins.str] status: Listener Status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerAclAttachmentState.__new__(_ListenerAclAttachmentState)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["acl_type"] = acl_type
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["status"] = status
        return ListenerAclAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID list of the access policy group bound by the listener.
        """
        return pulumi.get(self, "acl_id")

    @_builtins.property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> pulumi.Output[_builtins.str]:
        """
        Access control type:
        - **White**: only requests from IP addresses or address segments in the selected access control list are forwarded. The whitelist applies to scenarios where only specific IP addresses are allowed to access. There are certain business risks in setting up a whitelist. Once the whitelist is set, only the IP addresses in the whitelist can access the load balancer listener. If whitelist access is enabled but no IP addresses are added to the access policy group, the server load balancer listener forwards all requests.
        - **Black**: All requests from IP addresses or address segments in the selected access control list are not forwarded. Blacklists are applicable to scenarios where only certain IP addresses are restricted. If blacklist access is enabled and no IP is added to the access policy group, the server load balancer listener forwards all requests.
        """
        return pulumi.get(self, "acl_type")

    @_builtins.property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[_builtins.str]:
        """
        Listener instance ID.
        """
        return pulumi.get(self, "listener_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Listener Status.
        """
        return pulumi.get(self, "status")

