# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['LoadBalancerSecurityGroupAttachmentArgs', 'LoadBalancerSecurityGroupAttachment']

@pulumi.input_type
class LoadBalancerSecurityGroupAttachmentArgs:
    def __init__(__self__, *,
                 load_balancer_id: pulumi.Input[_builtins.str],
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LoadBalancerSecurityGroupAttachment resource.
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Application Load Balancer.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Application Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)


@pulumi.input_type
class _LoadBalancerSecurityGroupAttachmentState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerSecurityGroupAttachment resources.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Application Load Balancer.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Application Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)


@pulumi.type_token("alicloud:alb/loadBalancerSecurityGroupAttachment:LoadBalancerSecurityGroupAttachment")
class LoadBalancerSecurityGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer Security Group Attachment resource.

        Attachment between Application Load Balancer and Security Group.

        For information about Application Load Balancer (ALB) Load Balancer Security Group Attachment and how to use it, see [What is Load Balancer Security Group Attachment](https://next.api.alibabacloud.com/document/Alb/2020-06-16/LoadBalancerJoinSecurityGroup).

        > **NOTE:** Available since v1.226.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        create_vsw1 = alicloud.vpc.Switch("create_vsw_1",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="192.168.1.0/24",
            vswitch_name=name)
        create_vsw2 = alicloud.vpc.Switch("create_vsw_2",
            vpc_id=create_vpc.id,
            zone_id=default.zones[1].id,
            cidr_block="192.168.2.0/24",
            vswitch_name=name)
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            name=name,
            vpc_id=create_vpc.id)
        create_alb = alicloud.alb.LoadBalancer("create_alb",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            vpc_id=create_vpc.id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            address_type="Intranet",
            address_allocated_mode="Fixed",
            zone_mappings=[
                {
                    "vswitch_id": create_vsw2.id,
                    "zone_id": create_vsw2.zone_id,
                },
                {
                    "vswitch_id": create_vsw1.id,
                    "zone_id": create_vsw1.zone_id,
                },
            ])
        default_load_balancer_security_group_attachment = alicloud.alb.LoadBalancerSecurityGroupAttachment("default",
            security_group_id=create_security_group.id,
            load_balancer_id=create_alb.id)
        ```

        ## Import

        Application Load Balancer (ALB) Load Balancer Security Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancerSecurityGroupAttachment:LoadBalancerSecurityGroupAttachment example <load_balancer_id>:<security_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Application Load Balancer.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerSecurityGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Application Load Balancer (ALB) Load Balancer Security Group Attachment resource.

        Attachment between Application Load Balancer and Security Group.

        For information about Application Load Balancer (ALB) Load Balancer Security Group Attachment and how to use it, see [What is Load Balancer Security Group Attachment](https://next.api.alibabacloud.com/document/Alb/2020-06-16/LoadBalancerJoinSecurityGroup).

        > **NOTE:** Available since v1.226.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name=name)
        create_vsw1 = alicloud.vpc.Switch("create_vsw_1",
            vpc_id=create_vpc.id,
            zone_id=default.zones[0].id,
            cidr_block="192.168.1.0/24",
            vswitch_name=name)
        create_vsw2 = alicloud.vpc.Switch("create_vsw_2",
            vpc_id=create_vpc.id,
            zone_id=default.zones[1].id,
            cidr_block="192.168.2.0/24",
            vswitch_name=name)
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            name=name,
            vpc_id=create_vpc.id)
        create_alb = alicloud.alb.LoadBalancer("create_alb",
            load_balancer_name=name,
            load_balancer_edition="Standard",
            vpc_id=create_vpc.id,
            load_balancer_billing_config={
                "pay_type": "PayAsYouGo",
            },
            address_type="Intranet",
            address_allocated_mode="Fixed",
            zone_mappings=[
                {
                    "vswitch_id": create_vsw2.id,
                    "zone_id": create_vsw2.zone_id,
                },
                {
                    "vswitch_id": create_vsw1.id,
                    "zone_id": create_vsw1.zone_id,
                },
            ])
        default_load_balancer_security_group_attachment = alicloud.alb.LoadBalancerSecurityGroupAttachment("default",
            security_group_id=create_security_group.id,
            load_balancer_id=create_alb.id)
        ```

        ## Import

        Application Load Balancer (ALB) Load Balancer Security Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:alb/loadBalancerSecurityGroupAttachment:LoadBalancerSecurityGroupAttachment example <load_balancer_id>:<security_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerSecurityGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerSecurityGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerSecurityGroupAttachmentArgs.__new__(LoadBalancerSecurityGroupAttachmentArgs)

            __props__.__dict__["dry_run"] = dry_run
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["security_group_id"] = security_group_id
        super(LoadBalancerSecurityGroupAttachment, __self__).__init__(
            'alicloud:alb/loadBalancerSecurityGroupAttachment:LoadBalancerSecurityGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            load_balancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LoadBalancerSecurityGroupAttachment':
        """
        Get an existing LoadBalancerSecurityGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] dry_run: Whether to PreCheck only this request. Value:
        :param pulumi.Input[_builtins.str] load_balancer_id: The ID of the Application Load Balancer.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerSecurityGroupAttachmentState.__new__(_LoadBalancerSecurityGroupAttachmentState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["security_group_id"] = security_group_id
        return LoadBalancerSecurityGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to PreCheck only this request. Value:
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Application Load Balancer.
        """
        return pulumi.get(self, "load_balancer_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

