# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddonReleasesResult',
    'AwaitableGetAddonReleasesResult',
    'get_addon_releases',
    'get_addon_releases_output',
]

@pulumi.output_type
class GetAddonReleasesResult:
    """
    A collection of values returned by getAddonReleases.
    """
    def __init__(__self__, environment_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, releases=None):
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if releases and not isinstance(releases, list):
            raise TypeError("Expected argument 'releases' to be a list")
        pulumi.set(__self__, "releases", releases)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The environment ID.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of ARMS Addon Release names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def releases(self) -> Sequence['outputs.GetAddonReleasesReleaseResult']:
        """
        A list of ARMS Addon Releases. Each element contains the following attributes:
        """
        return pulumi.get(self, "releases")


class AwaitableGetAddonReleasesResult(GetAddonReleasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonReleasesResult(
            environment_id=self.environment_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            releases=self.releases)


def get_addon_releases(environment_id: Optional[_builtins.str] = None,
                       ids: Optional[Sequence[_builtins.str]] = None,
                       name_regex: Optional[_builtins.str] = None,
                       output_file: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonReleasesResult:
    """
    This data source provides the ARMS Addon Releases of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud
    import pulumi_random as random
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
    vpc = alicloud.vpc.Network("vpc",
        description="api-resource-test1-hz",
        cidr_block="192.168.0.0/16",
        vpc_name=f"{name}-{default_integer['result']}")
    vswitch = alicloud.vpc.Switch("vswitch",
        description="api-resource-test1-hz",
        vpc_id=vpc.id,
        vswitch_name=f"{name}-{default_integer['result']}",
        zone_id=enhanced.zones[0].zone_id,
        cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
            newbits=8,
            netnum=8)).apply(lambda invoke: invoke.result))
    default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
        name=f"{name}-{default_integer['result']}",
        repeat_weekdays=[
            "1",
            "2",
            "3",
        ],
        retention_days=-1,
        time_points=[
            "1",
            "22",
            "23",
        ])
    default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
        cpu_core_count=2,
        memory_size=4,
        kubernetes_node_role="Worker",
        instance_type_family="ecs.sn1ne"))
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name=f"{name}-{default_integer['result']}",
        cluster_spec="ack.pro.small",
        version="1.24.6-aliyun.1",
        new_nat_gateway=True,
        node_cidr_mask=26,
        proxy_mode="ipvs",
        service_cidr="172.23.0.0/16",
        pod_cidr="10.95.0.0/16",
        worker_vswitch_ids=[vswitch.id])
    default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
    default_node_pool = alicloud.cs.NodePool("default",
        name="desired_size",
        cluster_id=default_managed_kubernetes.id,
        vswitch_ids=[vswitch.id],
        instance_types=[default.instance_types[0].id],
        system_disk_category="cloud_efficiency",
        system_disk_size=40,
        key_name=default_key_pair.key_pair_name,
        desired_size="2")
    default_environment = alicloud.arms.Environment("default",
        environment_type="CS",
        environment_name=f"{name}-{default_integer['result']}",
        bind_resource_id=default_node_pool.cluster_id,
        environment_sub_type="ManagedKubernetes")
    default_addon_release = alicloud.arms.AddonRelease("default",
        aliyun_lang="zh",
        addon_name="mysql",
        environment_id=default_environment.id,
        addon_version="0.0.2",
        values=json.dumps({
            "host": "mysql-service.default",
            "password": "roots",
            "port": 3306,
            "username": "root",
        }))
    ids = alicloud.arms.get_addon_releases_output(environment_id=default_addon_release.environment_id,
        ids=[default_addon_release.id])
    pulumi.export("armsEnvServiceMonitorsId0", ids.releases[0].id)
    ```


    :param _builtins.str environment_id: The environment ID.
    :param Sequence[_builtins.str] ids: A list of ARMS Addon Release IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Addon Release name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getAddonReleases:getAddonReleases', __args__, opts=opts, typ=GetAddonReleasesResult).value

    return AwaitableGetAddonReleasesResult(
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        releases=pulumi.get(__ret__, 'releases'))
def get_addon_releases_output(environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                              ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddonReleasesResult]:
    """
    This data source provides the ARMS Addon Releases of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import json
    import pulumi_alicloud as alicloud
    import pulumi_random as random
    import pulumi_std as std

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
    vpc = alicloud.vpc.Network("vpc",
        description="api-resource-test1-hz",
        cidr_block="192.168.0.0/16",
        vpc_name=f"{name}-{default_integer['result']}")
    vswitch = alicloud.vpc.Switch("vswitch",
        description="api-resource-test1-hz",
        vpc_id=vpc.id,
        vswitch_name=f"{name}-{default_integer['result']}",
        zone_id=enhanced.zones[0].zone_id,
        cidr_block=vpc.cidr_block.apply(lambda cidr_block: std.cidrsubnet_output(input=cidr_block,
            newbits=8,
            netnum=8)).apply(lambda invoke: invoke.result))
    default_snapshot_policy = alicloud.ecs.SnapshotPolicy("default",
        name=f"{name}-{default_integer['result']}",
        repeat_weekdays=[
            "1",
            "2",
            "3",
        ],
        retention_days=-1,
        time_points=[
            "1",
            "22",
            "23",
        ])
    default = vswitch.zone_id.apply(lambda zone_id: alicloud.ecs.get_instance_types_output(availability_zone=zone_id,
        cpu_core_count=2,
        memory_size=4,
        kubernetes_node_role="Worker",
        instance_type_family="ecs.sn1ne"))
    default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
        name=f"{name}-{default_integer['result']}",
        cluster_spec="ack.pro.small",
        version="1.24.6-aliyun.1",
        new_nat_gateway=True,
        node_cidr_mask=26,
        proxy_mode="ipvs",
        service_cidr="172.23.0.0/16",
        pod_cidr="10.95.0.0/16",
        worker_vswitch_ids=[vswitch.id])
    default_key_pair = alicloud.ecs.KeyPair("default", key_pair_name=f"{name}-{default_integer['result']}")
    default_node_pool = alicloud.cs.NodePool("default",
        name="desired_size",
        cluster_id=default_managed_kubernetes.id,
        vswitch_ids=[vswitch.id],
        instance_types=[default.instance_types[0].id],
        system_disk_category="cloud_efficiency",
        system_disk_size=40,
        key_name=default_key_pair.key_pair_name,
        desired_size="2")
    default_environment = alicloud.arms.Environment("default",
        environment_type="CS",
        environment_name=f"{name}-{default_integer['result']}",
        bind_resource_id=default_node_pool.cluster_id,
        environment_sub_type="ManagedKubernetes")
    default_addon_release = alicloud.arms.AddonRelease("default",
        aliyun_lang="zh",
        addon_name="mysql",
        environment_id=default_environment.id,
        addon_version="0.0.2",
        values=json.dumps({
            "host": "mysql-service.default",
            "password": "roots",
            "port": 3306,
            "username": "root",
        }))
    ids = alicloud.arms.get_addon_releases_output(environment_id=default_addon_release.environment_id,
        ids=[default_addon_release.id])
    pulumi.export("armsEnvServiceMonitorsId0", ids.releases[0].id)
    ```


    :param _builtins.str environment_id: The environment ID.
    :param Sequence[_builtins.str] ids: A list of ARMS Addon Release IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Addon Release name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:arms/getAddonReleases:getAddonReleases', __args__, opts=opts, typ=GetAddonReleasesResult)
    return __ret__.apply(lambda __response__: GetAddonReleasesResult(
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        releases=pulumi.get(__response__, 'releases')))
