# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnvCustomJobsResult',
    'AwaitableGetEnvCustomJobsResult',
    'get_env_custom_jobs',
    'get_env_custom_jobs_output',
]

@pulumi.output_type
class GetEnvCustomJobsResult:
    """
    A collection of values returned by getEnvCustomJobs.
    """
    def __init__(__self__, environment_id=None, id=None, ids=None, jobs=None, name_regex=None, names=None, output_file=None):
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if jobs and not isinstance(jobs, list):
            raise TypeError("Expected argument 'jobs' to be a list")
        pulumi.set(__self__, "jobs", jobs)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The ID of the environment instance.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def jobs(self) -> Sequence['outputs.GetEnvCustomJobsJobResult']:
        """
        A list of ARMS Env Custom Jobs. Each element contains the following attributes:
        """
        return pulumi.get(self, "jobs")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of ARMS Env Custom Job names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetEnvCustomJobsResult(GetEnvCustomJobsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvCustomJobsResult(
            environment_id=self.environment_id,
            id=self.id,
            ids=self.ids,
            jobs=self.jobs,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_env_custom_jobs(environment_id: Optional[_builtins.str] = None,
                        ids: Optional[Sequence[_builtins.str]] = None,
                        name_regex: Optional[_builtins.str] = None,
                        output_file: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvCustomJobsResult:
    """
    This data source provides the ARMS Env Custom Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_environment = alicloud.arms.Environment("default",
        bind_resource_id=default.ids[0],
        environment_sub_type="ECS",
        environment_type="ECS",
        environment_name=f"{name}-{default_integer['result']}",
        tags={
            "Created": "TF",
            "For": "Environment",
        })
    default_env_custom_job = alicloud.arms.EnvCustomJob("default",
        status="run",
        environment_id=default_environment.id,
        env_custom_job_name=f"{name}-{default_integer['result']}",
        config_yaml=\"\"\"scrape_configs:
    - job_name: job-demo1
      honor_timestamps: false
      honor_labels: false
      scrape_interval: 30s
      scheme: http
      metrics_path: /metric
      static_configs:
      - targets:
        - 127.0.0.1:9090
    \"\"\",
        aliyun_lang="en")
    ids = alicloud.arms.get_env_custom_jobs_output(environment_id=default_env_custom_job.environment_id,
        ids=[default_env_custom_job.id])
    pulumi.export("armsEnvCustomJobsId0", ids.jobs[0].id)
    ```


    :param _builtins.str environment_id: The ID of the environment instance.
    :param Sequence[_builtins.str] ids: A list of ARMS Env Custom Job IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Env Custom Job name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getEnvCustomJobs:getEnvCustomJobs', __args__, opts=opts, typ=GetEnvCustomJobsResult).value

    return AwaitableGetEnvCustomJobsResult(
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        jobs=pulumi.get(__ret__, 'jobs'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_env_custom_jobs_output(environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                               ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvCustomJobsResult]:
    """
    This data source provides the ARMS Env Custom Jobs of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_environment = alicloud.arms.Environment("default",
        bind_resource_id=default.ids[0],
        environment_sub_type="ECS",
        environment_type="ECS",
        environment_name=f"{name}-{default_integer['result']}",
        tags={
            "Created": "TF",
            "For": "Environment",
        })
    default_env_custom_job = alicloud.arms.EnvCustomJob("default",
        status="run",
        environment_id=default_environment.id,
        env_custom_job_name=f"{name}-{default_integer['result']}",
        config_yaml=\"\"\"scrape_configs:
    - job_name: job-demo1
      honor_timestamps: false
      honor_labels: false
      scrape_interval: 30s
      scheme: http
      metrics_path: /metric
      static_configs:
      - targets:
        - 127.0.0.1:9090
    \"\"\",
        aliyun_lang="en")
    ids = alicloud.arms.get_env_custom_jobs_output(environment_id=default_env_custom_job.environment_id,
        ids=[default_env_custom_job.id])
    pulumi.export("armsEnvCustomJobsId0", ids.jobs[0].id)
    ```


    :param _builtins.str environment_id: The ID of the environment instance.
    :param Sequence[_builtins.str] ids: A list of ARMS Env Custom Job IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Env Custom Job name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['environmentId'] = environment_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:arms/getEnvCustomJobs:getEnvCustomJobs', __args__, opts=opts, typ=GetEnvCustomJobsResult)
    return __ret__.apply(lambda __response__: GetEnvCustomJobsResult(
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        jobs=pulumi.get(__response__, 'jobs'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
