# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentsResult',
    'AwaitableGetEnvironmentsResult',
    'get_environments',
    'get_environments_output',
]

@pulumi.output_type
class GetEnvironmentsResult:
    """
    A collection of values returned by getEnvironments.
    """
    def __init__(__self__, environment_type=None, environments=None, id=None, ids=None, name_regex=None, names=None, output_file=None, resource_group_id=None, tags=None):
        if environment_type and not isinstance(environment_type, str):
            raise TypeError("Expected argument 'environment_type' to be a str")
        pulumi.set(__self__, "environment_type", environment_type)
        if environments and not isinstance(environments, list):
            raise TypeError("Expected argument 'environments' to be a list")
        pulumi.set(__self__, "environments", environments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[_builtins.str]:
        """
        The type of the environment instance.
        """
        return pulumi.get(self, "environment_type")

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Sequence['outputs.GetEnvironmentsEnvironmentResult']:
        """
        A list of ARMS Environments. Each element contains the following attributes:
        """
        return pulumi.get(self, "environments")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of ARMS Environment names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The tags of the environment resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEnvironmentsResult(GetEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentsResult(
            environment_type=self.environment_type,
            environments=self.environments,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            resource_group_id=self.resource_group_id,
            tags=self.tags)


def get_environments(environment_type: Optional[_builtins.str] = None,
                     ids: Optional[Sequence[_builtins.str]] = None,
                     name_regex: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     resource_group_id: Optional[_builtins.str] = None,
                     tags: Optional[Mapping[str, _builtins.str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentsResult:
    """
    This data source provides the ARMS Environments of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default_environment = alicloud.arms.Environment("default",
        bind_resource_id=default_get_networks.ids[0],
        environment_sub_type="ECS",
        environment_type="ECS",
        environment_name=f"{name}-{default_integer['result']}",
        resource_group_id=default.ids[1],
        tags={
            "Created": "TF",
            "For": "Environment",
        })
    ids = alicloud.arms.get_environments_output(ids=[default_environment.id])
    pulumi.export("armsEnvironmentsId0", ids.environments[0].id)
    ```


    :param _builtins.str environment_type: The environment type. Valid values: `CS`, `ECS`, `Cloud`.
    :param Sequence[_builtins.str] ids: A list of ARMS Environment IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Environment name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['environmentType'] = environment_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:arms/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult).value

    return AwaitableGetEnvironmentsResult(
        environment_type=pulumi.get(__ret__, 'environment_type'),
        environments=pulumi.get(__ret__, 'environments'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_environments_output(environment_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            resource_group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentsResult]:
    """
    This data source provides the ARMS Environments of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.258.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud
    import pulumi_random as random

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "terraform-example"
    default = alicloud.resourcemanager.get_resource_groups(status="OK")
    default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
    default_integer = random.index.Integer("default",
        min=10000,
        max=99999)
    default_environment = alicloud.arms.Environment("default",
        bind_resource_id=default_get_networks.ids[0],
        environment_sub_type="ECS",
        environment_type="ECS",
        environment_name=f"{name}-{default_integer['result']}",
        resource_group_id=default.ids[1],
        tags={
            "Created": "TF",
            "For": "Environment",
        })
    ids = alicloud.arms.get_environments_output(ids=[default_environment.id])
    pulumi.export("armsEnvironmentsId0", ids.environments[0].id)
    ```


    :param _builtins.str environment_type: The environment type. Valid values: `CS`, `ECS`, `Cloud`.
    :param Sequence[_builtins.str] ids: A list of ARMS Environment IDs.
    :param _builtins.str name_regex: A regex string to filter results by ARMS Environment name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str resource_group_id: The ID of the resource group.
    :param Mapping[str, _builtins.str] tags: A mapping of tags to assign to the resource.
    """
    __args__ = dict()
    __args__['environmentType'] = environment_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['resourceGroupId'] = resource_group_id
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:arms/getEnvironments:getEnvironments', __args__, opts=opts, typ=GetEnvironmentsResult)
    return __ret__.apply(lambda __response__: GetEnvironmentsResult(
        environment_type=pulumi.get(__response__, 'environment_type'),
        environments=pulumi.get(__response__, 'environments'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        tags=pulumi.get(__response__, 'tags')))
