# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RealTimeLogDeliveryArgs', 'RealTimeLogDelivery']

@pulumi.input_type
class RealTimeLogDeliveryArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 logstore: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 sls_region: pulumi.Input[_builtins.str],
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RealTimeLogDelivery resource.
        :param pulumi.Input[_builtins.str] domain: The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] logstore: The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).
               
               For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] project: The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] sls_region: The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] status: Resource attribute fields that represent the status of the resource.
               
               Value:
               - offline
               - online
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "sls_region", sls_region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).

        For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="slsRegion")
    def sls_region(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "sls_region")

    @sls_region.setter
    def sls_region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sls_region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute fields that represent the status of the resource.

        Value:
        - offline
        - online
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _RealTimeLogDeliveryState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RealTimeLogDelivery resources.
        :param pulumi.Input[_builtins.str] domain: The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] logstore: The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).
               
               For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] project: The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] sls_region: The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] status: Resource attribute fields that represent the status of the resource.
               
               Value:
               - offline
               - online
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if logstore is not None:
            pulumi.set(__self__, "logstore", logstore)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if sls_region is not None:
            pulumi.set(__self__, "sls_region", sls_region)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).

        For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "logstore")

    @logstore.setter
    def logstore(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logstore", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="slsRegion")
    def sls_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "sls_region")

    @sls_region.setter
    def sls_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sls_region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attribute fields that represent the status of the resource.

        Value:
        - offline
        - online
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cdn/realTimeLogDelivery:RealTimeLogDelivery")
class RealTimeLogDelivery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CDN Real Time Log Delivery resource.

        Accelerate domain name real-time log push.

        For information about CDN Real Time Log Delivery and how to use it, see [What is Real Time Log Delivery](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-createrealtimelogdelivery).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("default",
            scope="overseas",
            domain_name=f"mycdndomain-{default_integer['result']}.alicloud-provider.cn",
            cdn_type="web",
            sources=[{
                "type": "ipaddr",
                "content": "1.1.3.1",
                "priority": 20,
                "port": 80,
                "weight": 15,
            }])
        default_project = alicloud.log.Project("default",
            project_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name="example-store",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        default = alicloud.get_regions(current=True)
        default_real_time_log_delivery = alicloud.cdn.RealTimeLogDelivery("default",
            domain=default_domain_new.domain_name,
            logstore=default_store.logstore_name,
            project=default_project.project_name,
            sls_region=default.regions[0].id)
        ```

        ## Import

        CDN Real Time Log Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cdn/realTimeLogDelivery:RealTimeLogDelivery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] logstore: The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).
               
               For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] project: The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] sls_region: The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] status: Resource attribute fields that represent the status of the resource.
               
               Value:
               - offline
               - online
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RealTimeLogDeliveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CDN Real Time Log Delivery resource.

        Accelerate domain name real-time log push.

        For information about CDN Real Time Log Delivery and how to use it, see [What is Real Time Log Delivery](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-createrealtimelogdelivery).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_integer = random.index.Integer("default",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("default",
            scope="overseas",
            domain_name=f"mycdndomain-{default_integer['result']}.alicloud-provider.cn",
            cdn_type="web",
            sources=[{
                "type": "ipaddr",
                "content": "1.1.3.1",
                "priority": 20,
                "port": 80,
                "weight": 15,
            }])
        default_project = alicloud.log.Project("default",
            project_name=f"terraform-example-{default_integer['result']}",
            description="terraform-example")
        default_store = alicloud.log.Store("default",
            project_name=default_project.project_name,
            logstore_name="example-store",
            shard_count=3,
            auto_split=True,
            max_split_shard_count=60,
            append_meta=True)
        default = alicloud.get_regions(current=True)
        default_real_time_log_delivery = alicloud.cdn.RealTimeLogDelivery("default",
            domain=default_domain_new.domain_name,
            logstore=default_store.logstore_name,
            project=default_project.project_name,
            sls_region=default.regions[0].id)
        ```

        ## Import

        CDN Real Time Log Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cdn/realTimeLogDelivery:RealTimeLogDelivery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RealTimeLogDeliveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RealTimeLogDeliveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 logstore: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 sls_region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RealTimeLogDeliveryArgs.__new__(RealTimeLogDeliveryArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if logstore is None and not opts.urn:
                raise TypeError("Missing required property 'logstore'")
            __props__.__dict__["logstore"] = logstore
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if sls_region is None and not opts.urn:
                raise TypeError("Missing required property 'sls_region'")
            __props__.__dict__["sls_region"] = sls_region
            __props__.__dict__["status"] = status
        super(RealTimeLogDelivery, __self__).__init__(
            'alicloud:cdn/realTimeLogDelivery:RealTimeLogDelivery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            logstore: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            sls_region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RealTimeLogDelivery':
        """
        Get an existing RealTimeLogDelivery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] logstore: The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).
               
               For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] project: The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        :param pulumi.Input[_builtins.str] sls_region: The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        :param pulumi.Input[_builtins.str] status: Resource attribute fields that represent the status of the resource.
               
               Value:
               - offline
               - online
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RealTimeLogDeliveryState.__new__(_RealTimeLogDeliveryState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["logstore"] = logstore
        __props__.__dict__["project"] = project
        __props__.__dict__["sls_region"] = sls_region
        __props__.__dict__["status"] = status
        return RealTimeLogDelivery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The accelerated domain name for which you want to disable real-time log delivery. You can specify multiple domain names and separate them with commas (,).
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def logstore(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the Log Service project is deployed. You can specify multiple region IDs and separate them with commas (,).

        For more information about regions, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "logstore")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Logstore that collects log data from Alibaba Cloud CDN in real time. You can specify multiple Logstore names and separate them with commas (,).
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="slsRegion")
    def sls_region(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the region where the Log Service project is deployed. For more information, see [Regions that support real-time log delivery](https://www.alibabacloud.com/help/en/doc-detail/144883.html).
        """
        return pulumi.get(self, "sls_region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Resource attribute fields that represent the status of the resource.

        Value:
        - offline
        - online
        """
        return pulumi.get(self, "status")

