# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteServiceArgs', 'RouteService']

@pulumi.input_type
class RouteServiceArgs:
    def __init__(__self__, *,
                 access_region_id: pulumi.Input[_builtins.str],
                 cen_id: pulumi.Input[_builtins.str],
                 host: pulumi.Input[_builtins.str],
                 host_region_id: pulumi.Input[_builtins.str],
                 host_vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RouteService resource.
        :param pulumi.Input[_builtins.str] access_region_id: The region of the network instances that access the cloud services.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] host: The domain name or IP address of the cloud service.
        :param pulumi.Input[_builtins.str] host_region_id: The region of the cloud service.
        :param pulumi.Input[_builtins.str] host_vpc_id: The VPC associated with the cloud service.
               
               > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        :param pulumi.Input[_builtins.str] description: The description of the cloud service.
        """
        pulumi.set(__self__, "access_region_id", access_region_id)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "host_region_id", host_region_id)
        pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @access_region_id.setter
    def access_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_region_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @host_region_id.setter
    def host_region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_region_id", value)

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC associated with the cloud service.

        > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        """
        return pulumi.get(self, "host_vpc_id")

    @host_vpc_id.setter
    def host_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cloud service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _RouteServiceState:
    def __init__(__self__, *,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RouteService resources.
        :param pulumi.Input[_builtins.str] access_region_id: The region of the network instances that access the cloud services.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] description: The description of the cloud service.
        :param pulumi.Input[_builtins.str] host: The domain name or IP address of the cloud service.
        :param pulumi.Input[_builtins.str] host_region_id: The region of the cloud service.
        :param pulumi.Input[_builtins.str] host_vpc_id: The VPC associated with the cloud service.
               
               > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        :param pulumi.Input[_builtins.str] status: The status of the cloud service.
        """
        if access_region_id is not None:
            pulumi.set(__self__, "access_region_id", access_region_id)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if host_region_id is not None:
            pulumi.set(__self__, "host_region_id", host_region_id)
        if host_vpc_id is not None:
            pulumi.set(__self__, "host_vpc_id", host_vpc_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @access_region_id.setter
    def access_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_region_id", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cloud service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @host_region_id.setter
    def host_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_region_id", value)

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC associated with the cloud service.

        > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        """
        return pulumi.get(self, "host_vpc_id")

    @host_vpc_id.setter
    def host_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the cloud service.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cen/routeService:RouteService")
class RouteService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CEN Route Service resource. The virtual border routers (VBRs) and Cloud Connect Network (CCN) instances attached to Cloud Enterprise Network (CEN) instances can access the cloud services deployed in VPCs through the CEN instances.

        For information about CEN Route Service and how to use it, see [What is Route Service](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-resolveandrouteserviceincen).

        > **NOTE:** Available since v1.99.0.

        > **NOTE:** Ensure that at least one VPC in the selected region is attached to the CEN instance.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_regions(current=True)
        example = alicloud.vpc.Network("example",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_instance_attachment = alicloud.cen.InstanceAttachment("example",
            instance_id=example_instance.id,
            child_instance_id=example.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        example_route_service = alicloud.cen.RouteService("example",
            access_region_id=default.regions[0].id,
            host_region_id=default.regions[0].id,
            host_vpc_id=example.id,
            cen_id=example_instance_attachment.instance_id,
            host="100.118.28.52/32")
        ```

        ## Import

        CEN Route Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/routeService:RouteService example cen-ahixm0efqh********:cn-shanghai:100.118.28.52/32:cn-shanghai
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_region_id: The region of the network instances that access the cloud services.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] description: The description of the cloud service.
        :param pulumi.Input[_builtins.str] host: The domain name or IP address of the cloud service.
        :param pulumi.Input[_builtins.str] host_region_id: The region of the cloud service.
        :param pulumi.Input[_builtins.str] host_vpc_id: The VPC associated with the cloud service.
               
               > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CEN Route Service resource. The virtual border routers (VBRs) and Cloud Connect Network (CCN) instances attached to Cloud Enterprise Network (CEN) instances can access the cloud services deployed in VPCs through the CEN instances.

        For information about CEN Route Service and how to use it, see [What is Route Service](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-resolveandrouteserviceincen).

        > **NOTE:** Available since v1.99.0.

        > **NOTE:** Ensure that at least one VPC in the selected region is attached to the CEN instance.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_regions(current=True)
        example = alicloud.vpc.Network("example",
            vpc_name="tf_example",
            cidr_block="172.17.3.0/24")
        example_instance = alicloud.cen.Instance("example",
            cen_instance_name="tf_example",
            description="an example for cen")
        example_instance_attachment = alicloud.cen.InstanceAttachment("example",
            instance_id=example_instance.id,
            child_instance_id=example.id,
            child_instance_type="VPC",
            child_instance_region_id=default.regions[0].id)
        example_route_service = alicloud.cen.RouteService("example",
            access_region_id=default.regions[0].id,
            host_region_id=default.regions[0].id,
            host_vpc_id=example.id,
            cen_id=example_instance_attachment.instance_id,
            host="100.118.28.52/32")
        ```

        ## Import

        CEN Route Service can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/routeService:RouteService example cen-ahixm0efqh********:cn-shanghai:100.118.28.52/32:cn-shanghai
        ```

        :param str resource_name: The name of the resource.
        :param RouteServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServiceArgs.__new__(RouteServiceArgs)

            if access_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_region_id'")
            __props__.__dict__["access_region_id"] = access_region_id
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["description"] = description
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            if host_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_region_id'")
            __props__.__dict__["host_region_id"] = host_region_id
            if host_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_vpc_id'")
            __props__.__dict__["host_vpc_id"] = host_vpc_id
            __props__.__dict__["status"] = None
        super(RouteService, __self__).__init__(
            'alicloud:cen/routeService:RouteService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            host_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            host_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'RouteService':
        """
        Get an existing RouteService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_region_id: The region of the network instances that access the cloud services.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] description: The description of the cloud service.
        :param pulumi.Input[_builtins.str] host: The domain name or IP address of the cloud service.
        :param pulumi.Input[_builtins.str] host_region_id: The region of the cloud service.
        :param pulumi.Input[_builtins.str] host_vpc_id: The VPC associated with the cloud service.
               
               > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        :param pulumi.Input[_builtins.str] status: The status of the cloud service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServiceState.__new__(_RouteServiceState)

        __props__.__dict__["access_region_id"] = access_region_id
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["description"] = description
        __props__.__dict__["host"] = host
        __props__.__dict__["host_region_id"] = host_region_id
        __props__.__dict__["host_vpc_id"] = host_vpc_id
        __props__.__dict__["status"] = status
        return RouteService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessRegionId")
    def access_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the network instances that access the cloud services.
        """
        return pulumi.get(self, "access_region_id")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the cloud service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name or IP address of the cloud service.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="hostRegionId")
    def host_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the cloud service.
        """
        return pulumi.get(self, "host_region_id")

    @_builtins.property
    @pulumi.getter(name="hostVpcId")
    def host_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC associated with the cloud service.

        > **NOTE:** The values of `host_region_id` and `access_region_id` must be consistent.
        """
        return pulumi.get(self, "host_vpc_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the cloud service.
        """
        return pulumi.get(self, "status")

