# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransitRouterMulticastDomainArgs', 'TransitRouterMulticastDomain']

@pulumi.input_type
class TransitRouterMulticastDomainArgs:
    def __init__(__self__, *,
                 transit_router_id: pulumi.Input[_builtins.str],
                 options: Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_multicast_domain_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransitRouterMulticastDomain resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input['TransitRouterMulticastDomainOptionsArgs'] options: The function options of the multicast domain. See `options` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_description: The description of the multicast domain.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_name: The name of the multicast domain.
        """
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_multicast_domain_description is not None:
            pulumi.set(__self__, "transit_router_multicast_domain_description", transit_router_multicast_domain_description)
        if transit_router_multicast_domain_name is not None:
            pulumi.set(__self__, "transit_router_multicast_domain_name", transit_router_multicast_domain_name)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']]:
        """
        The function options of the multicast domain. See `options` below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainDescription")
    def transit_router_multicast_domain_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_description")

    @transit_router_multicast_domain_description.setter
    def transit_router_multicast_domain_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_multicast_domain_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainName")
    def transit_router_multicast_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_name")

    @transit_router_multicast_domain_name.setter
    def transit_router_multicast_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_multicast_domain_name", value)


@pulumi.input_type
class _TransitRouterMulticastDomainState:
    def __init__(__self__, *,
                 options: Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterMulticastDomain resources.
        :param pulumi.Input['TransitRouterMulticastDomainOptionsArgs'] options: The function options of the multicast domain. See `options` below.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the transit router.
        :param pulumi.Input[_builtins.str] status: The status of the Transit Router Multicast Domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_description: The description of the multicast domain.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_name: The name of the multicast domain.
        """
        if options is not None:
            pulumi.set(__self__, "options", options)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_multicast_domain_description is not None:
            pulumi.set(__self__, "transit_router_multicast_domain_description", transit_router_multicast_domain_description)
        if transit_router_multicast_domain_name is not None:
            pulumi.set(__self__, "transit_router_multicast_domain_name", transit_router_multicast_domain_name)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']]:
        """
        The function options of the multicast domain. See `options` below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TransitRouterMulticastDomainOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.242.0) The region ID of the transit router.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainDescription")
    def transit_router_multicast_domain_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_description")

    @transit_router_multicast_domain_description.setter
    def transit_router_multicast_domain_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_multicast_domain_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainName")
    def transit_router_multicast_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_name")

    @transit_router_multicast_domain_name.setter
    def transit_router_multicast_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_multicast_domain_name", value)


@pulumi.type_token("alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain")
class TransitRouterMulticastDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 options: Optional[pulumi.Input[Union['TransitRouterMulticastDomainOptionsArgs', 'TransitRouterMulticastDomainOptionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Multicast Domain resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Multicast Domain and how to use it, see [What is Transit Router Multicast Domain](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutermulticastdomain).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.cen.Instance("example", cen_instance_name=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name=name,
            cen_id=example.id,
            support_multicast=True)
        default = alicloud.cen.TransitRouterMulticastDomain("default",
            transit_router_id=example_transit_router.transit_router_id,
            transit_router_multicast_domain_name=name,
            transit_router_multicast_domain_description=name,
            options={
                "igmpv2_support": "disable",
            })
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Multicast Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TransitRouterMulticastDomainOptionsArgs', 'TransitRouterMulticastDomainOptionsArgsDict']] options: The function options of the multicast domain. See `options` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_description: The description of the multicast domain.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_name: The name of the multicast domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterMulticastDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router Multicast Domain resource.

        For information about Cloud Enterprise Network (CEN) Transit Router Multicast Domain and how to use it, see [What is Transit Router Multicast Domain](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutermulticastdomain).

        > **NOTE:** Available since v1.195.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        example = alicloud.cen.Instance("example", cen_instance_name=name)
        example_transit_router = alicloud.cen.TransitRouter("example",
            transit_router_name=name,
            cen_id=example.id,
            support_multicast=True)
        default = alicloud.cen.TransitRouterMulticastDomain("default",
            transit_router_id=example_transit_router.transit_router_id,
            transit_router_multicast_domain_name=name,
            transit_router_multicast_domain_description=name,
            options={
                "igmpv2_support": "disable",
            })
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router Multicast Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterMulticastDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterMulticastDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 options: Optional[pulumi.Input[Union['TransitRouterMulticastDomainOptionsArgs', 'TransitRouterMulticastDomainOptionsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_multicast_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterMulticastDomainArgs.__new__(TransitRouterMulticastDomainArgs)

            __props__.__dict__["options"] = options
            __props__.__dict__["tags"] = tags
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_multicast_domain_description"] = transit_router_multicast_domain_description
            __props__.__dict__["transit_router_multicast_domain_name"] = transit_router_multicast_domain_name
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(TransitRouterMulticastDomain, __self__).__init__(
            'alicloud:cen/transitRouterMulticastDomain:TransitRouterMulticastDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            options: Optional[pulumi.Input[Union['TransitRouterMulticastDomainOptionsArgs', 'TransitRouterMulticastDomainOptionsArgsDict']]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_multicast_domain_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_multicast_domain_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouterMulticastDomain':
        """
        Get an existing TransitRouterMulticastDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TransitRouterMulticastDomainOptionsArgs', 'TransitRouterMulticastDomainOptionsArgsDict']] options: The function options of the multicast domain. See `options` below.
        :param pulumi.Input[_builtins.str] region_id: (Available since v1.242.0) The region ID of the transit router.
        :param pulumi.Input[_builtins.str] status: The status of the Transit Router Multicast Domain.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the forwarding router instance.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_description: The description of the multicast domain.
        :param pulumi.Input[_builtins.str] transit_router_multicast_domain_name: The name of the multicast domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterMulticastDomainState.__new__(_TransitRouterMulticastDomainState)

        __props__.__dict__["options"] = options
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_multicast_domain_description"] = transit_router_multicast_domain_description
        __props__.__dict__["transit_router_multicast_domain_name"] = transit_router_multicast_domain_name
        return TransitRouterMulticastDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.TransitRouterMulticastDomainOptions']:
        """
        The function options of the multicast domain. See `options` below.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.242.0) The region ID of the transit router.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Transit Router Multicast Domain.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the forwarding router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainDescription")
    def transit_router_multicast_domain_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterMulticastDomainName")
    def transit_router_multicast_domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the multicast domain.
        """
        return pulumi.get(self, "transit_router_multicast_domain_name")

