# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TransitRouterVbrAttachmentArgs', 'TransitRouterVbrAttachment']

@pulumi.input_type
class TransitRouterVbrAttachmentArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[_builtins.str],
                 vbr_id: pulumi.Input[_builtins.str],
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TransitRouterVbrAttachment resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN.
        :param pulumi.Input[_builtins.str] vbr_id: The ID of the VBR.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
               
               ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The owner id of the vbr.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "vbr_id", vbr_id)
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VBR.
        """
        return pulumi.get(self, "vbr_id")

    @vbr_id.setter
    def vbr_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vbr_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."

        ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner id of the vbr.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vbr_owner_id", value)


@pulumi.input_type
class _TransitRouterVbrAttachmentState:
    def __init__(__self__, *,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TransitRouterVbrAttachment resources.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
               
               ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        :param pulumi.Input[_builtins.str] status: The status of the Transit Router VBR Attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the VBR connection.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vbr_id: The ID of the VBR.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The owner id of the vbr.
        """
        if auto_publish_route_enabled is not None:
            pulumi.set(__self__, "auto_publish_route_enabled", auto_publish_route_enabled)
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if route_table_association_enabled is not None:
            warnings.warn("""Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_association_enabled is deprecated: Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
        if route_table_association_enabled is not None:
            pulumi.set(__self__, "route_table_association_enabled", route_table_association_enabled)
        if route_table_propagation_enabled is not None:
            warnings.warn("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""", DeprecationWarning)
            pulumi.log.warn("""route_table_propagation_enabled is deprecated: Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
        if route_table_propagation_enabled is not None:
            pulumi.set(__self__, "route_table_propagation_enabled", route_table_propagation_enabled)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_router_attachment_description is not None:
            pulumi.set(__self__, "transit_router_attachment_description", transit_router_attachment_description)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if vbr_id is not None:
            pulumi.set(__self__, "vbr_id", vbr_id)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @auto_publish_route_enabled.setter
    def auto_publish_route_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_publish_route_enabled", value)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @route_table_association_enabled.setter
    def route_table_association_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_association_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."

        ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @route_table_propagation_enabled.setter
    def route_table_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "route_table_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Transit Router VBR Attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @transit_router_attachment_description.setter
    def transit_router_attachment_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_description", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VBR connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VBR.
        """
        return pulumi.get(self, "vbr_id")

    @vbr_id.setter
    def vbr_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vbr_id", value)

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner id of the vbr.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vbr_owner_id", value)


@pulumi.type_token("alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment")
class TransitRouterVbrAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router VBR Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router VBR Attachment and how to use it, see [What is Transit Router VBR Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervbrattachment)

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        default = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default.id)
        default_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("default",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=name_regex.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=2420,
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        default_transit_router_vbr_attachment = alicloud.cen.TransitRouterVbrAttachment("default",
            cen_id=default.id,
            vbr_id=default_virtual_border_router.id,
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router VBR Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment example <cen_id>:<transit_router_attachment_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
               
               ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vbr_id: The ID of the VBR.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The owner id of the vbr.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransitRouterVbrAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Enterprise Network (CEN) Transit Router VBR Attachment resource.

        For information about Cloud Enterprise Network (CEN) Transit Router VBR Attachment and how to use it, see [What is Transit Router VBR Attachment](https://www.alibabacloud.com/help/en/cen/developer-reference/api-cbn-2017-09-12-createtransitroutervbrattachment)

        > **NOTE:** Available since v1.126.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        name_regex = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        default = alicloud.cen.Instance("default",
            cen_instance_name=name,
            protection_level="REDUCED")
        default_transit_router = alicloud.cen.TransitRouter("default", cen_id=default.id)
        default_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("default",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=name_regex.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=2420,
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        default_transit_router_vbr_attachment = alicloud.cen.TransitRouterVbrAttachment("default",
            cen_id=default.id,
            vbr_id=default_virtual_border_router.id,
            transit_router_id=default_transit_router.transit_router_id,
            transit_router_attachment_name=name,
            transit_router_attachment_description=name)
        ```

        ## Import

        Cloud Enterprise Network (CEN) Transit Router VBR Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment example <cen_id>:<transit_router_attachment_id>
        ```

        :param str resource_name: The name of the resource.
        :param TransitRouterVbrAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransitRouterVbrAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransitRouterVbrAttachmentArgs.__new__(TransitRouterVbrAttachmentArgs)

            __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
            __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_id"] = transit_router_id
            if vbr_id is None and not opts.urn:
                raise TypeError("Missing required property 'vbr_id'")
            __props__.__dict__["vbr_id"] = vbr_id
            __props__.__dict__["vbr_owner_id"] = vbr_owner_id
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_attachment_id"] = None
        super(TransitRouterVbrAttachment, __self__).__init__(
            'alicloud:cen/transitRouterVbrAttachment:TransitRouterVbrAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_publish_route_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            route_table_association_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            route_table_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            transit_router_attachment_description: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
            vbr_id: Optional[pulumi.Input[_builtins.str]] = None,
            vbr_owner_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'TransitRouterVbrAttachment':
        """
        Get an existing TransitRouterVbrAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_publish_route_enabled: Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        :param pulumi.Input[_builtins.str] resource_type: The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        :param pulumi.Input[_builtins.bool] route_table_association_enabled: Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        :param pulumi.Input[_builtins.bool] route_table_propagation_enabled: Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."
               
               ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        :param pulumi.Input[_builtins.str] status: The status of the Transit Router VBR Attachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] transit_router_attachment_description: The description of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_attachment_id: The ID of the VBR connection.
        :param pulumi.Input[_builtins.str] transit_router_attachment_name: The name of the transit router vbr attachment.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router.
        :param pulumi.Input[_builtins.str] vbr_id: The ID of the VBR.
        :param pulumi.Input[_builtins.str] vbr_owner_id: The owner id of the vbr.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransitRouterVbrAttachmentState.__new__(_TransitRouterVbrAttachmentState)

        __props__.__dict__["auto_publish_route_enabled"] = auto_publish_route_enabled
        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["route_table_association_enabled"] = route_table_association_enabled
        __props__.__dict__["route_table_propagation_enabled"] = route_table_propagation_enabled
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["transit_router_attachment_description"] = transit_router_attachment_description
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["vbr_id"] = vbr_id
        __props__.__dict__["vbr_owner_id"] = vbr_owner_id
        return TransitRouterVbrAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPublishRouteEnabled")
    def auto_publish_route_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "auto_publish_route_enabled")

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to perform a dry run. Default value: `false`. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource type of the transit router vbr attachment. Default value: `VBR`. Valid values: `VBR`.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="routeTableAssociationEnabled")
    @_utilities.deprecated("""Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead.""")
    def route_table_association_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enabled route table association. **NOTE:** "Field `route_table_association_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTableAssociation` instead, how to use alicloud_cen_transit_router_route_table_association."
        """
        return pulumi.get(self, "route_table_association_enabled")

    @_builtins.property
    @pulumi.getter(name="routeTablePropagationEnabled")
    @_utilities.deprecated("""Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead.""")
    def route_table_propagation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enabled route table propagation. **NOTE:** "Field `route_table_propagation_enabled` has been deprecated from provider version 1.233.1. Please use the resource `cen.TransitRouterRouteTablePropagation` instead, how to use alicloud_cen_transit_router_route_table_propagation."

        ->**NOTE:** Ensure that the vbr is not used in Express Connect.
        """
        return pulumi.get(self, "route_table_propagation_enabled")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Transit Router VBR Attachment.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentDescription")
    def transit_router_attachment_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_description")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VBR connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @_builtins.property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the transit router vbr attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @_builtins.property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VBR.
        """
        return pulumi.get(self, "vbr_id")

    @_builtins.property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> pulumi.Output[_builtins.str]:
        """
        The owner id of the vbr.
        """
        return pulumi.get(self, "vbr_owner_id")

