# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DeliveryArgs', 'Delivery']

@pulumi.input_type
class DeliveryArgs:
    def __init__(__self__, *,
                 delivery_channel_target_arn: pulumi.Input[_builtins.str],
                 delivery_channel_type: pulumi.Input[_builtins.str],
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Delivery resource.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:  
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.  
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] description: The description of the delivery channel.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.int] status: The status of the delivery channel. Valid values:  
               - 0: The delivery channel is disabled.
               - 1: The delivery channel is enabled.
        """
        pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        if configuration_item_change_notification is not None:
            pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        if configuration_snapshot is not None:
            pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        if delivery_channel_condition is not None:
            pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        if delivery_channel_name is not None:
            pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if non_compliant_notification is not None:
            pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> pulumi.Input[_builtins.str]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @delivery_channel_target_arn.setter
    def delivery_channel_target_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_target_arn", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the delivery channel. Valid values:  
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @delivery_channel_type.setter
    def delivery_channel_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "delivery_channel_type", value)

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @configuration_item_change_notification.setter
    def configuration_item_change_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_item_change_notification", value)

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @configuration_snapshot.setter
    def configuration_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.  

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @delivery_channel_condition.setter
    def delivery_channel_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_condition", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @non_compliant_notification.setter
    def non_compliant_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_compliant_notification", value)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @oversized_data_oss_target_arn.setter
    def oversized_data_oss_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oversized_data_oss_target_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the delivery channel. Valid values:  
        - 0: The delivery channel is disabled.
        - 1: The delivery channel is enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DeliveryState:
    def __init__(__self__, *,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Delivery resources.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.  
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:  
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery channel.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.int] status: The status of the delivery channel. Valid values:  
               - 0: The delivery channel is disabled.
               - 1: The delivery channel is enabled.
        """
        if configuration_item_change_notification is not None:
            pulumi.set(__self__, "configuration_item_change_notification", configuration_item_change_notification)
        if configuration_snapshot is not None:
            pulumi.set(__self__, "configuration_snapshot", configuration_snapshot)
        if delivery_channel_condition is not None:
            pulumi.set(__self__, "delivery_channel_condition", delivery_channel_condition)
        if delivery_channel_name is not None:
            pulumi.set(__self__, "delivery_channel_name", delivery_channel_name)
        if delivery_channel_target_arn is not None:
            pulumi.set(__self__, "delivery_channel_target_arn", delivery_channel_target_arn)
        if delivery_channel_type is not None:
            pulumi.set(__self__, "delivery_channel_type", delivery_channel_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if non_compliant_notification is not None:
            pulumi.set(__self__, "non_compliant_notification", non_compliant_notification)
        if oversized_data_oss_target_arn is not None:
            pulumi.set(__self__, "oversized_data_oss_target_arn", oversized_data_oss_target_arn)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @configuration_item_change_notification.setter
    def configuration_item_change_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_item_change_notification", value)

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @configuration_snapshot.setter
    def configuration_snapshot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "configuration_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.  

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @delivery_channel_condition.setter
    def delivery_channel_condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_condition", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @delivery_channel_name.setter
    def delivery_channel_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_name", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @delivery_channel_target_arn.setter
    def delivery_channel_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_target_arn", value)

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the delivery channel. Valid values:  
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @delivery_channel_type.setter
    def delivery_channel_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delivery_channel_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @non_compliant_notification.setter
    def non_compliant_notification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "non_compliant_notification", value)

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @oversized_data_oss_target_arn.setter
    def oversized_data_oss_target_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oversized_data_oss_target_arn", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the delivery channel. Valid values:  
        - 0: The delivery channel is disabled.
        - 1: The delivery channel is enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cfg/delivery:Delivery")
class Delivery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Config Delivery resource.

        Delivery channel of current account.

        For information about Config Delivery and how to use it, see [What is Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigdeliverychannel).

        > **NOTE:** Available since v1.171.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example-sls"
        this = alicloud.get_account()
        this_get_regions = alicloud.get_regions(current=True)
        default = alicloud.log.Project("default", project_name=name)
        default_store = alicloud.log.Store("default",
            logstore_name=name,
            project_name=default.project_name)
        default_delivery = alicloud.cfg.Delivery("default",
            configuration_item_change_notification=True,
            non_compliant_notification=True,
            delivery_channel_name=name,
            delivery_channel_target_arn=pulumi.Output.all(
                project_name=default.project_name,
                logstore_name=default_store.logstore_name
        ).apply(lambda resolved_outputs: f"acs:log:{this_get_regions.ids[0]}:{this.id}:project/{resolved_outputs['project_name']}/logstore/{resolved_outputs['logstore_name']}")
        ,
            delivery_channel_type="SLS",
            description=name)
        ```

        ## Import

        Config Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/delivery:Delivery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.  
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:  
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery channel.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.int] status: The status of the delivery channel. Valid values:  
               - 0: The delivery channel is disabled.
               - 1: The delivery channel is enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeliveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Config Delivery resource.

        Delivery channel of current account.

        For information about Config Delivery and how to use it, see [What is Delivery](https://www.alibabacloud.com/help/en/cloud-config/latest/api-config-2020-09-07-createconfigdeliverychannel).

        > **NOTE:** Available since v1.171.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example-sls"
        this = alicloud.get_account()
        this_get_regions = alicloud.get_regions(current=True)
        default = alicloud.log.Project("default", project_name=name)
        default_store = alicloud.log.Store("default",
            logstore_name=name,
            project_name=default.project_name)
        default_delivery = alicloud.cfg.Delivery("default",
            configuration_item_change_notification=True,
            non_compliant_notification=True,
            delivery_channel_name=name,
            delivery_channel_target_arn=pulumi.Output.all(
                project_name=default.project_name,
                logstore_name=default_store.logstore_name
        ).apply(lambda resolved_outputs: f"acs:log:{this_get_regions.ids[0]}:{this.id}:project/{resolved_outputs['project_name']}/logstore/{resolved_outputs['logstore_name']}")
        ,
            delivery_channel_type="SLS",
            description=name)
        ```

        ## Import

        Config Delivery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cfg/delivery:Delivery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DeliveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeliveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
                 oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeliveryArgs.__new__(DeliveryArgs)

            __props__.__dict__["configuration_item_change_notification"] = configuration_item_change_notification
            __props__.__dict__["configuration_snapshot"] = configuration_snapshot
            __props__.__dict__["delivery_channel_condition"] = delivery_channel_condition
            __props__.__dict__["delivery_channel_name"] = delivery_channel_name
            if delivery_channel_target_arn is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_target_arn'")
            __props__.__dict__["delivery_channel_target_arn"] = delivery_channel_target_arn
            if delivery_channel_type is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_channel_type'")
            __props__.__dict__["delivery_channel_type"] = delivery_channel_type
            __props__.__dict__["description"] = description
            __props__.__dict__["non_compliant_notification"] = non_compliant_notification
            __props__.__dict__["oversized_data_oss_target_arn"] = oversized_data_oss_target_arn
            __props__.__dict__["status"] = status
        super(Delivery, __self__).__init__(
            'alicloud:cfg/delivery:Delivery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_item_change_notification: Optional[pulumi.Input[_builtins.bool]] = None,
            configuration_snapshot: Optional[pulumi.Input[_builtins.bool]] = None,
            delivery_channel_condition: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_name: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            delivery_channel_type: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            non_compliant_notification: Optional[pulumi.Input[_builtins.bool]] = None,
            oversized_data_oss_target_arn: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None) -> 'Delivery':
        """
        Get an existing Delivery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] configuration_item_change_notification: Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
               - true: The specified destination receives resource change logs.
               - false: The specified destination does not receive resource change logs.
        :param pulumi.Input[_builtins.bool] configuration_snapshot: Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
               - true: The specified destination receives scheduled resource snapshots.
               - false: The specified destination does not receive scheduled resource snapshots.
        :param pulumi.Input[_builtins.str] delivery_channel_condition: The rule that is attached to the delivery channel.  
               
               This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.
               
               If you specify the risk level or resource types for subscription events, this is as follows:
               
               The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.
               
               The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.
               
               Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        :param pulumi.Input[_builtins.str] delivery_channel_name: The name of the delivery channel.
        :param pulumi.Input[_builtins.str] delivery_channel_target_arn: The ARN of the delivery destination.  
               - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
               - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
               - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        :param pulumi.Input[_builtins.str] delivery_channel_type: The type of the delivery channel. Valid values:  
               - OSS: Object Storage Service (OSS)
               - MNS: Message Service (MNS)
               - SLS: Log Service
        :param pulumi.Input[_builtins.str] description: The description of the delivery channel.
        :param pulumi.Input[_builtins.bool] non_compliant_notification: Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
               - true: The specified destination receives resource non-compliance events.
               - false: The specified destination does not receive resource non-compliance events.
        :param pulumi.Input[_builtins.str] oversized_data_oss_target_arn: The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        :param pulumi.Input[_builtins.int] status: The status of the delivery channel. Valid values:  
               - 0: The delivery channel is disabled.
               - 1: The delivery channel is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeliveryState.__new__(_DeliveryState)

        __props__.__dict__["configuration_item_change_notification"] = configuration_item_change_notification
        __props__.__dict__["configuration_snapshot"] = configuration_snapshot
        __props__.__dict__["delivery_channel_condition"] = delivery_channel_condition
        __props__.__dict__["delivery_channel_name"] = delivery_channel_name
        __props__.__dict__["delivery_channel_target_arn"] = delivery_channel_target_arn
        __props__.__dict__["delivery_channel_type"] = delivery_channel_type
        __props__.__dict__["description"] = description
        __props__.__dict__["non_compliant_notification"] = non_compliant_notification
        __props__.__dict__["oversized_data_oss_target_arn"] = oversized_data_oss_target_arn
        __props__.__dict__["status"] = status
        return Delivery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configurationItemChangeNotification")
    def configuration_item_change_notification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource change logs. If the value of this parameter is true, Cloud Config delivers the resource change logs to OSS, Log Service, or MNS when the configurations of the resources change. Valid values:  
        - true: The specified destination receives resource change logs.
        - false: The specified destination does not receive resource change logs.
        """
        return pulumi.get(self, "configuration_item_change_notification")

    @_builtins.property
    @pulumi.getter(name="configurationSnapshot")
    def configuration_snapshot(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives scheduled resource snapshots. Cloud Config delivers scheduled resource snapshots at 04:00Z and 16:00Z to OSS, MNS, or Log Service every day. The time is displayed in UTC. Valid values:  
        - true: The specified destination receives scheduled resource snapshots.
        - false: The specified destination does not receive scheduled resource snapshots.
        """
        return pulumi.get(self, "configuration_snapshot")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelCondition")
    def delivery_channel_condition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule that is attached to the delivery channel.  

        This parameter is available when you deliver data of all types to MNS or deliver snapshots to Log Service.

        If you specify the risk level or resource types for subscription events, this is as follows:

        The lowest risk level of the events to which you want to subscribe is in the following format: {"filterType":"RuleRiskLevel","value":"1","multiple":false}, The value field indicates the risk level of the events to which you want to subscribe. Valid values: 1, 2, and 3. The value 1 indicates the high risk level, the value 2 indicates the medium risk level, and the value 3 indicates the low risk level.

        The setting of the resource types of the events to which you want to subscribe is in the following format: {"filterType":"ResourceType","values":["ACS::ACK::Cluster","ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage"],"multiple":true}, The values field indicates the resource types of the events to which you want to subscribe. The value of the field is a JSON array.

        Examples:[{"filterType":"ResourceType","values":["ACS::ActionTrail::Trail","ACS::CBWP::CommonBandwidthPackage","ACS::CDN::Domain","ACS::CEN::CenBandwidthPackage","ACS::CEN::CenInstance","ACS::CEN::Flowlog","ACS::DdosCoo::Instance"],"multiple":true}].
        """
        return pulumi.get(self, "delivery_channel_condition")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelName")
    def delivery_channel_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the delivery channel.
        """
        return pulumi.get(self, "delivery_channel_name")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelTargetArn")
    def delivery_channel_target_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the delivery destination.  
        - If the value of the DeliveryChannelType parameter is OSS, the value of this parameter is the ARN of the destination OSS bucket.
        - If the value of the DeliveryChannelType parameter is MNS, the value of this parameter is the ARN of the destination MNS topic.
        - If the value of the DeliveryChannelType parameter is SLS, the value of this parameter is the ARN of the destination Log Service Logstore.
        """
        return pulumi.get(self, "delivery_channel_target_arn")

    @_builtins.property
    @pulumi.getter(name="deliveryChannelType")
    def delivery_channel_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the delivery channel. Valid values:  
        - OSS: Object Storage Service (OSS)
        - MNS: Message Service (MNS)
        - SLS: Log Service
        """
        return pulumi.get(self, "delivery_channel_type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the delivery channel.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="nonCompliantNotification")
    def non_compliant_notification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the specified destination receives resource non-compliance events. If the value of this parameter is true, Cloud Config delivers resource non-compliance events to Log Service or MNS when resources are evaluated as non-compliant. Valid values:  
        - true: The specified destination receives resource non-compliance events.
        - false: The specified destination does not receive resource non-compliance events.
        """
        return pulumi.get(self, "non_compliant_notification")

    @_builtins.property
    @pulumi.getter(name="oversizedDataOssTargetArn")
    def oversized_data_oss_target_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The oss ARN of the delivery channel when the value data oversized limit.  The value must be in one of the following formats:  acs:oss:{RegionId}:{Aliuid}:{bucketName} if your delivery destination is an Object Storage Service (OSS) bucket.
        """
        return pulumi.get(self, "oversized_data_oss_target_arn")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        The status of the delivery channel. Valid values:  
        - 0: The delivery channel is disabled.
        - 1: The delivery channel is enabled.
        """
        return pulumi.get(self, "status")

