# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicEndpointArgs', 'PublicEndpoint']

@pulumi.input_type
class PublicEndpointArgs:
    def __init__(__self__, *,
                 connection_string_prefix: pulumi.Input[_builtins.str],
                 db_instance_id: pulumi.Input[_builtins.str],
                 net_type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PublicEndpoint resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The public network connection string prefix of the instance.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] net_type: Network type of the connection address. Valid values:
               - Public: Public network.
        """
        pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        pulumi.set(__self__, "net_type", net_type)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The public network connection string prefix of the instance.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Input[_builtins.str]:
        """
        Network type of the connection address. Valid values:
        - Public: Public network.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "net_type", value)


@pulumi.input_type
class _PublicEndpointState:
    def __init__(__self__, *,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicEndpoint resources.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The public network connection string prefix of the instance.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] net_type: Network type of the connection address. Valid values:
               - Public: Public network.
        """
        if connection_string_prefix is not None:
            pulumi.set(__self__, "connection_string_prefix", connection_string_prefix)
        if db_instance_id is not None:
            pulumi.set(__self__, "db_instance_id", db_instance_id)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public network connection string prefix of the instance.
        """
        return pulumi.get(self, "connection_string_prefix")

    @connection_string_prefix.setter
    def connection_string_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_prefix", value)

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @db_instance_id.setter
    def db_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network type of the connection address. Valid values:
        - Public: Public network.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)


@pulumi.type_token("alicloud:clickhouseenterprisedbcluster/publicEndpoint:PublicEndpoint")
class PublicEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Click House Enterprise Db Cluster Public Endpoint resource.

        ClickHouse enterprise instance public network endpoint.

        For information about Click House Enterprise Db Cluster Public Endpoint and how to use it, see [What is Enterprise Db Cluster Public Endpoint](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateEndpoint).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultaqnt22 = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("defaultaqnt22",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.PublicEndpoint("default",
            db_instance_id=defaultaqnt22.id,
            net_type="Public",
            connection_string_prefix=defaultaqnt22.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Public Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/publicEndpoint:PublicEndpoint example <db_instance_id>:<net_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The public network connection string prefix of the instance.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] net_type: Network type of the connection address. Valid values:
               - Public: Public network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Click House Enterprise Db Cluster Public Endpoint resource.

        ClickHouse enterprise instance public network endpoint.

        For information about Click House Enterprise Db Cluster Public Endpoint and how to use it, see [What is Enterprise Db Cluster Public Endpoint](https://next.api.alibabacloud.com/document/clickhouse/2023-05-22/CreateEndpoint).

        > **NOTE:** Available since v1.247.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        region_id = config.get("regionId")
        if region_id is None:
            region_id = "cn-beijing"
        vsw_ip_range_i = config.get("vswIpRangeI")
        if vsw_ip_range_i is None:
            vsw_ip_range_i = "172.16.1.0/24"
        vpc_ip_range = config.get("vpcIpRange")
        if vpc_ip_range is None:
            vpc_ip_range = "172.16.0.0/12"
        zone_id_i = config.get("zoneIdI")
        if zone_id_i is None:
            zone_id_i = "cn-beijing-i"
        defaultkt_k_lu_m = alicloud.vpc.Network("defaultktKLuM", cidr_block=vpc_ip_range)
        default_tqwn3k = alicloud.vpc.Switch("defaultTQWN3k",
            vpc_id=defaultkt_k_lu_m.id,
            zone_id=zone_id_i,
            cidr_block=vsw_ip_range_i)
        defaultaqnt22 = alicloud.clickhouseenterprisedbcluster.ClickHouseEnterpriseDbCluster("defaultaqnt22",
            zone_id=zone_id_i,
            vpc_id=defaultkt_k_lu_m.id,
            scale_min="8",
            scale_max="16",
            vswitch_id=default_tqwn3k.id)
        default = alicloud.clickhouseenterprisedbcluster.PublicEndpoint("default",
            db_instance_id=defaultaqnt22.id,
            net_type="Public",
            connection_string_prefix=defaultaqnt22.id)
        ```

        ## Import

        Click House Enterprise Db Cluster Public Endpoint can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:clickhouseenterprisedbcluster/publicEndpoint:PublicEndpoint example <db_instance_id>:<net_type>
        ```

        :param str resource_name: The name of the resource.
        :param PublicEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicEndpointArgs.__new__(PublicEndpointArgs)

            if connection_string_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'connection_string_prefix'")
            __props__.__dict__["connection_string_prefix"] = connection_string_prefix
            if db_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_instance_id'")
            __props__.__dict__["db_instance_id"] = db_instance_id
            if net_type is None and not opts.urn:
                raise TypeError("Missing required property 'net_type'")
            __props__.__dict__["net_type"] = net_type
        super(PublicEndpoint, __self__).__init__(
            'alicloud:clickhouseenterprisedbcluster/publicEndpoint:PublicEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            db_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'PublicEndpoint':
        """
        Get an existing PublicEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string_prefix: The public network connection string prefix of the instance.
        :param pulumi.Input[_builtins.str] db_instance_id: The cluster ID.
        :param pulumi.Input[_builtins.str] net_type: Network type of the connection address. Valid values:
               - Public: Public network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicEndpointState.__new__(_PublicEndpointState)

        __props__.__dict__["connection_string_prefix"] = connection_string_prefix
        __props__.__dict__["db_instance_id"] = db_instance_id
        __props__.__dict__["net_type"] = net_type
        return PublicEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionStringPrefix")
    def connection_string_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The public network connection string prefix of the instance.
        """
        return pulumi.get(self, "connection_string_prefix")

    @_builtins.property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster ID.
        """
        return pulumi.get(self, "db_instance_id")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[_builtins.str]:
        """
        Network type of the connection address. Valid values:
        - Public: Public network.
        """
        return pulumi.get(self, "net_type")

