# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourceArgs', 'Resource']

@pulumi.input_type
class ResourceArgs:
    def __init__(__self__, *,
                 product: pulumi.Input[_builtins.str],
                 resource_code: pulumi.Input[_builtins.str],
                 desire_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Resource resource.
        :param pulumi.Input[_builtins.str] product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] desire_attributes: Resource attributes specified when a user creates or updates a resource.
        :param pulumi.Input[_builtins.str] resource_id: If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "resource_code", resource_code)
        if desire_attributes is not None:
            pulumi.set(__self__, "desire_attributes", desire_attributes)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Input[_builtins.str]:
        """
        The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter(name="resourceCode")
    def resource_code(self) -> pulumi.Input[_builtins.str]:
        """
        Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "resource_code")

    @resource_code.setter
    def resource_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_code", value)

    @_builtins.property
    @pulumi.getter(name="desireAttributes")
    def desire_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attributes specified when a user creates or updates a resource.
        """
        return pulumi.get(self, "desire_attributes")

    @desire_attributes.setter
    def desire_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desire_attributes", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.input_type
class _ResourceState:
    def __init__(__self__, *,
                 desire_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 product: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Resource resources.
        :param pulumi.Input[_builtins.str] desire_attributes: Resource attributes specified when a user creates or updates a resource.
        :param pulumi.Input[_builtins.str] product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_attributes: The collection of properties for the resource.
        :param pulumi.Input[_builtins.str] resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_id: If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        if desire_attributes is not None:
            pulumi.set(__self__, "desire_attributes", desire_attributes)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if resource_attributes is not None:
            pulumi.set(__self__, "resource_attributes", resource_attributes)
        if resource_code is not None:
            pulumi.set(__self__, "resource_code", resource_code)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)

    @_builtins.property
    @pulumi.getter(name="desireAttributes")
    def desire_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource attributes specified when a user creates or updates a resource.
        """
        return pulumi.get(self, "desire_attributes")

    @desire_attributes.setter
    def desire_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desire_attributes", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The collection of properties for the resource.
        """
        return pulumi.get(self, "resource_attributes")

    @resource_attributes.setter
    def resource_attributes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_attributes", value)

    @_builtins.property
    @pulumi.getter(name="resourceCode")
    def resource_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "resource_code")

    @resource_code.setter
    def resource_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_code", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)


@pulumi.type_token("alicloud:cloudcontrol/resource:Resource")
class Resource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desire_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 product: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Control Resource resource.

        For information about Cloud Control Resource and how to use it, see [What is Resource](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetResourceType).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        mq_instance = alicloud.cloudcontrol.Resource("mq_instance",
            desire_attributes=json.dumps({
                "InstanceName": "terraform-example-ons-instance",
            }),
            product="Ons",
            resource_code="Instance")
        default = alicloud.cloudcontrol.Resource("default",
            product="Ons",
            resource_code="Instance::Topic",
            resource_id=mq_instance.resource_id,
            desire_attributes=pulumi.Output.json_dumps({
                "InstanceId": mq_instance.resource_id,
                "TopicName": "terraform-example-ons-topic",
                "MessageType": "1",
            }))
        ```

        ## Import

        Cloud Control Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudcontrol/resource:Resource example <provider>:<product>:<resource_code>:<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desire_attributes: Resource attributes specified when a user creates or updates a resource.
        :param pulumi.Input[_builtins.str] product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_id: If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Control Resource resource.

        For information about Cloud Control Resource and how to use it, see [What is Resource](https://next.api.aliyun.com/document/cloudcontrol/2022-08-30/GetResourceType).

        > **NOTE:** Available since v1.241.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        mq_instance = alicloud.cloudcontrol.Resource("mq_instance",
            desire_attributes=json.dumps({
                "InstanceName": "terraform-example-ons-instance",
            }),
            product="Ons",
            resource_code="Instance")
        default = alicloud.cloudcontrol.Resource("default",
            product="Ons",
            resource_code="Instance::Topic",
            resource_id=mq_instance.resource_id,
            desire_attributes=pulumi.Output.json_dumps({
                "InstanceId": mq_instance.resource_id,
                "TopicName": "terraform-example-ons-topic",
                "MessageType": "1",
            }))
        ```

        ## Import

        Cloud Control Resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudcontrol/resource:Resource example <provider>:<product>:<resource_code>:<resource_id>
        ```

        :param str resource_name: The name of the resource.
        :param ResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desire_attributes: Optional[pulumi.Input[_builtins.str]] = None,
                 product: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_code: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceArgs.__new__(ResourceArgs)

            __props__.__dict__["desire_attributes"] = None if desire_attributes is None else pulumi.Output.secret(desire_attributes)
            if product is None and not opts.urn:
                raise TypeError("Missing required property 'product'")
            __props__.__dict__["product"] = product
            if resource_code is None and not opts.urn:
                raise TypeError("Missing required property 'resource_code'")
            __props__.__dict__["resource_code"] = resource_code
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["resource_attributes"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["desireAttributes"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Resource, __self__).__init__(
            'alicloud:cloudcontrol/resource:Resource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            desire_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            product: Optional[pulumi.Input[_builtins.str]] = None,
            resource_attributes: Optional[pulumi.Input[_builtins.str]] = None,
            resource_code: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Resource':
        """
        Get an existing Resource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desire_attributes: Resource attributes specified when a user creates or updates a resource.
        :param pulumi.Input[_builtins.str] product: The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_attributes: The collection of properties for the resource.
        :param pulumi.Input[_builtins.str] resource_code: Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        :param pulumi.Input[_builtins.str] resource_id: If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceState.__new__(_ResourceState)

        __props__.__dict__["desire_attributes"] = desire_attributes
        __props__.__dict__["product"] = product
        __props__.__dict__["resource_attributes"] = resource_attributes
        __props__.__dict__["resource_code"] = resource_code
        __props__.__dict__["resource_id"] = resource_id
        return Resource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="desireAttributes")
    def desire_attributes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource attributes specified when a user creates or updates a resource.
        """
        return pulumi.get(self, "desire_attributes")

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Output[_builtins.str]:
        """
        The product Code represents the product to be operated. Currently supported products and resources can be queried at the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> pulumi.Output[_builtins.str]:
        """
        The collection of properties for the resource.
        """
        return pulumi.get(self, "resource_attributes")

    @_builtins.property
    @pulumi.getter(name="resourceCode")
    def resource_code(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Code, if there is a parent resource, split with `::`, such as VPC::VSwitch. The supported resource Code can be obtained from the following link: [supported-services-and-resource-types](https://help.aliyun.com/zh/cloud-control-api/product-overview/supported-services-and-resource-types).
        """
        return pulumi.get(self, "resource_code")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        If there is a parent resource, you need to enter the id of the parent resource, for example, in the VPC::VSwtich resource, you need to enter the id of the VPC: vpc-dexadfe3r4ad. If there are more than one level of parent resources, you need to use `:` to split.
        """
        return pulumi.get(self, "resource_id")

