# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcCenTrFirewallArgs', 'VpcCenTrFirewall']

@pulumi.input_type
class VpcCenTrFirewallArgs:
    def __init__(__self__, *,
                 cen_id: pulumi.Input[_builtins.str],
                 firewall_name: pulumi.Input[_builtins.str],
                 firewall_subnet_cidr: pulumi.Input[_builtins.str],
                 firewall_vpc_cidr: pulumi.Input[_builtins.str],
                 region_no: pulumi.Input[_builtins.str],
                 route_mode: pulumi.Input[_builtins.str],
                 tr_attachment_master_cidr: pulumi.Input[_builtins.str],
                 tr_attachment_slave_cidr: pulumi.Input[_builtins.str],
                 transit_router_id: pulumi.Input[_builtins.str],
                 firewall_description: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpcCenTrFirewall resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] firewall_name: The name of Cloud Firewall.
        :param pulumi.Input[_builtins.str] firewall_subnet_cidr: Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        :param pulumi.Input[_builtins.str] firewall_vpc_cidr: Required in automatic mode,  th CIDR of firewall VPC.
        :param pulumi.Input[_builtins.str] region_no: The region ID of the transit router instance.
        :param pulumi.Input[_builtins.str] route_mode: The routing pattern. Value: managed: indicates automatic mode
        :param pulumi.Input[_builtins.str] tr_attachment_master_cidr: Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_cidr: Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router instance.
        :param pulumi.Input[_builtins.str] firewall_description: Firewall description.
        :param pulumi.Input[_builtins.str] tr_attachment_master_zone: The primary zone of the switch.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_zone: Switch standby area.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "firewall_name", firewall_name)
        pulumi.set(__self__, "firewall_subnet_cidr", firewall_subnet_cidr)
        pulumi.set(__self__, "firewall_vpc_cidr", firewall_vpc_cidr)
        pulumi.set(__self__, "region_no", region_no)
        pulumi.set(__self__, "route_mode", route_mode)
        pulumi.set(__self__, "tr_attachment_master_cidr", tr_attachment_master_cidr)
        pulumi.set(__self__, "tr_attachment_slave_cidr", tr_attachment_slave_cidr)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if firewall_description is not None:
            pulumi.set(__self__, "firewall_description", firewall_description)
        if tr_attachment_master_zone is not None:
            pulumi.set(__self__, "tr_attachment_master_zone", tr_attachment_master_zone)
        if tr_attachment_slave_zone is not None:
            pulumi.set(__self__, "tr_attachment_slave_zone", tr_attachment_slave_zone)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of Cloud Firewall.
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_name", value)

    @_builtins.property
    @pulumi.getter(name="firewallSubnetCidr")
    def firewall_subnet_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        """
        return pulumi.get(self, "firewall_subnet_cidr")

    @firewall_subnet_cidr.setter
    def firewall_subnet_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="firewallVpcCidr")
    def firewall_vpc_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Required in automatic mode,  th CIDR of firewall VPC.
        """
        return pulumi.get(self, "firewall_vpc_cidr")

    @firewall_vpc_cidr.setter
    def firewall_vpc_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "firewall_vpc_cidr", value)

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> pulumi.Input[_builtins.str]:
        """
        The region ID of the transit router instance.
        """
        return pulumi.get(self, "region_no")

    @region_no.setter
    def region_no(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_no", value)

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> pulumi.Input[_builtins.str]:
        """
        The routing pattern. Value: managed: indicates automatic mode
        """
        return pulumi.get(self, "route_mode")

    @route_mode.setter
    def route_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "route_mode", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterCidr")
    def tr_attachment_master_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        """
        return pulumi.get(self, "tr_attachment_master_cidr")

    @tr_attachment_master_cidr.setter
    def tr_attachment_master_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tr_attachment_master_cidr", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveCidr")
    def tr_attachment_slave_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        """
        return pulumi.get(self, "tr_attachment_slave_cidr")

    @tr_attachment_slave_cidr.setter
    def tr_attachment_slave_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tr_attachment_slave_cidr", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the transit router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "transit_router_id", value)

    @_builtins.property
    @pulumi.getter(name="firewallDescription")
    def firewall_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Firewall description.
        """
        return pulumi.get(self, "firewall_description")

    @firewall_description.setter
    def firewall_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_description", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterZone")
    def tr_attachment_master_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary zone of the switch.
        """
        return pulumi.get(self, "tr_attachment_master_zone")

    @tr_attachment_master_zone.setter
    def tr_attachment_master_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_master_zone", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveZone")
    def tr_attachment_slave_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Switch standby area.
        """
        return pulumi.get(self, "tr_attachment_slave_zone")

    @tr_attachment_slave_zone.setter
    def tr_attachment_slave_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_slave_zone", value)


@pulumi.input_type
class _VpcCenTrFirewallState:
    def __init__(__self__, *,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VpcCenTrFirewall resources.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] firewall_description: Firewall description.
        :param pulumi.Input[_builtins.str] firewall_name: The name of Cloud Firewall.
        :param pulumi.Input[_builtins.str] firewall_subnet_cidr: Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        :param pulumi.Input[_builtins.str] firewall_vpc_cidr: Required in automatic mode,  th CIDR of firewall VPC.
        :param pulumi.Input[_builtins.str] region_no: The region ID of the transit router instance.
        :param pulumi.Input[_builtins.str] route_mode: The routing pattern. Value: managed: indicates automatic mode
        :param pulumi.Input[_builtins.str] status: Firewall status. Value:
        :param pulumi.Input[_builtins.str] tr_attachment_master_cidr: Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        :param pulumi.Input[_builtins.str] tr_attachment_master_zone: The primary zone of the switch.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_cidr: Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_zone: Switch standby area.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router instance.
        """
        if cen_id is not None:
            pulumi.set(__self__, "cen_id", cen_id)
        if firewall_description is not None:
            pulumi.set(__self__, "firewall_description", firewall_description)
        if firewall_name is not None:
            pulumi.set(__self__, "firewall_name", firewall_name)
        if firewall_subnet_cidr is not None:
            pulumi.set(__self__, "firewall_subnet_cidr", firewall_subnet_cidr)
        if firewall_vpc_cidr is not None:
            pulumi.set(__self__, "firewall_vpc_cidr", firewall_vpc_cidr)
        if region_no is not None:
            pulumi.set(__self__, "region_no", region_no)
        if route_mode is not None:
            pulumi.set(__self__, "route_mode", route_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tr_attachment_master_cidr is not None:
            pulumi.set(__self__, "tr_attachment_master_cidr", tr_attachment_master_cidr)
        if tr_attachment_master_zone is not None:
            pulumi.set(__self__, "tr_attachment_master_zone", tr_attachment_master_zone)
        if tr_attachment_slave_cidr is not None:
            pulumi.set(__self__, "tr_attachment_slave_cidr", tr_attachment_slave_cidr)
        if tr_attachment_slave_zone is not None:
            pulumi.set(__self__, "tr_attachment_slave_zone", tr_attachment_slave_zone)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @cen_id.setter
    def cen_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cen_id", value)

    @_builtins.property
    @pulumi.getter(name="firewallDescription")
    def firewall_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Firewall description.
        """
        return pulumi.get(self, "firewall_description")

    @firewall_description.setter
    def firewall_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_description", value)

    @_builtins.property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Cloud Firewall.
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_name", value)

    @_builtins.property
    @pulumi.getter(name="firewallSubnetCidr")
    def firewall_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        """
        return pulumi.get(self, "firewall_subnet_cidr")

    @firewall_subnet_cidr.setter
    def firewall_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter(name="firewallVpcCidr")
    def firewall_vpc_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required in automatic mode,  th CIDR of firewall VPC.
        """
        return pulumi.get(self, "firewall_vpc_cidr")

    @firewall_vpc_cidr.setter
    def firewall_vpc_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_vpc_cidr", value)

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the transit router instance.
        """
        return pulumi.get(self, "region_no")

    @region_no.setter
    def region_no(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_no", value)

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The routing pattern. Value: managed: indicates automatic mode
        """
        return pulumi.get(self, "route_mode")

    @route_mode.setter
    def route_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_mode", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Firewall status. Value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterCidr")
    def tr_attachment_master_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        """
        return pulumi.get(self, "tr_attachment_master_cidr")

    @tr_attachment_master_cidr.setter
    def tr_attachment_master_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_master_cidr", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterZone")
    def tr_attachment_master_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary zone of the switch.
        """
        return pulumi.get(self, "tr_attachment_master_zone")

    @tr_attachment_master_zone.setter
    def tr_attachment_master_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_master_zone", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveCidr")
    def tr_attachment_slave_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        """
        return pulumi.get(self, "tr_attachment_slave_cidr")

    @tr_attachment_slave_cidr.setter
    def tr_attachment_slave_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_slave_cidr", value)

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveZone")
    def tr_attachment_slave_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Switch standby area.
        """
        return pulumi.get(self, "tr_attachment_slave_zone")

    @tr_attachment_slave_zone.setter
    def tr_attachment_slave_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tr_attachment_slave_zone", value)

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the transit router instance.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_router_id", value)


@pulumi.type_token("alicloud:cloudfirewall/vpcCenTrFirewall:VpcCenTrFirewall")
class VpcCenTrFirewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud Firewall Vpc Cen Tr Firewall resource.

        VPC firewall Cloud Enterprise Network Enterprise Edition.

        For information about Cloud Firewall Vpc Cen Tr Firewall and how to use it, see [What is Vpc Cen Tr Firewall](https://www.alibabacloud.com/help/en/cloud-firewall/cloudfirewall/developer-reference/api-cloudfw-2017-12-07-createtrfirewallv2).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        description = config.get("description")
        if description is None:
            description = "Created by Terraform"
        firewall_name = config.get("firewallName")
        if firewall_name is None:
            firewall_name = "tf-example"
        tr_attachment_master_cidr = config.get("trAttachmentMasterCidr")
        if tr_attachment_master_cidr is None:
            tr_attachment_master_cidr = "192.168.3.192/26"
        firewall_subnet_cidr = config.get("firewallSubnetCidr")
        if firewall_subnet_cidr is None:
            firewall_subnet_cidr = "192.168.3.0/25"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        tr_attachment_slave_cidr = config.get("trAttachmentSlaveCidr")
        if tr_attachment_slave_cidr is None:
            tr_attachment_slave_cidr = "192.168.3.128/26"
        firewall_vpc_cidr = config.get("firewallVpcCidr")
        if firewall_vpc_cidr is None:
            firewall_vpc_cidr = "192.168.3.0/24"
        zone1 = config.get("zone1")
        if zone1 is None:
            zone1 = "cn-hangzhou-h"
        firewall_name_update = config.get("firewallNameUpdate")
        if firewall_name_update is None:
            firewall_name_update = "tf-example-1"
        zone2 = config.get("zone2")
        if zone2 is None:
            zone2 = "cn-hangzhou-i"
        default = alicloud.cen.get_transit_router_available_resources()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        cen = alicloud.cen.Instance("cen",
            description="terraform example",
            cen_instance_name=name)
        tr = alicloud.cen.TransitRouter("tr",
            transit_router_name=name,
            transit_router_description="tr-created-by-terraform",
            cen_id=cen.id)
        vpc1 = alicloud.vpc.Network("vpc1",
            description="created by terraform",
            cidr_block="192.168.1.0/24",
            vpc_name=name)
        vpc1vsw1 = alicloud.vpc.Switch("vpc1vsw1",
            cidr_block="192.168.1.0/25",
            vswitch_name=name,
            vpc_id=vpc1.id,
            zone_id=default.resources[0].master_zones[1])
        vpc1vsw2 = alicloud.vpc.Switch("vpc1vsw2",
            vpc_id=vpc1.id,
            cidr_block="192.168.1.128/26",
            vswitch_name=name,
            zone_id=default.resources[0].master_zones[2])
        foo = alicloud.vpc.RouteTable("foo",
            vpc_id=vpc1.id,
            route_table_name=name,
            description=name)
        tr_vpc1 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc1",
            zone_mappings=[
                {
                    "vswitch_id": vpc1vsw1.id,
                    "zone_id": default.resources[0].master_zones[1],
                },
                {
                    "zone_id": default.resources[0].master_zones[2],
                    "vswitch_id": vpc1vsw2.id,
                },
            ],
            vpc_id=vpc1.id,
            cen_id=cen.id,
            transit_router_id=tr.transit_router_id,
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        wait10_minutes = time.index.Sleep("wait_10_minutes", create_duration=10m,
        opts = pulumi.ResourceOptions(depends_on=[tr_vpc1]))
        default_vpc_cen_tr_firewall = alicloud.cloudfirewall.VpcCenTrFirewall("default",
            cen_id=tr_vpc1.cen_id,
            firewall_name=name,
            firewall_subnet_cidr=firewall_subnet_cidr,
            tr_attachment_slave_cidr=tr_attachment_slave_cidr,
            firewall_description="VpcCenTrFirewall created by terraform",
            region_no=region,
            tr_attachment_master_cidr=tr_attachment_master_cidr,
            firewall_vpc_cidr=firewall_vpc_cidr,
            transit_router_id=tr.transit_router_id,
            route_mode="managed",
            opts = pulumi.ResourceOptions(depends_on=[wait10_minutes]))
        ```

        ## Import

        Cloud Firewall Vpc Cen Tr Firewall can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/vpcCenTrFirewall:VpcCenTrFirewall example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] firewall_description: Firewall description.
        :param pulumi.Input[_builtins.str] firewall_name: The name of Cloud Firewall.
        :param pulumi.Input[_builtins.str] firewall_subnet_cidr: Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        :param pulumi.Input[_builtins.str] firewall_vpc_cidr: Required in automatic mode,  th CIDR of firewall VPC.
        :param pulumi.Input[_builtins.str] region_no: The region ID of the transit router instance.
        :param pulumi.Input[_builtins.str] route_mode: The routing pattern. Value: managed: indicates automatic mode
        :param pulumi.Input[_builtins.str] tr_attachment_master_cidr: Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        :param pulumi.Input[_builtins.str] tr_attachment_master_zone: The primary zone of the switch.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_cidr: Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_zone: Switch standby area.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcCenTrFirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud Firewall Vpc Cen Tr Firewall resource.

        VPC firewall Cloud Enterprise Network Enterprise Edition.

        For information about Cloud Firewall Vpc Cen Tr Firewall and how to use it, see [What is Vpc Cen Tr Firewall](https://www.alibabacloud.com/help/en/cloud-firewall/cloudfirewall/developer-reference/api-cloudfw-2017-12-07-createtrfirewallv2).

        > **NOTE:** Available since v1.228.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_time as time

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        description = config.get("description")
        if description is None:
            description = "Created by Terraform"
        firewall_name = config.get("firewallName")
        if firewall_name is None:
            firewall_name = "tf-example"
        tr_attachment_master_cidr = config.get("trAttachmentMasterCidr")
        if tr_attachment_master_cidr is None:
            tr_attachment_master_cidr = "192.168.3.192/26"
        firewall_subnet_cidr = config.get("firewallSubnetCidr")
        if firewall_subnet_cidr is None:
            firewall_subnet_cidr = "192.168.3.0/25"
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        tr_attachment_slave_cidr = config.get("trAttachmentSlaveCidr")
        if tr_attachment_slave_cidr is None:
            tr_attachment_slave_cidr = "192.168.3.128/26"
        firewall_vpc_cidr = config.get("firewallVpcCidr")
        if firewall_vpc_cidr is None:
            firewall_vpc_cidr = "192.168.3.0/24"
        zone1 = config.get("zone1")
        if zone1 is None:
            zone1 = "cn-hangzhou-h"
        firewall_name_update = config.get("firewallNameUpdate")
        if firewall_name_update is None:
            firewall_name_update = "tf-example-1"
        zone2 = config.get("zone2")
        if zone2 is None:
            zone2 = "cn-hangzhou-i"
        default = alicloud.cen.get_transit_router_available_resources()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        cen = alicloud.cen.Instance("cen",
            description="terraform example",
            cen_instance_name=name)
        tr = alicloud.cen.TransitRouter("tr",
            transit_router_name=name,
            transit_router_description="tr-created-by-terraform",
            cen_id=cen.id)
        vpc1 = alicloud.vpc.Network("vpc1",
            description="created by terraform",
            cidr_block="192.168.1.0/24",
            vpc_name=name)
        vpc1vsw1 = alicloud.vpc.Switch("vpc1vsw1",
            cidr_block="192.168.1.0/25",
            vswitch_name=name,
            vpc_id=vpc1.id,
            zone_id=default.resources[0].master_zones[1])
        vpc1vsw2 = alicloud.vpc.Switch("vpc1vsw2",
            vpc_id=vpc1.id,
            cidr_block="192.168.1.128/26",
            vswitch_name=name,
            zone_id=default.resources[0].master_zones[2])
        foo = alicloud.vpc.RouteTable("foo",
            vpc_id=vpc1.id,
            route_table_name=name,
            description=name)
        tr_vpc1 = alicloud.cen.TransitRouterVpcAttachment("tr-vpc1",
            zone_mappings=[
                {
                    "vswitch_id": vpc1vsw1.id,
                    "zone_id": default.resources[0].master_zones[1],
                },
                {
                    "zone_id": default.resources[0].master_zones[2],
                    "vswitch_id": vpc1vsw2.id,
                },
            ],
            vpc_id=vpc1.id,
            cen_id=cen.id,
            transit_router_id=tr.transit_router_id,
            opts = pulumi.ResourceOptions(depends_on=[foo]))
        wait10_minutes = time.index.Sleep("wait_10_minutes", create_duration=10m,
        opts = pulumi.ResourceOptions(depends_on=[tr_vpc1]))
        default_vpc_cen_tr_firewall = alicloud.cloudfirewall.VpcCenTrFirewall("default",
            cen_id=tr_vpc1.cen_id,
            firewall_name=name,
            firewall_subnet_cidr=firewall_subnet_cidr,
            tr_attachment_slave_cidr=tr_attachment_slave_cidr,
            firewall_description="VpcCenTrFirewall created by terraform",
            region_no=region,
            tr_attachment_master_cidr=tr_attachment_master_cidr,
            firewall_vpc_cidr=firewall_vpc_cidr,
            transit_router_id=tr.transit_router_id,
            route_mode="managed",
            opts = pulumi.ResourceOptions(depends_on=[wait10_minutes]))
        ```

        ## Import

        Cloud Firewall Vpc Cen Tr Firewall can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudfirewall/vpcCenTrFirewall:VpcCenTrFirewall example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VpcCenTrFirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcCenTrFirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cen_id: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_description: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 region_no: Optional[pulumi.Input[_builtins.str]] = None,
                 route_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_master_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tr_attachment_slave_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_router_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcCenTrFirewallArgs.__new__(VpcCenTrFirewallArgs)

            if cen_id is None and not opts.urn:
                raise TypeError("Missing required property 'cen_id'")
            __props__.__dict__["cen_id"] = cen_id
            __props__.__dict__["firewall_description"] = firewall_description
            if firewall_name is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_name'")
            __props__.__dict__["firewall_name"] = firewall_name
            if firewall_subnet_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_subnet_cidr'")
            __props__.__dict__["firewall_subnet_cidr"] = firewall_subnet_cidr
            if firewall_vpc_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_vpc_cidr'")
            __props__.__dict__["firewall_vpc_cidr"] = firewall_vpc_cidr
            if region_no is None and not opts.urn:
                raise TypeError("Missing required property 'region_no'")
            __props__.__dict__["region_no"] = region_no
            if route_mode is None and not opts.urn:
                raise TypeError("Missing required property 'route_mode'")
            __props__.__dict__["route_mode"] = route_mode
            if tr_attachment_master_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'tr_attachment_master_cidr'")
            __props__.__dict__["tr_attachment_master_cidr"] = tr_attachment_master_cidr
            __props__.__dict__["tr_attachment_master_zone"] = tr_attachment_master_zone
            if tr_attachment_slave_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'tr_attachment_slave_cidr'")
            __props__.__dict__["tr_attachment_slave_cidr"] = tr_attachment_slave_cidr
            __props__.__dict__["tr_attachment_slave_zone"] = tr_attachment_slave_zone
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["status"] = None
        super(VpcCenTrFirewall, __self__).__init__(
            'alicloud:cloudfirewall/vpcCenTrFirewall:VpcCenTrFirewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cen_id: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_description: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_name: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            region_no: Optional[pulumi.Input[_builtins.str]] = None,
            route_mode: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tr_attachment_master_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            tr_attachment_master_zone: Optional[pulumi.Input[_builtins.str]] = None,
            tr_attachment_slave_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            tr_attachment_slave_zone: Optional[pulumi.Input[_builtins.str]] = None,
            transit_router_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VpcCenTrFirewall':
        """
        Get an existing VpcCenTrFirewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cen_id: The ID of the CEN instance.
        :param pulumi.Input[_builtins.str] firewall_description: Firewall description.
        :param pulumi.Input[_builtins.str] firewall_name: The name of Cloud Firewall.
        :param pulumi.Input[_builtins.str] firewall_subnet_cidr: Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        :param pulumi.Input[_builtins.str] firewall_vpc_cidr: Required in automatic mode,  th CIDR of firewall VPC.
        :param pulumi.Input[_builtins.str] region_no: The region ID of the transit router instance.
        :param pulumi.Input[_builtins.str] route_mode: The routing pattern. Value: managed: indicates automatic mode
        :param pulumi.Input[_builtins.str] status: Firewall status. Value:
        :param pulumi.Input[_builtins.str] tr_attachment_master_cidr: Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        :param pulumi.Input[_builtins.str] tr_attachment_master_zone: The primary zone of the switch.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_cidr: Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        :param pulumi.Input[_builtins.str] tr_attachment_slave_zone: Switch standby area.
        :param pulumi.Input[_builtins.str] transit_router_id: The ID of the transit router instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcCenTrFirewallState.__new__(_VpcCenTrFirewallState)

        __props__.__dict__["cen_id"] = cen_id
        __props__.__dict__["firewall_description"] = firewall_description
        __props__.__dict__["firewall_name"] = firewall_name
        __props__.__dict__["firewall_subnet_cidr"] = firewall_subnet_cidr
        __props__.__dict__["firewall_vpc_cidr"] = firewall_vpc_cidr
        __props__.__dict__["region_no"] = region_no
        __props__.__dict__["route_mode"] = route_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["tr_attachment_master_cidr"] = tr_attachment_master_cidr
        __props__.__dict__["tr_attachment_master_zone"] = tr_attachment_master_zone
        __props__.__dict__["tr_attachment_slave_cidr"] = tr_attachment_slave_cidr
        __props__.__dict__["tr_attachment_slave_zone"] = tr_attachment_slave_zone
        __props__.__dict__["transit_router_id"] = transit_router_id
        return VpcCenTrFirewall(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @_builtins.property
    @pulumi.getter(name="firewallDescription")
    def firewall_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Firewall description.
        """
        return pulumi.get(self, "firewall_description")

    @_builtins.property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Cloud Firewall.
        """
        return pulumi.get(self, "firewall_name")

    @_builtins.property
    @pulumi.getter(name="firewallSubnetCidr")
    def firewall_subnet_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Required in automatic mode, the CIDR of subnet used to store the firewall ENI in the firewall VPC.
        """
        return pulumi.get(self, "firewall_subnet_cidr")

    @_builtins.property
    @pulumi.getter(name="firewallVpcCidr")
    def firewall_vpc_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Required in automatic mode,  th CIDR of firewall VPC.
        """
        return pulumi.get(self, "firewall_vpc_cidr")

    @_builtins.property
    @pulumi.getter(name="regionNo")
    def region_no(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the transit router instance.
        """
        return pulumi.get(self, "region_no")

    @_builtins.property
    @pulumi.getter(name="routeMode")
    def route_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The routing pattern. Value: managed: indicates automatic mode
        """
        return pulumi.get(self, "route_mode")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Firewall status. Value:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterCidr")
    def tr_attachment_master_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Required in automatic mode, the primary CIDR of network used to connect to the TR in the firewall VPC.
        """
        return pulumi.get(self, "tr_attachment_master_cidr")

    @_builtins.property
    @pulumi.getter(name="trAttachmentMasterZone")
    def tr_attachment_master_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The primary zone of the switch.
        """
        return pulumi.get(self, "tr_attachment_master_zone")

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveCidr")
    def tr_attachment_slave_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Required in automatic mode, the the secondary CIDR of the subnet in the firewall VPC used to connect to TR.
        """
        return pulumi.get(self, "tr_attachment_slave_cidr")

    @_builtins.property
    @pulumi.getter(name="trAttachmentSlaveZone")
    def tr_attachment_slave_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Switch standby area.
        """
        return pulumi.get(self, "tr_attachment_slave_zone")

    @_builtins.property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the transit router instance.
        """
        return pulumi.get(self, "transit_router_id")

