# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccessConfigurationArgs', 'AccessConfiguration']

@pulumi.input_type
class AccessConfigurationArgs:
    def __init__(__self__, *,
                 access_configuration_name: pulumi.Input[_builtins.str],
                 directory_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 force_remove_permission_policies: Optional[pulumi.Input[_builtins.bool]] = None,
                 permission_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]] = None,
                 relay_state: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AccessConfiguration resource.
        :param pulumi.Input[_builtins.str] access_configuration_name: The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] description: The description of the access configuration. The description can be up to `1024` characters in length.
        :param pulumi.Input[_builtins.bool] force_remove_permission_policies: This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.
               
               * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]] permission_policies: The Policy List. See `permission_policies` below.
        :param pulumi.Input[_builtins.str] relay_state: The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        :param pulumi.Input[_builtins.int] session_duration: The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "directory_id", directory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if force_remove_permission_policies is not None:
            pulumi.set(__self__, "force_remove_permission_policies", force_remove_permission_policies)
        if permission_policies is not None:
            pulumi.set(__self__, "permission_policies", permission_policies)
        if relay_state is not None:
            pulumi.set(__self__, "relay_state", relay_state)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "access_configuration_name")

    @access_configuration_name.setter
    def access_configuration_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_configuration_name", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the access configuration. The description can be up to `1024` characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="forceRemovePermissionPolicies")
    def force_remove_permission_policies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.

        * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        """
        return pulumi.get(self, "force_remove_permission_policies")

    @force_remove_permission_policies.setter
    def force_remove_permission_policies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_remove_permission_policies", value)

    @_builtins.property
    @pulumi.getter(name="permissionPolicies")
    def permission_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]]:
        """
        The Policy List. See `permission_policies` below.
        """
        return pulumi.get(self, "permission_policies")

    @permission_policies.setter
    def permission_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]]):
        pulumi.set(self, "permission_policies", value)

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        """
        return pulumi.get(self, "relay_state")

    @relay_state.setter
    def relay_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_state", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_duration", value)


@pulumi.input_type
class _AccessConfigurationState:
    def __init__(__self__, *,
                 access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 access_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_remove_permission_policies: Optional[pulumi.Input[_builtins.bool]] = None,
                 permission_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]] = None,
                 relay_state: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering AccessConfiguration resources.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the Access Configuration.
        :param pulumi.Input[_builtins.str] access_configuration_name: The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        :param pulumi.Input[_builtins.str] description: The description of the access configuration. The description can be up to `1024` characters in length.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.bool] force_remove_permission_policies: This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.
               
               * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]] permission_policies: The Policy List. See `permission_policies` below.
        :param pulumi.Input[_builtins.str] relay_state: The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        :param pulumi.Input[_builtins.int] session_duration: The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        if access_configuration_id is not None:
            pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        if access_configuration_name is not None:
            pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if force_remove_permission_policies is not None:
            pulumi.set(__self__, "force_remove_permission_policies", force_remove_permission_policies)
        if permission_policies is not None:
            pulumi.set(__self__, "permission_policies", permission_policies)
        if relay_state is not None:
            pulumi.set(__self__, "relay_state", relay_state)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @access_configuration_id.setter
    def access_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "access_configuration_name")

    @access_configuration_name.setter
    def access_configuration_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_configuration_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the access configuration. The description can be up to `1024` characters in length.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="forceRemovePermissionPolicies")
    def force_remove_permission_policies(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.

        * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        """
        return pulumi.get(self, "force_remove_permission_policies")

    @force_remove_permission_policies.setter
    def force_remove_permission_policies(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_remove_permission_policies", value)

    @_builtins.property
    @pulumi.getter(name="permissionPolicies")
    def permission_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]]:
        """
        The Policy List. See `permission_policies` below.
        """
        return pulumi.get(self, "permission_policies")

    @permission_policies.setter
    def permission_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessConfigurationPermissionPolicyArgs']]]]):
        pulumi.set(self, "permission_policies", value)

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        """
        return pulumi.get(self, "relay_state")

    @relay_state.setter
    def relay_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "relay_state", value)

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        return pulumi.get(self, "session_duration")

    @session_duration.setter
    def session_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "session_duration", value)


@pulumi.type_token("alicloud:cloudsso/accessConfiguration:AccessConfiguration")
class AccessConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_remove_permission_policies: Optional[pulumi.Input[_builtins.bool]] = None,
                 permission_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessConfigurationPermissionPolicyArgs', 'AccessConfigurationPermissionPolicyArgsDict']]]]] = None,
                 relay_state: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Cloud SSO Access Configuration resource.

        For information about Cloud SSO Access Configuration and how to use it, see [What is Access Configuration](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createaccessconfiguration).

        > **NOTE:** Available since v1.145.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_access_configuration = alicloud.cloudsso.AccessConfiguration("default",
            directory_id=default.directories[0].id,
            access_configuration_name=name,
            permission_policies=[{
                "permission_policy_type": "Inline",
                "permission_policy_name": name,
                "permission_policy_document": \"\"\"    {
                \\"Statement\\":[
              {
                \\"Action\\":\\"ecs:Get*\\",
                \\"Effect\\":\\"Allow\\",
                \\"Resource\\":[
                    \\"*\\"
                ]
              }
              ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            }])
        ```

        ## Import

        Cloud SSO Access Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/accessConfiguration:AccessConfiguration example <directory_id>:<access_configuration_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_configuration_name: The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        :param pulumi.Input[_builtins.str] description: The description of the access configuration. The description can be up to `1024` characters in length.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.bool] force_remove_permission_policies: This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.
               
               * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessConfigurationPermissionPolicyArgs', 'AccessConfigurationPermissionPolicyArgsDict']]]] permission_policies: The Policy List. See `permission_policies` below.
        :param pulumi.Input[_builtins.str] relay_state: The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        :param pulumi.Input[_builtins.int] session_duration: The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud SSO Access Configuration resource.

        For information about Cloud SSO Access Configuration and how to use it, see [What is Access Configuration](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createaccessconfiguration).

        > **NOTE:** Available since v1.145.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_access_configuration = alicloud.cloudsso.AccessConfiguration("default",
            directory_id=default.directories[0].id,
            access_configuration_name=name,
            permission_policies=[{
                "permission_policy_type": "Inline",
                "permission_policy_name": name,
                "permission_policy_document": \"\"\"    {
                \\"Statement\\":[
              {
                \\"Action\\":\\"ecs:Get*\\",
                \\"Effect\\":\\"Allow\\",
                \\"Resource\\":[
                    \\"*\\"
                ]
              }
              ],
                \\"Version\\": \\"1\\"
            }
        \"\"\",
            }])
        ```

        ## Import

        Cloud SSO Access Configuration can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/accessConfiguration:AccessConfiguration example <directory_id>:<access_configuration_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_remove_permission_policies: Optional[pulumi.Input[_builtins.bool]] = None,
                 permission_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessConfigurationPermissionPolicyArgs', 'AccessConfigurationPermissionPolicyArgsDict']]]]] = None,
                 relay_state: Optional[pulumi.Input[_builtins.str]] = None,
                 session_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessConfigurationArgs.__new__(AccessConfigurationArgs)

            if access_configuration_name is None and not opts.urn:
                raise TypeError("Missing required property 'access_configuration_name'")
            __props__.__dict__["access_configuration_name"] = access_configuration_name
            __props__.__dict__["description"] = description
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["force_remove_permission_policies"] = force_remove_permission_policies
            __props__.__dict__["permission_policies"] = permission_policies
            __props__.__dict__["relay_state"] = relay_state
            __props__.__dict__["session_duration"] = session_duration
            __props__.__dict__["access_configuration_id"] = None
        super(AccessConfiguration, __self__).__init__(
            'alicloud:cloudsso/accessConfiguration:AccessConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            access_configuration_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_remove_permission_policies: Optional[pulumi.Input[_builtins.bool]] = None,
            permission_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessConfigurationPermissionPolicyArgs', 'AccessConfigurationPermissionPolicyArgsDict']]]]] = None,
            relay_state: Optional[pulumi.Input[_builtins.str]] = None,
            session_duration: Optional[pulumi.Input[_builtins.int]] = None) -> 'AccessConfiguration':
        """
        Get an existing AccessConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_configuration_id: The ID of the Access Configuration.
        :param pulumi.Input[_builtins.str] access_configuration_name: The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        :param pulumi.Input[_builtins.str] description: The description of the access configuration. The description can be up to `1024` characters in length.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.bool] force_remove_permission_policies: This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.
               
               * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessConfigurationPermissionPolicyArgs', 'AccessConfigurationPermissionPolicyArgsDict']]]] permission_policies: The Policy List. See `permission_policies` below.
        :param pulumi.Input[_builtins.str] relay_state: The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        :param pulumi.Input[_builtins.int] session_duration: The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessConfigurationState.__new__(_AccessConfigurationState)

        __props__.__dict__["access_configuration_id"] = access_configuration_id
        __props__.__dict__["access_configuration_name"] = access_configuration_name
        __props__.__dict__["description"] = description
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["force_remove_permission_policies"] = force_remove_permission_policies
        __props__.__dict__["permission_policies"] = permission_policies
        __props__.__dict__["relay_state"] = relay_state
        __props__.__dict__["session_duration"] = session_duration
        return AccessConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the access configuration. The name can be up to `32` characters long and can contain letters, digits, and hyphens (-).
        """
        return pulumi.get(self, "access_configuration_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the access configuration. The description can be up to `1024` characters in length.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="forceRemovePermissionPolicies")
    def force_remove_permission_policies(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        This parameter is used to force deletion `permission_policies`. Valid Value: `true`, `false`.

        * **NOTE:** The `permission_policies` will be removed automatically when the resource is deleted, please operate with caution. If there are left more permission policies in the access configuration, please remove them before deleting the access configuration.
        """
        return pulumi.get(self, "force_remove_permission_policies")

    @_builtins.property
    @pulumi.getter(name="permissionPolicies")
    def permission_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AccessConfigurationPermissionPolicy']]]:
        """
        The Policy List. See `permission_policies` below.
        """
        return pulumi.get(self, "permission_policies")

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The RelayState of the Access Configuration, Cloud SSO users use this access configuration to access the RD account, the initial access page address. Must be the Alibaba Cloud console page, the default is the console home page.
        """
        return pulumi.get(self, "relay_state")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> pulumi.Output[_builtins.int]:
        """
        The SessionDuration of the Access Configuration. Unit: Seconds. Valid values: `900` to `43200`.
        """
        return pulumi.get(self, "session_duration")

