# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccessConfigurationPermissionPolicy',
    'DirectoryLoginPreference',
    'DirectoryMfaAuthenticationSettingInfo',
    'DirectoryPasswordPolicy',
    'DirectorySamlIdentityProviderConfiguration',
    'DirectorySamlServiceProvider',
    'DirectoryUserProvisioningConfiguration',
    'UserProvisioningUserProvisioningStatistic',
    'GetAccessAssignmentsAssignmentResult',
    'GetAccessConfigurationsConfigurationResult',
    'GetAccessConfigurationsConfigurationPermissionPolicyResult',
    'GetDirectoriesDirectoryResult',
    'GetDirectoriesDirectorySamlIdentityProviderConfigurationResult',
    'GetDirectoriesDirectoryTaskResult',
    'GetGroupsGroupResult',
    'GetScimServerCredentialsCredentialResult',
    'GetUsersUserResult',
    'GetUsersUserMfaDeviceResult',
]

@pulumi.output_type
class AccessConfigurationPermissionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permissionPolicyName":
            suggest = "permission_policy_name"
        elif key == "permissionPolicyType":
            suggest = "permission_policy_type"
        elif key == "permissionPolicyDocument":
            suggest = "permission_policy_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessConfigurationPermissionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessConfigurationPermissionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessConfigurationPermissionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission_policy_name: _builtins.str,
                 permission_policy_type: _builtins.str,
                 permission_policy_document: Optional[_builtins.str] = None):
        """
        :param _builtins.str permission_policy_name: The name of the policy.
        :param _builtins.str permission_policy_type: The type of the policy. Valid values: `System`, `Inline`.
        :param _builtins.str permission_policy_document: The configurations of the inline policy. **NOTE:** If `permission_policy_type` is set to `Inline`, `permission_policy_document` is required.
        """
        pulumi.set(__self__, "permission_policy_name", permission_policy_name)
        pulumi.set(__self__, "permission_policy_type", permission_policy_type)
        if permission_policy_document is not None:
            pulumi.set(__self__, "permission_policy_document", permission_policy_document)

    @_builtins.property
    @pulumi.getter(name="permissionPolicyName")
    def permission_policy_name(self) -> _builtins.str:
        """
        The name of the policy.
        """
        return pulumi.get(self, "permission_policy_name")

    @_builtins.property
    @pulumi.getter(name="permissionPolicyType")
    def permission_policy_type(self) -> _builtins.str:
        """
        The type of the policy. Valid values: `System`, `Inline`.
        """
        return pulumi.get(self, "permission_policy_type")

    @_builtins.property
    @pulumi.getter(name="permissionPolicyDocument")
    def permission_policy_document(self) -> Optional[_builtins.str]:
        """
        The configurations of the inline policy. **NOTE:** If `permission_policy_type` is set to `Inline`, `permission_policy_document` is required.
        """
        return pulumi.get(self, "permission_policy_document")


@pulumi.output_type
class DirectoryLoginPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowUserToGetCredentials":
            suggest = "allow_user_to_get_credentials"
        elif key == "loginNetworkMasks":
            suggest = "login_network_masks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryLoginPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryLoginPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryLoginPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_user_to_get_credentials: Optional[_builtins.bool] = None,
                 login_network_masks: Optional[_builtins.str] = None):
        """
        :param _builtins.bool allow_user_to_get_credentials: Whether the user can obtain the program access credential in the portal after logging in.
        :param _builtins.str login_network_masks: IP address whitelist
        """
        if allow_user_to_get_credentials is not None:
            pulumi.set(__self__, "allow_user_to_get_credentials", allow_user_to_get_credentials)
        if login_network_masks is not None:
            pulumi.set(__self__, "login_network_masks", login_network_masks)

    @_builtins.property
    @pulumi.getter(name="allowUserToGetCredentials")
    def allow_user_to_get_credentials(self) -> Optional[_builtins.bool]:
        """
        Whether the user can obtain the program access credential in the portal after logging in.
        """
        return pulumi.get(self, "allow_user_to_get_credentials")

    @_builtins.property
    @pulumi.getter(name="loginNetworkMasks")
    def login_network_masks(self) -> Optional[_builtins.str]:
        """
        IP address whitelist
        """
        return pulumi.get(self, "login_network_masks")


@pulumi.output_type
class DirectoryMfaAuthenticationSettingInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mfaAuthenticationAdvanceSettings":
            suggest = "mfa_authentication_advance_settings"
        elif key == "operationForRiskLogin":
            suggest = "operation_for_risk_login"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryMfaAuthenticationSettingInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryMfaAuthenticationSettingInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryMfaAuthenticationSettingInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mfa_authentication_advance_settings: Optional[_builtins.str] = None,
                 operation_for_risk_login: Optional[_builtins.str] = None):
        """
        :param _builtins.str mfa_authentication_advance_settings: Global MFA validation policy
        :param _builtins.str operation_for_risk_login: MFA verification policy for abnormal logon.
        """
        if mfa_authentication_advance_settings is not None:
            pulumi.set(__self__, "mfa_authentication_advance_settings", mfa_authentication_advance_settings)
        if operation_for_risk_login is not None:
            pulumi.set(__self__, "operation_for_risk_login", operation_for_risk_login)

    @_builtins.property
    @pulumi.getter(name="mfaAuthenticationAdvanceSettings")
    def mfa_authentication_advance_settings(self) -> Optional[_builtins.str]:
        """
        Global MFA validation policy
        """
        return pulumi.get(self, "mfa_authentication_advance_settings")

    @_builtins.property
    @pulumi.getter(name="operationForRiskLogin")
    def operation_for_risk_login(self) -> Optional[_builtins.str]:
        """
        MFA verification policy for abnormal logon.
        """
        return pulumi.get(self, "operation_for_risk_login")


@pulumi.output_type
class DirectoryPasswordPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardExpire":
            suggest = "hard_expire"
        elif key == "maxLoginAttempts":
            suggest = "max_login_attempts"
        elif key == "maxPasswordAge":
            suggest = "max_password_age"
        elif key == "maxPasswordLength":
            suggest = "max_password_length"
        elif key == "minPasswordDifferentChars":
            suggest = "min_password_different_chars"
        elif key == "minPasswordLength":
            suggest = "min_password_length"
        elif key == "passwordNotContainUsername":
            suggest = "password_not_contain_username"
        elif key == "passwordReusePrevention":
            suggest = "password_reuse_prevention"
        elif key == "requireLowerCaseChars":
            suggest = "require_lower_case_chars"
        elif key == "requireNumbers":
            suggest = "require_numbers"
        elif key == "requireSymbols":
            suggest = "require_symbols"
        elif key == "requireUpperCaseChars":
            suggest = "require_upper_case_chars"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryPasswordPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryPasswordPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryPasswordPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hard_expire: Optional[_builtins.bool] = None,
                 max_login_attempts: Optional[_builtins.int] = None,
                 max_password_age: Optional[_builtins.int] = None,
                 max_password_length: Optional[_builtins.int] = None,
                 min_password_different_chars: Optional[_builtins.int] = None,
                 min_password_length: Optional[_builtins.int] = None,
                 password_not_contain_username: Optional[_builtins.bool] = None,
                 password_reuse_prevention: Optional[_builtins.int] = None,
                 require_lower_case_chars: Optional[_builtins.bool] = None,
                 require_numbers: Optional[_builtins.bool] = None,
                 require_symbols: Optional[_builtins.bool] = None,
                 require_upper_case_chars: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool hard_expire: Whether to restrict login after Password Expiration
        :param _builtins.int max_login_attempts: Number of password retries.
        :param _builtins.int max_password_age: Password validity period.
        :param _builtins.int max_password_length: Maximum password length.
        :param _builtins.int min_password_different_chars: The minimum number of different characters in a password.
        :param _builtins.int min_password_length: Minimum password length.
        :param _builtins.bool password_not_contain_username: Whether the user name is not allowed in the password.
        :param _builtins.int password_reuse_prevention: Historical password check policy.
        :param _builtins.bool require_lower_case_chars: Whether lowercase letters are required in the password.
        :param _builtins.bool require_numbers: Whether numbers are required in the password.
        :param _builtins.bool require_symbols: Whether symbols are required in the password.
        :param _builtins.bool require_upper_case_chars: Whether uppercase letters are required in the password.
        """
        if hard_expire is not None:
            pulumi.set(__self__, "hard_expire", hard_expire)
        if max_login_attempts is not None:
            pulumi.set(__self__, "max_login_attempts", max_login_attempts)
        if max_password_age is not None:
            pulumi.set(__self__, "max_password_age", max_password_age)
        if max_password_length is not None:
            pulumi.set(__self__, "max_password_length", max_password_length)
        if min_password_different_chars is not None:
            pulumi.set(__self__, "min_password_different_chars", min_password_different_chars)
        if min_password_length is not None:
            pulumi.set(__self__, "min_password_length", min_password_length)
        if password_not_contain_username is not None:
            pulumi.set(__self__, "password_not_contain_username", password_not_contain_username)
        if password_reuse_prevention is not None:
            pulumi.set(__self__, "password_reuse_prevention", password_reuse_prevention)
        if require_lower_case_chars is not None:
            pulumi.set(__self__, "require_lower_case_chars", require_lower_case_chars)
        if require_numbers is not None:
            pulumi.set(__self__, "require_numbers", require_numbers)
        if require_symbols is not None:
            pulumi.set(__self__, "require_symbols", require_symbols)
        if require_upper_case_chars is not None:
            pulumi.set(__self__, "require_upper_case_chars", require_upper_case_chars)

    @_builtins.property
    @pulumi.getter(name="hardExpire")
    def hard_expire(self) -> Optional[_builtins.bool]:
        """
        Whether to restrict login after Password Expiration
        """
        return pulumi.get(self, "hard_expire")

    @_builtins.property
    @pulumi.getter(name="maxLoginAttempts")
    def max_login_attempts(self) -> Optional[_builtins.int]:
        """
        Number of password retries.
        """
        return pulumi.get(self, "max_login_attempts")

    @_builtins.property
    @pulumi.getter(name="maxPasswordAge")
    def max_password_age(self) -> Optional[_builtins.int]:
        """
        Password validity period.
        """
        return pulumi.get(self, "max_password_age")

    @_builtins.property
    @pulumi.getter(name="maxPasswordLength")
    def max_password_length(self) -> Optional[_builtins.int]:
        """
        Maximum password length.
        """
        return pulumi.get(self, "max_password_length")

    @_builtins.property
    @pulumi.getter(name="minPasswordDifferentChars")
    def min_password_different_chars(self) -> Optional[_builtins.int]:
        """
        The minimum number of different characters in a password.
        """
        return pulumi.get(self, "min_password_different_chars")

    @_builtins.property
    @pulumi.getter(name="minPasswordLength")
    def min_password_length(self) -> Optional[_builtins.int]:
        """
        Minimum password length.
        """
        return pulumi.get(self, "min_password_length")

    @_builtins.property
    @pulumi.getter(name="passwordNotContainUsername")
    def password_not_contain_username(self) -> Optional[_builtins.bool]:
        """
        Whether the user name is not allowed in the password.
        """
        return pulumi.get(self, "password_not_contain_username")

    @_builtins.property
    @pulumi.getter(name="passwordReusePrevention")
    def password_reuse_prevention(self) -> Optional[_builtins.int]:
        """
        Historical password check policy.
        """
        return pulumi.get(self, "password_reuse_prevention")

    @_builtins.property
    @pulumi.getter(name="requireLowerCaseChars")
    def require_lower_case_chars(self) -> Optional[_builtins.bool]:
        """
        Whether lowercase letters are required in the password.
        """
        return pulumi.get(self, "require_lower_case_chars")

    @_builtins.property
    @pulumi.getter(name="requireNumbers")
    def require_numbers(self) -> Optional[_builtins.bool]:
        """
        Whether numbers are required in the password.
        """
        return pulumi.get(self, "require_numbers")

    @_builtins.property
    @pulumi.getter(name="requireSymbols")
    def require_symbols(self) -> Optional[_builtins.bool]:
        """
        Whether symbols are required in the password.
        """
        return pulumi.get(self, "require_symbols")

    @_builtins.property
    @pulumi.getter(name="requireUpperCaseChars")
    def require_upper_case_chars(self) -> Optional[_builtins.bool]:
        """
        Whether uppercase letters are required in the password.
        """
        return pulumi.get(self, "require_upper_case_chars")


@pulumi.output_type
class DirectorySamlIdentityProviderConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindingType":
            suggest = "binding_type"
        elif key == "certificateIds":
            suggest = "certificate_ids"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "encodedMetadataDocument":
            suggest = "encoded_metadata_document"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "loginUrl":
            suggest = "login_url"
        elif key == "ssoStatus":
            suggest = "sso_status"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "wantRequestSigned":
            suggest = "want_request_signed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectorySamlIdentityProviderConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectorySamlIdentityProviderConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectorySamlIdentityProviderConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binding_type: Optional[_builtins.str] = None,
                 certificate_ids: Optional[Sequence[_builtins.str]] = None,
                 create_time: Optional[_builtins.str] = None,
                 encoded_metadata_document: Optional[_builtins.str] = None,
                 entity_id: Optional[_builtins.str] = None,
                 login_url: Optional[_builtins.str] = None,
                 sso_status: Optional[_builtins.str] = None,
                 update_time: Optional[_builtins.str] = None,
                 want_request_signed: Optional[_builtins.bool] = None):
        """
        :param _builtins.str binding_type: The Binding method for initiating a SAML request.
        :param Sequence[_builtins.str] certificate_ids: Certificate ID list
        :param _builtins.str create_time: CreateTime
        :param _builtins.str encoded_metadata_document: EncodedMetadataDocument
        :param _builtins.str entity_id: EntityId
        :param _builtins.str login_url: LoginUrl
        :param _builtins.str sso_status: SSOStatus
        :param _builtins.str update_time: UpdateTime
        :param _builtins.bool want_request_signed: SP Request whether the signature is required
        """
        if binding_type is not None:
            pulumi.set(__self__, "binding_type", binding_type)
        if certificate_ids is not None:
            pulumi.set(__self__, "certificate_ids", certificate_ids)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if encoded_metadata_document is not None:
            pulumi.set(__self__, "encoded_metadata_document", encoded_metadata_document)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if login_url is not None:
            pulumi.set(__self__, "login_url", login_url)
        if sso_status is not None:
            pulumi.set(__self__, "sso_status", sso_status)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if want_request_signed is not None:
            pulumi.set(__self__, "want_request_signed", want_request_signed)

    @_builtins.property
    @pulumi.getter(name="bindingType")
    def binding_type(self) -> Optional[_builtins.str]:
        """
        The Binding method for initiating a SAML request.
        """
        return pulumi.get(self, "binding_type")

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Certificate ID list
        """
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[_builtins.str]:
        """
        CreateTime
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="encodedMetadataDocument")
    def encoded_metadata_document(self) -> Optional[_builtins.str]:
        """
        EncodedMetadataDocument
        """
        return pulumi.get(self, "encoded_metadata_document")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[_builtins.str]:
        """
        EntityId
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> Optional[_builtins.str]:
        """
        LoginUrl
        """
        return pulumi.get(self, "login_url")

    @_builtins.property
    @pulumi.getter(name="ssoStatus")
    def sso_status(self) -> Optional[_builtins.str]:
        """
        SSOStatus
        """
        return pulumi.get(self, "sso_status")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[_builtins.str]:
        """
        UpdateTime
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="wantRequestSigned")
    def want_request_signed(self) -> Optional[_builtins.bool]:
        """
        SP Request whether the signature is required
        """
        return pulumi.get(self, "want_request_signed")


@pulumi.output_type
class DirectorySamlServiceProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acsUrl":
            suggest = "acs_url"
        elif key == "authnSignAlgo":
            suggest = "authn_sign_algo"
        elif key == "certificateType":
            suggest = "certificate_type"
        elif key == "encodedMetadataDocument":
            suggest = "encoded_metadata_document"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "supportEncryptedAssertion":
            suggest = "support_encrypted_assertion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectorySamlServiceProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectorySamlServiceProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectorySamlServiceProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acs_url: Optional[_builtins.str] = None,
                 authn_sign_algo: Optional[_builtins.str] = None,
                 certificate_type: Optional[_builtins.str] = None,
                 encoded_metadata_document: Optional[_builtins.str] = None,
                 entity_id: Optional[_builtins.str] = None,
                 support_encrypted_assertion: Optional[_builtins.bool] = None):
        """
        :param _builtins.str acs_url: ACS URL of SP.
        :param _builtins.str authn_sign_algo: Signature algorithms supported by AuthNRequest
        :param _builtins.str certificate_type: Type of certificate used for signing in the SSO process
        :param _builtins.str encoded_metadata_document: SP metadata document (Base64 encoding).
        :param _builtins.str entity_id: SP identity.
        :param _builtins.bool support_encrypted_assertion: Whether IdP-side encryption of Assertion is supported.
        """
        if acs_url is not None:
            pulumi.set(__self__, "acs_url", acs_url)
        if authn_sign_algo is not None:
            pulumi.set(__self__, "authn_sign_algo", authn_sign_algo)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if encoded_metadata_document is not None:
            pulumi.set(__self__, "encoded_metadata_document", encoded_metadata_document)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if support_encrypted_assertion is not None:
            pulumi.set(__self__, "support_encrypted_assertion", support_encrypted_assertion)

    @_builtins.property
    @pulumi.getter(name="acsUrl")
    def acs_url(self) -> Optional[_builtins.str]:
        """
        ACS URL of SP.
        """
        return pulumi.get(self, "acs_url")

    @_builtins.property
    @pulumi.getter(name="authnSignAlgo")
    def authn_sign_algo(self) -> Optional[_builtins.str]:
        """
        Signature algorithms supported by AuthNRequest
        """
        return pulumi.get(self, "authn_sign_algo")

    @_builtins.property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[_builtins.str]:
        """
        Type of certificate used for signing in the SSO process
        """
        return pulumi.get(self, "certificate_type")

    @_builtins.property
    @pulumi.getter(name="encodedMetadataDocument")
    def encoded_metadata_document(self) -> Optional[_builtins.str]:
        """
        SP metadata document (Base64 encoding).
        """
        return pulumi.get(self, "encoded_metadata_document")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[_builtins.str]:
        """
        SP identity.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="supportEncryptedAssertion")
    def support_encrypted_assertion(self) -> Optional[_builtins.bool]:
        """
        Whether IdP-side encryption of Assertion is supported.
        """
        return pulumi.get(self, "support_encrypted_assertion")


@pulumi.output_type
class DirectoryUserProvisioningConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLandingPage":
            suggest = "default_landing_page"
        elif key == "sessionDuration":
            suggest = "session_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DirectoryUserProvisioningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DirectoryUserProvisioningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DirectoryUserProvisioningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_landing_page: Optional[_builtins.str] = None,
                 session_duration: Optional[_builtins.str] = None):
        """
        :param _builtins.str default_landing_page: The duration of the Session after the user logs in.
        :param _builtins.str session_duration: The duration of the Session after the user logs in.
        """
        if default_landing_page is not None:
            pulumi.set(__self__, "default_landing_page", default_landing_page)
        if session_duration is not None:
            pulumi.set(__self__, "session_duration", session_duration)

    @_builtins.property
    @pulumi.getter(name="defaultLandingPage")
    def default_landing_page(self) -> Optional[_builtins.str]:
        """
        The duration of the Session after the user logs in.
        """
        return pulumi.get(self, "default_landing_page")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> Optional[_builtins.str]:
        """
        The duration of the Session after the user logs in.
        """
        return pulumi.get(self, "session_duration")


@pulumi.output_type
class UserProvisioningUserProvisioningStatistic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedEventCount":
            suggest = "failed_event_count"
        elif key == "gmtLatestSync":
            suggest = "gmt_latest_sync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserProvisioningUserProvisioningStatistic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserProvisioningUserProvisioningStatistic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserProvisioningUserProvisioningStatistic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_event_count: Optional[_builtins.int] = None,
                 gmt_latest_sync: Optional[_builtins.str] = None):
        """
        :param _builtins.int failed_event_count: Number of failed events
        :param _builtins.str gmt_latest_sync: Last Provisioning time
        """
        if failed_event_count is not None:
            pulumi.set(__self__, "failed_event_count", failed_event_count)
        if gmt_latest_sync is not None:
            pulumi.set(__self__, "gmt_latest_sync", gmt_latest_sync)

    @_builtins.property
    @pulumi.getter(name="failedEventCount")
    def failed_event_count(self) -> Optional[_builtins.int]:
        """
        Number of failed events
        """
        return pulumi.get(self, "failed_event_count")

    @_builtins.property
    @pulumi.getter(name="gmtLatestSync")
    def gmt_latest_sync(self) -> Optional[_builtins.str]:
        """
        Last Provisioning time
        """
        return pulumi.get(self, "gmt_latest_sync")


@pulumi.output_type
class GetAccessAssignmentsAssignmentResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: _builtins.str,
                 access_configuration_name: _builtins.str,
                 directory_id: _builtins.str,
                 id: _builtins.str,
                 principal_id: _builtins.str,
                 principal_name: _builtins.str,
                 principal_type: _builtins.str,
                 target_id: _builtins.str,
                 target_name: _builtins.str,
                 target_path_name: _builtins.str,
                 target_type: _builtins.str):
        """
        :param _builtins.str access_configuration_id: Access configuration ID.
        :param _builtins.str access_configuration_name: The name of the access configuration.
        :param _builtins.str directory_id: Directory ID.
        :param _builtins.str id: The ID of the Access Assignment.
        :param _builtins.str principal_id: The ID of the access assignment.
        :param _builtins.str principal_name: Cloud SSO identity name.
        :param _builtins.str principal_type: Create the identity type of the access assignment, which can be a user or a user group.
        :param _builtins.str target_id: The ID of the target to create the resource range.
        :param _builtins.str target_name: Task target name.
        :param _builtins.str target_path_name: The path name of the task target in the resource directory.
        :param _builtins.str target_type: The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "target_path_name", target_path_name)
        pulumi.set(__self__, "target_type", target_type)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> _builtins.str:
        """
        Access configuration ID.
        """
        return pulumi.get(self, "access_configuration_id")

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> _builtins.str:
        """
        The name of the access configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        Directory ID.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Access Assignment.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The ID of the access assignment.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> _builtins.str:
        """
        Cloud SSO identity name.
        """
        return pulumi.get(self, "principal_name")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        Create the identity type of the access assignment, which can be a user or a user group.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The ID of the target to create the resource range.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> _builtins.str:
        """
        Task target name.
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="targetPathName")
    def target_path_name(self) -> _builtins.str:
        """
        The path name of the task target in the resource directory.
        """
        return pulumi.get(self, "target_path_name")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The type of the resource range target to be accessed. Only a single RD primary account or member account can be specified in the first phase.
        """
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetAccessConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: _builtins.str,
                 access_configuration_name: _builtins.str,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 directory_id: _builtins.str,
                 id: _builtins.str,
                 permission_policies: Sequence['outputs.GetAccessConfigurationsConfigurationPermissionPolicyResult'],
                 relay_state: _builtins.str,
                 session_duration: _builtins.int,
                 status_notifications: Sequence[_builtins.str]):
        """
        :param _builtins.str access_configuration_id: The AccessConfigurationId of the Access Configuration.
        :param _builtins.str access_configuration_name: The AccessConfigurationName of the Access Configuration.
        :param _builtins.str create_time: The Created Time of the Directory.
        :param _builtins.str description: The Description of the Directory.
        :param _builtins.str directory_id: The ID of the Directory.
        :param _builtins.str id: The ID of the Access Configuration.
        :param Sequence['GetAccessConfigurationsConfigurationPermissionPolicyArgs'] permission_policies: The Policy List.
        :param _builtins.str relay_state: The RelayState of the Access Configuration.
        :param _builtins.int session_duration: The SessionDuration of the Access Configuration.
        :param Sequence[_builtins.str] status_notifications: The StatusNotifications of the Access Configuration.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "permission_policies", permission_policies)
        pulumi.set(__self__, "relay_state", relay_state)
        pulumi.set(__self__, "session_duration", session_duration)
        pulumi.set(__self__, "status_notifications", status_notifications)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> _builtins.str:
        """
        The AccessConfigurationId of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> _builtins.str:
        """
        The AccessConfigurationName of the Access Configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Created Time of the Directory.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of the Directory.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Access Configuration.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="permissionPolicies")
    def permission_policies(self) -> Sequence['outputs.GetAccessConfigurationsConfigurationPermissionPolicyResult']:
        """
        The Policy List.
        """
        return pulumi.get(self, "permission_policies")

    @_builtins.property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> _builtins.str:
        """
        The RelayState of the Access Configuration.
        """
        return pulumi.get(self, "relay_state")

    @_builtins.property
    @pulumi.getter(name="sessionDuration")
    def session_duration(self) -> _builtins.int:
        """
        The SessionDuration of the Access Configuration.
        """
        return pulumi.get(self, "session_duration")

    @_builtins.property
    @pulumi.getter(name="statusNotifications")
    def status_notifications(self) -> Sequence[_builtins.str]:
        """
        The StatusNotifications of the Access Configuration.
        """
        return pulumi.get(self, "status_notifications")


@pulumi.output_type
class GetAccessConfigurationsConfigurationPermissionPolicyResult(dict):
    def __init__(__self__, *,
                 add_time: _builtins.str,
                 permission_policy_document: _builtins.str,
                 permission_policy_name: _builtins.str,
                 permission_policy_type: _builtins.str):
        """
        :param _builtins.str add_time: The Creation time of policy.
        :param _builtins.str permission_policy_document: The Content of Policy.
        :param _builtins.str permission_policy_name: The Policy Name of policy.
        :param _builtins.str permission_policy_type: The Policy Type of policy. Valid values: `System`, `Inline`.
        """
        pulumi.set(__self__, "add_time", add_time)
        pulumi.set(__self__, "permission_policy_document", permission_policy_document)
        pulumi.set(__self__, "permission_policy_name", permission_policy_name)
        pulumi.set(__self__, "permission_policy_type", permission_policy_type)

    @_builtins.property
    @pulumi.getter(name="addTime")
    def add_time(self) -> _builtins.str:
        """
        The Creation time of policy.
        """
        return pulumi.get(self, "add_time")

    @_builtins.property
    @pulumi.getter(name="permissionPolicyDocument")
    def permission_policy_document(self) -> _builtins.str:
        """
        The Content of Policy.
        """
        return pulumi.get(self, "permission_policy_document")

    @_builtins.property
    @pulumi.getter(name="permissionPolicyName")
    def permission_policy_name(self) -> _builtins.str:
        """
        The Policy Name of policy.
        """
        return pulumi.get(self, "permission_policy_name")

    @_builtins.property
    @pulumi.getter(name="permissionPolicyType")
    def permission_policy_type(self) -> _builtins.str:
        """
        The Policy Type of policy. Valid values: `System`, `Inline`.
        """
        return pulumi.get(self, "permission_policy_type")


@pulumi.output_type
class GetDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 directory_id: _builtins.str,
                 directory_name: _builtins.str,
                 id: _builtins.str,
                 mfa_authentication_status: _builtins.str,
                 region: _builtins.str,
                 saml_identity_provider_configurations: Sequence['outputs.GetDirectoriesDirectorySamlIdentityProviderConfigurationResult'],
                 scim_synchronization_status: _builtins.str,
                 tasks: Sequence['outputs.GetDirectoriesDirectoryTaskResult']):
        """
        :param _builtins.str create_time: The CreateTime of the CloudSSO directory.
        :param _builtins.str directory_id: The DirectoryId of the CloudSSO directory.
        :param _builtins.str directory_name: The name of the CloudSSO directory.
        :param _builtins.str id: The ID of the Directory.
        :param _builtins.str mfa_authentication_status: The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        :param _builtins.str region: The Region of the CloudSSO directory.
        :param Sequence['GetDirectoriesDirectorySamlIdentityProviderConfigurationArgs'] saml_identity_provider_configurations: The saml identity provider configuration.
        :param _builtins.str scim_synchronization_status: The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        :param Sequence['GetDirectoriesDirectoryTaskArgs'] tasks: Asynchronous Task Information Array.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "directory_name", directory_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mfa_authentication_status", mfa_authentication_status)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "saml_identity_provider_configurations", saml_identity_provider_configurations)
        pulumi.set(__self__, "scim_synchronization_status", scim_synchronization_status)
        pulumi.set(__self__, "tasks", tasks)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The CreateTime of the CloudSSO directory.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        The DirectoryId of the CloudSSO directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> _builtins.str:
        """
        The name of the CloudSSO directory.
        """
        return pulumi.get(self, "directory_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mfaAuthenticationStatus")
    def mfa_authentication_status(self) -> _builtins.str:
        """
        The mfa authentication status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "mfa_authentication_status")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The Region of the CloudSSO directory.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="samlIdentityProviderConfigurations")
    def saml_identity_provider_configurations(self) -> Sequence['outputs.GetDirectoriesDirectorySamlIdentityProviderConfigurationResult']:
        """
        The saml identity provider configuration.
        """
        return pulumi.get(self, "saml_identity_provider_configurations")

    @_builtins.property
    @pulumi.getter(name="scimSynchronizationStatus")
    def scim_synchronization_status(self) -> _builtins.str:
        """
        The scim synchronization status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "scim_synchronization_status")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.GetDirectoriesDirectoryTaskResult']:
        """
        Asynchronous Task Information Array.
        """
        return pulumi.get(self, "tasks")


@pulumi.output_type
class GetDirectoriesDirectorySamlIdentityProviderConfigurationResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 encoded_metadata_document: _builtins.str,
                 entity_id: _builtins.str,
                 login_url: _builtins.str,
                 sso_status: _builtins.str):
        """
        :param _builtins.str create_time: Saml identifies the creation time of the provider configuration.
        :param _builtins.str encoded_metadata_document: Base64 encoded IdP metadata document.
        :param _builtins.str entity_id: SAML IdPEntityID.
        :param _builtins.str login_url: SAML IdP http-post Binding address.
        :param _builtins.str sso_status: SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "encoded_metadata_document", encoded_metadata_document)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "login_url", login_url)
        pulumi.set(__self__, "sso_status", sso_status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Saml identifies the creation time of the provider configuration.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="encodedMetadataDocument")
    def encoded_metadata_document(self) -> _builtins.str:
        """
        Base64 encoded IdP metadata document.
        """
        return pulumi.get(self, "encoded_metadata_document")

    @_builtins.property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> _builtins.str:
        """
        SAML IdPEntityID.
        """
        return pulumi.get(self, "entity_id")

    @_builtins.property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> _builtins.str:
        """
        SAML IdP http-post Binding address.
        """
        return pulumi.get(self, "login_url")

    @_builtins.property
    @pulumi.getter(name="ssoStatus")
    def sso_status(self) -> _builtins.str:
        """
        SAML SSO login enabled status. Valid values: `Enabled` or `Disabled`. Default to `Disabled`.
        """
        return pulumi.get(self, "sso_status")


@pulumi.output_type
class GetDirectoriesDirectoryTaskResult(dict):
    def __init__(__self__, *,
                 access_configuration_id: _builtins.str,
                 access_configuration_name: _builtins.str,
                 end_time: _builtins.str,
                 failure_reason: _builtins.str,
                 principal_id: _builtins.str,
                 principal_name: _builtins.str,
                 principal_type: _builtins.str,
                 start_time: _builtins.str,
                 status: _builtins.str,
                 target_id: _builtins.str,
                 target_name: _builtins.str,
                 target_path: _builtins.str,
                 target_type: _builtins.str,
                 task_id: _builtins.str,
                 task_type: _builtins.str):
        """
        :param _builtins.str access_configuration_id: The ID of Access Configuration.
        :param _builtins.str access_configuration_name: The Name of Access Configuration.
        :param _builtins.str end_time: The End Time of Task.
        :param _builtins.str failure_reason: the Reason for the Failure of  the task.
        :param _builtins.str principal_id: The ID of Cloud SSO Identity.
        :param _builtins.str principal_name: The Name of Cloud SSO Identity.
        :param _builtins.str principal_type: The Type of Cloud SSO Identity.
        :param _builtins.str start_time: The Start Time of Task.
        :param _builtins.str status: The Task Status.
        :param _builtins.str target_id: The Id of deploy target.
        :param _builtins.str target_name: The Name of Deploy Target.
        :param _builtins.str target_path: The Path in RD of Deploy Target.
        :param _builtins.str target_type: The Type of Deploy Target.
        :param _builtins.str task_id: The ID of the Task.
        :param _builtins.str task_type: The Type of the Task.
        """
        pulumi.set(__self__, "access_configuration_id", access_configuration_id)
        pulumi.set(__self__, "access_configuration_name", access_configuration_name)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_name", principal_name)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_name", target_name)
        pulumi.set(__self__, "target_path", target_path)
        pulumi.set(__self__, "target_type", target_type)
        pulumi.set(__self__, "task_id", task_id)
        pulumi.set(__self__, "task_type", task_type)

    @_builtins.property
    @pulumi.getter(name="accessConfigurationId")
    def access_configuration_id(self) -> _builtins.str:
        """
        The ID of Access Configuration.
        """
        return pulumi.get(self, "access_configuration_id")

    @_builtins.property
    @pulumi.getter(name="accessConfigurationName")
    def access_configuration_name(self) -> _builtins.str:
        """
        The Name of Access Configuration.
        """
        return pulumi.get(self, "access_configuration_name")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        The End Time of Task.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> _builtins.str:
        """
        the Reason for the Failure of  the task.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The ID of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> _builtins.str:
        """
        The Name of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_name")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> _builtins.str:
        """
        The Type of Cloud SSO Identity.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        The Start Time of Task.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Task Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="targetId")
    def target_id(self) -> _builtins.str:
        """
        The Id of deploy target.
        """
        return pulumi.get(self, "target_id")

    @_builtins.property
    @pulumi.getter(name="targetName")
    def target_name(self) -> _builtins.str:
        """
        The Name of Deploy Target.
        """
        return pulumi.get(self, "target_name")

    @_builtins.property
    @pulumi.getter(name="targetPath")
    def target_path(self) -> _builtins.str:
        """
        The Path in RD of Deploy Target.
        """
        return pulumi.get(self, "target_path")

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> _builtins.str:
        """
        The Type of Deploy Target.
        """
        return pulumi.get(self, "target_type")

    @_builtins.property
    @pulumi.getter(name="taskId")
    def task_id(self) -> _builtins.str:
        """
        The ID of the Task.
        """
        return pulumi.get(self, "task_id")

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> _builtins.str:
        """
        The Type of the Task.
        """
        return pulumi.get(self, "task_type")


@pulumi.output_type
class GetGroupsGroupResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 directory_id: _builtins.str,
                 group_id: _builtins.str,
                 group_name: _builtins.str,
                 id: _builtins.str,
                 provision_type: _builtins.str):
        """
        :param _builtins.str create_time: The Created Time of the Directory.
        :param _builtins.str description: The Description of the Directory.
        :param _builtins.str directory_id: The ID of the Directory.
        :param _builtins.str group_id: The Group ID of the group.
        :param _builtins.str group_name: The Name of the group.
        :param _builtins.str id: The ID of the Group.
        :param _builtins.str provision_type: The Provision Type of the Group. Valid values: `Manual`, `Synchronized`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "provision_type", provision_type)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The Created Time of the Directory.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Description of the Directory.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        The Group ID of the group.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> _builtins.str:
        """
        The Name of the group.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="provisionType")
    def provision_type(self) -> _builtins.str:
        """
        The Provision Type of the Group. Valid values: `Manual`, `Synchronized`.
        """
        return pulumi.get(self, "provision_type")


@pulumi.output_type
class GetScimServerCredentialsCredentialResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 credential_id: _builtins.str,
                 credential_secret: _builtins.str,
                 credential_type: _builtins.str,
                 directory_id: _builtins.str,
                 expire_time: _builtins.str,
                 id: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str create_time: The CreateTime of the resource.
        :param _builtins.str credential_id: The CredentialId of the resource.
        :param _builtins.str credential_secret: The CredentialSecret of the resource.
        :param _builtins.str credential_type: The CredentialType of the resource.
        :param _builtins.str directory_id: The ID of the Directory.
        :param _builtins.str expire_time: The ExpireTime of the resource.
        :param _builtins.str id: The ID of the SCIM Server Credential.
        :param _builtins.str status: The Status of the resource. Valid values: `Disabled`, `Enabled`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "credential_id", credential_id)
        pulumi.set(__self__, "credential_secret", credential_secret)
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The CreateTime of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> _builtins.str:
        """
        The CredentialId of the resource.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="credentialSecret")
    def credential_secret(self) -> _builtins.str:
        """
        The CredentialSecret of the resource.
        """
        return pulumi.get(self, "credential_secret")

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> _builtins.str:
        """
        The CredentialType of the resource.
        """
        return pulumi.get(self, "credential_type")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The ExpireTime of the resource.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the SCIM Server Credential.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The Status of the resource. Valid values: `Disabled`, `Enabled`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 description: _builtins.str,
                 directory_id: _builtins.str,
                 display_name: _builtins.str,
                 email: _builtins.str,
                 first_name: _builtins.str,
                 id: _builtins.str,
                 last_name: _builtins.str,
                 mfa_devices: Sequence['outputs.GetUsersUserMfaDeviceResult'],
                 provision_type: _builtins.str,
                 status: _builtins.str,
                 user_id: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str create_time: The create time of the user.
        :param _builtins.str description: The description of user.
        :param _builtins.str directory_id: The ID of the Directory.
        :param _builtins.str display_name: The display name of user.
        :param _builtins.str email: The User's Contact Email Address.
        :param _builtins.str first_name: The first name of user.
        :param _builtins.str id: The ID of the User.
        :param _builtins.str last_name: The last name of user.
        :param Sequence['GetUsersUserMfaDeviceArgs'] mfa_devices: The List of MFA Device for User.
        :param _builtins.str provision_type: ProvisionType.
        :param _builtins.str status: User status. Valid values: `Enabled` and `Disabled`.
        :param _builtins.str user_id: The User ID of the group.
        :param _builtins.str user_name: The name of user.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "first_name", first_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_name", last_name)
        pulumi.set(__self__, "mfa_devices", mfa_devices)
        pulumi.set(__self__, "provision_type", provision_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The create time of the user.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of user.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> _builtins.str:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of user.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The User's Contact Email Address.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firstName")
    def first_name(self) -> _builtins.str:
        """
        The first name of user.
        """
        return pulumi.get(self, "first_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the User.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastName")
    def last_name(self) -> _builtins.str:
        """
        The last name of user.
        """
        return pulumi.get(self, "last_name")

    @_builtins.property
    @pulumi.getter(name="mfaDevices")
    def mfa_devices(self) -> Sequence['outputs.GetUsersUserMfaDeviceResult']:
        """
        The List of MFA Device for User.
        """
        return pulumi.get(self, "mfa_devices")

    @_builtins.property
    @pulumi.getter(name="provisionType")
    def provision_type(self) -> _builtins.str:
        """
        ProvisionType.
        """
        return pulumi.get(self, "provision_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        User status. Valid values: `Enabled` and `Disabled`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The User ID of the group.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The name of user.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetUsersUserMfaDeviceResult(dict):
    def __init__(__self__, *,
                 device_id: _builtins.str,
                 device_name: _builtins.str,
                 device_type: _builtins.str,
                 effective_time: _builtins.str):
        """
        :param _builtins.str device_id: The MFA Device ID.
        :param _builtins.str device_name: The MFA Device Name.
        :param _builtins.str device_type: The MFA Device Type.
        :param _builtins.str effective_time: The Effective Time of MFA Device.
        """
        pulumi.set(__self__, "device_id", device_id)
        pulumi.set(__self__, "device_name", device_name)
        pulumi.set(__self__, "device_type", device_type)
        pulumi.set(__self__, "effective_time", effective_time)

    @_builtins.property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> _builtins.str:
        """
        The MFA Device ID.
        """
        return pulumi.get(self, "device_id")

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> _builtins.str:
        """
        The MFA Device Name.
        """
        return pulumi.get(self, "device_name")

    @_builtins.property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> _builtins.str:
        """
        The MFA Device Type.
        """
        return pulumi.get(self, "device_type")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        """
        The Effective Time of MFA Device.
        """
        return pulumi.get(self, "effective_time")


