# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ScimServerCredentialArgs', 'ScimServerCredential']

@pulumi.input_type
class ScimServerCredentialArgs:
    def __init__(__self__, *,
                 directory_id: pulumi.Input[_builtins.str],
                 credential_secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ScimServerCredential resource.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] credential_secret_file: The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        :param pulumi.Input[_builtins.str] status: The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        pulumi.set(__self__, "directory_id", directory_id)
        if credential_secret_file is not None:
            pulumi.set(__self__, "credential_secret_file", credential_secret_file)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialSecretFile")
    def credential_secret_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        """
        return pulumi.get(self, "credential_secret_file")

    @credential_secret_file.setter
    def credential_secret_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_secret_file", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ScimServerCredentialState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_type: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ScimServerCredential resources.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.245.0) The time when the SCIM credential was created.
        :param pulumi.Input[_builtins.str] credential_id: The ID of the SCIM credential.
        :param pulumi.Input[_builtins.str] credential_secret_file: The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        :param pulumi.Input[_builtins.str] credential_type: (Available since v1.245.0) The type of the SCIM credential.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] expire_time: (Available since v1.245.0) The time when the SCIM credential expires.
        :param pulumi.Input[_builtins.str] status: The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if credential_secret_file is not None:
            pulumi.set(__self__, "credential_secret_file", credential_secret_file)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The time when the SCIM credential was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the SCIM credential.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="credentialSecretFile")
    def credential_secret_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        """
        return pulumi.get(self, "credential_secret_file")

    @credential_secret_file.setter
    def credential_secret_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_secret_file", value)

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The type of the SCIM credential.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_type", value)

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.245.0) The time when the SCIM credential expires.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:cloudsso/scimServerCredential:ScimServerCredential")
class ScimServerCredential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Cloud SSO SCIM Server Credential resource.

        For information about Cloud SSO SCIM Server Credential and how to use it, see [What is Cloud SSO SCIM Server Credential](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createscimservercredential).

        > **NOTE:** Available since v1.138.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_scim_server_credential = alicloud.cloudsso.ScimServerCredential("default",
            directory_id=default.directories[0].id,
            credential_secret_file="./credential_secret_file.txt")
        ```

        ## Import

        Cloud SSO SCIM Server Credential can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/scimServerCredential:ScimServerCredential example <directory_id>:<credential_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credential_secret_file: The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] status: The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScimServerCredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Cloud SSO SCIM Server Credential resource.

        For information about Cloud SSO SCIM Server Credential and how to use it, see [What is Cloud SSO SCIM Server Credential](https://www.alibabacloud.com/help/en/cloudsso/latest/api-cloudsso-2021-05-15-createscimservercredential).

        > **NOTE:** Available since v1.138.0.

        > **NOTE:** Cloud SSO Only Support `cn-shanghai` And `us-west-1` Region

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.cloudsso.get_directories()
        default_scim_server_credential = alicloud.cloudsso.ScimServerCredential("default",
            directory_id=default.directories[0].id,
            credential_secret_file="./credential_secret_file.txt")
        ```

        ## Import

        Cloud SSO SCIM Server Credential can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:cloudsso/scimServerCredential:ScimServerCredential example <directory_id>:<credential_id>
        ```

        :param str resource_name: The name of the resource.
        :param ScimServerCredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScimServerCredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_secret_file: Optional[pulumi.Input[_builtins.str]] = None,
                 directory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScimServerCredentialArgs.__new__(ScimServerCredentialArgs)

            __props__.__dict__["credential_secret_file"] = credential_secret_file
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["status"] = status
            __props__.__dict__["create_time"] = None
            __props__.__dict__["credential_id"] = None
            __props__.__dict__["credential_type"] = None
            __props__.__dict__["expire_time"] = None
        super(ScimServerCredential, __self__).__init__(
            'alicloud:cloudsso/scimServerCredential:ScimServerCredential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            credential_secret_file: Optional[pulumi.Input[_builtins.str]] = None,
            credential_type: Optional[pulumi.Input[_builtins.str]] = None,
            directory_id: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'ScimServerCredential':
        """
        Get an existing ScimServerCredential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: (Available since v1.245.0) The time when the SCIM credential was created.
        :param pulumi.Input[_builtins.str] credential_id: The ID of the SCIM credential.
        :param pulumi.Input[_builtins.str] credential_secret_file: The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        :param pulumi.Input[_builtins.str] credential_type: (Available since v1.245.0) The type of the SCIM credential.
        :param pulumi.Input[_builtins.str] directory_id: The ID of the Directory.
        :param pulumi.Input[_builtins.str] expire_time: (Available since v1.245.0) The time when the SCIM credential expires.
        :param pulumi.Input[_builtins.str] status: The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScimServerCredentialState.__new__(_ScimServerCredentialState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["credential_secret_file"] = credential_secret_file
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["directory_id"] = directory_id
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["status"] = status
        return ScimServerCredential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The time when the SCIM credential was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the SCIM credential.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="credentialSecretFile")
    def credential_secret_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of file that can save Credential ID and Credential Secret. Strongly suggest you to specified it when you creating credential, otherwise, you wouldn't get its secret ever.
        """
        return pulumi.get(self, "credential_secret_file")

    @_builtins.property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The type of the SCIM credential.
        """
        return pulumi.get(self, "credential_type")

    @_builtins.property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Directory.
        """
        return pulumi.get(self, "directory_id")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.245.0) The time when the SCIM credential expires.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the SCIM Server Credential. Valid values: `Enabled`, `Disabled`.
        """
        return pulumi.get(self, "status")

