# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NestServiceInstanceArgs', 'NestServiceInstance']

@pulumi.input_type
class NestServiceInstanceArgs:
    def __init__(__self__, *,
                 service_id: pulumi.Input[_builtins.str],
                 service_version: pulumi.Input[_builtins.str],
                 commodity: Optional[pulumi.Input['NestServiceInstanceCommodityArgs']] = None,
                 enable_instance_ops: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_prometheus: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_metadata: Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specification_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NestServiceInstance resource.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service.
        :param pulumi.Input[_builtins.str] service_version: The version of the service.
        :param pulumi.Input['NestServiceInstanceCommodityArgs'] commodity: The order information of cloud market. See `commodity` below.
        :param pulumi.Input[_builtins.bool] enable_instance_ops: Whether the service instance has the O&M function. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_user_prometheus: Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        :param pulumi.Input['NestServiceInstanceOperationMetadataArgs'] operation_metadata: The configuration of O&M. See `operation_metadata` below.
        :param pulumi.Input[_builtins.str] parameters: The parameters entered by the deployment service instance.
        :param pulumi.Input[_builtins.str] payment_type: The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] service_instance_name: The name of the Service Instance.
        :param pulumi.Input[_builtins.str] specification_name: The name of the specification.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] template_name: The name of the template.
        """
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "service_version", service_version)
        if commodity is not None:
            pulumi.set(__self__, "commodity", commodity)
        if enable_instance_ops is not None:
            pulumi.set(__self__, "enable_instance_ops", enable_instance_ops)
        if enable_user_prometheus is not None:
            pulumi.set(__self__, "enable_user_prometheus", enable_user_prometheus)
        if operation_metadata is not None:
            pulumi.set(__self__, "operation_metadata", operation_metadata)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if service_instance_name is not None:
            pulumi.set(__self__, "service_instance_name", service_instance_name)
        if specification_name is not None:
            pulumi.set(__self__, "specification_name", specification_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the service.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_version", value)

    @_builtins.property
    @pulumi.getter
    def commodity(self) -> Optional[pulumi.Input['NestServiceInstanceCommodityArgs']]:
        """
        The order information of cloud market. See `commodity` below.
        """
        return pulumi.get(self, "commodity")

    @commodity.setter
    def commodity(self, value: Optional[pulumi.Input['NestServiceInstanceCommodityArgs']]):
        pulumi.set(self, "commodity", value)

    @_builtins.property
    @pulumi.getter(name="enableInstanceOps")
    def enable_instance_ops(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the service instance has the O&M function. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_instance_ops")

    @enable_instance_ops.setter
    def enable_instance_ops(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_instance_ops", value)

    @_builtins.property
    @pulumi.getter(name="enableUserPrometheus")
    def enable_user_prometheus(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_user_prometheus")

    @enable_user_prometheus.setter
    def enable_user_prometheus(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_user_prometheus", value)

    @_builtins.property
    @pulumi.getter(name="operationMetadata")
    def operation_metadata(self) -> Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']]:
        """
        The configuration of O&M. See `operation_metadata` below.
        """
        return pulumi.get(self, "operation_metadata")

    @operation_metadata.setter
    def operation_metadata(self, value: Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']]):
        pulumi.set(self, "operation_metadata", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameters entered by the deployment service instance.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceInstanceName")
    def service_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Instance.
        """
        return pulumi.get(self, "service_instance_name")

    @service_instance_name.setter
    def service_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="specificationName")
    def specification_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the specification.
        """
        return pulumi.get(self, "specification_name")

    @specification_name.setter
    def specification_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)


@pulumi.input_type
class _NestServiceInstanceState:
    def __init__(__self__, *,
                 commodity: Optional[pulumi.Input['NestServiceInstanceCommodityArgs']] = None,
                 enable_instance_ops: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_prometheus: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_metadata: Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification_name: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NestServiceInstance resources.
        :param pulumi.Input['NestServiceInstanceCommodityArgs'] commodity: The order information of cloud market. See `commodity` below.
        :param pulumi.Input[_builtins.bool] enable_instance_ops: Whether the service instance has the O&M function. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_user_prometheus: Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        :param pulumi.Input['NestServiceInstanceOperationMetadataArgs'] operation_metadata: The configuration of O&M. See `operation_metadata` below.
        :param pulumi.Input[_builtins.str] parameters: The parameters entered by the deployment service instance.
        :param pulumi.Input[_builtins.str] payment_type: The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service.
        :param pulumi.Input[_builtins.str] service_instance_name: The name of the Service Instance.
        :param pulumi.Input[_builtins.str] service_version: The version of the service.
        :param pulumi.Input[_builtins.str] specification_name: The name of the specification.
        :param pulumi.Input[_builtins.str] status: The status of the Service Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] template_name: The name of the template.
        """
        if commodity is not None:
            pulumi.set(__self__, "commodity", commodity)
        if enable_instance_ops is not None:
            pulumi.set(__self__, "enable_instance_ops", enable_instance_ops)
        if enable_user_prometheus is not None:
            pulumi.set(__self__, "enable_user_prometheus", enable_user_prometheus)
        if operation_metadata is not None:
            pulumi.set(__self__, "operation_metadata", operation_metadata)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)
        if service_instance_name is not None:
            pulumi.set(__self__, "service_instance_name", service_instance_name)
        if service_version is not None:
            pulumi.set(__self__, "service_version", service_version)
        if specification_name is not None:
            pulumi.set(__self__, "specification_name", specification_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter
    def commodity(self) -> Optional[pulumi.Input['NestServiceInstanceCommodityArgs']]:
        """
        The order information of cloud market. See `commodity` below.
        """
        return pulumi.get(self, "commodity")

    @commodity.setter
    def commodity(self, value: Optional[pulumi.Input['NestServiceInstanceCommodityArgs']]):
        pulumi.set(self, "commodity", value)

    @_builtins.property
    @pulumi.getter(name="enableInstanceOps")
    def enable_instance_ops(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the service instance has the O&M function. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_instance_ops")

    @enable_instance_ops.setter
    def enable_instance_ops(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_instance_ops", value)

    @_builtins.property
    @pulumi.getter(name="enableUserPrometheus")
    def enable_user_prometheus(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_user_prometheus")

    @enable_user_prometheus.setter
    def enable_user_prometheus(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_user_prometheus", value)

    @_builtins.property
    @pulumi.getter(name="operationMetadata")
    def operation_metadata(self) -> Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']]:
        """
        The configuration of O&M. See `operation_metadata` below.
        """
        return pulumi.get(self, "operation_metadata")

    @operation_metadata.setter
    def operation_metadata(self, value: Optional[pulumi.Input['NestServiceInstanceOperationMetadataArgs']]):
        pulumi.set(self, "operation_metadata", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameters entered by the deployment service instance.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceInstanceName")
    def service_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Instance.
        """
        return pulumi.get(self, "service_instance_name")

    @service_instance_name.setter
    def service_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the service.
        """
        return pulumi.get(self, "service_version")

    @service_version.setter
    def service_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_version", value)

    @_builtins.property
    @pulumi.getter(name="specificationName")
    def specification_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the specification.
        """
        return pulumi.get(self, "specification_name")

    @specification_name.setter
    def specification_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification_name", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the Service Instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_name", value)


@pulumi.type_token("alicloud:compute/nestServiceInstance:NestServiceInstance")
class NestServiceInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commodity: Optional[pulumi.Input[Union['NestServiceInstanceCommodityArgs', 'NestServiceInstanceCommodityArgsDict']]] = None,
                 enable_instance_ops: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_prometheus: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_metadata: Optional[pulumi.Input[Union['NestServiceInstanceOperationMetadataArgs', 'NestServiceInstanceOperationMetadataArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Compute Nest Service Instance resource.

        For information about Compute Nest Service Instance and how to use it, see [What is Service Instance](https://www.alibabacloud.com/help/zh/compute-nest/developer-reference/api-computenest-2021-06-01-createserviceinstance).

        > **NOTE:** Available since v1.205.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_get_zones.zones[0].id,
            instance_type_family="ecs.sn1ne")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_zones.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id)
        default_nest_service_instance = alicloud.compute.NestServiceInstance("default",
            service_id="service-dd475e6e468348799f0f",
            service_version="1",
            service_instance_name=name,
            resource_group_id=default.groups[0].id,
            payment_type="Permanent",
            operation_metadata={
                "operation_start_time": "1681281179000",
                "operation_end_time": "1681367579000",
                "resources": default_instance.id.apply(lambda id: f\"\"\"    {{
              \\"Type\\": \\"ResourceIds\\",
              \\"RegionId\\": \\"cn-hangzhou\\",
              \\"ResourceIds\\": {{
              \\"ALIYUN::ECS::INSTANCE\\": [
                \\"{id}\\"
                ]
              }} 
            }}
        \"\"\"),
            },
            tags={
                "Created": "TF",
                "For": "ServiceInstance",
            })
        ```

        ## Import

        Compute Nest Service Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:compute/nestServiceInstance:NestServiceInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NestServiceInstanceCommodityArgs', 'NestServiceInstanceCommodityArgsDict']] commodity: The order information of cloud market. See `commodity` below.
        :param pulumi.Input[_builtins.bool] enable_instance_ops: Whether the service instance has the O&M function. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_user_prometheus: Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[Union['NestServiceInstanceOperationMetadataArgs', 'NestServiceInstanceOperationMetadataArgsDict']] operation_metadata: The configuration of O&M. See `operation_metadata` below.
        :param pulumi.Input[_builtins.str] parameters: The parameters entered by the deployment service instance.
        :param pulumi.Input[_builtins.str] payment_type: The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service.
        :param pulumi.Input[_builtins.str] service_instance_name: The name of the Service Instance.
        :param pulumi.Input[_builtins.str] service_version: The version of the service.
        :param pulumi.Input[_builtins.str] specification_name: The name of the specification.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] template_name: The name of the template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NestServiceInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Compute Nest Service Instance resource.

        For information about Compute Nest Service Instance and how to use it, see [What is Service Instance](https://www.alibabacloud.com/help/zh/compute-nest/developer-reference/api-computenest-2021-06-01-createserviceinstance).

        > **NOTE:** Available since v1.205.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tfexample"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_get_zones.zones[0].id,
            instance_type_family="ecs.sn1ne")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            owners="system")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_get_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_network.id)
        default_instance = alicloud.ecs.Instance("default",
            image_id=default_get_images.images[0].id,
            instance_type=default_get_instance_types.instance_types[0].id,
            security_groups=[__item.id for __item in [default_security_group]],
            internet_charge_type="PayByTraffic",
            internet_max_bandwidth_out=10,
            availability_zone=default_get_zones.zones[0].id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_switch.id)
        default_nest_service_instance = alicloud.compute.NestServiceInstance("default",
            service_id="service-dd475e6e468348799f0f",
            service_version="1",
            service_instance_name=name,
            resource_group_id=default.groups[0].id,
            payment_type="Permanent",
            operation_metadata={
                "operation_start_time": "1681281179000",
                "operation_end_time": "1681367579000",
                "resources": default_instance.id.apply(lambda id: f\"\"\"    {{
              \\"Type\\": \\"ResourceIds\\",
              \\"RegionId\\": \\"cn-hangzhou\\",
              \\"ResourceIds\\": {{
              \\"ALIYUN::ECS::INSTANCE\\": [
                \\"{id}\\"
                ]
              }} 
            }}
        \"\"\"),
            },
            tags={
                "Created": "TF",
                "For": "ServiceInstance",
            })
        ```

        ## Import

        Compute Nest Service Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:compute/nestServiceInstance:NestServiceInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NestServiceInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NestServiceInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commodity: Optional[pulumi.Input[Union['NestServiceInstanceCommodityArgs', 'NestServiceInstanceCommodityArgsDict']]] = None,
                 enable_instance_ops: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_user_prometheus: Optional[pulumi.Input[_builtins.bool]] = None,
                 operation_metadata: Optional[pulumi.Input[Union['NestServiceInstanceOperationMetadataArgs', 'NestServiceInstanceOperationMetadataArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NestServiceInstanceArgs.__new__(NestServiceInstanceArgs)

            __props__.__dict__["commodity"] = commodity
            __props__.__dict__["enable_instance_ops"] = enable_instance_ops
            __props__.__dict__["enable_user_prometheus"] = enable_user_prometheus
            __props__.__dict__["operation_metadata"] = operation_metadata
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["service_instance_name"] = service_instance_name
            if service_version is None and not opts.urn:
                raise TypeError("Missing required property 'service_version'")
            __props__.__dict__["service_version"] = service_version
            __props__.__dict__["specification_name"] = specification_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["status"] = None
        super(NestServiceInstance, __self__).__init__(
            'alicloud:compute/nestServiceInstance:NestServiceInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commodity: Optional[pulumi.Input[Union['NestServiceInstanceCommodityArgs', 'NestServiceInstanceCommodityArgsDict']]] = None,
            enable_instance_ops: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_user_prometheus: Optional[pulumi.Input[_builtins.bool]] = None,
            operation_metadata: Optional[pulumi.Input[Union['NestServiceInstanceOperationMetadataArgs', 'NestServiceInstanceOperationMetadataArgsDict']]] = None,
            parameters: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_version: Optional[pulumi.Input[_builtins.str]] = None,
            specification_name: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            template_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'NestServiceInstance':
        """
        Get an existing NestServiceInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NestServiceInstanceCommodityArgs', 'NestServiceInstanceCommodityArgsDict']] commodity: The order information of cloud market. See `commodity` below.
        :param pulumi.Input[_builtins.bool] enable_instance_ops: Whether the service instance has the O&M function. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.bool] enable_user_prometheus: Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        :param pulumi.Input[Union['NestServiceInstanceOperationMetadataArgs', 'NestServiceInstanceOperationMetadataArgsDict']] operation_metadata: The configuration of O&M. See `operation_metadata` below.
        :param pulumi.Input[_builtins.str] parameters: The parameters entered by the deployment service instance.
        :param pulumi.Input[_builtins.str] payment_type: The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.str] service_id: The ID of the service.
        :param pulumi.Input[_builtins.str] service_instance_name: The name of the Service Instance.
        :param pulumi.Input[_builtins.str] service_version: The version of the service.
        :param pulumi.Input[_builtins.str] specification_name: The name of the specification.
        :param pulumi.Input[_builtins.str] status: The status of the Service Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] template_name: The name of the template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NestServiceInstanceState.__new__(_NestServiceInstanceState)

        __props__.__dict__["commodity"] = commodity
        __props__.__dict__["enable_instance_ops"] = enable_instance_ops
        __props__.__dict__["enable_user_prometheus"] = enable_user_prometheus
        __props__.__dict__["operation_metadata"] = operation_metadata
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["service_id"] = service_id
        __props__.__dict__["service_instance_name"] = service_instance_name
        __props__.__dict__["service_version"] = service_version
        __props__.__dict__["specification_name"] = specification_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_name"] = template_name
        return NestServiceInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def commodity(self) -> pulumi.Output[Optional['outputs.NestServiceInstanceCommodity']]:
        """
        The order information of cloud market. See `commodity` below.
        """
        return pulumi.get(self, "commodity")

    @_builtins.property
    @pulumi.getter(name="enableInstanceOps")
    def enable_instance_ops(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the service instance has the O&M function. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_instance_ops")

    @_builtins.property
    @pulumi.getter(name="enableUserPrometheus")
    def enable_user_prometheus(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether Prometheus monitoring is enabled. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_user_prometheus")

    @_builtins.property
    @pulumi.getter(name="operationMetadata")
    def operation_metadata(self) -> pulumi.Output['outputs.NestServiceInstanceOperationMetadata']:
        """
        The configuration of O&M. See `operation_metadata` below.
        """
        return pulumi.get(self, "operation_metadata")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The parameters entered by the deployment service instance.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of payment. Valid values: `Permanent`, `Subscription`, `PayAsYouGo`, `CustomFixTime`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the service.
        """
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceInstanceName")
    def service_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Instance.
        """
        return pulumi.get(self, "service_instance_name")

    @_builtins.property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the service.
        """
        return pulumi.get(self, "service_version")

    @_builtins.property
    @pulumi.getter(name="specificationName")
    def specification_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the specification.
        """
        return pulumi.get(self, "specification_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the Service Instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the template.
        """
        return pulumi.get(self, "template_name")

