# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRegistryEnterpriseSyncRulesResult',
    'AwaitableGetRegistryEnterpriseSyncRulesResult',
    'get_registry_enterprise_sync_rules',
    'get_registry_enterprise_sync_rules_output',
]

@pulumi.output_type
class GetRegistryEnterpriseSyncRulesResult:
    """
    A collection of values returned by getRegistryEnterpriseSyncRules.
    """
    def __init__(__self__, id=None, ids=None, instance_id=None, name_regex=None, names=None, namespace_name=None, output_file=None, repo_name=None, rules=None, target_instance_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if namespace_name and not isinstance(namespace_name, str):
            raise TypeError("Expected argument 'namespace_name' to be a str")
        pulumi.set(__self__, "namespace_name", namespace_name)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if repo_name and not isinstance(repo_name, str):
            raise TypeError("Expected argument 'repo_name' to be a str")
        pulumi.set(__self__, "repo_name", repo_name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if target_instance_id and not isinstance(target_instance_id, str):
            raise TypeError("Expected argument 'target_instance_id' to be a str")
        pulumi.set(__self__, "target_instance_id", target_instance_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of matched Container Registry Enterprise Edition sync rules. Its element is a sync rule uuid.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        ID of Container Registry Enterprise Edition local instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        A list of sync rule names.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="namespaceName")
    def namespace_name(self) -> Optional[_builtins.str]:
        """
        Name of Container Registry Enterprise Edition local namespace.
        """
        return pulumi.get(self, "namespace_name")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[_builtins.str]:
        """
        Name of Container Registry Enterprise Edition local repo.
        """
        return pulumi.get(self, "repo_name")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetRegistryEnterpriseSyncRulesRuleResult']:
        """
        A list of matched Container Registry Enterprise Edition sync rules. Each element contains the following attributes:
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter(name="targetInstanceId")
    def target_instance_id(self) -> Optional[_builtins.str]:
        """
        ID of Container Registry Enterprise Edition target instance.
        """
        return pulumi.get(self, "target_instance_id")


class AwaitableGetRegistryEnterpriseSyncRulesResult(GetRegistryEnterpriseSyncRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryEnterpriseSyncRulesResult(
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            name_regex=self.name_regex,
            names=self.names,
            namespace_name=self.namespace_name,
            output_file=self.output_file,
            repo_name=self.repo_name,
            rules=self.rules,
            target_instance_id=self.target_instance_id)


def get_registry_enterprise_sync_rules(ids: Optional[Sequence[_builtins.str]] = None,
                                       instance_id: Optional[_builtins.str] = None,
                                       name_regex: Optional[_builtins.str] = None,
                                       namespace_name: Optional[_builtins.str] = None,
                                       output_file: Optional[_builtins.str] = None,
                                       repo_name: Optional[_builtins.str] = None,
                                       target_instance_id: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryEnterpriseSyncRulesResult:
    """
    This data source provides a list Container Registry Enterprise Edition sync rules on Alibaba Cloud.

    > **NOTE:** Available in v1.90.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    my_sync_rules = alicloud.cs.get_registry_enterprise_sync_rules(instance_id="cri-xxx",
        namespace_name="test-namespace",
        repo_name="test-repo",
        target_instance_id="cri-yyy",
        name_regex="test-rule")
    pulumi.export("output", [__item.id for __item in my_sync_rules.rules])
    ```


    :param Sequence[_builtins.str] ids: A list of ids to filter results by sync rule id.
    :param _builtins.str instance_id: ID of Container Registry Enterprise Edition local instance.
    :param _builtins.str name_regex: A regex string to filter results by sync rule name.
    :param _builtins.str namespace_name: Name of Container Registry Enterprise Edition local namespace.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str repo_name: Name of Container Registry Enterprise Edition local repo.
    :param _builtins.str target_instance_id: ID of Container Registry Enterprise Edition target instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['namespaceName'] = namespace_name
    __args__['outputFile'] = output_file
    __args__['repoName'] = repo_name
    __args__['targetInstanceId'] = target_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:cs/getRegistryEnterpriseSyncRules:getRegistryEnterpriseSyncRules', __args__, opts=opts, typ=GetRegistryEnterpriseSyncRulesResult).value

    return AwaitableGetRegistryEnterpriseSyncRulesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        namespace_name=pulumi.get(__ret__, 'namespace_name'),
        output_file=pulumi.get(__ret__, 'output_file'),
        repo_name=pulumi.get(__ret__, 'repo_name'),
        rules=pulumi.get(__ret__, 'rules'),
        target_instance_id=pulumi.get(__ret__, 'target_instance_id'))
def get_registry_enterprise_sync_rules_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                              instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              namespace_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              repo_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              target_instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryEnterpriseSyncRulesResult]:
    """
    This data source provides a list Container Registry Enterprise Edition sync rules on Alibaba Cloud.

    > **NOTE:** Available in v1.90.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    # Declare the data source
    my_sync_rules = alicloud.cs.get_registry_enterprise_sync_rules(instance_id="cri-xxx",
        namespace_name="test-namespace",
        repo_name="test-repo",
        target_instance_id="cri-yyy",
        name_regex="test-rule")
    pulumi.export("output", [__item.id for __item in my_sync_rules.rules])
    ```


    :param Sequence[_builtins.str] ids: A list of ids to filter results by sync rule id.
    :param _builtins.str instance_id: ID of Container Registry Enterprise Edition local instance.
    :param _builtins.str name_regex: A regex string to filter results by sync rule name.
    :param _builtins.str namespace_name: Name of Container Registry Enterprise Edition local namespace.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str repo_name: Name of Container Registry Enterprise Edition local repo.
    :param _builtins.str target_instance_id: ID of Container Registry Enterprise Edition target instance.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['nameRegex'] = name_regex
    __args__['namespaceName'] = namespace_name
    __args__['outputFile'] = output_file
    __args__['repoName'] = repo_name
    __args__['targetInstanceId'] = target_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:cs/getRegistryEnterpriseSyncRules:getRegistryEnterpriseSyncRules', __args__, opts=opts, typ=GetRegistryEnterpriseSyncRulesResult)
    return __ret__.apply(lambda __response__: GetRegistryEnterpriseSyncRulesResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        namespace_name=pulumi.get(__response__, 'namespace_name'),
        output_file=pulumi.get(__response__, 'output_file'),
        repo_name=pulumi.get(__response__, 'repo_name'),
        rules=pulumi.get(__response__, 'rules'),
        target_instance_id=pulumi.get(__response__, 'target_instance_id')))
