# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedKubernetesArgs', 'ManagedKubernetes']

@pulumi.input_type
class ManagedKubernetesArgs:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_log_config: Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']] = None,
                 auto_mode: Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_stack: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 operation_policy: Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedKubernetes resource.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input['ManagedKubernetesAuditLogConfigArgs'] audit_log_config: Audit log configuration. See `audit_log_config` below.
        :param pulumi.Input['ManagedKubernetesAutoModeArgs'] auto_mode: Auto mode cluster configuration. See `auto_mode` below.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Basic managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[_builtins.str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[_builtins.str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.str] encryption_provider_key: The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        :param pulumi.Input[_builtins.str] ip_stack: The IP address family that the cluster network uses. Valid values:
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        :param pulumi.Input['ManagedKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input['ManagedKubernetesOperationPolicyArgs'] operation_policy: The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] profile: The profile of cluster. Valid values:
               * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
               * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
               * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
               * `Acs`: ACS cluster.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
               * > **NOTE:** Please take of note before updating the `security_group_id`:
               * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
               * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        :param pulumi.Input[_builtins.str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[_builtins.str] timezone: Cluster timezone, works for control plane and Worker nodes.
               * > **NOTE:** Please take of note before updating the `timezone`:
               * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
               * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        :param pulumi.Input[_builtins.str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vSwitches of the control plane.
               > **NOTE:** Please take of note before updating the `vswitch_ids`:
               * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
               * The control plane restarts during the change process. Exercise caution when you perform this operation.
               * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
               * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if audit_log_config is not None:
            pulumi.set(__self__, "audit_log_config", audit_log_config)
        if auto_mode is not None:
            pulumi.set(__self__, "auto_mode", auto_mode)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if control_plane_log_components is not None:
            pulumi.set(__self__, "control_plane_log_components", control_plane_log_components)
        if control_plane_log_project is not None:
            pulumi.set(__self__, "control_plane_log_project", control_plane_log_project)
        if control_plane_log_ttl is not None:
            pulumi.set(__self__, "control_plane_log_ttl", control_plane_log_ttl)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if encryption_provider_key is not None:
            pulumi.set(__self__, "encryption_provider_key", encryption_provider_key)
        if ip_stack is not None:
            pulumi.set(__self__, "ip_stack", ip_stack)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if load_balancer_spec is not None:
            warnings.warn("""Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""", DeprecationWarning)
            pulumi.log.warn("""load_balancer_spec is deprecated: Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""")
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if operation_policy is not None:
            pulumi.set(__self__, "operation_policy", operation_policy)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if skip_set_certificate_authority is not None:
            pulumi.set(__self__, "skip_set_certificate_authority", skip_set_certificate_authority)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if worker_vswitch_ids is not None:
            warnings.warn("""Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""", DeprecationWarning)
            pulumi.log.warn("""worker_vswitch_ids is deprecated: Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""")
        if worker_vswitch_ids is not None:
            pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_audiences", value)

    @_builtins.property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']]:
        """
        Audit log configuration. See `audit_log_config` below.
        """
        return pulumi.get(self, "audit_log_config")

    @audit_log_config.setter
    def audit_log_config(self, value: Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']]):
        pulumi.set(self, "audit_log_config", value)

    @_builtins.property
    @pulumi.getter(name="autoMode")
    def auto_mode(self) -> Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']]:
        """
        Auto mode cluster configuration. See `auto_mode` below.
        """
        return pulumi.get(self, "auto_mode")

    @auto_mode.setter
    def auto_mode(self, value: Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']]):
        pulumi.set(self, "auto_mode", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_domain", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Basic managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @control_plane_log_components.setter
    def control_plane_log_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "control_plane_log_components", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @control_plane_log_project.setter
    def control_plane_log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_log_project", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @control_plane_log_ttl.setter
    def control_plane_log_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_log_ttl", value)

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_san", value)

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]]):
        pulumi.set(self, "delete_options", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @_builtins.property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        """
        return pulumi.get(self, "encryption_provider_key")

    @encryption_provider_key.setter
    def encryption_provider_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_provider_key", value)

    @_builtins.property
    @pulumi.getter(name="ipStack")
    def ip_stack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address family that the cluster network uses. Valid values:
        """
        return pulumi.get(self, "ip_stack")

    @ip_stack.setter
    def ip_stack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_stack", value)

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']]:
        """
        The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        """
        return pulumi.get(self, "operation_policy")

    @operation_policy.setter
    def operation_policy(self, value: Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']]):
        pulumi.set(self, "operation_policy", value)

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_cidr", value)

    @_builtins.property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile of cluster. Valid values:
        * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
        * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
        * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
        * `Acs`: ACS cluster.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        * > **NOTE:** Please take of note before updating the `security_group_id`:
        * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
        * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_issuer", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @skip_set_certificate_authority.setter
    def skip_set_certificate_authority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_set_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster timezone, works for control plane and Worker nodes.
        * > **NOTE:** Please take of note before updating the `timezone`:
        * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
        * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_ca", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vSwitches of the control plane.
        > **NOTE:** Please take of note before updating the `vswitch_ids`:
        * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
        * The control plane restarts during the change process. Exercise caution when you perform this operation.
        * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
        * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    @_utilities.deprecated("""Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""")
    def worker_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zone_ids", value)


@pulumi.input_type
class _ManagedKubernetesState:
    def __init__(__self__, *,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_log_config: Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']] = None,
                 auto_mode: Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']] = None,
                 certificate_authority: Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 connections: Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_stack: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 operation_policy: Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 rrsa_metadata: Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_internet: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_intranet: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ManagedKubernetes resources.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]] addons: The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input['ManagedKubernetesAuditLogConfigArgs'] audit_log_config: Audit log configuration. See `audit_log_config` below.
        :param pulumi.Input['ManagedKubernetesAutoModeArgs'] auto_mode: Auto mode cluster configuration. See `auto_mode` below.
        :param pulumi.Input['ManagedKubernetesCertificateAuthorityArgs'] certificate_authority: (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Basic managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input['ManagedKubernetesConnectionsArgs'] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[_builtins.str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[_builtins.str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.str] encryption_provider_key: The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        :param pulumi.Input[_builtins.str] ip_stack: The IP address family that the cluster network uses. Valid values:
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        :param pulumi.Input['ManagedKubernetesMaintenanceWindowArgs'] maintenance_window: The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input['ManagedKubernetesOperationPolicyArgs'] operation_policy: The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] profile: The profile of cluster. Valid values:
               * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
               * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
               * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
               * `Acs`: ACS cluster.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input['ManagedKubernetesRrsaMetadataArgs'] rrsa_metadata: (Optional, Available since v1.185.0) Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
               * > **NOTE:** Please take of note before updating the `security_group_id`:
               * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
               * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        :param pulumi.Input[_builtins.str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.str] slb_id: The ID of APIServer load balancer.
        :param pulumi.Input[_builtins.str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[_builtins.str] timezone: Cluster timezone, works for control plane and Worker nodes.
               * > **NOTE:** Please take of note before updating the `timezone`:
               * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
               * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        :param pulumi.Input[_builtins.str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vSwitches of the control plane.
               > **NOTE:** Please take of note before updating the `vswitch_ids`:
               * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
               * The control plane restarts during the change process. Exercise caution when you perform this operation.
               * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
               * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        :param pulumi.Input[_builtins.str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        if addons is not None:
            pulumi.set(__self__, "addons", addons)
        if api_audiences is not None:
            pulumi.set(__self__, "api_audiences", api_audiences)
        if audit_log_config is not None:
            pulumi.set(__self__, "audit_log_config", audit_log_config)
        if auto_mode is not None:
            pulumi.set(__self__, "auto_mode", auto_mode)
        if certificate_authority is not None:
            warnings.warn("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""", DeprecationWarning)
            pulumi.log.warn("""certificate_authority is deprecated: Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
        if certificate_authority is not None:
            pulumi.set(__self__, "certificate_authority", certificate_authority)
        if client_cert is not None:
            warnings.warn("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_cert is deprecated: Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            warnings.warn("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""client_key is deprecated: Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_cert is not None:
            warnings.warn("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""", DeprecationWarning)
            pulumi.log.warn("""cluster_ca_cert is deprecated: Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
        if cluster_ca_cert is not None:
            pulumi.set(__self__, "cluster_ca_cert", cluster_ca_cert)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if control_plane_log_components is not None:
            pulumi.set(__self__, "control_plane_log_components", control_plane_log_components)
        if control_plane_log_project is not None:
            pulumi.set(__self__, "control_plane_log_project", control_plane_log_project)
        if control_plane_log_ttl is not None:
            pulumi.set(__self__, "control_plane_log_ttl", control_plane_log_ttl)
        if custom_san is not None:
            pulumi.set(__self__, "custom_san", custom_san)
        if delete_options is not None:
            pulumi.set(__self__, "delete_options", delete_options)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if enable_rrsa is not None:
            pulumi.set(__self__, "enable_rrsa", enable_rrsa)
        if encryption_provider_key is not None:
            pulumi.set(__self__, "encryption_provider_key", encryption_provider_key)
        if ip_stack is not None:
            pulumi.set(__self__, "ip_stack", ip_stack)
        if is_enterprise_security_group is not None:
            pulumi.set(__self__, "is_enterprise_security_group", is_enterprise_security_group)
        if load_balancer_spec is not None:
            warnings.warn("""Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""", DeprecationWarning)
            pulumi.log.warn("""load_balancer_spec is deprecated: Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""")
        if load_balancer_spec is not None:
            pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if new_nat_gateway is not None:
            pulumi.set(__self__, "new_nat_gateway", new_nat_gateway)
        if node_cidr_mask is not None:
            pulumi.set(__self__, "node_cidr_mask", node_cidr_mask)
        if operation_policy is not None:
            pulumi.set(__self__, "operation_policy", operation_policy)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if pod_vswitch_ids is not None:
            pulumi.set(__self__, "pod_vswitch_ids", pod_vswitch_ids)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if proxy_mode is not None:
            pulumi.set(__self__, "proxy_mode", proxy_mode)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if retain_resources is not None:
            pulumi.set(__self__, "retain_resources", retain_resources)
        if rrsa_metadata is not None:
            pulumi.set(__self__, "rrsa_metadata", rrsa_metadata)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if service_account_issuer is not None:
            pulumi.set(__self__, "service_account_issuer", service_account_issuer)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)
        if skip_set_certificate_authority is not None:
            pulumi.set(__self__, "skip_set_certificate_authority", skip_set_certificate_authority)
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)
        if slb_internet is not None:
            pulumi.set(__self__, "slb_internet", slb_internet)
        if slb_internet_enabled is not None:
            pulumi.set(__self__, "slb_internet_enabled", slb_internet_enabled)
        if slb_intranet is not None:
            pulumi.set(__self__, "slb_intranet", slb_intranet)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if user_ca is not None:
            pulumi.set(__self__, "user_ca", user_ca)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if worker_ram_role_name is not None:
            pulumi.set(__self__, "worker_ram_role_name", worker_ram_role_name)
        if worker_vswitch_ids is not None:
            warnings.warn("""Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""", DeprecationWarning)
            pulumi.log.warn("""worker_vswitch_ids is deprecated: Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""")
        if worker_vswitch_ids is not None:
            pulumi.set(__self__, "worker_vswitch_ids", worker_vswitch_ids)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]:
        """
        The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @addons.setter
    def addons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesAddonArgs']]]]):
        pulumi.set(self, "addons", value)

    @_builtins.property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @api_audiences.setter
    def api_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "api_audiences", value)

    @_builtins.property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']]:
        """
        Audit log configuration. See `audit_log_config` below.
        """
        return pulumi.get(self, "audit_log_config")

    @audit_log_config.setter
    def audit_log_config(self, value: Optional[pulumi.Input['ManagedKubernetesAuditLogConfigArgs']]):
        pulumi.set(self, "audit_log_config", value)

    @_builtins.property
    @pulumi.getter(name="autoMode")
    def auto_mode(self) -> Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']]:
        """
        Auto mode cluster configuration. See `auto_mode` below.
        """
        return pulumi.get(self, "auto_mode")

    @auto_mode.setter
    def auto_mode(self, value: Optional[pulumi.Input['ManagedKubernetesAutoModeArgs']]):
        pulumi.set(self, "auto_mode", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    @_utilities.deprecated("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def certificate_authority(self) -> Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']]:
        """
        (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "certificate_authority")

    @certificate_authority.setter
    def certificate_authority(self, value: Optional[pulumi.Input['ManagedKubernetesCertificateAuthorityArgs']]):
        pulumi.set(self, "certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @client_cert.setter
    def client_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_cert", value)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_key", value)

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @cluster_ca_cert.setter
    def cluster_ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_domain", value)

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Basic managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_spec", value)

    @_builtins.property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']]:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input['ManagedKubernetesConnectionsArgs']]):
        pulumi.set(self, "connections", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @control_plane_log_components.setter
    def control_plane_log_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "control_plane_log_components", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @control_plane_log_project.setter
    def control_plane_log_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_log_project", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @control_plane_log_ttl.setter
    def control_plane_log_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_log_ttl", value)

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @custom_san.setter
    def custom_san(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_san", value)

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @delete_options.setter
    def delete_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedKubernetesDeleteOptionArgs']]]]):
        pulumi.set(self, "delete_options", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @enable_rrsa.setter
    def enable_rrsa(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rrsa", value)

    @_builtins.property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        """
        return pulumi.get(self, "encryption_provider_key")

    @encryption_provider_key.setter
    def encryption_provider_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_provider_key", value)

    @_builtins.property
    @pulumi.getter(name="ipStack")
    def ip_stack(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address family that the cluster network uses. Valid values:
        """
        return pulumi.get(self, "ip_stack")

    @ip_stack.setter
    def ip_stack(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_stack", value)

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @is_enterprise_security_group.setter
    def is_enterprise_security_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enterprise_security_group", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""")
    def load_balancer_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        """
        return pulumi.get(self, "load_balancer_spec")

    @load_balancer_spec.setter
    def load_balancer_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_spec", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]:
        """
        The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ManagedKubernetesMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        """
        return pulumi.get(self, "new_nat_gateway")

    @new_nat_gateway.setter
    def new_nat_gateway(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_nat_gateway", value)

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @node_cidr_mask.setter
    def node_cidr_mask(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']]:
        """
        The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        """
        return pulumi.get(self, "operation_policy")

    @operation_policy.setter
    def operation_policy(self, value: Optional[pulumi.Input['ManagedKubernetesOperationPolicyArgs']]):
        pulumi.set(self, "operation_policy", value)

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @pod_cidr.setter
    def pod_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_cidr", value)

    @_builtins.property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @pod_vswitch_ids.setter
    def pod_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_vswitch_ids", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The profile of cluster. Valid values:
        * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
        * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
        * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
        * `Acs`: ACS cluster.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @proxy_mode.setter
    def proxy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "retain_resources")

    @retain_resources.setter
    def retain_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "retain_resources", value)

    @_builtins.property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']]:
        """
        (Optional, Available since v1.185.0) Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @rrsa_metadata.setter
    def rrsa_metadata(self, value: Optional[pulumi.Input['ManagedKubernetesRrsaMetadataArgs']]):
        pulumi.set(self, "rrsa_metadata", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        * > **NOTE:** Please take of note before updating the `security_group_id`:
        * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
        * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @service_account_issuer.setter
    def service_account_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_issuer", value)

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @service_cidr.setter
    def service_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_cidr", value)

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @skip_set_certificate_authority.setter
    def skip_set_certificate_authority(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_set_certificate_authority", value)

    @_builtins.property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of APIServer load balancer.
        """
        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_id", value)

    @_builtins.property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @slb_internet.setter
    def slb_internet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_internet", value)

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @slb_internet_enabled.setter
    def slb_internet_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "slb_internet_enabled", value)

    @_builtins.property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @slb_intranet.setter
    def slb_intranet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slb_intranet", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster timezone, works for control plane and Worker nodes.
        * > **NOTE:** Please take of note before updating the `timezone`:
        * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
        * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone", value)

    @_builtins.property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @user_ca.setter
    def user_ca(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_ca", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vSwitches of the control plane.
        > **NOTE:** Please take of note before updating the `vswitch_ids`:
        * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
        * The control plane restarts during the change process. Exercise caution when you perform this operation.
        * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
        * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @worker_ram_role_name.setter
    def worker_ram_role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "worker_ram_role_name", value)

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    @_utilities.deprecated("""Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""")
    def worker_vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @worker_vswitch_ids.setter
    def worker_vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "worker_vswitch_ids", value)

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zone_ids", value)


@pulumi.type_token("alicloud:cs/managedKubernetes:ManagedKubernetes")
class ManagedKubernetes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesAddonArgs', 'ManagedKubernetesAddonArgsDict']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_log_config: Optional[pulumi.Input[Union['ManagedKubernetesAuditLogConfigArgs', 'ManagedKubernetesAuditLogConfigArgsDict']]] = None,
                 auto_mode: Optional[pulumi.Input[Union['ManagedKubernetesAutoModeArgs', 'ManagedKubernetesAutoModeArgsDict']]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesDeleteOptionArgs', 'ManagedKubernetesDeleteOptionArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_stack: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ManagedKubernetesMaintenanceWindowArgs', 'ManagedKubernetesMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 operation_policy: Optional[pulumi.Input[Union['ManagedKubernetesOperationPolicyArgs', 'ManagedKubernetesOperationPolicyArgsDict']]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.

        > **NOTE:** Available since v1.26.0.

        > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.

        > **NOTE:** From version 1.177.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Example Usage

        ACK cluster

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        # Existing vpc id used to create several vswitches and other resources.
        vpc_id = config.get("vpcId")
        if vpc_id is None:
            vpc_id = ""
        # The cidr block used to launch a new vpc when 'vpc_id' is not specified.
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "10.0.0.0/8"
        # List of existing vswitch id.
        vswitch_ids = config.get_object("vswitchIds")
        if vswitch_ids is None:
            vswitch_ids = []
        # List of cidr blocks used to create several new vswitches when 'vswitch_ids' is not specified.
        vswitch_cidrs = config.get_object("vswitchCidrs")
        if vswitch_cidrs is None:
            vswitch_cidrs = [
                "10.1.0.0/16",
                "10.2.0.0/16",
            ]
        # Proxy mode is option of kube-proxy.
        proxy_mode = config.get("proxyMode")
        if proxy_mode is None:
            proxy_mode = "ipvs"
        # The kubernetes service cidr block. It cannot be equals to vpc's or vswitch's or pod's and cannot be in them.
        service_cidr = config.get("serviceCidr")
        if service_cidr is None:
            service_cidr = "192.168.0.0/16"
        # List of existing vswitch ids for terway.
        terway_vswitch_ids = config.get_object("terwayVswitchIds")
        if terway_vswitch_ids is None:
            terway_vswitch_ids = []
        # List of cidr blocks used to create several new vswitches when 'terway_vswitch_cidrs' is not specified.
        terway_vswitch_cidrs = config.get_object("terwayVswitchCidrs")
        if terway_vswitch_cidrs is None:
            terway_vswitch_cidrs = [
                "10.4.0.0/16",
                "10.5.0.0/16",
            ]
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        # If there is not specifying vpc_id, the module will launch a new vpc
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}", cidr_block=vpc_cidr))
        # According to the vswitch cidr blocks to launch several vswitches
        vswitches = []
        for range in [{"value": i} for i in range(0, 0 if len(vswitch_ids) > 0 else len(vswitch_cidrs))]:
            vswitches.append(alicloud.vpc.Switch(f"vswitches-{range['value']}",
                vpc_id=std.join_output(separator="",
                    input=[__item.id for __item in vpc]).apply(lambda invoke: invoke.result) if vpc_id == "" else vpc_id,
                cidr_block=vswitch_cidrs[range["value"]],
                zone_id=enhanced.zones[range["value"]].zone_id))
        # According to the vswitch cidr blocks to launch several vswitches
        terway_vswitches = []
        for range in [{"value": i} for i in range(0, 0 if len(terway_vswitch_ids) > 0 else len(terway_vswitch_cidrs))]:
            terway_vswitches.append(alicloud.vpc.Switch(f"terway_vswitches-{range['value']}",
                vpc_id=std.join_output(separator="",
                    input=[__item.id for __item in vpc]).apply(lambda invoke: invoke.result) if vpc_id == "" else vpc_id,
                cidr_block=terway_vswitch_cidrs[range["value"]],
                zone_id=enhanced.zones[range["value"]].zone_id))
        k8s = alicloud.cs.ManagedKubernetes("k8s",
            name=name,
            cluster_spec="ack.pro.small",
            vswitch_ids=std.split(separator=",",
                text=std.join(separator=",",
                    input=vswitch_ids).result).result if len(vswitch_ids) > 0 else [] if len(vswitch_cidrs) < 1 else std.join_output(separator=",",
                input=[__item.id for __item in vswitches]).apply(lambda invoke: std.split_output(separator=",",
                text=invoke.result)).apply(lambda invoke: invoke.result),
            pod_vswitch_ids=std.split(separator=",",
                text=std.join(separator=",",
                    input=terway_vswitch_ids).result).result if len(terway_vswitch_ids) > 0 else [] if len(terway_vswitch_cidrs) < 1 else std.join_output(separator=",",
                input=[__item.id for __item in terway_vswitches]).apply(lambda invoke: std.split_output(separator=",",
                text=invoke.result)).apply(lambda invoke: invoke.result),
            new_nat_gateway=True,
            proxy_mode=proxy_mode,
            service_cidr=service_cidr,
            skip_set_certificate_authority=True,
            addons=[
                {
                    "name": "terway-eniip",
                },
                {
                    "name": "csi-plugin",
                },
                {
                    "name": "csi-provisioner",
                },
                {
                    "name": "logtail-ds",
                    "config": json.dumps({
                        "IngressDashboardEnabled": "true",
                    }),
                },
                {
                    "name": "nginx-ingress-controller",
                    "config": json.dumps({
                        "IngressSlbNetworkType": "internet",
                    }),
                },
                {
                    "name": "arms-prometheus",
                },
                {
                    "name": "ack-node-problem-detector",
                    "config": json.dumps({}),
                },
            ])
        ```

        ACK Cluster with Auto Mode

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "auto-mode"
        # Proxy mode is option of kube-proxy.
        proxy_mode = config.get("proxyMode")
        if proxy_mode is None:
            proxy_mode = "ipvs"
        # The kubernetes service cidr block.
        service_cidr = config.get("serviceCidr")
        if service_cidr is None:
            service_cidr = "192.168.0.0/16"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        auto_mode = alicloud.cs.ManagedKubernetes("auto-mode",
            name=name,
            cluster_spec="ack.pro.small",
            zone_ids=[enhanced.zones[0].zone_id],
            new_nat_gateway=True,
            is_enterprise_security_group=True,
            slb_internet_enabled=False,
            skip_set_certificate_authority=True,
            proxy_mode=proxy_mode,
            service_cidr=service_cidr,
            ip_stack="ipv4",
            auto_mode={
                "enabled": True,
            },
            maintenance_window={
                "duration": "3h",
                "weekly_period": "Monday",
                "enable": True,
                "maintenance_time": "2025-07-07T00:00:00.000+08:00",
            },
            operation_policy={
                "cluster_auto_upgrade": {
                    "channel": "stable",
                    "enabled": True,
                },
            },
            control_plane_log_components=[
                "apiserver",
                "kcm",
                "scheduler",
                "ccm",
                "controlplane-events",
                "alb",
                "ack-goatscaler",
                "coredns",
            ],
            control_plane_log_ttl="30",
            audit_log_config={
                "enabled": True,
            },
            addons=[
                {
                    "name": "managed-metrics-server",
                },
                {
                    "name": "managed-coredns",
                },
                {
                    "name": "managed-security-inspector",
                },
                {
                    "name": "ack-cost-exporter",
                },
                {
                    "name": "terway-controlplane",
                    "config": json.dumps({
                        "ENITrunking": "true",
                    }),
                },
                {
                    "name": "terway-eniip",
                    "config": json.dumps({
                        "NetworkPolicy": "false",
                        "ENITrunking": "true",
                        "IPVlan": "false",
                    }),
                },
                {
                    "name": "csi-plugin",
                },
                {
                    "name": "managed-csiprovisioner",
                },
                {
                    "name": "storage-operator",
                    "config": json.dumps({
                        "CnfsOssEnable": "false",
                        "CnfsNasEnable": "false",
                    }),
                },
                {
                    "name": "loongcollector",
                    "config": json.dumps({
                        "IngressDashboardEnabled": "true",
                    }),
                },
                {
                    "name": "ack-node-problem-detector",
                    "config": json.dumps({
                        "sls_project_name": "",
                    }),
                },
                {
                    "name": "nginx-ingress-controller",
                    "disabled": True,
                },
                {
                    "name": "alb-ingress-controller",
                    "config": json.dumps({
                        "albIngress": {
                            "CreateDefaultALBConfig": False,
                        },
                    }),
                },
                {
                    "name": "arms-prometheus",
                    "config": json.dumps({
                        "prometheusMode": "default",
                    }),
                },
                {
                    "name": "alicloud-monitor-controller",
                },
                {
                    "name": "managed-aliyun-acr-credential-helper",
                },
            ])
        ```

        ## Import

        Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesAddonArgs', 'ManagedKubernetesAddonArgsDict']]]] addons: The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[Union['ManagedKubernetesAuditLogConfigArgs', 'ManagedKubernetesAuditLogConfigArgsDict']] audit_log_config: Audit log configuration. See `audit_log_config` below.
        :param pulumi.Input[Union['ManagedKubernetesAutoModeArgs', 'ManagedKubernetesAutoModeArgsDict']] auto_mode: Auto mode cluster configuration. See `auto_mode` below.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Basic managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[_builtins.str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[_builtins.str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesDeleteOptionArgs', 'ManagedKubernetesDeleteOptionArgsDict']]]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.str] encryption_provider_key: The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        :param pulumi.Input[_builtins.str] ip_stack: The IP address family that the cluster network uses. Valid values:
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        :param pulumi.Input[Union['ManagedKubernetesMaintenanceWindowArgs', 'ManagedKubernetesMaintenanceWindowArgsDict']] maintenance_window: The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[Union['ManagedKubernetesOperationPolicyArgs', 'ManagedKubernetesOperationPolicyArgsDict']] operation_policy: The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] profile: The profile of cluster. Valid values:
               * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
               * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
               * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
               * `Acs`: ACS cluster.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
               * > **NOTE:** Please take of note before updating the `security_group_id`:
               * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
               * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        :param pulumi.Input[_builtins.str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[_builtins.str] timezone: Cluster timezone, works for control plane and Worker nodes.
               * > **NOTE:** Please take of note before updating the `timezone`:
               * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
               * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        :param pulumi.Input[_builtins.str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vSwitches of the control plane.
               > **NOTE:** Please take of note before updating the `vswitch_ids`:
               * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
               * The control plane restarts during the change process. Exercise caution when you perform this operation.
               * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
               * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ManagedKubernetesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will help you to manage a ManagedKubernetes Cluster in Alibaba Cloud Kubernetes Service.

        > **NOTE:** Available since v1.26.0.

        > **NOTE:** It is recommended to create a cluster with zero worker nodes, and then use a node pool to manage the cluster nodes.

        > **NOTE:** Kubernetes cluster only supports VPC network and it can access internet while creating kubernetes cluster.
        A Nat Gateway and configuring a SNAT for it can ensure one VPC network access internet. If there is no nat gateway in the
        VPC, you can set `new_nat_gateway` to "true" to create one automatically.

        > **NOTE:** Creating kubernetes cluster need to install several packages and it will cost about 15 minutes. Please be patient.

        > **NOTE:** From version 1.9.4, the provider supports to download kube config, client certificate, client key and cluster ca certificate
        after creating cluster successfully, and you can put them into the specified location, like '~/.kube/config'.

        > **NOTE:** From version 1.20.0, the provider supports disabling internet load balancer for API Server by setting `false` to `slb_internet_enabled`.

        > **NOTE:** If you want to manage Kubernetes, you can use Kubernetes Provider.

        > **NOTE:** You need to activate several other products and confirm Authorization Policy used by Container Service before using this resource.
        Please refer to the `Authorization management` and `Cluster management` sections in the [Document Center](https://www.alibabacloud.com/help/doc-detail/86488.htm).

        > **NOTE:** From version 1.72.0, Some parameters have been removed from resource,You can check them below and re-import the cluster if necessary.

        > **NOTE:** From version 1.120.0, Support for cluster migration from Standard cluster to professional.

        > **NOTE:** From version 1.177.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor` are deprecated.
        We Suggest you using resource **`cs.NodePool`** to manage your cluster worker nodes.

        > **NOTE:** From version 1.212.0, `runtime`,`enable_ssh`,`rds_instances`,`exclude_autoscaler_nodes`,`worker_number`,`worker_instance_types`,`password`,`key_name`,`kms_encrypted_password`,`kms_encryption_context`,`worker_instance_charge_type`,`worker_period`,`worker_period_unit`,`worker_auto_renew`,`worker_auto_renew_period`,`worker_disk_category`,`worker_disk_size`,`worker_data_disks`,`node_name_mode`,`node_port_range`,`os_type`,`platform`,`image_id`,`cpu_policy`,`user_data`,`taints`,`worker_disk_performance_level`,`worker_disk_snapshot_policy_id`,`install_cloud_monitor`,`kube_config`,`availability_zone` are removed.
        Please use resource **`cs.NodePool`** to manage your cluster worker nodes.

        ## Example Usage

        ACK cluster

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        # Existing vpc id used to create several vswitches and other resources.
        vpc_id = config.get("vpcId")
        if vpc_id is None:
            vpc_id = ""
        # The cidr block used to launch a new vpc when 'vpc_id' is not specified.
        vpc_cidr = config.get("vpcCidr")
        if vpc_cidr is None:
            vpc_cidr = "10.0.0.0/8"
        # List of existing vswitch id.
        vswitch_ids = config.get_object("vswitchIds")
        if vswitch_ids is None:
            vswitch_ids = []
        # List of cidr blocks used to create several new vswitches when 'vswitch_ids' is not specified.
        vswitch_cidrs = config.get_object("vswitchCidrs")
        if vswitch_cidrs is None:
            vswitch_cidrs = [
                "10.1.0.0/16",
                "10.2.0.0/16",
            ]
        # Proxy mode is option of kube-proxy.
        proxy_mode = config.get("proxyMode")
        if proxy_mode is None:
            proxy_mode = "ipvs"
        # The kubernetes service cidr block. It cannot be equals to vpc's or vswitch's or pod's and cannot be in them.
        service_cidr = config.get("serviceCidr")
        if service_cidr is None:
            service_cidr = "192.168.0.0/16"
        # List of existing vswitch ids for terway.
        terway_vswitch_ids = config.get_object("terwayVswitchIds")
        if terway_vswitch_ids is None:
            terway_vswitch_ids = []
        # List of cidr blocks used to create several new vswitches when 'terway_vswitch_cidrs' is not specified.
        terway_vswitch_cidrs = config.get_object("terwayVswitchCidrs")
        if terway_vswitch_cidrs is None:
            terway_vswitch_cidrs = [
                "10.4.0.0/16",
                "10.5.0.0/16",
            ]
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        # If there is not specifying vpc_id, the module will launch a new vpc
        vpc = []
        for range in [{"value": i} for i in range(0, 1 if vpc_id ==  else 0)]:
            vpc.append(alicloud.vpc.Network(f"vpc-{range['value']}", cidr_block=vpc_cidr))
        # According to the vswitch cidr blocks to launch several vswitches
        vswitches = []
        for range in [{"value": i} for i in range(0, 0 if len(vswitch_ids) > 0 else len(vswitch_cidrs))]:
            vswitches.append(alicloud.vpc.Switch(f"vswitches-{range['value']}",
                vpc_id=std.join_output(separator="",
                    input=[__item.id for __item in vpc]).apply(lambda invoke: invoke.result) if vpc_id == "" else vpc_id,
                cidr_block=vswitch_cidrs[range["value"]],
                zone_id=enhanced.zones[range["value"]].zone_id))
        # According to the vswitch cidr blocks to launch several vswitches
        terway_vswitches = []
        for range in [{"value": i} for i in range(0, 0 if len(terway_vswitch_ids) > 0 else len(terway_vswitch_cidrs))]:
            terway_vswitches.append(alicloud.vpc.Switch(f"terway_vswitches-{range['value']}",
                vpc_id=std.join_output(separator="",
                    input=[__item.id for __item in vpc]).apply(lambda invoke: invoke.result) if vpc_id == "" else vpc_id,
                cidr_block=terway_vswitch_cidrs[range["value"]],
                zone_id=enhanced.zones[range["value"]].zone_id))
        k8s = alicloud.cs.ManagedKubernetes("k8s",
            name=name,
            cluster_spec="ack.pro.small",
            vswitch_ids=std.split(separator=",",
                text=std.join(separator=",",
                    input=vswitch_ids).result).result if len(vswitch_ids) > 0 else [] if len(vswitch_cidrs) < 1 else std.join_output(separator=",",
                input=[__item.id for __item in vswitches]).apply(lambda invoke: std.split_output(separator=",",
                text=invoke.result)).apply(lambda invoke: invoke.result),
            pod_vswitch_ids=std.split(separator=",",
                text=std.join(separator=",",
                    input=terway_vswitch_ids).result).result if len(terway_vswitch_ids) > 0 else [] if len(terway_vswitch_cidrs) < 1 else std.join_output(separator=",",
                input=[__item.id for __item in terway_vswitches]).apply(lambda invoke: std.split_output(separator=",",
                text=invoke.result)).apply(lambda invoke: invoke.result),
            new_nat_gateway=True,
            proxy_mode=proxy_mode,
            service_cidr=service_cidr,
            skip_set_certificate_authority=True,
            addons=[
                {
                    "name": "terway-eniip",
                },
                {
                    "name": "csi-plugin",
                },
                {
                    "name": "csi-provisioner",
                },
                {
                    "name": "logtail-ds",
                    "config": json.dumps({
                        "IngressDashboardEnabled": "true",
                    }),
                },
                {
                    "name": "nginx-ingress-controller",
                    "config": json.dumps({
                        "IngressSlbNetworkType": "internet",
                    }),
                },
                {
                    "name": "arms-prometheus",
                },
                {
                    "name": "ack-node-problem-detector",
                    "config": json.dumps({}),
                },
            ])
        ```

        ACK Cluster with Auto Mode

        ```python
        import pulumi
        import json
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "auto-mode"
        # Proxy mode is option of kube-proxy.
        proxy_mode = config.get("proxyMode")
        if proxy_mode is None:
            proxy_mode = "ipvs"
        # The kubernetes service cidr block.
        service_cidr = config.get("serviceCidr")
        if service_cidr is None:
            service_cidr = "192.168.0.0/16"
        enhanced = alicloud.vpc.get_enhanced_nat_available_zones()
        auto_mode = alicloud.cs.ManagedKubernetes("auto-mode",
            name=name,
            cluster_spec="ack.pro.small",
            zone_ids=[enhanced.zones[0].zone_id],
            new_nat_gateway=True,
            is_enterprise_security_group=True,
            slb_internet_enabled=False,
            skip_set_certificate_authority=True,
            proxy_mode=proxy_mode,
            service_cidr=service_cidr,
            ip_stack="ipv4",
            auto_mode={
                "enabled": True,
            },
            maintenance_window={
                "duration": "3h",
                "weekly_period": "Monday",
                "enable": True,
                "maintenance_time": "2025-07-07T00:00:00.000+08:00",
            },
            operation_policy={
                "cluster_auto_upgrade": {
                    "channel": "stable",
                    "enabled": True,
                },
            },
            control_plane_log_components=[
                "apiserver",
                "kcm",
                "scheduler",
                "ccm",
                "controlplane-events",
                "alb",
                "ack-goatscaler",
                "coredns",
            ],
            control_plane_log_ttl="30",
            audit_log_config={
                "enabled": True,
            },
            addons=[
                {
                    "name": "managed-metrics-server",
                },
                {
                    "name": "managed-coredns",
                },
                {
                    "name": "managed-security-inspector",
                },
                {
                    "name": "ack-cost-exporter",
                },
                {
                    "name": "terway-controlplane",
                    "config": json.dumps({
                        "ENITrunking": "true",
                    }),
                },
                {
                    "name": "terway-eniip",
                    "config": json.dumps({
                        "NetworkPolicy": "false",
                        "ENITrunking": "true",
                        "IPVlan": "false",
                    }),
                },
                {
                    "name": "csi-plugin",
                },
                {
                    "name": "managed-csiprovisioner",
                },
                {
                    "name": "storage-operator",
                    "config": json.dumps({
                        "CnfsOssEnable": "false",
                        "CnfsNasEnable": "false",
                    }),
                },
                {
                    "name": "loongcollector",
                    "config": json.dumps({
                        "IngressDashboardEnabled": "true",
                    }),
                },
                {
                    "name": "ack-node-problem-detector",
                    "config": json.dumps({
                        "sls_project_name": "",
                    }),
                },
                {
                    "name": "nginx-ingress-controller",
                    "disabled": True,
                },
                {
                    "name": "alb-ingress-controller",
                    "config": json.dumps({
                        "albIngress": {
                            "CreateDefaultALBConfig": False,
                        },
                    }),
                },
                {
                    "name": "arms-prometheus",
                    "config": json.dumps({
                        "prometheusMode": "default",
                    }),
                },
                {
                    "name": "alicloud-monitor-controller",
                },
                {
                    "name": "managed-aliyun-acr-credential-helper",
                },
            ])
        ```

        ## Import

        Kubernetes managed cluster can be imported using the id, e.g. Then complete the main.tf accords to the result of `pulumi preview`.

        ```sh
        $ pulumi import alicloud:cs/managedKubernetes:ManagedKubernetes main cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param ManagedKubernetesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedKubernetesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesAddonArgs', 'ManagedKubernetesAddonArgsDict']]]]] = None,
                 api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 audit_log_config: Optional[pulumi.Input[Union['ManagedKubernetesAuditLogConfigArgs', 'ManagedKubernetesAuditLogConfigArgsDict']]] = None,
                 auto_mode: Optional[pulumi.Input[Union['ManagedKubernetesAutoModeArgs', 'ManagedKubernetesAutoModeArgsDict']]] = None,
                 client_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 client_key: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 control_plane_log_project: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_log_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_san: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesDeleteOptionArgs', 'ManagedKubernetesDeleteOptionArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption_provider_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_stack: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ManagedKubernetesMaintenanceWindowArgs', 'ManagedKubernetesMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
                 operation_policy: Optional[pulumi.Input[Union['ManagedKubernetesOperationPolicyArgs', 'ManagedKubernetesOperationPolicyArgsDict']]] = None,
                 pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
                 slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 user_ca: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedKubernetesArgs.__new__(ManagedKubernetesArgs)

            __props__.__dict__["addons"] = addons
            __props__.__dict__["api_audiences"] = api_audiences
            __props__.__dict__["audit_log_config"] = audit_log_config
            __props__.__dict__["auto_mode"] = auto_mode
            __props__.__dict__["client_cert"] = client_cert
            __props__.__dict__["client_key"] = client_key
            __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
            __props__.__dict__["cluster_domain"] = cluster_domain
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["control_plane_log_components"] = control_plane_log_components
            __props__.__dict__["control_plane_log_project"] = control_plane_log_project
            __props__.__dict__["control_plane_log_ttl"] = control_plane_log_ttl
            __props__.__dict__["custom_san"] = custom_san
            __props__.__dict__["delete_options"] = delete_options
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["enable_rrsa"] = enable_rrsa
            __props__.__dict__["encryption_provider_key"] = encryption_provider_key
            __props__.__dict__["ip_stack"] = ip_stack
            __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
            __props__.__dict__["load_balancer_spec"] = load_balancer_spec
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["new_nat_gateway"] = new_nat_gateway
            __props__.__dict__["node_cidr_mask"] = node_cidr_mask
            __props__.__dict__["operation_policy"] = operation_policy
            __props__.__dict__["pod_cidr"] = pod_cidr
            __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
            __props__.__dict__["profile"] = profile
            __props__.__dict__["proxy_mode"] = proxy_mode
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["retain_resources"] = retain_resources
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["service_account_issuer"] = service_account_issuer
            __props__.__dict__["service_cidr"] = service_cidr
            __props__.__dict__["skip_set_certificate_authority"] = skip_set_certificate_authority
            __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["user_ca"] = user_ca
            __props__.__dict__["version"] = version
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
            __props__.__dict__["zone_ids"] = zone_ids
            __props__.__dict__["certificate_authority"] = None
            __props__.__dict__["connections"] = None
            __props__.__dict__["nat_gateway_id"] = None
            __props__.__dict__["rrsa_metadata"] = None
            __props__.__dict__["slb_id"] = None
            __props__.__dict__["slb_internet"] = None
            __props__.__dict__["slb_intranet"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["worker_ram_role_name"] = None
        super(ManagedKubernetes, __self__).__init__(
            'alicloud:cs/managedKubernetes:ManagedKubernetes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesAddonArgs', 'ManagedKubernetesAddonArgsDict']]]]] = None,
            api_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            audit_log_config: Optional[pulumi.Input[Union['ManagedKubernetesAuditLogConfigArgs', 'ManagedKubernetesAuditLogConfigArgsDict']]] = None,
            auto_mode: Optional[pulumi.Input[Union['ManagedKubernetesAutoModeArgs', 'ManagedKubernetesAutoModeArgsDict']]] = None,
            certificate_authority: Optional[pulumi.Input[Union['ManagedKubernetesCertificateAuthorityArgs', 'ManagedKubernetesCertificateAuthorityArgsDict']]] = None,
            client_cert: Optional[pulumi.Input[_builtins.str]] = None,
            client_key: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_domain: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_spec: Optional[pulumi.Input[_builtins.str]] = None,
            connections: Optional[pulumi.Input[Union['ManagedKubernetesConnectionsArgs', 'ManagedKubernetesConnectionsArgsDict']]] = None,
            control_plane_log_components: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            control_plane_log_project: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_log_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            custom_san: Optional[pulumi.Input[_builtins.str]] = None,
            delete_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesDeleteOptionArgs', 'ManagedKubernetesDeleteOptionArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_rrsa: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption_provider_key: Optional[pulumi.Input[_builtins.str]] = None,
            ip_stack: Optional[pulumi.Input[_builtins.str]] = None,
            is_enterprise_security_group: Optional[pulumi.Input[_builtins.bool]] = None,
            load_balancer_spec: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['ManagedKubernetesMaintenanceWindowArgs', 'ManagedKubernetesMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            new_nat_gateway: Optional[pulumi.Input[_builtins.bool]] = None,
            node_cidr_mask: Optional[pulumi.Input[_builtins.int]] = None,
            operation_policy: Optional[pulumi.Input[Union['ManagedKubernetesOperationPolicyArgs', 'ManagedKubernetesOperationPolicyArgsDict']]] = None,
            pod_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            pod_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            profile: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            retain_resources: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            rrsa_metadata: Optional[pulumi.Input[Union['ManagedKubernetesRrsaMetadataArgs', 'ManagedKubernetesRrsaMetadataArgsDict']]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            service_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            skip_set_certificate_authority: Optional[pulumi.Input[_builtins.bool]] = None,
            slb_id: Optional[pulumi.Input[_builtins.str]] = None,
            slb_internet: Optional[pulumi.Input[_builtins.str]] = None,
            slb_internet_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            slb_intranet: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timezone: Optional[pulumi.Input[_builtins.str]] = None,
            user_ca: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            worker_ram_role_name: Optional[pulumi.Input[_builtins.str]] = None,
            worker_vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ManagedKubernetes':
        """
        Get an existing ManagedKubernetes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesAddonArgs', 'ManagedKubernetesAddonArgsDict']]]] addons: The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] api_audiences: A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[Union['ManagedKubernetesAuditLogConfigArgs', 'ManagedKubernetesAuditLogConfigArgsDict']] audit_log_config: Audit log configuration. See `audit_log_config` below.
        :param pulumi.Input[Union['ManagedKubernetesAutoModeArgs', 'ManagedKubernetesAutoModeArgsDict']] auto_mode: Auto mode cluster configuration. See `auto_mode` below.
        :param pulumi.Input[Union['ManagedKubernetesCertificateAuthorityArgs', 'ManagedKubernetesCertificateAuthorityArgsDict']] certificate_authority: (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        :param pulumi.Input[_builtins.str] client_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        :param pulumi.Input[_builtins.str] client_key: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        :param pulumi.Input[_builtins.str] cluster_ca_cert: From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.
               
               *Removed params*
        :param pulumi.Input[_builtins.str] cluster_domain: Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        :param pulumi.Input[_builtins.str] cluster_spec: The cluster specifications of kubernetes cluster,which can be empty. Valid values:
               * ack.standard : Basic managed clusters.
               * ack.pro.small : Professional managed clusters.
        :param pulumi.Input[Union['ManagedKubernetesConnectionsArgs', 'ManagedKubernetesConnectionsArgsDict']] connections: Map of kubernetes cluster connection information.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] control_plane_log_components: List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        :param pulumi.Input[_builtins.str] control_plane_log_project: Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        :param pulumi.Input[_builtins.str] control_plane_log_ttl: Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        :param pulumi.Input[_builtins.str] custom_san: Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
               > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedKubernetesDeleteOptionArgs', 'ManagedKubernetesDeleteOptionArgsDict']]]] delete_options: Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether to enable cluster deletion protection.
        :param pulumi.Input[_builtins.bool] enable_rrsa: Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        :param pulumi.Input[_builtins.str] encryption_provider_key: The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        :param pulumi.Input[_builtins.str] ip_stack: The IP address family that the cluster network uses. Valid values:
        :param pulumi.Input[_builtins.bool] is_enterprise_security_group: Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        :param pulumi.Input[_builtins.str] load_balancer_spec: The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        :param pulumi.Input[Union['ManagedKubernetesMaintenanceWindowArgs', 'ManagedKubernetesMaintenanceWindowArgsDict']] maintenance_window: The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        :param pulumi.Input[_builtins.str] name: The kubernetes cluster's name. It is unique in one Alicloud account.
        :param pulumi.Input[_builtins.str] nat_gateway_id: The ID of nat gateway used to launch kubernetes cluster.
        :param pulumi.Input[_builtins.bool] new_nat_gateway: Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.int] node_cidr_mask: The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        :param pulumi.Input[Union['ManagedKubernetesOperationPolicyArgs', 'ManagedKubernetesOperationPolicyArgsDict']] operation_policy: The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        :param pulumi.Input[_builtins.str] pod_cidr: [Flannel Specific] The CIDR block for the pod network when using Flannel.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_vswitch_ids: [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] profile: The profile of cluster. Valid values:
               * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
               * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
               * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
               * `Acs`: ACS cluster.
        :param pulumi.Input[_builtins.str] proxy_mode: Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        :param pulumi.Input[Union['ManagedKubernetesRrsaMetadataArgs', 'ManagedKubernetesRrsaMetadataArgsDict']] rrsa_metadata: (Optional, Available since v1.185.0) Nested attribute containing RRSA related data for your cluster.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
               * > **NOTE:** Please take of note before updating the `security_group_id`:
               * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
               * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        :param pulumi.Input[_builtins.str] service_account_issuer: The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        :param pulumi.Input[_builtins.str] service_cidr: The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        :param pulumi.Input[_builtins.bool] skip_set_certificate_authority: Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.
               
               *Network params*
        :param pulumi.Input[_builtins.str] slb_id: The ID of APIServer load balancer.
        :param pulumi.Input[_builtins.str] slb_internet: The public ip of load balancer.
        :param pulumi.Input[_builtins.bool] slb_internet_enabled: Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        :param pulumi.Input[_builtins.str] slb_intranet: The ID of private load balancer where the current cluster master node is located.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        :param pulumi.Input[_builtins.str] timezone: Cluster timezone, works for control plane and Worker nodes.
               * > **NOTE:** Please take of note before updating the `timezone`:
               * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
               * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
               * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        :param pulumi.Input[_builtins.str] user_ca: The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        :param pulumi.Input[_builtins.str] version: Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of VPC where the current cluster is located.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vswitch_ids: The vSwitches of the control plane.
               > **NOTE:** Please take of note before updating the `vswitch_ids`:
               * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
               * The control plane restarts during the change process. Exercise caution when you perform this operation.
               * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
               * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        :param pulumi.Input[_builtins.str] worker_ram_role_name: The RamRole Name attached to worker node.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] worker_vswitch_ids: The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zone_ids: The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedKubernetesState.__new__(_ManagedKubernetesState)

        __props__.__dict__["addons"] = addons
        __props__.__dict__["api_audiences"] = api_audiences
        __props__.__dict__["audit_log_config"] = audit_log_config
        __props__.__dict__["auto_mode"] = auto_mode
        __props__.__dict__["certificate_authority"] = certificate_authority
        __props__.__dict__["client_cert"] = client_cert
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cluster_ca_cert"] = cluster_ca_cert
        __props__.__dict__["cluster_domain"] = cluster_domain
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["connections"] = connections
        __props__.__dict__["control_plane_log_components"] = control_plane_log_components
        __props__.__dict__["control_plane_log_project"] = control_plane_log_project
        __props__.__dict__["control_plane_log_ttl"] = control_plane_log_ttl
        __props__.__dict__["custom_san"] = custom_san
        __props__.__dict__["delete_options"] = delete_options
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["enable_rrsa"] = enable_rrsa
        __props__.__dict__["encryption_provider_key"] = encryption_provider_key
        __props__.__dict__["ip_stack"] = ip_stack
        __props__.__dict__["is_enterprise_security_group"] = is_enterprise_security_group
        __props__.__dict__["load_balancer_spec"] = load_balancer_spec
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["new_nat_gateway"] = new_nat_gateway
        __props__.__dict__["node_cidr_mask"] = node_cidr_mask
        __props__.__dict__["operation_policy"] = operation_policy
        __props__.__dict__["pod_cidr"] = pod_cidr
        __props__.__dict__["pod_vswitch_ids"] = pod_vswitch_ids
        __props__.__dict__["profile"] = profile
        __props__.__dict__["proxy_mode"] = proxy_mode
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["retain_resources"] = retain_resources
        __props__.__dict__["rrsa_metadata"] = rrsa_metadata
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["service_account_issuer"] = service_account_issuer
        __props__.__dict__["service_cidr"] = service_cidr
        __props__.__dict__["skip_set_certificate_authority"] = skip_set_certificate_authority
        __props__.__dict__["slb_id"] = slb_id
        __props__.__dict__["slb_internet"] = slb_internet
        __props__.__dict__["slb_internet_enabled"] = slb_internet_enabled
        __props__.__dict__["slb_intranet"] = slb_intranet
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["user_ca"] = user_ca
        __props__.__dict__["version"] = version
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        __props__.__dict__["worker_ram_role_name"] = worker_ram_role_name
        __props__.__dict__["worker_vswitch_ids"] = worker_vswitch_ids
        __props__.__dict__["zone_ids"] = zone_ids
        return ManagedKubernetes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addons(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedKubernetesAddon']]]:
        """
        The addon you want to install in cluster. See `addons` below. Only works for **Create** Operation, use resource cs_kubernetes_addon to manage addons if cluster is created.
        """
        return pulumi.get(self, "addons")

    @_builtins.property
    @pulumi.getter(name="apiAudiences")
    def api_audiences(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of API audiences for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm). Set this to `["https://kubernetes.default.svc"]` if you want to enable the Token Volume Projection feature (requires specifying `service_account_issuer` as well. From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "api_audiences")

    @_builtins.property
    @pulumi.getter(name="auditLogConfig")
    def audit_log_config(self) -> pulumi.Output['outputs.ManagedKubernetesAuditLogConfig']:
        """
        Audit log configuration. See `audit_log_config` below.
        """
        return pulumi.get(self, "audit_log_config")

    @_builtins.property
    @pulumi.getter(name="autoMode")
    def auto_mode(self) -> pulumi.Output[Optional['outputs.ManagedKubernetesAutoMode']]:
        """
        Auto mode cluster configuration. See `auto_mode` below.
        """
        return pulumi.get(self, "auto_mode")

    @_builtins.property
    @pulumi.getter(name="certificateAuthority")
    @_utilities.deprecated("""Field 'certificate_authority' has been deprecated from provider version 1.248.0. Please use the attribute 'certificate_authority' of new DataSource 'alicloud_cs_cluster_credential' to replace it.""")
    def certificate_authority(self) -> pulumi.Output['outputs.ManagedKubernetesCertificateAuthority']:
        """
        (Map, Deprecated from v1.248.0) Nested attribute containing certificate authority data for your cluster. Please use the attribute certificate_authority of new DataSource `cs_get_cluster_credential` to replace it.
        """
        return pulumi.get(self, "certificate_authority")

    @_builtins.property
    @pulumi.getter(name="clientCert")
    @_utilities.deprecated("""Field 'client_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-cert.pem) for replace it.""")
    def client_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-cert.pem) for replace it.
        """
        return pulumi.get(self, "client_cert")

    @_builtins.property
    @pulumi.getter(name="clientKey")
    @_utilities.deprecated("""Field 'client_key' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.client_key' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/client-key.pem) for replace it.""")
    def client_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.client_key attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/client-key.pem) for replace it.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="clusterCaCert")
    @_utilities.deprecated("""Field 'cluster_ca_cert' has been deprecated from provider version 1.248.0. From version 1.248.0, new DataSource 'alicloud_cs_cluster_credential' is recommended to manage cluster's kubeconfig, you can also save the 'certificate_authority.cluster_cert' attribute content of new DataSource 'alicloud_cs_cluster_credential' to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.""")
    def cluster_ca_cert(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        From version 1.248.0, new DataSource `cs_get_cluster_credential` is recommended to manage cluster's kubeconfig, you can also save the certificate_authority.cluster_cert attribute content of new DataSource `cs_get_cluster_credential` to an appropriate path(like ~/.kube/cluster-ca-cert.pem) for replace it.

        *Removed params*
        """
        return pulumi.get(self, "cluster_ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster local domain name, Default to `cluster.local`. A domain name consists of one or more sections separated by a decimal point (.), each of which is up to 63 characters long, and can be lowercase, numerals, and underscores (-), and must be lowercase or numerals at the beginning and end.
        """
        return pulumi.get(self, "cluster_domain")

    @_builtins.property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster specifications of kubernetes cluster,which can be empty. Valid values:
        * ack.standard : Basic managed clusters.
        * ack.pro.small : Professional managed clusters.
        """
        return pulumi.get(self, "cluster_spec")

    @_builtins.property
    @pulumi.getter
    def connections(self) -> pulumi.Output['outputs.ManagedKubernetesConnections']:
        """
        Map of kubernetes cluster connection information.
        """
        return pulumi.get(self, "connections")

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogComponents")
    def control_plane_log_components(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of target components for which logs need to be collected. Supports `apiserver`, `kcm`, `scheduler`, `ccm` and `controlplane-events`.
        """
        return pulumi.get(self, "control_plane_log_components")

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogProject")
    def control_plane_log_project(self) -> pulumi.Output[_builtins.str]:
        """
        Control plane log project. If this field is not set, a log service project named k8s-log-{ClusterID} will be automatically created.
        """
        return pulumi.get(self, "control_plane_log_project")

    @_builtins.property
    @pulumi.getter(name="controlPlaneLogTtl")
    def control_plane_log_ttl(self) -> pulumi.Output[_builtins.str]:
        """
        Control plane log retention duration (unit: day). Default `30`. If control plane logs are to be collected, `control_plane_log_ttl` and `control_plane_log_components` must be specified.
        """
        return pulumi.get(self, "control_plane_log_ttl")

    @_builtins.property
    @pulumi.getter(name="customSan")
    def custom_san(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Customize the certificate SAN, multiple IP or domain names are separated by English commas (,).
        > **NOTE:** Make sure you have specified all certificate SANs before updating. Updating this field will lead APIServer to restart.
        """
        return pulumi.get(self, "custom_san")

    @_builtins.property
    @pulumi.getter(name="deleteOptions")
    def delete_options(self) -> pulumi.Output[Optional[Sequence['outputs.ManagedKubernetesDeleteOption']]]:
        """
        Delete options, only work for deleting resource. Make sure you have run `pulumi up` to make the configuration applied. See `delete_options` below.
        """
        return pulumi.get(self, "delete_options")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable cluster deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="enableRrsa")
    def enable_rrsa(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable cluster to support RRSA for kubernetes version 1.22.3+. Default to `false`. Once the RRSA function is turned on, it is not allowed to turn off. If your cluster has enabled this function, please manually modify your tf file and add the rrsa configuration to the file, learn more [RAM Roles for Service Accounts](https://www.alibabacloud.com/help/zh/container-service-for-kubernetes/latest/use-rrsa-to-enforce-access-control).
        """
        return pulumi.get(self, "enable_rrsa")

    @_builtins.property
    @pulumi.getter(name="encryptionProviderKey")
    def encryption_provider_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Key Management Service (KMS) key that is used to encrypt Kubernetes Secrets.
        """
        return pulumi.get(self, "encryption_provider_key")

    @_builtins.property
    @pulumi.getter(name="ipStack")
    def ip_stack(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address family that the cluster network uses. Valid values:
        """
        return pulumi.get(self, "ip_stack")

    @_builtins.property
    @pulumi.getter(name="isEnterpriseSecurityGroup")
    def is_enterprise_security_group(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable to create advanced security group. default: false. Only works for **Create** Operation. See [Advanced security group](https://www.alibabacloud.com/help/doc-detail/120621.htm).
        """
        return pulumi.get(self, "is_enterprise_security_group")

    @_builtins.property
    @pulumi.getter(name="loadBalancerSpec")
    @_utilities.deprecated("""Field 'load_balancer_spec' has been deprecated from provider version 1.232.0. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU""")
    def load_balancer_spec(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster api server load balancer instance specification. For more information on how to select a LB instance specification, see [SLB instance overview](https://help.aliyun.com/document_detail/85931.html). Only works for **Create** Operation. The spec will not take effect because the charge of the load balancer has been changed to PayByCLCU.
        """
        return pulumi.get(self, "load_balancer_spec")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.ManagedKubernetesMaintenanceWindow']:
        """
        The cluster maintenance window. Managed node pool will use it. See `maintenance_window` below.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The kubernetes cluster's name. It is unique in one Alicloud account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of nat gateway used to launch kubernetes cluster.
        """
        return pulumi.get(self, "nat_gateway_id")

    @_builtins.property
    @pulumi.getter(name="newNatGateway")
    def new_nat_gateway(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create a new nat gateway while creating kubernetes cluster. Default to true. Then openapi in Alibaba Cloud are not all on intranet, So turn this option on is a good choice. Only works for **Create** Operation.
        """
        return pulumi.get(self, "new_nat_gateway")

    @_builtins.property
    @pulumi.getter(name="nodeCidrMask")
    def node_cidr_mask(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The node cidr block to specific how many pods can run on single node. 24-28 is allowed. 24 means 2^(32-24)-1=255 and the node can run at most 255 pods. default: 24
        """
        return pulumi.get(self, "node_cidr_mask")

    @_builtins.property
    @pulumi.getter(name="operationPolicy")
    def operation_policy(self) -> pulumi.Output['outputs.ManagedKubernetesOperationPolicy']:
        """
        The cluster automatic operation policy, only works when `maintenance_window` is enabled. See `operation_policy` below.
        """
        return pulumi.get(self, "operation_policy")

    @_builtins.property
    @pulumi.getter(name="podCidr")
    def pod_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        [Flannel Specific] The CIDR block for the pod network when using Flannel.
        """
        return pulumi.get(self, "pod_cidr")

    @_builtins.property
    @pulumi.getter(name="podVswitchIds")
    def pod_vswitch_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        [Terway Specific] The vswitches for the pod network when using Terway. It is recommended that `pod_vswitch_ids` is not belong to `vswitch_ids` but must be in same availability zones. Only works for **Create** Operation.
        """
        return pulumi.get(self, "pod_vswitch_ids")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[_builtins.str]:
        """
        The profile of cluster. Valid values:
        * `Default`: ACK managed cluster. ACK managed clusters include ACK Basic clusters and ACK Pro clusters.
        * `Edge`: ACK Edge cluster. ACK Edge clusters include ACK Edge Basic clusters and ACK Edge Pro clusters.
        * `Serverless`: ACK Serverless cluster. ACK Serverless clusters include ACK Serverless Basic clusters and ACK Serverless Pro clusters.
        * `Acs`: ACS cluster.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter(name="proxyMode")
    def proxy_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Proxy mode is option of kube-proxy. options: iptables|ipvs. default: ipvs.
        """
        return pulumi.get(self, "proxy_mode")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group,by default these cloud resources are automatically assigned to the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="retainResources")
    def retain_resources(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "retain_resources")

    @_builtins.property
    @pulumi.getter(name="rrsaMetadata")
    def rrsa_metadata(self) -> pulumi.Output['outputs.ManagedKubernetesRrsaMetadata']:
        """
        (Optional, Available since v1.185.0) Nested attribute containing RRSA related data for your cluster.
        """
        return pulumi.get(self, "rrsa_metadata")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the ECS instances in the cluster belong. If it is not specified, a new Security group will be built.
        * > **NOTE:** Please take of note before updating the `security_group_id`:
        * If block rules are configured in the security group, ensure the security group rules allow traffic for protocols and ports required by the cluster. For recommended security group rules, see [Configure and manage security groups for an ACK cluster](https://www.alibabacloud.com/help/en/ack/ack-managed-and-ack-dedicated/user-guide/configure-security-group-rules-to-enforce-access-control-on-ack-clusters).
        * During security group updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the control plane security group, the Elastic Network Interfaces (ENIs) used by the control plane and managed components will automatically join the new security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountIssuer")
    def service_account_issuer(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The issuer of the Service Account token for [Service Account Token Volume Projection](https://www.alibabacloud.com/help/doc-detail/160384.htm), corresponds to the `iss` field in the token payload. Set this to `"https://kubernetes.default.svc"` to enable the Token Volume Projection feature (requires specifying `api_audiences` as well). From cluster version 1.22, Service Account Token Volume Projection will be enabled by default.
        """
        return pulumi.get(self, "service_account_issuer")

    @_builtins.property
    @pulumi.getter(name="serviceCidr")
    def service_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The CIDR block for the service network. It cannot be duplicated with the VPC CIDR and CIDR used by Kubernetes cluster in VPC, cannot be modified after creation.
        """
        return pulumi.get(self, "service_cidr")

    @_builtins.property
    @pulumi.getter(name="skipSetCertificateAuthority")
    def skip_set_certificate_authority(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Configure whether to save certificate authority data for your cluster to attribute `certificate_authority`. For cluster security, recommended configuration as `true`. Will be removed with attribute certificate_authority removed.

        *Network params*
        """
        return pulumi.get(self, "skip_set_certificate_authority")

    @_builtins.property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of APIServer load balancer.
        """
        return pulumi.get(self, "slb_id")

    @_builtins.property
    @pulumi.getter(name="slbInternet")
    def slb_internet(self) -> pulumi.Output[_builtins.str]:
        """
        The public ip of load balancer.
        """
        return pulumi.get(self, "slb_internet")

    @_builtins.property
    @pulumi.getter(name="slbInternetEnabled")
    def slb_internet_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to create internet load balancer for API Server. Default to true. Only works for **Create** Operation.
        """
        return pulumi.get(self, "slb_internet_enabled")

    @_builtins.property
    @pulumi.getter(name="slbIntranet")
    def slb_intranet(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of private load balancer where the current cluster master node is located.
        """
        return pulumi.get(self, "slb_intranet")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Default nil, A map of tags assigned to the kubernetes cluster and work nodes. See `tags` below.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster timezone, works for control plane and Worker nodes.
        * > **NOTE:** Please take of note before updating the `timezone`:
        * After modifying the timezone, cluster inspection configurations will adopt the new timezone.
        * During timezone updates, the cluster control plane and managed components (e.g., terway-controlplane) will restart briefly. Perform this operation during off-peak hours.
        * After updating the timezone: Newly scaled-out nodes will automatically apply the new timezone. Existing nodes remain unaffected. Reset the node to apply changes to existing nodes.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="userCa")
    def user_ca(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path of customized CA cert, you can use this CA to sign client certs to connect your cluster.
        """
        return pulumi.get(self, "user_ca")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Desired Kubernetes version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except you set a higher version number. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by ACK. Do not specify if cluster auto upgrade is enabled, see cluster_auto_upgrade for more information.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of VPC where the current cluster is located.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The vSwitches of the control plane.
        > **NOTE:** Please take of note before updating the `vswitch_ids`:
        * This parameter overwrites the existing configuration. You must specify all vSwitches of the control plane.
        * The control plane restarts during the change process. Exercise caution when you perform this operation.
        * Ensure that all security groups of the cluster, including the security groups of the control plane, all node pools, and container network, are allowed to access the CIDR blocks of the new vSwitches. This ensures that the nodes and containers can connect to the API server.
        * If the new vSwitches of the control plane are configured with an ACL, ensure that the ACL allows communication between the new vSwitches and CIDR blocks such as those of the cluster nodes and the container network.
        """
        return pulumi.get(self, "vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="workerRamRoleName")
    def worker_ram_role_name(self) -> pulumi.Output[_builtins.str]:
        """
        The RamRole Name attached to worker node.
        """
        return pulumi.get(self, "worker_ram_role_name")

    @_builtins.property
    @pulumi.getter(name="workerVswitchIds")
    @_utilities.deprecated("""Field 'worker_vswitch_ids' has been deprecated from provider version 1.241.0. Please use 'vswitch_ids' to managed control plane vswtiches""")
    def worker_vswitch_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The vSwitches used by control plane. Modification after creation will not take effect. Please use `vswitch_ids` to managed control plane vSwitches, which supports modifying control plane vSwitches.
        """
        return pulumi.get(self, "worker_vswitch_ids")

    @_builtins.property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of the zone in which the cluster control plane is deployed. ACK automatically creates a VPC in the region and vSwitches in the specified zones. Only works for **Create** Operation. Do not specify this with `vswitch_ids` together.
        """
        return pulumi.get(self, "zone_ids")

