# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FolderArgs', 'Folder']

@pulumi.input_type
class FolderArgs:
    def __init__(__self__, *,
                 folder_path: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Folder resource.
        :param pulumi.Input[_builtins.str] folder_path: Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        """
        pulumi.set(__self__, "folder_path", folder_path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> pulumi.Input[_builtins.str]:
        """
        Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder_path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)


@pulumi.input_type
class _FolderState:
    def __init__(__self__, *,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Folder resources.
        :param pulumi.Input[_builtins.str] folder_path: Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        """
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if folder_path is not None:
            pulumi.set(__self__, "folder_path", folder_path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if project_identifier is not None:
            pulumi.set(__self__, "project_identifier", project_identifier)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        """
        return pulumi.get(self, "folder_path")

    @folder_path.setter
    def folder_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_identifier", value)


@pulumi.type_token("alicloud:dataworks/folder:Folder")
class Folder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Data Works Folder resource.

        For information about Data Works Folder and how to use it, see [What is Folder](https://help.aliyun.com/document_detail/173940.html).

        > **NOTE:** Available in v1.131.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.dataworks.Folder("example",
            project_id="320687",
            folder_path="Business Flow/tfTestAcc/folderDi/tftest1")
        ```

        ## Import

        Data Works Folder can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/folder:Folder example <folder_id>:<$.ProjectId>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] folder_path: Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Data Works Folder resource.

        For information about Data Works Folder and how to use it, see [What is Folder](https://help.aliyun.com/document_detail/173940.html).

        > **NOTE:** Available in v1.131.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.dataworks.Folder("example",
            project_id="320687",
            folder_path="Business Flow/tfTestAcc/folderDi/tftest1")
        ```

        ## Import

        Data Works Folder can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dataworks/folder:Folder example <folder_id>:<$.ProjectId>
        ```

        :param str resource_name: The name of the resource.
        :param FolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 folder_path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderArgs.__new__(FolderArgs)

            if folder_path is None and not opts.urn:
                raise TypeError("Missing required property 'folder_path'")
            __props__.__dict__["folder_path"] = folder_path
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["project_identifier"] = project_identifier
            __props__.__dict__["folder_id"] = None
        super(Folder, __self__).__init__(
            'alicloud:dataworks/folder:Folder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            folder_path: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_identifier: Optional[pulumi.Input[_builtins.str]] = None) -> 'Folder':
        """
        Get an existing Folder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] folder_path: Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderState.__new__(_FolderState)

        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["folder_path"] = folder_path
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["project_identifier"] = project_identifier
        return Folder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter(name="folderPath")
    def folder_path(self) -> pulumi.Output[_builtins.str]:
        """
        Folder Path. The folder path composed with for part: `Business Flow/{Business Flow Name}/[folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined]/{Directory Name}`. The first segment of path must be `Business Flow`, and sencond segment of path must be a Business Flow Name within the project. The third part of path must be one of those keywords:`folderDi|folderMaxCompute|folderGeneral|folderJdbc|folderUserDefined`. Then the finial part of folder path can be specified in yourself.
        """
        return pulumi.get(self, "folder_path")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "project_identifier")

