# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[_builtins.str]] = None,
                 function_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]] = None,
                 ssl_pri: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_pub: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 top_level_domain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[_builtins.str] domain_name: The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        :param pulumi.Input[_builtins.str] cert_id: The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        :param pulumi.Input[_builtins.str] cert_name: The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        :param pulumi.Input[_builtins.str] cert_region: The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        :param pulumi.Input[_builtins.str] cert_type: The certificate type.
        :param pulumi.Input[_builtins.str] check_url: The URL that is used for health checks.
        :param pulumi.Input[_builtins.str] env: Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        :param pulumi.Input[_builtins.str] function_type: Computing service type. Valid values:
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        :param pulumi.Input[_builtins.str] scene: The Acceleration scen. Supported:
        :param pulumi.Input[_builtins.str] scope: The region where the acceleration service is deployed. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: Source  See `sources` below.
        :param pulumi.Input[_builtins.str] ssl_pri: The private key. Specify the private key only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] ssl_protocol: Specifies whether to enable the SSL certificate. Valid values:
        :param pulumi.Input[_builtins.str] ssl_pub: The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] status: The status of the domain name. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] top_level_domain: The top-level domain.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if cert_region is not None:
            pulumi.set(__self__, "cert_region", cert_region)
        if cert_type is not None:
            pulumi.set(__self__, "cert_type", cert_type)
        if check_url is not None:
            pulumi.set(__self__, "check_url", check_url)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if function_type is not None:
            pulumi.set(__self__, "function_type", function_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scene is not None:
            pulumi.set(__self__, "scene", scene)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if ssl_pri is not None:
            pulumi.set(__self__, "ssl_pri", ssl_pri)
        if ssl_protocol is not None:
            pulumi.set(__self__, "ssl_protocol", ssl_protocol)
        if ssl_pub is not None:
            pulumi.set(__self__, "ssl_pub", ssl_pub)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if top_level_domain is not None:
            pulumi.set(__self__, "top_level_domain", top_level_domain)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        """
        return pulumi.get(self, "cert_region")

    @cert_region.setter
    def cert_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_region", value)

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate type.
        """
        return pulumi.get(self, "cert_type")

    @cert_type.setter
    def cert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_type", value)

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that is used for health checks.
        """
        return pulumi.get(self, "check_url")

    @check_url.setter
    def check_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_url", value)

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env", value)

    @_builtins.property
    @pulumi.getter(name="functionType")
    def function_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computing service type. Valid values:
        """
        return pulumi.get(self, "function_type")

    @function_type.setter
    def function_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Acceleration scen. Supported:
        """
        return pulumi.get(self, "scene")

    @scene.setter
    def scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scene", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the acceleration service is deployed. Valid values:
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]:
        """
        Source  See `sources` below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="sslPri")
    def ssl_pri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. Specify the private key only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pri")

    @ssl_pri.setter
    def ssl_pri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_pri", value)

    @_builtins.property
    @pulumi.getter(name="sslProtocol")
    def ssl_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the SSL certificate. Valid values:
        """
        return pulumi.get(self, "ssl_protocol")

    @ssl_protocol.setter
    def ssl_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslPub")
    def ssl_pub(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pub")

    @ssl_pub.setter
    def ssl_pub(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_pub", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the domain name. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topLevelDomain")
    def top_level_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The top-level domain.
        """
        return pulumi.get(self, "top_level_domain")

    @top_level_domain.setter
    def top_level_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "top_level_domain", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 cname: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[_builtins.str]] = None,
                 function_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]] = None,
                 ssl_pri: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_pub: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 top_level_domain: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[_builtins.str] cert_id: The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        :param pulumi.Input[_builtins.str] cert_name: The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        :param pulumi.Input[_builtins.str] cert_region: The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        :param pulumi.Input[_builtins.str] cert_type: The certificate type.
        :param pulumi.Input[_builtins.str] check_url: The URL that is used for health checks.
        :param pulumi.Input[_builtins.str] cname: The CNAME domain name corresponding to the accelerated domain name.
        :param pulumi.Input[_builtins.str] create_time: The time when the accelerated domain name was created.
        :param pulumi.Input[_builtins.str] domain_name: The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        :param pulumi.Input[_builtins.str] env: Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        :param pulumi.Input[_builtins.str] function_type: Computing service type. Valid values:
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        :param pulumi.Input[_builtins.str] scene: The Acceleration scen. Supported:
        :param pulumi.Input[_builtins.str] scope: The region where the acceleration service is deployed. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]] sources: Source  See `sources` below.
        :param pulumi.Input[_builtins.str] ssl_pri: The private key. Specify the private key only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] ssl_protocol: Specifies whether to enable the SSL certificate. Valid values:
        :param pulumi.Input[_builtins.str] ssl_pub: The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] status: The status of the domain name. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] top_level_domain: The top-level domain.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_name is not None:
            pulumi.set(__self__, "cert_name", cert_name)
        if cert_region is not None:
            pulumi.set(__self__, "cert_region", cert_region)
        if cert_type is not None:
            pulumi.set(__self__, "cert_type", cert_type)
        if check_url is not None:
            pulumi.set(__self__, "check_url", check_url)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if function_type is not None:
            pulumi.set(__self__, "function_type", function_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if scene is not None:
            pulumi.set(__self__, "scene", scene)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if ssl_pri is not None:
            pulumi.set(__self__, "ssl_pri", ssl_pri)
        if ssl_protocol is not None:
            pulumi.set(__self__, "ssl_protocol", ssl_protocol)
        if ssl_pub is not None:
            pulumi.set(__self__, "ssl_pub", ssl_pub)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if top_level_domain is not None:
            pulumi.set(__self__, "top_level_domain", top_level_domain)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_id", value)

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        """
        return pulumi.get(self, "cert_name")

    @cert_name.setter
    def cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_name", value)

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        """
        return pulumi.get(self, "cert_region")

    @cert_region.setter
    def cert_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_region", value)

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate type.
        """
        return pulumi.get(self, "cert_type")

    @cert_type.setter
    def cert_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cert_type", value)

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that is used for health checks.
        """
        return pulumi.get(self, "check_url")

    @check_url.setter
    def check_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "check_url", value)

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CNAME domain name corresponding to the accelerated domain name.
        """
        return pulumi.get(self, "cname")

    @cname.setter
    def cname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cname", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the accelerated domain name was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "env", value)

    @_builtins.property
    @pulumi.getter(name="functionType")
    def function_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computing service type. Valid values:
        """
        return pulumi.get(self, "function_type")

    @function_type.setter
    def function_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def scene(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Acceleration scen. Supported:
        """
        return pulumi.get(self, "scene")

    @scene.setter
    def scene(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scene", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the acceleration service is deployed. Valid values:
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]:
        """
        Source  See `sources` below.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @_builtins.property
    @pulumi.getter(name="sslPri")
    def ssl_pri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key. Specify the private key only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pri")

    @ssl_pri.setter
    def ssl_pri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_pri", value)

    @_builtins.property
    @pulumi.getter(name="sslProtocol")
    def ssl_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to enable the SSL certificate. Valid values:
        """
        return pulumi.get(self, "ssl_protocol")

    @ssl_protocol.setter
    def ssl_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslPub")
    def ssl_pub(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pub")

    @ssl_pub.setter
    def ssl_pub(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_pub", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the domain name. Valid values:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topLevelDomain")
    def top_level_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The top-level domain.
        """
        return pulumi.get(self, "top_level_domain")

    @top_level_domain.setter
    def top_level_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "top_level_domain", value)


@pulumi.type_token("alicloud:dcdn/domain:Domain")
class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[_builtins.str]] = None,
                 function_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
                 ssl_pri: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_pub: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 top_level_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a DCDN Domain resource.

        Full station accelerated domain name.

        For information about DCDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/doc-detail/130628.htm).

        > **NOTE:** Available since v1.94.0.

        > **NOTE:** Field `force_set`, `security_token` has been removed from provider version 1.227.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "tf-example.com"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.dcdn.Domain("example",
            domain_name=f"{domain_name}-{default['result']}",
            scope="overseas",
            sources=[{
                "content": "1.1.1.1",
                "port": 80,
                "priority": "20",
                "type": "ipaddr",
                "weight": "10",
            }])
        ```

        ## Import

        DCDN Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/domain:Domain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert_id: The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        :param pulumi.Input[_builtins.str] cert_name: The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        :param pulumi.Input[_builtins.str] cert_region: The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        :param pulumi.Input[_builtins.str] cert_type: The certificate type.
        :param pulumi.Input[_builtins.str] check_url: The URL that is used for health checks.
        :param pulumi.Input[_builtins.str] domain_name: The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        :param pulumi.Input[_builtins.str] env: Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        :param pulumi.Input[_builtins.str] function_type: Computing service type. Valid values:
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        :param pulumi.Input[_builtins.str] scene: The Acceleration scen. Supported:
        :param pulumi.Input[_builtins.str] scope: The region where the acceleration service is deployed. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]] sources: Source  See `sources` below.
        :param pulumi.Input[_builtins.str] ssl_pri: The private key. Specify the private key only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] ssl_protocol: Specifies whether to enable the SSL certificate. Valid values:
        :param pulumi.Input[_builtins.str] ssl_pub: The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] status: The status of the domain name. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] top_level_domain: The top-level domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DCDN Domain resource.

        Full station accelerated domain name.

        For information about DCDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/doc-detail/130628.htm).

        > **NOTE:** Available since v1.94.0.

        > **NOTE:** Field `force_set`, `security_token` has been removed from provider version 1.227.1.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        domain_name = config.get("domainName")
        if domain_name is None:
            domain_name = "tf-example.com"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        example = alicloud.dcdn.Domain("example",
            domain_name=f"{domain_name}-{default['result']}",
            scope="overseas",
            sources=[{
                "content": "1.1.1.1",
                "port": 80,
                "priority": "20",
                "type": "ipaddr",
                "weight": "10",
            }])
        ```

        ## Import

        DCDN Domain can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dcdn/domain:Domain example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_region: Optional[pulumi.Input[_builtins.str]] = None,
                 cert_type: Optional[pulumi.Input[_builtins.str]] = None,
                 check_url: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 env: Optional[pulumi.Input[_builtins.str]] = None,
                 function_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scene: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
                 ssl_pri: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_pub: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 top_level_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["cert_id"] = cert_id
            __props__.__dict__["cert_name"] = cert_name
            __props__.__dict__["cert_region"] = cert_region
            __props__.__dict__["cert_type"] = cert_type
            __props__.__dict__["check_url"] = check_url
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["env"] = env
            __props__.__dict__["function_type"] = function_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["scene"] = scene
            __props__.__dict__["scope"] = scope
            __props__.__dict__["sources"] = sources
            __props__.__dict__["ssl_pri"] = None if ssl_pri is None else pulumi.Output.secret(ssl_pri)
            __props__.__dict__["ssl_protocol"] = ssl_protocol
            __props__.__dict__["ssl_pub"] = ssl_pub
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["top_level_domain"] = top_level_domain
            __props__.__dict__["cname"] = None
            __props__.__dict__["create_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sslPri"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Domain, __self__).__init__(
            'alicloud:dcdn/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert_id: Optional[pulumi.Input[_builtins.str]] = None,
            cert_name: Optional[pulumi.Input[_builtins.str]] = None,
            cert_region: Optional[pulumi.Input[_builtins.str]] = None,
            cert_type: Optional[pulumi.Input[_builtins.str]] = None,
            check_url: Optional[pulumi.Input[_builtins.str]] = None,
            cname: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            env: Optional[pulumi.Input[_builtins.str]] = None,
            function_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            scene: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]]] = None,
            ssl_pri: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_pub: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            top_level_domain: Optional[pulumi.Input[_builtins.str]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cert_id: The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        :param pulumi.Input[_builtins.str] cert_name: The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        :param pulumi.Input[_builtins.str] cert_region: The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        :param pulumi.Input[_builtins.str] cert_type: The certificate type.
        :param pulumi.Input[_builtins.str] check_url: The URL that is used for health checks.
        :param pulumi.Input[_builtins.str] cname: The CNAME domain name corresponding to the accelerated domain name.
        :param pulumi.Input[_builtins.str] create_time: The time when the accelerated domain name was created.
        :param pulumi.Input[_builtins.str] domain_name: The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        :param pulumi.Input[_builtins.str] env: Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        :param pulumi.Input[_builtins.str] function_type: Computing service type. Valid values:
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        :param pulumi.Input[_builtins.str] scene: The Acceleration scen. Supported:
        :param pulumi.Input[_builtins.str] scope: The region where the acceleration service is deployed. Valid values:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainSourceArgs', 'DomainSourceArgsDict']]]] sources: Source  See `sources` below.
        :param pulumi.Input[_builtins.str] ssl_pri: The private key. Specify the private key only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] ssl_protocol: Specifies whether to enable the SSL certificate. Valid values:
        :param pulumi.Input[_builtins.str] ssl_pub: The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        :param pulumi.Input[_builtins.str] status: The status of the domain name. Valid values:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource
        :param pulumi.Input[_builtins.str] top_level_domain: The top-level domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["cert_id"] = cert_id
        __props__.__dict__["cert_name"] = cert_name
        __props__.__dict__["cert_region"] = cert_region
        __props__.__dict__["cert_type"] = cert_type
        __props__.__dict__["check_url"] = check_url
        __props__.__dict__["cname"] = cname
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["env"] = env
        __props__.__dict__["function_type"] = function_type
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["scene"] = scene
        __props__.__dict__["scope"] = scope
        __props__.__dict__["sources"] = sources
        __props__.__dict__["ssl_pri"] = ssl_pri
        __props__.__dict__["ssl_protocol"] = ssl_protocol
        __props__.__dict__["ssl_pub"] = ssl_pub
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["top_level_domain"] = top_level_domain
        return Domain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certId")
    def cert_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate ID. This parameter is required and valid only when `CertType` is set to `cas`. If you specify this parameter, an existing certificate is used.
        """
        return pulumi.get(self, "cert_id")

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the new certificate. You can specify only one certificate name. This parameter is optional and valid only when `CertType` is set to `upload`.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter(name="certRegion")
    def cert_region(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the SSL certificate. This parameter takes effect only when `CertType` is set to `cas`. Default value: **cn-hangzhou**. Valid values: **cn-hangzhou** and **ap-southeast-1**.
        """
        return pulumi.get(self, "cert_region")

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate type.
        """
        return pulumi.get(self, "cert_type")

    @_builtins.property
    @pulumi.getter(name="checkUrl")
    def check_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL that is used for health checks.
        """
        return pulumi.get(self, "check_url")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> pulumi.Output[_builtins.str]:
        """
        The CNAME domain name corresponding to the accelerated domain name.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the accelerated domain name was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The accelerated domain name. You can specify multiple domain names and separate them with commas (,). You can specify up to 500 domain names in each request. The query results of multiple domain names are aggregated. If you do not specify this parameter, data of all accelerated domain names under your account is queried.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def env(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether the certificate is issued in canary releases. If you set this parameter to `staging`, the certificate is issued in canary releases. If you do not specify this parameter or set this parameter to other values, the certificate is officially issued.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter(name="functionType")
    def function_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Computing service type. Valid values:
        """
        return pulumi.get(self, "function_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group. If you do not specify a value for this parameter, the system automatically assigns the ID of the default resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def scene(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Acceleration scen. Supported:
        """
        return pulumi.get(self, "scene")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region where the acceleration service is deployed. Valid values:
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.DomainSource']]]:
        """
        Source  See `sources` below.
        """
        return pulumi.get(self, "sources")

    @_builtins.property
    @pulumi.getter(name="sslPri")
    def ssl_pri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The private key. Specify the private key only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pri")

    @_builtins.property
    @pulumi.getter(name="sslProtocol")
    def ssl_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to enable the SSL certificate. Valid values:
        """
        return pulumi.get(self, "ssl_protocol")

    @_builtins.property
    @pulumi.getter(name="sslPub")
    def ssl_pub(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the SSL certificate. Specify the content of the SSL certificate only if you want to enable the SSL certificate.
        """
        return pulumi.get(self, "ssl_pub")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the domain name. Valid values:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topLevelDomain")
    def top_level_domain(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The top-level domain.
        """
        return pulumi.get(self, "top_level_domain")

