# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BgpPolicyContentArgs',
    'BgpPolicyContentArgsDict',
    'BgpPolicyContentFingerPrintRuleListArgs',
    'BgpPolicyContentFingerPrintRuleListArgsDict',
    'BgpPolicyContentLayer4RuleListArgs',
    'BgpPolicyContentLayer4RuleListArgsDict',
    'BgpPolicyContentLayer4RuleListConditionListArgs',
    'BgpPolicyContentLayer4RuleListConditionListArgsDict',
    'BgpPolicyContentPortRuleListArgs',
    'BgpPolicyContentPortRuleListArgsDict',
    'BgpPolicyContentSourceBlockListArgs',
    'BgpPolicyContentSourceBlockListArgsDict',
    'BgpPolicyContentSourceLimitArgs',
    'BgpPolicyContentSourceLimitArgsDict',
    'DomainResourceProxyTypeArgs',
    'DomainResourceProxyTypeArgsDict',
    'PortConfigArgs',
    'PortConfigArgsDict',
    'SchedulerRuleRuleArgs',
    'SchedulerRuleRuleArgsDict',
]

MYPY = False

if not MYPY:
    class BgpPolicyContentArgsDict(TypedDict):
        black_ip_list_expire_at: NotRequired[pulumi.Input[_builtins.int]]
        """
        Blacklist and whitelist timeout.
        """
        enable_defense: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable L4 protection.
        """
        enable_drop_icmp: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Switch to discard ICMP.
        """
        enable_intelligence: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the intelligent switch is on.
        """
        finger_print_rule_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentFingerPrintRuleListArgsDict']]]]
        """
        Fingerprint Rules. See `finger_print_rule_list` below.
        """
        intelligence_level: NotRequired[pulumi.Input[_builtins.str]]
        """
        Smart mode. Valid values: weak, hard, and default.
        """
        layer4_rule_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListArgsDict']]]]
        """
        L4 protection rules. See `layer4_rule_list` below.
        """
        port_rule_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentPortRuleListArgsDict']]]]
        """
        Port Rule List. See `port_rule_list` below.
        """
        reflect_block_udp_port_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        Reflective port filtering.
        """
        region_block_country_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        List of Regional Banned Countries.
        """
        region_block_province_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]
        """
        List of Prohibited Provinces by Region.
        """
        source_block_lists: NotRequired[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentSourceBlockListArgsDict']]]]
        """
        Source pull Black. See `source_block_list` below.
        """
        source_limit: NotRequired[pulumi.Input['BgpPolicyContentSourceLimitArgsDict']]
        """
        Do not fill in when the source speed limit is deleted. See `source_limit` below.
        """
        whiten_gfbr_nets: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Add white high protection back to source network segment switch.
        """
elif False:
    BgpPolicyContentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentArgs:
    def __init__(__self__, *,
                 black_ip_list_expire_at: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_defense: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_drop_icmp: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_intelligence: Optional[pulumi.Input[_builtins.bool]] = None,
                 finger_print_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentFingerPrintRuleListArgs']]]] = None,
                 intelligence_level: Optional[pulumi.Input[_builtins.str]] = None,
                 layer4_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListArgs']]]] = None,
                 port_rule_lists: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentPortRuleListArgs']]]] = None,
                 reflect_block_udp_port_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 region_block_country_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 region_block_province_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 source_block_lists: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentSourceBlockListArgs']]]] = None,
                 source_limit: Optional[pulumi.Input['BgpPolicyContentSourceLimitArgs']] = None,
                 whiten_gfbr_nets: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.int] black_ip_list_expire_at: Blacklist and whitelist timeout.
        :param pulumi.Input[_builtins.bool] enable_defense: Whether to enable L4 protection.
        :param pulumi.Input[_builtins.bool] enable_drop_icmp: Switch to discard ICMP.
        :param pulumi.Input[_builtins.bool] enable_intelligence: Whether the intelligent switch is on.
        :param pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentFingerPrintRuleListArgs']]] finger_print_rule_lists: Fingerprint Rules. See `finger_print_rule_list` below.
        :param pulumi.Input[_builtins.str] intelligence_level: Smart mode. Valid values: weak, hard, and default.
        :param pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListArgs']]] layer4_rule_lists: L4 protection rules. See `layer4_rule_list` below.
        :param pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentPortRuleListArgs']]] port_rule_lists: Port Rule List. See `port_rule_list` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] reflect_block_udp_port_lists: Reflective port filtering.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] region_block_country_lists: List of Regional Banned Countries.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] region_block_province_lists: List of Prohibited Provinces by Region.
        :param pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentSourceBlockListArgs']]] source_block_lists: Source pull Black. See `source_block_list` below.
        :param pulumi.Input['BgpPolicyContentSourceLimitArgs'] source_limit: Do not fill in when the source speed limit is deleted. See `source_limit` below.
        :param pulumi.Input[_builtins.bool] whiten_gfbr_nets: Add white high protection back to source network segment switch.
        """
        if black_ip_list_expire_at is not None:
            pulumi.set(__self__, "black_ip_list_expire_at", black_ip_list_expire_at)
        if enable_defense is not None:
            pulumi.set(__self__, "enable_defense", enable_defense)
        if enable_drop_icmp is not None:
            pulumi.set(__self__, "enable_drop_icmp", enable_drop_icmp)
        if enable_intelligence is not None:
            pulumi.set(__self__, "enable_intelligence", enable_intelligence)
        if finger_print_rule_lists is not None:
            pulumi.set(__self__, "finger_print_rule_lists", finger_print_rule_lists)
        if intelligence_level is not None:
            pulumi.set(__self__, "intelligence_level", intelligence_level)
        if layer4_rule_lists is not None:
            pulumi.set(__self__, "layer4_rule_lists", layer4_rule_lists)
        if port_rule_lists is not None:
            pulumi.set(__self__, "port_rule_lists", port_rule_lists)
        if reflect_block_udp_port_lists is not None:
            pulumi.set(__self__, "reflect_block_udp_port_lists", reflect_block_udp_port_lists)
        if region_block_country_lists is not None:
            pulumi.set(__self__, "region_block_country_lists", region_block_country_lists)
        if region_block_province_lists is not None:
            pulumi.set(__self__, "region_block_province_lists", region_block_province_lists)
        if source_block_lists is not None:
            pulumi.set(__self__, "source_block_lists", source_block_lists)
        if source_limit is not None:
            pulumi.set(__self__, "source_limit", source_limit)
        if whiten_gfbr_nets is not None:
            pulumi.set(__self__, "whiten_gfbr_nets", whiten_gfbr_nets)

    @_builtins.property
    @pulumi.getter(name="blackIpListExpireAt")
    def black_ip_list_expire_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Blacklist and whitelist timeout.
        """
        return pulumi.get(self, "black_ip_list_expire_at")

    @black_ip_list_expire_at.setter
    def black_ip_list_expire_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "black_ip_list_expire_at", value)

    @_builtins.property
    @pulumi.getter(name="enableDefense")
    def enable_defense(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable L4 protection.
        """
        return pulumi.get(self, "enable_defense")

    @enable_defense.setter
    def enable_defense(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_defense", value)

    @_builtins.property
    @pulumi.getter(name="enableDropIcmp")
    def enable_drop_icmp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Switch to discard ICMP.
        """
        return pulumi.get(self, "enable_drop_icmp")

    @enable_drop_icmp.setter
    def enable_drop_icmp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_drop_icmp", value)

    @_builtins.property
    @pulumi.getter(name="enableIntelligence")
    def enable_intelligence(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the intelligent switch is on.
        """
        return pulumi.get(self, "enable_intelligence")

    @enable_intelligence.setter
    def enable_intelligence(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_intelligence", value)

    @_builtins.property
    @pulumi.getter(name="fingerPrintRuleLists")
    def finger_print_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentFingerPrintRuleListArgs']]]]:
        """
        Fingerprint Rules. See `finger_print_rule_list` below.
        """
        return pulumi.get(self, "finger_print_rule_lists")

    @finger_print_rule_lists.setter
    def finger_print_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentFingerPrintRuleListArgs']]]]):
        pulumi.set(self, "finger_print_rule_lists", value)

    @_builtins.property
    @pulumi.getter(name="intelligenceLevel")
    def intelligence_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Smart mode. Valid values: weak, hard, and default.
        """
        return pulumi.get(self, "intelligence_level")

    @intelligence_level.setter
    def intelligence_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "intelligence_level", value)

    @_builtins.property
    @pulumi.getter(name="layer4RuleLists")
    def layer4_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListArgs']]]]:
        """
        L4 protection rules. See `layer4_rule_list` below.
        """
        return pulumi.get(self, "layer4_rule_lists")

    @layer4_rule_lists.setter
    def layer4_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListArgs']]]]):
        pulumi.set(self, "layer4_rule_lists", value)

    @_builtins.property
    @pulumi.getter(name="portRuleLists")
    def port_rule_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentPortRuleListArgs']]]]:
        """
        Port Rule List. See `port_rule_list` below.
        """
        return pulumi.get(self, "port_rule_lists")

    @port_rule_lists.setter
    def port_rule_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentPortRuleListArgs']]]]):
        pulumi.set(self, "port_rule_lists", value)

    @_builtins.property
    @pulumi.getter(name="reflectBlockUdpPortLists")
    def reflect_block_udp_port_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        Reflective port filtering.
        """
        return pulumi.get(self, "reflect_block_udp_port_lists")

    @reflect_block_udp_port_lists.setter
    def reflect_block_udp_port_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "reflect_block_udp_port_lists", value)

    @_builtins.property
    @pulumi.getter(name="regionBlockCountryLists")
    def region_block_country_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of Regional Banned Countries.
        """
        return pulumi.get(self, "region_block_country_lists")

    @region_block_country_lists.setter
    def region_block_country_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "region_block_country_lists", value)

    @_builtins.property
    @pulumi.getter(name="regionBlockProvinceLists")
    def region_block_province_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        """
        List of Prohibited Provinces by Region.
        """
        return pulumi.get(self, "region_block_province_lists")

    @region_block_province_lists.setter
    def region_block_province_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "region_block_province_lists", value)

    @_builtins.property
    @pulumi.getter(name="sourceBlockLists")
    def source_block_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentSourceBlockListArgs']]]]:
        """
        Source pull Black. See `source_block_list` below.
        """
        return pulumi.get(self, "source_block_lists")

    @source_block_lists.setter
    def source_block_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentSourceBlockListArgs']]]]):
        pulumi.set(self, "source_block_lists", value)

    @_builtins.property
    @pulumi.getter(name="sourceLimit")
    def source_limit(self) -> Optional[pulumi.Input['BgpPolicyContentSourceLimitArgs']]:
        """
        Do not fill in when the source speed limit is deleted. See `source_limit` below.
        """
        return pulumi.get(self, "source_limit")

    @source_limit.setter
    def source_limit(self, value: Optional[pulumi.Input['BgpPolicyContentSourceLimitArgs']]):
        pulumi.set(self, "source_limit", value)

    @_builtins.property
    @pulumi.getter(name="whitenGfbrNets")
    def whiten_gfbr_nets(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Add white high protection back to source network segment switch.
        """
        return pulumi.get(self, "whiten_gfbr_nets")

    @whiten_gfbr_nets.setter
    def whiten_gfbr_nets(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "whiten_gfbr_nets", value)


if not MYPY:
    class BgpPolicyContentFingerPrintRuleListArgsDict(TypedDict):
        dst_port_end: pulumi.Input[_builtins.int]
        """
        End of destination port 0-65535.
        """
        dst_port_start: pulumi.Input[_builtins.int]
        """
        Destination Port start 0-65535.
        """
        match_action: pulumi.Input[_builtins.str]
        """
        Action. Currently, only drop is supported.
        """
        max_pkt_len: pulumi.Input[_builtins.int]
        """
        Maximum bag length.
        """
        min_pkt_len: pulumi.Input[_builtins.int]
        """
        Minimum package length.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol, tcp or udp.
        """
        seq_no: pulumi.Input[_builtins.int]
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        src_port_end: pulumi.Input[_builtins.int]
        """
        Source Port end 0-65535.
        """
        src_port_start: pulumi.Input[_builtins.int]
        """
        Source port start 0-65535.
        """
        finger_print_rule_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The UUID of the rule is required to be deleted and modified, and it is not required to be created.
        """
        offset: NotRequired[pulumi.Input[_builtins.int]]
        """
        Offset.
        """
        payload_bytes: NotRequired[pulumi.Input[_builtins.str]]
        """
        Load match, hexadecimal string; Similar to 'abcd'.
        """
        rate_value: NotRequired[pulumi.Input[_builtins.int]]
        """
        Speed limit value 1-100000.
        """
elif False:
    BgpPolicyContentFingerPrintRuleListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentFingerPrintRuleListArgs:
    def __init__(__self__, *,
                 dst_port_end: pulumi.Input[_builtins.int],
                 dst_port_start: pulumi.Input[_builtins.int],
                 match_action: pulumi.Input[_builtins.str],
                 max_pkt_len: pulumi.Input[_builtins.int],
                 min_pkt_len: pulumi.Input[_builtins.int],
                 protocol: pulumi.Input[_builtins.str],
                 seq_no: pulumi.Input[_builtins.int],
                 src_port_end: pulumi.Input[_builtins.int],
                 src_port_start: pulumi.Input[_builtins.int],
                 finger_print_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 offset: Optional[pulumi.Input[_builtins.int]] = None,
                 payload_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_value: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] dst_port_end: End of destination port 0-65535.
        :param pulumi.Input[_builtins.int] dst_port_start: Destination Port start 0-65535.
        :param pulumi.Input[_builtins.str] match_action: Action. Currently, only drop is supported.
        :param pulumi.Input[_builtins.int] max_pkt_len: Maximum bag length.
        :param pulumi.Input[_builtins.int] min_pkt_len: Minimum package length.
        :param pulumi.Input[_builtins.str] protocol: Protocol, tcp or udp.
        :param pulumi.Input[_builtins.int] seq_no: Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        :param pulumi.Input[_builtins.int] src_port_end: Source Port end 0-65535.
        :param pulumi.Input[_builtins.int] src_port_start: Source port start 0-65535.
        :param pulumi.Input[_builtins.str] finger_print_rule_id: The UUID of the rule is required to be deleted and modified, and it is not required to be created.
        :param pulumi.Input[_builtins.int] offset: Offset.
        :param pulumi.Input[_builtins.str] payload_bytes: Load match, hexadecimal string; Similar to 'abcd'.
        :param pulumi.Input[_builtins.int] rate_value: Speed limit value 1-100000.
        """
        pulumi.set(__self__, "dst_port_end", dst_port_end)
        pulumi.set(__self__, "dst_port_start", dst_port_start)
        pulumi.set(__self__, "match_action", match_action)
        pulumi.set(__self__, "max_pkt_len", max_pkt_len)
        pulumi.set(__self__, "min_pkt_len", min_pkt_len)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "seq_no", seq_no)
        pulumi.set(__self__, "src_port_end", src_port_end)
        pulumi.set(__self__, "src_port_start", src_port_start)
        if finger_print_rule_id is not None:
            pulumi.set(__self__, "finger_print_rule_id", finger_print_rule_id)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if payload_bytes is not None:
            pulumi.set(__self__, "payload_bytes", payload_bytes)
        if rate_value is not None:
            pulumi.set(__self__, "rate_value", rate_value)

    @_builtins.property
    @pulumi.getter(name="dstPortEnd")
    def dst_port_end(self) -> pulumi.Input[_builtins.int]:
        """
        End of destination port 0-65535.
        """
        return pulumi.get(self, "dst_port_end")

    @dst_port_end.setter
    def dst_port_end(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "dst_port_end", value)

    @_builtins.property
    @pulumi.getter(name="dstPortStart")
    def dst_port_start(self) -> pulumi.Input[_builtins.int]:
        """
        Destination Port start 0-65535.
        """
        return pulumi.get(self, "dst_port_start")

    @dst_port_start.setter
    def dst_port_start(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "dst_port_start", value)

    @_builtins.property
    @pulumi.getter(name="matchAction")
    def match_action(self) -> pulumi.Input[_builtins.str]:
        """
        Action. Currently, only drop is supported.
        """
        return pulumi.get(self, "match_action")

    @match_action.setter
    def match_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match_action", value)

    @_builtins.property
    @pulumi.getter(name="maxPktLen")
    def max_pkt_len(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum bag length.
        """
        return pulumi.get(self, "max_pkt_len")

    @max_pkt_len.setter
    def max_pkt_len(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_pkt_len", value)

    @_builtins.property
    @pulumi.getter(name="minPktLen")
    def min_pkt_len(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum package length.
        """
        return pulumi.get(self, "min_pkt_len")

    @min_pkt_len.setter
    def min_pkt_len(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min_pkt_len", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol, tcp or udp.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="seqNo")
    def seq_no(self) -> pulumi.Input[_builtins.int]:
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        return pulumi.get(self, "seq_no")

    @seq_no.setter
    def seq_no(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "seq_no", value)

    @_builtins.property
    @pulumi.getter(name="srcPortEnd")
    def src_port_end(self) -> pulumi.Input[_builtins.int]:
        """
        Source Port end 0-65535.
        """
        return pulumi.get(self, "src_port_end")

    @src_port_end.setter
    def src_port_end(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "src_port_end", value)

    @_builtins.property
    @pulumi.getter(name="srcPortStart")
    def src_port_start(self) -> pulumi.Input[_builtins.int]:
        """
        Source port start 0-65535.
        """
        return pulumi.get(self, "src_port_start")

    @src_port_start.setter
    def src_port_start(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "src_port_start", value)

    @_builtins.property
    @pulumi.getter(name="fingerPrintRuleId")
    def finger_print_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the rule is required to be deleted and modified, and it is not required to be created.
        """
        return pulumi.get(self, "finger_print_rule_id")

    @finger_print_rule_id.setter
    def finger_print_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "finger_print_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Offset.
        """
        return pulumi.get(self, "offset")

    @offset.setter
    def offset(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "offset", value)

    @_builtins.property
    @pulumi.getter(name="payloadBytes")
    def payload_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Load match, hexadecimal string; Similar to 'abcd'.
        """
        return pulumi.get(self, "payload_bytes")

    @payload_bytes.setter
    def payload_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payload_bytes", value)

    @_builtins.property
    @pulumi.getter(name="rateValue")
    def rate_value(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Speed limit value 1-100000.
        """
        return pulumi.get(self, "rate_value")

    @rate_value.setter
    def rate_value(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rate_value", value)


if not MYPY:
    class BgpPolicyContentLayer4RuleListArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        1 for observation 2 for blocking.
        """
        condition_lists: pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListConditionListArgsDict']]]
        """
        Matching Condition. See `condition_list` below.
        """
        limited: pulumi.Input[_builtins.int]
        """
        .
        """
        match: pulumi.Input[_builtins.str]
        """
        0 indicates that the condition is not met 1 indicates that the condition is met.
        """
        method: pulumi.Input[_builtins.str]
        """
        Char indicates a string match hex match.
        """
        name: pulumi.Input[_builtins.str]
        """
        Rule Name.
        """
        priority: pulumi.Input[_builtins.int]
        """
        1-100, priority, the lower the number, the higher the priority.
        """
elif False:
    BgpPolicyContentLayer4RuleListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentLayer4RuleListArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 condition_lists: pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListConditionListArgs']]],
                 limited: pulumi.Input[_builtins.int],
                 match: pulumi.Input[_builtins.str],
                 method: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 priority: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] action: 1 for observation 2 for blocking.
        :param pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListConditionListArgs']]] condition_lists: Matching Condition. See `condition_list` below.
        :param pulumi.Input[_builtins.int] limited: .
        :param pulumi.Input[_builtins.str] match: 0 indicates that the condition is not met 1 indicates that the condition is met.
        :param pulumi.Input[_builtins.str] method: Char indicates a string match hex match.
        :param pulumi.Input[_builtins.str] name: Rule Name.
        :param pulumi.Input[_builtins.int] priority: 1-100, priority, the lower the number, the higher the priority.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition_lists", condition_lists)
        pulumi.set(__self__, "limited", limited)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        1 for observation 2 for blocking.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="conditionLists")
    def condition_lists(self) -> pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListConditionListArgs']]]:
        """
        Matching Condition. See `condition_list` below.
        """
        return pulumi.get(self, "condition_lists")

    @condition_lists.setter
    def condition_lists(self, value: pulumi.Input[Sequence[pulumi.Input['BgpPolicyContentLayer4RuleListConditionListArgs']]]):
        pulumi.set(self, "condition_lists", value)

    @_builtins.property
    @pulumi.getter
    def limited(self) -> pulumi.Input[_builtins.int]:
        """
        .
        """
        return pulumi.get(self, "limited")

    @limited.setter
    def limited(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "limited", value)

    @_builtins.property
    @pulumi.getter
    def match(self) -> pulumi.Input[_builtins.str]:
        """
        0 indicates that the condition is not met 1 indicates that the condition is met.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Input[_builtins.str]:
        """
        Char indicates a string match hex match.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Rule Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Input[_builtins.int]:
        """
        1-100, priority, the lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "priority", value)


if not MYPY:
    class BgpPolicyContentLayer4RuleListConditionListArgsDict(TypedDict):
        arg: pulumi.Input[_builtins.str]
        """
        Matching target character.
        """
        depth: pulumi.Input[_builtins.int]
        """
        Depth of Matching.
        """
        position: pulumi.Input[_builtins.int]
        """
        Position to start matching, starting from 0.
        """
elif False:
    BgpPolicyContentLayer4RuleListConditionListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentLayer4RuleListConditionListArgs:
    def __init__(__self__, *,
                 arg: pulumi.Input[_builtins.str],
                 depth: pulumi.Input[_builtins.int],
                 position: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] arg: Matching target character.
        :param pulumi.Input[_builtins.int] depth: Depth of Matching.
        :param pulumi.Input[_builtins.int] position: Position to start matching, starting from 0.
        """
        pulumi.set(__self__, "arg", arg)
        pulumi.set(__self__, "depth", depth)
        pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter
    def arg(self) -> pulumi.Input[_builtins.str]:
        """
        Matching target character.
        """
        return pulumi.get(self, "arg")

    @arg.setter
    def arg(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "arg", value)

    @_builtins.property
    @pulumi.getter
    def depth(self) -> pulumi.Input[_builtins.int]:
        """
        Depth of Matching.
        """
        return pulumi.get(self, "depth")

    @depth.setter
    def depth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "depth", value)

    @_builtins.property
    @pulumi.getter
    def position(self) -> pulumi.Input[_builtins.int]:
        """
        Position to start matching, starting from 0.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "position", value)


if not MYPY:
    class BgpPolicyContentPortRuleListArgsDict(TypedDict):
        dst_port_end: pulumi.Input[_builtins.int]
        """
        End of destination port 0-65535.
        """
        dst_port_start: pulumi.Input[_builtins.int]
        """
        Destination Port start 0-65535.
        """
        match_action: pulumi.Input[_builtins.str]
        """
        Action. Currently, only drop is supported.
        """
        protocol: pulumi.Input[_builtins.str]
        """
        Protocol, tcp or udp.
        """
        seq_no: pulumi.Input[_builtins.int]
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        src_port_end: pulumi.Input[_builtins.int]
        """
        Source Port end 0-65535.
        """
        src_port_start: pulumi.Input[_builtins.int]
        """
        Source port start 0-65535.
        """
        port_rule_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Rule UUID is required to be deleted and modified, and is not required to be created.
        """
elif False:
    BgpPolicyContentPortRuleListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentPortRuleListArgs:
    def __init__(__self__, *,
                 dst_port_end: pulumi.Input[_builtins.int],
                 dst_port_start: pulumi.Input[_builtins.int],
                 match_action: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 seq_no: pulumi.Input[_builtins.int],
                 src_port_end: pulumi.Input[_builtins.int],
                 src_port_start: pulumi.Input[_builtins.int],
                 port_rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] dst_port_end: End of destination port 0-65535.
        :param pulumi.Input[_builtins.int] dst_port_start: Destination Port start 0-65535.
        :param pulumi.Input[_builtins.str] match_action: Action. Currently, only drop is supported.
        :param pulumi.Input[_builtins.str] protocol: Protocol, tcp or udp.
        :param pulumi.Input[_builtins.int] seq_no: Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        :param pulumi.Input[_builtins.int] src_port_end: Source Port end 0-65535.
        :param pulumi.Input[_builtins.int] src_port_start: Source port start 0-65535.
        :param pulumi.Input[_builtins.str] port_rule_id: Rule UUID is required to be deleted and modified, and is not required to be created.
        """
        pulumi.set(__self__, "dst_port_end", dst_port_end)
        pulumi.set(__self__, "dst_port_start", dst_port_start)
        pulumi.set(__self__, "match_action", match_action)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "seq_no", seq_no)
        pulumi.set(__self__, "src_port_end", src_port_end)
        pulumi.set(__self__, "src_port_start", src_port_start)
        if port_rule_id is not None:
            pulumi.set(__self__, "port_rule_id", port_rule_id)

    @_builtins.property
    @pulumi.getter(name="dstPortEnd")
    def dst_port_end(self) -> pulumi.Input[_builtins.int]:
        """
        End of destination port 0-65535.
        """
        return pulumi.get(self, "dst_port_end")

    @dst_port_end.setter
    def dst_port_end(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "dst_port_end", value)

    @_builtins.property
    @pulumi.getter(name="dstPortStart")
    def dst_port_start(self) -> pulumi.Input[_builtins.int]:
        """
        Destination Port start 0-65535.
        """
        return pulumi.get(self, "dst_port_start")

    @dst_port_start.setter
    def dst_port_start(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "dst_port_start", value)

    @_builtins.property
    @pulumi.getter(name="matchAction")
    def match_action(self) -> pulumi.Input[_builtins.str]:
        """
        Action. Currently, only drop is supported.
        """
        return pulumi.get(self, "match_action")

    @match_action.setter
    def match_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "match_action", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol, tcp or udp.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="seqNo")
    def seq_no(self) -> pulumi.Input[_builtins.int]:
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        return pulumi.get(self, "seq_no")

    @seq_no.setter
    def seq_no(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "seq_no", value)

    @_builtins.property
    @pulumi.getter(name="srcPortEnd")
    def src_port_end(self) -> pulumi.Input[_builtins.int]:
        """
        Source Port end 0-65535.
        """
        return pulumi.get(self, "src_port_end")

    @src_port_end.setter
    def src_port_end(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "src_port_end", value)

    @_builtins.property
    @pulumi.getter(name="srcPortStart")
    def src_port_start(self) -> pulumi.Input[_builtins.int]:
        """
        Source port start 0-65535.
        """
        return pulumi.get(self, "src_port_start")

    @src_port_start.setter
    def src_port_start(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "src_port_start", value)

    @_builtins.property
    @pulumi.getter(name="portRuleId")
    def port_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rule UUID is required to be deleted and modified, and is not required to be created.
        """
        return pulumi.get(self, "port_rule_id")

    @port_rule_id.setter
    def port_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_rule_id", value)


if not MYPY:
    class BgpPolicyContentSourceBlockListArgsDict(TypedDict):
        block_expire_seconds: pulumi.Input[_builtins.int]
        """
        Statistical cycle range 60-1200.
        """
        every_seconds: pulumi.Input[_builtins.int]
        """
        The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
        """
        exceed_limit_times: pulumi.Input[_builtins.int]
        """
        The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
        """
        type: pulumi.Input[_builtins.int]
        """
        Type
        """
elif False:
    BgpPolicyContentSourceBlockListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentSourceBlockListArgs:
    def __init__(__self__, *,
                 block_expire_seconds: pulumi.Input[_builtins.int],
                 every_seconds: pulumi.Input[_builtins.int],
                 exceed_limit_times: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] block_expire_seconds: Statistical cycle range 60-1200.
        :param pulumi.Input[_builtins.int] every_seconds: The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
        :param pulumi.Input[_builtins.int] exceed_limit_times: The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
        :param pulumi.Input[_builtins.int] type: Type
        """
        pulumi.set(__self__, "block_expire_seconds", block_expire_seconds)
        pulumi.set(__self__, "every_seconds", every_seconds)
        pulumi.set(__self__, "exceed_limit_times", exceed_limit_times)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="blockExpireSeconds")
    def block_expire_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        Statistical cycle range 60-1200.
        """
        return pulumi.get(self, "block_expire_seconds")

    @block_expire_seconds.setter
    def block_expire_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "block_expire_seconds", value)

    @_builtins.property
    @pulumi.getter(name="everySeconds")
    def every_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
        """
        return pulumi.get(self, "every_seconds")

    @every_seconds.setter
    def every_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "every_seconds", value)

    @_builtins.property
    @pulumi.getter(name="exceedLimitTimes")
    def exceed_limit_times(self) -> pulumi.Input[_builtins.int]:
        """
        The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
        """
        return pulumi.get(self, "exceed_limit_times")

    @exceed_limit_times.setter
    def exceed_limit_times(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "exceed_limit_times", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.int]:
        """
        Type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "type", value)


if not MYPY:
    class BgpPolicyContentSourceLimitArgsDict(TypedDict):
        bps: NotRequired[pulumi.Input[_builtins.int]]
        """
        bps range 1024~268435456.
        """
        pps: NotRequired[pulumi.Input[_builtins.int]]
        """
        Pps range 32~500000.
        """
        syn_bps: NotRequired[pulumi.Input[_builtins.int]]
        """
        SynBps range 1024~268435456.
        """
        syn_pps: NotRequired[pulumi.Input[_builtins.int]]
        """
        SynPps range 1~100000.
        """
elif False:
    BgpPolicyContentSourceLimitArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BgpPolicyContentSourceLimitArgs:
    def __init__(__self__, *,
                 bps: Optional[pulumi.Input[_builtins.int]] = None,
                 pps: Optional[pulumi.Input[_builtins.int]] = None,
                 syn_bps: Optional[pulumi.Input[_builtins.int]] = None,
                 syn_pps: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] bps: bps range 1024~268435456.
        :param pulumi.Input[_builtins.int] pps: Pps range 32~500000.
        :param pulumi.Input[_builtins.int] syn_bps: SynBps range 1024~268435456.
        :param pulumi.Input[_builtins.int] syn_pps: SynPps range 1~100000.
        """
        if bps is not None:
            pulumi.set(__self__, "bps", bps)
        if pps is not None:
            pulumi.set(__self__, "pps", pps)
        if syn_bps is not None:
            pulumi.set(__self__, "syn_bps", syn_bps)
        if syn_pps is not None:
            pulumi.set(__self__, "syn_pps", syn_pps)

    @_builtins.property
    @pulumi.getter
    def bps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        bps range 1024~268435456.
        """
        return pulumi.get(self, "bps")

    @bps.setter
    def bps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bps", value)

    @_builtins.property
    @pulumi.getter
    def pps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Pps range 32~500000.
        """
        return pulumi.get(self, "pps")

    @pps.setter
    def pps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pps", value)

    @_builtins.property
    @pulumi.getter(name="synBps")
    def syn_bps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        SynBps range 1024~268435456.
        """
        return pulumi.get(self, "syn_bps")

    @syn_bps.setter
    def syn_bps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "syn_bps", value)

    @_builtins.property
    @pulumi.getter(name="synPps")
    def syn_pps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        SynPps range 1~100000.
        """
        return pulumi.get(self, "syn_pps")

    @syn_pps.setter
    def syn_pps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "syn_pps", value)


if not MYPY:
    class DomainResourceProxyTypeArgsDict(TypedDict):
        proxy_ports: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]
        """
        The port numbers.
        """
        proxy_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the protocol. Valid values:
        """
elif False:
    DomainResourceProxyTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DomainResourceProxyTypeArgs:
    def __init__(__self__, *,
                 proxy_ports: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]],
                 proxy_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.int]]] proxy_ports: The port numbers.
        :param pulumi.Input[_builtins.str] proxy_type: The type of the protocol. Valid values:
        """
        pulumi.set(__self__, "proxy_ports", proxy_ports)
        if proxy_type is not None:
            pulumi.set(__self__, "proxy_type", proxy_type)

    @_builtins.property
    @pulumi.getter(name="proxyPorts")
    def proxy_ports(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]:
        """
        The port numbers.
        """
        return pulumi.get(self, "proxy_ports")

    @proxy_ports.setter
    def proxy_ports(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]):
        pulumi.set(self, "proxy_ports", value)

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the protocol. Valid values:
        """
        return pulumi.get(self, "proxy_type")

    @proxy_type.setter
    def proxy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_type", value)


if not MYPY:
    class PortConfigArgsDict(TypedDict):
        persistence_timeout: NotRequired[pulumi.Input[_builtins.int]]
        """
        The timeout period for session retention. Value range: 30~3600, unit: second. The default is 0, which means off.
        """
elif False:
    PortConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PortConfigArgs:
    def __init__(__self__, *,
                 persistence_timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] persistence_timeout: The timeout period for session retention. Value range: 30~3600, unit: second. The default is 0, which means off.
        """
        if persistence_timeout is not None:
            pulumi.set(__self__, "persistence_timeout", persistence_timeout)

    @_builtins.property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout period for session retention. Value range: 30~3600, unit: second. The default is 0, which means off.
        """
        return pulumi.get(self, "persistence_timeout")

    @persistence_timeout.setter
    def persistence_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "persistence_timeout", value)


if not MYPY:
    class SchedulerRuleRuleArgsDict(TypedDict):
        priority: NotRequired[pulumi.Input[_builtins.int]]
        """
        The priority of the rule.
        """
        region_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
        """
        status: NotRequired[pulumi.Input[_builtins.int]]
        """
        The status of the scheduling rule.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The address type of the interaction resource. Valid values:
        `A`: IPv4 address.
        `CNAME`: CNAME record.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The address of the interaction resource.
        """
        value_type: NotRequired[pulumi.Input[_builtins.int]]
        """
        Required. The type of the linked resource. It is an Integer. Valid values:
        `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
        `2`: the IP address of the interaction resource (in the tiered protection scenario)
        `3`: the IP address used to accelerate access (in the network acceleration scenario)
        `6` the IP address of the interaction resource (in the cloud service interaction scenario)
        """
elif False:
    SchedulerRuleRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchedulerRuleRuleArgs:
    def __init__(__self__, *,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_type: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] priority: The priority of the rule.
        :param pulumi.Input[_builtins.str] region_id: The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
        :param pulumi.Input[_builtins.int] status: The status of the scheduling rule.
        :param pulumi.Input[_builtins.str] type: The address type of the interaction resource. Valid values:
               `A`: IPv4 address.
               `CNAME`: CNAME record.
        :param pulumi.Input[_builtins.str] value: The address of the interaction resource.
        :param pulumi.Input[_builtins.int] value_type: Required. The type of the linked resource. It is an Integer. Valid values:
               `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
               `2`: the IP address of the interaction resource (in the tiered protection scenario)
               `3`: the IP address used to accelerate access (in the network acceleration scenario)
               `6` the IP address of the interaction resource (in the cloud service interaction scenario)
        """
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The status of the scheduling rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address type of the interaction resource. Valid values:
        `A`: IPv4 address.
        `CNAME`: CNAME record.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the interaction resource.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Required. The type of the linked resource. It is an Integer. Valid values:
        `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
        `2`: the IP address of the interaction resource (in the tiered protection scenario)
        `3`: the IP address used to accelerate access (in the network acceleration scenario)
        `6` the IP address of the interaction resource (in the cloud service interaction scenario)
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "value_type", value)


