# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DdosBgpInstanceArgs', 'DdosBgpInstance']

@pulumi.input_type
class DdosBgpInstanceArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[_builtins.int],
                 ip_count: pulumi.Input[_builtins.int],
                 ip_type: pulumi.Input[_builtins.str],
                 normal_bandwidth: pulumi.Input[_builtins.int],
                 base_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DdosBgpInstance resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the package configuration.
        :param pulumi.Input[_builtins.int] ip_count: The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        :param pulumi.Input[_builtins.str] ip_type: The protection IP address type of the protection package. Valid values:
               - `IPv4`
               - `IPv6`
        :param pulumi.Input[_builtins.int] normal_bandwidth: The normal clean bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.int] base_bandwidth: The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key of the tag that is added to the Anti-DDoS Origin instance.
        :param pulumi.Input[_builtins.str] type: The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "ip_count", ip_count)
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The bandwidth of the package configuration.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="ipCount")
    def ip_count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        """
        return pulumi.get(self, "ip_count")

    @ip_count.setter
    def ip_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ip_count", value)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Input[_builtins.str]:
        """
        The protection IP address type of the protection package. Valid values:
        - `IPv4`
        - `IPv6`
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_type", value)

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> pulumi.Input[_builtins.int]:
        """
        The normal clean bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "normal_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key of the tag that is added to the Anti-DDoS Origin instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _DdosBgpInstanceState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DdosBgpInstance resources.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the package configuration.
        :param pulumi.Input[_builtins.int] base_bandwidth: The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.int] ip_count: The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        :param pulumi.Input[_builtins.str] ip_type: The protection IP address type of the protection package. Valid values:
               - `IPv4`
               - `IPv6`
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        :param pulumi.Input[_builtins.int] normal_bandwidth: The normal clean bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID
        :param pulumi.Input[_builtins.str] status: (Available since v1.259.0) The status of the Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key of the tag that is added to the Anti-DDoS Origin instance.
        :param pulumi.Input[_builtins.str] type: The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if base_bandwidth is not None:
            pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if ip_count is not None:
            pulumi.set(__self__, "ip_count", ip_count)
        if ip_type is not None:
            pulumi.set(__self__, "ip_type", ip_type)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if normal_bandwidth is not None:
            pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth of the package configuration.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        """
        return pulumi.get(self, "base_bandwidth")

    @base_bandwidth.setter
    def base_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "base_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="ipCount")
    def ip_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        """
        return pulumi.get(self, "ip_count")

    @ip_count.setter
    def ip_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_count", value)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection IP address type of the protection package. Valid values:
        - `IPv4`
        - `IPv6`
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The normal clean bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "normal_bandwidth")

    @normal_bandwidth.setter
    def normal_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "normal_bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Group ID
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.259.0) The status of the Instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key of the tag that is added to the Anti-DDoS Origin instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("alicloud:ddos/ddosBgpInstance:DdosBgpInstance")
class DdosBgpInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Anti-DDoS Pro (DdosBgp) Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/ddosBgpInstance:DdosBgpInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the package configuration.
        :param pulumi.Input[_builtins.int] base_bandwidth: The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.int] ip_count: The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        :param pulumi.Input[_builtins.str] ip_type: The protection IP address type of the protection package. Valid values:
               - `IPv4`
               - `IPv6`
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        :param pulumi.Input[_builtins.int] normal_bandwidth: The normal clean bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key of the tag that is added to the Anti-DDoS Origin instance.
        :param pulumi.Input[_builtins.str] type: The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdosBgpInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Anti-DDoS Pro (DdosBgp) Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ddos/ddosBgpInstance:DdosBgpInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DdosBgpInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdosBgpInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 base_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_count: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 normal_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdosBgpInstanceArgs.__new__(DdosBgpInstanceArgs)

            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["base_bandwidth"] = base_bandwidth
            __props__.__dict__["instance_name"] = instance_name
            if ip_count is None and not opts.urn:
                raise TypeError("Missing required property 'ip_count'")
            __props__.__dict__["ip_count"] = ip_count
            if ip_type is None and not opts.urn:
                raise TypeError("Missing required property 'ip_type'")
            __props__.__dict__["ip_type"] = ip_type
            __props__.__dict__["name"] = name
            if normal_bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'normal_bandwidth'")
            __props__.__dict__["normal_bandwidth"] = normal_bandwidth
            __props__.__dict__["period"] = period
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="alicloud:dns/ddosBgpInstance:DdosBgpInstance")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(DdosBgpInstance, __self__).__init__(
            'alicloud:ddos/ddosBgpInstance:DdosBgpInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            base_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            ip_count: Optional[pulumi.Input[_builtins.int]] = None,
            ip_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            normal_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'DdosBgpInstance':
        """
        Get an existing DdosBgpInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] bandwidth: The bandwidth of the package configuration.
        :param pulumi.Input[_builtins.int] base_bandwidth: The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        :param pulumi.Input[_builtins.str] instance_name: The name of the instance.
        :param pulumi.Input[_builtins.int] ip_count: The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        :param pulumi.Input[_builtins.str] ip_type: The protection IP address type of the protection package. Valid values:
               - `IPv4`
               - `IPv6`
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        :param pulumi.Input[_builtins.int] normal_bandwidth: The normal clean bandwidth. Unit: Mbit/s.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        :param pulumi.Input[_builtins.str] resource_group_id: Resource Group ID
        :param pulumi.Input[_builtins.str] status: (Available since v1.259.0) The status of the Instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key of the tag that is added to the Anti-DDoS Origin instance.
        :param pulumi.Input[_builtins.str] type: The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdosBgpInstanceState.__new__(_DdosBgpInstanceState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["base_bandwidth"] = base_bandwidth
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["ip_count"] = ip_count
        __props__.__dict__["ip_type"] = ip_type
        __props__.__dict__["name"] = name
        __props__.__dict__["normal_bandwidth"] = normal_bandwidth
        __props__.__dict__["period"] = period
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return DdosBgpInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth of the package configuration.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The basic protection bandwidth of the Anti-DDoS Origin Enterprise instance. Default value: `20`. Valid values: `20`.
        """
        return pulumi.get(self, "base_bandwidth")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="ipCount")
    def ip_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IP addresses that can be protected by the Anti-DDoS Origin Enterprise instance.
        """
        return pulumi.get(self, "ip_count")

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Output[_builtins.str]:
        """
        The protection IP address type of the protection package. Valid values:
        - `IPv4`
        - `IPv6`
        """
        return pulumi.get(self, "ip_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.259.0. New field `instance_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> pulumi.Output[_builtins.int]:
        """
        The normal clean bandwidth. Unit: Mbit/s.
        """
        return pulumi.get(self, "normal_bandwidth")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy Ddosbgp instance (in month). Valid values: [1~9], 12, 24, 36. Default to 12. At present, the provider does not support modify "period".
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Group ID
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.259.0) The status of the Instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key of the tag that is added to the Anti-DDoS Origin instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The protection package type of the DDoS native protection instance. Default value: `Enterprise`. Valid values: `Enterprise`, `Professional`.
        """
        return pulumi.get(self, "type")

