# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BgpPolicyContent',
    'BgpPolicyContentFingerPrintRuleList',
    'BgpPolicyContentLayer4RuleList',
    'BgpPolicyContentLayer4RuleListConditionList',
    'BgpPolicyContentPortRuleList',
    'BgpPolicyContentSourceBlockList',
    'BgpPolicyContentSourceLimit',
    'DomainResourceProxyType',
    'PortConfig',
    'SchedulerRuleRule',
    'GetDdosBgpInstancesInstanceResult',
    'GetDdosBgpIpsIpResult',
    'GetDdosCooDomainResourcesResourceResult',
    'GetDdosCooDomainResourcesResourceProxyTypeResult',
    'GetDdosCooInstancesInstanceResult',
    'GetDdosCooPortsPortResult',
]

@pulumi.output_type
class BgpPolicyContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blackIpListExpireAt":
            suggest = "black_ip_list_expire_at"
        elif key == "enableDefense":
            suggest = "enable_defense"
        elif key == "enableDropIcmp":
            suggest = "enable_drop_icmp"
        elif key == "enableIntelligence":
            suggest = "enable_intelligence"
        elif key == "fingerPrintRuleLists":
            suggest = "finger_print_rule_lists"
        elif key == "intelligenceLevel":
            suggest = "intelligence_level"
        elif key == "layer4RuleLists":
            suggest = "layer4_rule_lists"
        elif key == "portRuleLists":
            suggest = "port_rule_lists"
        elif key == "reflectBlockUdpPortLists":
            suggest = "reflect_block_udp_port_lists"
        elif key == "regionBlockCountryLists":
            suggest = "region_block_country_lists"
        elif key == "regionBlockProvinceLists":
            suggest = "region_block_province_lists"
        elif key == "sourceBlockLists":
            suggest = "source_block_lists"
        elif key == "sourceLimit":
            suggest = "source_limit"
        elif key == "whitenGfbrNets":
            suggest = "whiten_gfbr_nets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 black_ip_list_expire_at: Optional[_builtins.int] = None,
                 enable_defense: Optional[_builtins.bool] = None,
                 enable_drop_icmp: Optional[_builtins.bool] = None,
                 enable_intelligence: Optional[_builtins.bool] = None,
                 finger_print_rule_lists: Optional[Sequence['outputs.BgpPolicyContentFingerPrintRuleList']] = None,
                 intelligence_level: Optional[_builtins.str] = None,
                 layer4_rule_lists: Optional[Sequence['outputs.BgpPolicyContentLayer4RuleList']] = None,
                 port_rule_lists: Optional[Sequence['outputs.BgpPolicyContentPortRuleList']] = None,
                 reflect_block_udp_port_lists: Optional[Sequence[_builtins.int]] = None,
                 region_block_country_lists: Optional[Sequence[_builtins.int]] = None,
                 region_block_province_lists: Optional[Sequence[_builtins.int]] = None,
                 source_block_lists: Optional[Sequence['outputs.BgpPolicyContentSourceBlockList']] = None,
                 source_limit: Optional['outputs.BgpPolicyContentSourceLimit'] = None,
                 whiten_gfbr_nets: Optional[_builtins.bool] = None):
        """
        :param _builtins.int black_ip_list_expire_at: Blacklist and whitelist timeout.
        :param _builtins.bool enable_defense: Whether to enable L4 protection.
        :param _builtins.bool enable_drop_icmp: Switch to discard ICMP.
        :param _builtins.bool enable_intelligence: Whether the intelligent switch is on.
        :param Sequence['BgpPolicyContentFingerPrintRuleListArgs'] finger_print_rule_lists: Fingerprint Rules. See `finger_print_rule_list` below.
        :param _builtins.str intelligence_level: Smart mode. Valid values: weak, hard, and default.
        :param Sequence['BgpPolicyContentLayer4RuleListArgs'] layer4_rule_lists: L4 protection rules. See `layer4_rule_list` below.
        :param Sequence['BgpPolicyContentPortRuleListArgs'] port_rule_lists: Port Rule List. See `port_rule_list` below.
        :param Sequence[_builtins.int] reflect_block_udp_port_lists: Reflective port filtering.
        :param Sequence[_builtins.int] region_block_country_lists: List of Regional Banned Countries.
        :param Sequence[_builtins.int] region_block_province_lists: List of Prohibited Provinces by Region.
        :param Sequence['BgpPolicyContentSourceBlockListArgs'] source_block_lists: Source pull Black. See `source_block_list` below.
        :param 'BgpPolicyContentSourceLimitArgs' source_limit: Do not fill in when the source speed limit is deleted. See `source_limit` below.
        :param _builtins.bool whiten_gfbr_nets: Add white high protection back to source network segment switch.
        """
        if black_ip_list_expire_at is not None:
            pulumi.set(__self__, "black_ip_list_expire_at", black_ip_list_expire_at)
        if enable_defense is not None:
            pulumi.set(__self__, "enable_defense", enable_defense)
        if enable_drop_icmp is not None:
            pulumi.set(__self__, "enable_drop_icmp", enable_drop_icmp)
        if enable_intelligence is not None:
            pulumi.set(__self__, "enable_intelligence", enable_intelligence)
        if finger_print_rule_lists is not None:
            pulumi.set(__self__, "finger_print_rule_lists", finger_print_rule_lists)
        if intelligence_level is not None:
            pulumi.set(__self__, "intelligence_level", intelligence_level)
        if layer4_rule_lists is not None:
            pulumi.set(__self__, "layer4_rule_lists", layer4_rule_lists)
        if port_rule_lists is not None:
            pulumi.set(__self__, "port_rule_lists", port_rule_lists)
        if reflect_block_udp_port_lists is not None:
            pulumi.set(__self__, "reflect_block_udp_port_lists", reflect_block_udp_port_lists)
        if region_block_country_lists is not None:
            pulumi.set(__self__, "region_block_country_lists", region_block_country_lists)
        if region_block_province_lists is not None:
            pulumi.set(__self__, "region_block_province_lists", region_block_province_lists)
        if source_block_lists is not None:
            pulumi.set(__self__, "source_block_lists", source_block_lists)
        if source_limit is not None:
            pulumi.set(__self__, "source_limit", source_limit)
        if whiten_gfbr_nets is not None:
            pulumi.set(__self__, "whiten_gfbr_nets", whiten_gfbr_nets)

    @_builtins.property
    @pulumi.getter(name="blackIpListExpireAt")
    def black_ip_list_expire_at(self) -> Optional[_builtins.int]:
        """
        Blacklist and whitelist timeout.
        """
        return pulumi.get(self, "black_ip_list_expire_at")

    @_builtins.property
    @pulumi.getter(name="enableDefense")
    def enable_defense(self) -> Optional[_builtins.bool]:
        """
        Whether to enable L4 protection.
        """
        return pulumi.get(self, "enable_defense")

    @_builtins.property
    @pulumi.getter(name="enableDropIcmp")
    def enable_drop_icmp(self) -> Optional[_builtins.bool]:
        """
        Switch to discard ICMP.
        """
        return pulumi.get(self, "enable_drop_icmp")

    @_builtins.property
    @pulumi.getter(name="enableIntelligence")
    def enable_intelligence(self) -> Optional[_builtins.bool]:
        """
        Whether the intelligent switch is on.
        """
        return pulumi.get(self, "enable_intelligence")

    @_builtins.property
    @pulumi.getter(name="fingerPrintRuleLists")
    def finger_print_rule_lists(self) -> Optional[Sequence['outputs.BgpPolicyContentFingerPrintRuleList']]:
        """
        Fingerprint Rules. See `finger_print_rule_list` below.
        """
        return pulumi.get(self, "finger_print_rule_lists")

    @_builtins.property
    @pulumi.getter(name="intelligenceLevel")
    def intelligence_level(self) -> Optional[_builtins.str]:
        """
        Smart mode. Valid values: weak, hard, and default.
        """
        return pulumi.get(self, "intelligence_level")

    @_builtins.property
    @pulumi.getter(name="layer4RuleLists")
    def layer4_rule_lists(self) -> Optional[Sequence['outputs.BgpPolicyContentLayer4RuleList']]:
        """
        L4 protection rules. See `layer4_rule_list` below.
        """
        return pulumi.get(self, "layer4_rule_lists")

    @_builtins.property
    @pulumi.getter(name="portRuleLists")
    def port_rule_lists(self) -> Optional[Sequence['outputs.BgpPolicyContentPortRuleList']]:
        """
        Port Rule List. See `port_rule_list` below.
        """
        return pulumi.get(self, "port_rule_lists")

    @_builtins.property
    @pulumi.getter(name="reflectBlockUdpPortLists")
    def reflect_block_udp_port_lists(self) -> Optional[Sequence[_builtins.int]]:
        """
        Reflective port filtering.
        """
        return pulumi.get(self, "reflect_block_udp_port_lists")

    @_builtins.property
    @pulumi.getter(name="regionBlockCountryLists")
    def region_block_country_lists(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of Regional Banned Countries.
        """
        return pulumi.get(self, "region_block_country_lists")

    @_builtins.property
    @pulumi.getter(name="regionBlockProvinceLists")
    def region_block_province_lists(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of Prohibited Provinces by Region.
        """
        return pulumi.get(self, "region_block_province_lists")

    @_builtins.property
    @pulumi.getter(name="sourceBlockLists")
    def source_block_lists(self) -> Optional[Sequence['outputs.BgpPolicyContentSourceBlockList']]:
        """
        Source pull Black. See `source_block_list` below.
        """
        return pulumi.get(self, "source_block_lists")

    @_builtins.property
    @pulumi.getter(name="sourceLimit")
    def source_limit(self) -> Optional['outputs.BgpPolicyContentSourceLimit']:
        """
        Do not fill in when the source speed limit is deleted. See `source_limit` below.
        """
        return pulumi.get(self, "source_limit")

    @_builtins.property
    @pulumi.getter(name="whitenGfbrNets")
    def whiten_gfbr_nets(self) -> Optional[_builtins.bool]:
        """
        Add white high protection back to source network segment switch.
        """
        return pulumi.get(self, "whiten_gfbr_nets")


@pulumi.output_type
class BgpPolicyContentFingerPrintRuleList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dstPortEnd":
            suggest = "dst_port_end"
        elif key == "dstPortStart":
            suggest = "dst_port_start"
        elif key == "matchAction":
            suggest = "match_action"
        elif key == "maxPktLen":
            suggest = "max_pkt_len"
        elif key == "minPktLen":
            suggest = "min_pkt_len"
        elif key == "seqNo":
            suggest = "seq_no"
        elif key == "srcPortEnd":
            suggest = "src_port_end"
        elif key == "srcPortStart":
            suggest = "src_port_start"
        elif key == "fingerPrintRuleId":
            suggest = "finger_print_rule_id"
        elif key == "payloadBytes":
            suggest = "payload_bytes"
        elif key == "rateValue":
            suggest = "rate_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContentFingerPrintRuleList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContentFingerPrintRuleList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContentFingerPrintRuleList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dst_port_end: _builtins.int,
                 dst_port_start: _builtins.int,
                 match_action: _builtins.str,
                 max_pkt_len: _builtins.int,
                 min_pkt_len: _builtins.int,
                 protocol: _builtins.str,
                 seq_no: _builtins.int,
                 src_port_end: _builtins.int,
                 src_port_start: _builtins.int,
                 finger_print_rule_id: Optional[_builtins.str] = None,
                 offset: Optional[_builtins.int] = None,
                 payload_bytes: Optional[_builtins.str] = None,
                 rate_value: Optional[_builtins.int] = None):
        """
        :param _builtins.int dst_port_end: End of destination port 0-65535.
        :param _builtins.int dst_port_start: Destination Port start 0-65535.
        :param _builtins.str match_action: Action. Currently, only drop is supported.
        :param _builtins.int max_pkt_len: Maximum bag length.
        :param _builtins.int min_pkt_len: Minimum package length.
        :param _builtins.str protocol: Protocol, tcp or udp.
        :param _builtins.int seq_no: Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        :param _builtins.int src_port_end: Source Port end 0-65535.
        :param _builtins.int src_port_start: Source port start 0-65535.
        :param _builtins.str finger_print_rule_id: The UUID of the rule is required to be deleted and modified, and it is not required to be created.
        :param _builtins.int offset: Offset.
        :param _builtins.str payload_bytes: Load match, hexadecimal string; Similar to 'abcd'.
        :param _builtins.int rate_value: Speed limit value 1-100000.
        """
        pulumi.set(__self__, "dst_port_end", dst_port_end)
        pulumi.set(__self__, "dst_port_start", dst_port_start)
        pulumi.set(__self__, "match_action", match_action)
        pulumi.set(__self__, "max_pkt_len", max_pkt_len)
        pulumi.set(__self__, "min_pkt_len", min_pkt_len)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "seq_no", seq_no)
        pulumi.set(__self__, "src_port_end", src_port_end)
        pulumi.set(__self__, "src_port_start", src_port_start)
        if finger_print_rule_id is not None:
            pulumi.set(__self__, "finger_print_rule_id", finger_print_rule_id)
        if offset is not None:
            pulumi.set(__self__, "offset", offset)
        if payload_bytes is not None:
            pulumi.set(__self__, "payload_bytes", payload_bytes)
        if rate_value is not None:
            pulumi.set(__self__, "rate_value", rate_value)

    @_builtins.property
    @pulumi.getter(name="dstPortEnd")
    def dst_port_end(self) -> _builtins.int:
        """
        End of destination port 0-65535.
        """
        return pulumi.get(self, "dst_port_end")

    @_builtins.property
    @pulumi.getter(name="dstPortStart")
    def dst_port_start(self) -> _builtins.int:
        """
        Destination Port start 0-65535.
        """
        return pulumi.get(self, "dst_port_start")

    @_builtins.property
    @pulumi.getter(name="matchAction")
    def match_action(self) -> _builtins.str:
        """
        Action. Currently, only drop is supported.
        """
        return pulumi.get(self, "match_action")

    @_builtins.property
    @pulumi.getter(name="maxPktLen")
    def max_pkt_len(self) -> _builtins.int:
        """
        Maximum bag length.
        """
        return pulumi.get(self, "max_pkt_len")

    @_builtins.property
    @pulumi.getter(name="minPktLen")
    def min_pkt_len(self) -> _builtins.int:
        """
        Minimum package length.
        """
        return pulumi.get(self, "min_pkt_len")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol, tcp or udp.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="seqNo")
    def seq_no(self) -> _builtins.int:
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        return pulumi.get(self, "seq_no")

    @_builtins.property
    @pulumi.getter(name="srcPortEnd")
    def src_port_end(self) -> _builtins.int:
        """
        Source Port end 0-65535.
        """
        return pulumi.get(self, "src_port_end")

    @_builtins.property
    @pulumi.getter(name="srcPortStart")
    def src_port_start(self) -> _builtins.int:
        """
        Source port start 0-65535.
        """
        return pulumi.get(self, "src_port_start")

    @_builtins.property
    @pulumi.getter(name="fingerPrintRuleId")
    def finger_print_rule_id(self) -> Optional[_builtins.str]:
        """
        The UUID of the rule is required to be deleted and modified, and it is not required to be created.
        """
        return pulumi.get(self, "finger_print_rule_id")

    @_builtins.property
    @pulumi.getter
    def offset(self) -> Optional[_builtins.int]:
        """
        Offset.
        """
        return pulumi.get(self, "offset")

    @_builtins.property
    @pulumi.getter(name="payloadBytes")
    def payload_bytes(self) -> Optional[_builtins.str]:
        """
        Load match, hexadecimal string; Similar to 'abcd'.
        """
        return pulumi.get(self, "payload_bytes")

    @_builtins.property
    @pulumi.getter(name="rateValue")
    def rate_value(self) -> Optional[_builtins.int]:
        """
        Speed limit value 1-100000.
        """
        return pulumi.get(self, "rate_value")


@pulumi.output_type
class BgpPolicyContentLayer4RuleList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionLists":
            suggest = "condition_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContentLayer4RuleList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContentLayer4RuleList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContentLayer4RuleList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: _builtins.str,
                 condition_lists: Sequence['outputs.BgpPolicyContentLayer4RuleListConditionList'],
                 limited: _builtins.int,
                 match: _builtins.str,
                 method: _builtins.str,
                 name: _builtins.str,
                 priority: _builtins.int):
        """
        :param _builtins.str action: 1 for observation 2 for blocking.
        :param Sequence['BgpPolicyContentLayer4RuleListConditionListArgs'] condition_lists: Matching Condition. See `condition_list` below.
        :param _builtins.int limited: .
        :param _builtins.str match: 0 indicates that the condition is not met 1 indicates that the condition is met.
        :param _builtins.str method: Char indicates a string match hex match.
        :param _builtins.str name: Rule Name.
        :param _builtins.int priority: 1-100, priority, the lower the number, the higher the priority.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition_lists", condition_lists)
        pulumi.set(__self__, "limited", limited)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        1 for observation 2 for blocking.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="conditionLists")
    def condition_lists(self) -> Sequence['outputs.BgpPolicyContentLayer4RuleListConditionList']:
        """
        Matching Condition. See `condition_list` below.
        """
        return pulumi.get(self, "condition_lists")

    @_builtins.property
    @pulumi.getter
    def limited(self) -> _builtins.int:
        """
        .
        """
        return pulumi.get(self, "limited")

    @_builtins.property
    @pulumi.getter
    def match(self) -> _builtins.str:
        """
        0 indicates that the condition is not met 1 indicates that the condition is met.
        """
        return pulumi.get(self, "match")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Char indicates a string match hex match.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Rule Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        1-100, priority, the lower the number, the higher the priority.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class BgpPolicyContentLayer4RuleListConditionList(dict):
    def __init__(__self__, *,
                 arg: _builtins.str,
                 depth: _builtins.int,
                 position: _builtins.int):
        """
        :param _builtins.str arg: Matching target character.
        :param _builtins.int depth: Depth of Matching.
        :param _builtins.int position: Position to start matching, starting from 0.
        """
        pulumi.set(__self__, "arg", arg)
        pulumi.set(__self__, "depth", depth)
        pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter
    def arg(self) -> _builtins.str:
        """
        Matching target character.
        """
        return pulumi.get(self, "arg")

    @_builtins.property
    @pulumi.getter
    def depth(self) -> _builtins.int:
        """
        Depth of Matching.
        """
        return pulumi.get(self, "depth")

    @_builtins.property
    @pulumi.getter
    def position(self) -> _builtins.int:
        """
        Position to start matching, starting from 0.
        """
        return pulumi.get(self, "position")


@pulumi.output_type
class BgpPolicyContentPortRuleList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dstPortEnd":
            suggest = "dst_port_end"
        elif key == "dstPortStart":
            suggest = "dst_port_start"
        elif key == "matchAction":
            suggest = "match_action"
        elif key == "seqNo":
            suggest = "seq_no"
        elif key == "srcPortEnd":
            suggest = "src_port_end"
        elif key == "srcPortStart":
            suggest = "src_port_start"
        elif key == "portRuleId":
            suggest = "port_rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContentPortRuleList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContentPortRuleList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContentPortRuleList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dst_port_end: _builtins.int,
                 dst_port_start: _builtins.int,
                 match_action: _builtins.str,
                 protocol: _builtins.str,
                 seq_no: _builtins.int,
                 src_port_end: _builtins.int,
                 src_port_start: _builtins.int,
                 port_rule_id: Optional[_builtins.str] = None):
        """
        :param _builtins.int dst_port_end: End of destination port 0-65535.
        :param _builtins.int dst_port_start: Destination Port start 0-65535.
        :param _builtins.str match_action: Action. Currently, only drop is supported.
        :param _builtins.str protocol: Protocol, tcp or udp.
        :param _builtins.int seq_no: Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        :param _builtins.int src_port_end: Source Port end 0-65535.
        :param _builtins.int src_port_start: Source port start 0-65535.
        :param _builtins.str port_rule_id: Rule UUID is required to be deleted and modified, and is not required to be created.
        """
        pulumi.set(__self__, "dst_port_end", dst_port_end)
        pulumi.set(__self__, "dst_port_start", dst_port_start)
        pulumi.set(__self__, "match_action", match_action)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "seq_no", seq_no)
        pulumi.set(__self__, "src_port_end", src_port_end)
        pulumi.set(__self__, "src_port_start", src_port_start)
        if port_rule_id is not None:
            pulumi.set(__self__, "port_rule_id", port_rule_id)

    @_builtins.property
    @pulumi.getter(name="dstPortEnd")
    def dst_port_end(self) -> _builtins.int:
        """
        End of destination port 0-65535.
        """
        return pulumi.get(self, "dst_port_end")

    @_builtins.property
    @pulumi.getter(name="dstPortStart")
    def dst_port_start(self) -> _builtins.int:
        """
        Destination Port start 0-65535.
        """
        return pulumi.get(self, "dst_port_start")

    @_builtins.property
    @pulumi.getter(name="matchAction")
    def match_action(self) -> _builtins.str:
        """
        Action. Currently, only drop is supported.
        """
        return pulumi.get(self, "match_action")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Protocol, tcp or udp.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="seqNo")
    def seq_no(self) -> _builtins.int:
        """
        Serial number 1-100 ● Affects the order issued by the bottom layer ● The larger the number, the lower it is.
        """
        return pulumi.get(self, "seq_no")

    @_builtins.property
    @pulumi.getter(name="srcPortEnd")
    def src_port_end(self) -> _builtins.int:
        """
        Source Port end 0-65535.
        """
        return pulumi.get(self, "src_port_end")

    @_builtins.property
    @pulumi.getter(name="srcPortStart")
    def src_port_start(self) -> _builtins.int:
        """
        Source port start 0-65535.
        """
        return pulumi.get(self, "src_port_start")

    @_builtins.property
    @pulumi.getter(name="portRuleId")
    def port_rule_id(self) -> Optional[_builtins.str]:
        """
        Rule UUID is required to be deleted and modified, and is not required to be created.
        """
        return pulumi.get(self, "port_rule_id")


@pulumi.output_type
class BgpPolicyContentSourceBlockList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockExpireSeconds":
            suggest = "block_expire_seconds"
        elif key == "everySeconds":
            suggest = "every_seconds"
        elif key == "exceedLimitTimes":
            suggest = "exceed_limit_times"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContentSourceBlockList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContentSourceBlockList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContentSourceBlockList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_expire_seconds: _builtins.int,
                 every_seconds: _builtins.int,
                 exceed_limit_times: _builtins.int,
                 type: _builtins.int):
        """
        :param _builtins.int block_expire_seconds: Statistical cycle range 60-1200.
        :param _builtins.int every_seconds: The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
        :param _builtins.int exceed_limit_times: The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
        :param _builtins.int type: Type
        """
        pulumi.set(__self__, "block_expire_seconds", block_expire_seconds)
        pulumi.set(__self__, "every_seconds", every_seconds)
        pulumi.set(__self__, "exceed_limit_times", exceed_limit_times)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="blockExpireSeconds")
    def block_expire_seconds(self) -> _builtins.int:
        """
        Statistical cycle range 60-1200.
        """
        return pulumi.get(self, "block_expire_seconds")

    @_builtins.property
    @pulumi.getter(name="everySeconds")
    def every_seconds(self) -> _builtins.int:
        """
        The time (unit second) for automatically releasing the black after triggering the speed limit is 60~2592000.
        """
        return pulumi.get(self, "every_seconds")

    @_builtins.property
    @pulumi.getter(name="exceedLimitTimes")
    def exceed_limit_times(self) -> _builtins.int:
        """
        The number of times the speed limit is exceeded in a statistical period ranges from 1 to 1200.
        """
        return pulumi.get(self, "exceed_limit_times")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.int:
        """
        Type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class BgpPolicyContentSourceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "synBps":
            suggest = "syn_bps"
        elif key == "synPps":
            suggest = "syn_pps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BgpPolicyContentSourceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BgpPolicyContentSourceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BgpPolicyContentSourceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bps: Optional[_builtins.int] = None,
                 pps: Optional[_builtins.int] = None,
                 syn_bps: Optional[_builtins.int] = None,
                 syn_pps: Optional[_builtins.int] = None):
        """
        :param _builtins.int bps: bps range 1024~268435456.
        :param _builtins.int pps: Pps range 32~500000.
        :param _builtins.int syn_bps: SynBps range 1024~268435456.
        :param _builtins.int syn_pps: SynPps range 1~100000.
        """
        if bps is not None:
            pulumi.set(__self__, "bps", bps)
        if pps is not None:
            pulumi.set(__self__, "pps", pps)
        if syn_bps is not None:
            pulumi.set(__self__, "syn_bps", syn_bps)
        if syn_pps is not None:
            pulumi.set(__self__, "syn_pps", syn_pps)

    @_builtins.property
    @pulumi.getter
    def bps(self) -> Optional[_builtins.int]:
        """
        bps range 1024~268435456.
        """
        return pulumi.get(self, "bps")

    @_builtins.property
    @pulumi.getter
    def pps(self) -> Optional[_builtins.int]:
        """
        Pps range 32~500000.
        """
        return pulumi.get(self, "pps")

    @_builtins.property
    @pulumi.getter(name="synBps")
    def syn_bps(self) -> Optional[_builtins.int]:
        """
        SynBps range 1024~268435456.
        """
        return pulumi.get(self, "syn_bps")

    @_builtins.property
    @pulumi.getter(name="synPps")
    def syn_pps(self) -> Optional[_builtins.int]:
        """
        SynPps range 1~100000.
        """
        return pulumi.get(self, "syn_pps")


@pulumi.output_type
class DomainResourceProxyType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "proxyPorts":
            suggest = "proxy_ports"
        elif key == "proxyType":
            suggest = "proxy_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainResourceProxyType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainResourceProxyType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainResourceProxyType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 proxy_ports: Sequence[_builtins.int],
                 proxy_type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.int] proxy_ports: The port numbers.
        :param _builtins.str proxy_type: The type of the protocol. Valid values:
        """
        pulumi.set(__self__, "proxy_ports", proxy_ports)
        if proxy_type is not None:
            pulumi.set(__self__, "proxy_type", proxy_type)

    @_builtins.property
    @pulumi.getter(name="proxyPorts")
    def proxy_ports(self) -> Sequence[_builtins.int]:
        """
        The port numbers.
        """
        return pulumi.get(self, "proxy_ports")

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> Optional[_builtins.str]:
        """
        The type of the protocol. Valid values:
        """
        return pulumi.get(self, "proxy_type")


@pulumi.output_type
class PortConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "persistenceTimeout":
            suggest = "persistence_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 persistence_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.int persistence_timeout: The timeout period for session retention. Value range: 30~3600, unit: second. The default is 0, which means off.
        """
        if persistence_timeout is not None:
            pulumi.set(__self__, "persistence_timeout", persistence_timeout)

    @_builtins.property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> Optional[_builtins.int]:
        """
        The timeout period for session retention. Value range: 30~3600, unit: second. The default is 0, which means off.
        """
        return pulumi.get(self, "persistence_timeout")


@pulumi.output_type
class SchedulerRuleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionId":
            suggest = "region_id"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchedulerRuleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchedulerRuleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchedulerRuleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 priority: Optional[_builtins.int] = None,
                 region_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 value_type: Optional[_builtins.int] = None):
        """
        :param _builtins.int priority: The priority of the rule.
        :param _builtins.str region_id: The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
        :param _builtins.int status: The status of the scheduling rule.
        :param _builtins.str type: The address type of the interaction resource. Valid values:
               `A`: IPv4 address.
               `CNAME`: CNAME record.
        :param _builtins.str value: The address of the interaction resource.
        :param _builtins.int value_type: Required. The type of the linked resource. It is an Integer. Valid values:
               `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
               `2`: the IP address of the interaction resource (in the tiered protection scenario)
               `3`: the IP address used to accelerate access (in the network acceleration scenario)
               `6` the IP address of the interaction resource (in the cloud service interaction scenario)
        """
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority of the rule.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[_builtins.str]:
        """
        The region where the interaction resource that is used in the scheduling rule is deployed. **NOTE:** This parameter is returned only if the RuleType parameter is set to 2.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.int]:
        """
        The status of the scheduling rule.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The address type of the interaction resource. Valid values:
        `A`: IPv4 address.
        `CNAME`: CNAME record.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The address of the interaction resource.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[_builtins.int]:
        """
        Required. The type of the linked resource. It is an Integer. Valid values:
        `1`: The IP address of Anti-DDoS Pro or Anti-DDoS Premium
        `2`: the IP address of the interaction resource (in the tiered protection scenario)
        `3`: the IP address used to accelerate access (in the network acceleration scenario)
        `6` the IP address of the interaction resource (in the cloud service interaction scenario)
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GetDdosBgpInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 base_bandwidth: _builtins.int,
                 id: _builtins.str,
                 ip_count: _builtins.int,
                 ip_type: _builtins.str,
                 name: _builtins.str,
                 normal_bandwidth: _builtins.int,
                 region: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int bandwidth: The instance's elastic defend bandwidth.
        :param _builtins.int base_bandwidth: The instance's base defend bandwidth.
        :param _builtins.str id: The instance's id.
        :param _builtins.int ip_count: The instance's count of ip config.
        :param _builtins.str ip_type: The instance's IP version.
        :param _builtins.str name: The instance's remark.
        :param _builtins.int normal_bandwidth: Normal defend bandwidth of the instance. The unit is Gbps.
        :param _builtins.str region: The instance's region.
        :param _builtins.str type: The instance's type.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_count", ip_count)
        pulumi.set(__self__, "ip_type", ip_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "normal_bandwidth", normal_bandwidth)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The instance's elastic defend bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> _builtins.int:
        """
        The instance's base defend bandwidth.
        """
        return pulumi.get(self, "base_bandwidth")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance's id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipCount")
    def ip_count(self) -> _builtins.int:
        """
        The instance's count of ip config.
        """
        return pulumi.get(self, "ip_count")

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> _builtins.str:
        """
        The instance's IP version.
        """
        return pulumi.get(self, "ip_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The instance's remark.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="normalBandwidth")
    def normal_bandwidth(self) -> _builtins.int:
        """
        Normal defend bandwidth of the instance. The unit is Gbps.
        """
        return pulumi.get(self, "normal_bandwidth")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The instance's region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The instance's type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDdosBgpIpsIpResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 ip: _builtins.str,
                 product: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str id: The ID of the Ip. The value formats as `<instance_id>:<ip>`.
        :param _builtins.str instance_id: The ID of the native protection enterprise instance to be operated.
        :param _builtins.str ip: The IP address.
        :param _builtins.str product: The type of cloud asset to which the IP address belongs.
        :param _builtins.str status: The current state of the IP address.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Ip. The value formats as `<instance_id>:<ip>`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the native protection enterprise instance to be operated.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The IP address.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        The type of cloud asset to which the IP address belongs.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current state of the IP address.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDdosCooDomainResourcesResourceResult(dict):
    def __init__(__self__, *,
                 black_lists: Sequence[_builtins.str],
                 cc_enabled: _builtins.bool,
                 cc_rule_enabled: _builtins.bool,
                 cc_template: _builtins.str,
                 cert_name: _builtins.str,
                 domain: _builtins.str,
                 http2_enable: _builtins.bool,
                 https_ext: _builtins.str,
                 id: _builtins.str,
                 instance_ids: Sequence[_builtins.str],
                 policy_mode: _builtins.str,
                 proxy_enabled: _builtins.bool,
                 proxy_types: Sequence['outputs.GetDdosCooDomainResourcesResourceProxyTypeResult'],
                 real_servers: Sequence[_builtins.str],
                 rs_type: _builtins.int,
                 ssl_ciphers: _builtins.str,
                 ssl_protocols: _builtins.str,
                 white_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] black_lists: The IP addresses in the blacklist for the domain name.
        :param _builtins.bool cc_enabled: Whether frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
        :param _builtins.bool cc_rule_enabled: Whether custom frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
        :param _builtins.str cc_template: The mode of the Frequency Control policy.
        :param _builtins.str cert_name: The name of the certificate.
        :param _builtins.str domain: The domain name of the website that you want to add to the instance.
        :param _builtins.bool http2_enable: Whether Http2.0 is enabled.
        :param _builtins.str https_ext: The advanced HTTPS settings.
        :param _builtins.str id: The ID of the Domain Resource.
        :param Sequence[_builtins.str] instance_ids: A ID list of Ddoscoo instance.
        :param _builtins.str policy_mode: The type of backload algorithm.
        :param _builtins.bool proxy_enabled: Whether the website service forwarding rules have been turned on.
        :param Sequence['GetDdosCooDomainResourcesResourceProxyTypeArgs'] proxy_types: Protocol type and port number information.
        :param Sequence[_builtins.str] real_servers: Server address information of the source station.
        :param _builtins.int rs_type: Server address type.
        :param _builtins.str ssl_ciphers: The type of the cipher suite.
        :param _builtins.str ssl_protocols: The version of the TLS protocol.
        :param Sequence[_builtins.str] white_lists: The IP addresses in the whitelist for the domain name.
        """
        pulumi.set(__self__, "black_lists", black_lists)
        pulumi.set(__self__, "cc_enabled", cc_enabled)
        pulumi.set(__self__, "cc_rule_enabled", cc_rule_enabled)
        pulumi.set(__self__, "cc_template", cc_template)
        pulumi.set(__self__, "cert_name", cert_name)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "http2_enable", http2_enable)
        pulumi.set(__self__, "https_ext", https_ext)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "policy_mode", policy_mode)
        pulumi.set(__self__, "proxy_enabled", proxy_enabled)
        pulumi.set(__self__, "proxy_types", proxy_types)
        pulumi.set(__self__, "real_servers", real_servers)
        pulumi.set(__self__, "rs_type", rs_type)
        pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        pulumi.set(__self__, "ssl_protocols", ssl_protocols)
        pulumi.set(__self__, "white_lists", white_lists)

    @_builtins.property
    @pulumi.getter(name="blackLists")
    def black_lists(self) -> Sequence[_builtins.str]:
        """
        The IP addresses in the blacklist for the domain name.
        """
        return pulumi.get(self, "black_lists")

    @_builtins.property
    @pulumi.getter(name="ccEnabled")
    def cc_enabled(self) -> _builtins.bool:
        """
        Whether frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
        """
        return pulumi.get(self, "cc_enabled")

    @_builtins.property
    @pulumi.getter(name="ccRuleEnabled")
    def cc_rule_enabled(self) -> _builtins.bool:
        """
        Whether custom frequency control guard (CC guard) is enabled. Values: `True`: Opened, `False`: Not enabled.
        """
        return pulumi.get(self, "cc_rule_enabled")

    @_builtins.property
    @pulumi.getter(name="ccTemplate")
    def cc_template(self) -> _builtins.str:
        """
        The mode of the Frequency Control policy.
        """
        return pulumi.get(self, "cc_template")

    @_builtins.property
    @pulumi.getter(name="certName")
    def cert_name(self) -> _builtins.str:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "cert_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name of the website that you want to add to the instance.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter(name="http2Enable")
    def http2_enable(self) -> _builtins.bool:
        """
        Whether Http2.0 is enabled.
        """
        return pulumi.get(self, "http2_enable")

    @_builtins.property
    @pulumi.getter(name="httpsExt")
    def https_ext(self) -> _builtins.str:
        """
        The advanced HTTPS settings.
        """
        return pulumi.get(self, "https_ext")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Domain Resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Sequence[_builtins.str]:
        """
        A ID list of Ddoscoo instance.
        """
        return pulumi.get(self, "instance_ids")

    @_builtins.property
    @pulumi.getter(name="policyMode")
    def policy_mode(self) -> _builtins.str:
        """
        The type of backload algorithm.
        """
        return pulumi.get(self, "policy_mode")

    @_builtins.property
    @pulumi.getter(name="proxyEnabled")
    def proxy_enabled(self) -> _builtins.bool:
        """
        Whether the website service forwarding rules have been turned on.
        """
        return pulumi.get(self, "proxy_enabled")

    @_builtins.property
    @pulumi.getter(name="proxyTypes")
    def proxy_types(self) -> Sequence['outputs.GetDdosCooDomainResourcesResourceProxyTypeResult']:
        """
        Protocol type and port number information.
        """
        return pulumi.get(self, "proxy_types")

    @_builtins.property
    @pulumi.getter(name="realServers")
    def real_servers(self) -> Sequence[_builtins.str]:
        """
        Server address information of the source station.
        """
        return pulumi.get(self, "real_servers")

    @_builtins.property
    @pulumi.getter(name="rsType")
    def rs_type(self) -> _builtins.int:
        """
        Server address type.
        """
        return pulumi.get(self, "rs_type")

    @_builtins.property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> _builtins.str:
        """
        The type of the cipher suite.
        """
        return pulumi.get(self, "ssl_ciphers")

    @_builtins.property
    @pulumi.getter(name="sslProtocols")
    def ssl_protocols(self) -> _builtins.str:
        """
        The version of the TLS protocol.
        """
        return pulumi.get(self, "ssl_protocols")

    @_builtins.property
    @pulumi.getter(name="whiteLists")
    def white_lists(self) -> Sequence[_builtins.str]:
        """
        The IP addresses in the whitelist for the domain name.
        """
        return pulumi.get(self, "white_lists")


@pulumi.output_type
class GetDdosCooDomainResourcesResourceProxyTypeResult(dict):
    def __init__(__self__, *,
                 proxy_ports: Sequence[_builtins.int],
                 proxy_type: _builtins.str):
        """
        :param Sequence[_builtins.int] proxy_ports: The forwarding port.
        :param _builtins.str proxy_type: Protocol type.
        """
        pulumi.set(__self__, "proxy_ports", proxy_ports)
        pulumi.set(__self__, "proxy_type", proxy_type)

    @_builtins.property
    @pulumi.getter(name="proxyPorts")
    def proxy_ports(self) -> Sequence[_builtins.int]:
        """
        The forwarding port.
        """
        return pulumi.get(self, "proxy_ports")

    @_builtins.property
    @pulumi.getter(name="proxyType")
    def proxy_type(self) -> _builtins.str:
        """
        Protocol type.
        """
        return pulumi.get(self, "proxy_type")


@pulumi.output_type
class GetDdosCooInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 bandwidth: _builtins.int,
                 base_bandwidth: _builtins.int,
                 create_time: _builtins.int,
                 debt_status: _builtins.int,
                 domain_count: _builtins.int,
                 edition: _builtins.int,
                 enabled: _builtins.int,
                 expire_time: _builtins.int,
                 id: _builtins.str,
                 ip_mode: _builtins.str,
                 ip_version: _builtins.str,
                 name: _builtins.str,
                 port_count: _builtins.int,
                 remark: _builtins.str,
                 service_bandwidth: _builtins.int,
                 status: _builtins.int):
        """
        :param _builtins.int bandwidth: The instance's elastic defend bandwidth.
        :param _builtins.int base_bandwidth: The instance's base defend bandwidth.
        :param _builtins.int create_time: The creation time of the instance.
        :param _builtins.int debt_status: The debt status of the instance.
        :param _builtins.int domain_count: The instance's count of domain retransmission config.
        :param _builtins.int edition: The edition of the instance.
        :param _builtins.int enabled: The enabled of the instance.
        :param _builtins.int expire_time: The expiry time of the instance.
        :param _builtins.str id: The instance's id.
        :param _builtins.str ip_mode: The ip mode of the instance.
        :param _builtins.str ip_version: The ip version of the instance.
        :param _builtins.str name: The instance's remark.
        :param _builtins.int port_count: The instance's count of port retransmission config.
        :param _builtins.str remark: The remark of the instance.
        :param _builtins.int service_bandwidth: The instance's business bandwidth.
        :param _builtins.int status: The status of the instance.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "base_bandwidth", base_bandwidth)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "debt_status", debt_status)
        pulumi.set(__self__, "domain_count", domain_count)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_mode", ip_mode)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port_count", port_count)
        pulumi.set(__self__, "remark", remark)
        pulumi.set(__self__, "service_bandwidth", service_bandwidth)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.int:
        """
        The instance's elastic defend bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="baseBandwidth")
    def base_bandwidth(self) -> _builtins.int:
        """
        The instance's base defend bandwidth.
        """
        return pulumi.get(self, "base_bandwidth")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.int:
        """
        The creation time of the instance.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="debtStatus")
    def debt_status(self) -> _builtins.int:
        """
        The debt status of the instance.
        """
        return pulumi.get(self, "debt_status")

    @_builtins.property
    @pulumi.getter(name="domainCount")
    def domain_count(self) -> _builtins.int:
        """
        The instance's count of domain retransmission config.
        """
        return pulumi.get(self, "domain_count")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> _builtins.int:
        """
        The edition of the instance.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.int:
        """
        The enabled of the instance.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.int:
        """
        The expiry time of the instance.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance's id.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> _builtins.str:
        """
        The ip mode of the instance.
        """
        return pulumi.get(self, "ip_mode")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The ip version of the instance.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The instance's remark.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="portCount")
    def port_count(self) -> _builtins.int:
        """
        The instance's count of port retransmission config.
        """
        return pulumi.get(self, "port_count")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> _builtins.str:
        """
        The remark of the instance.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter(name="serviceBandwidth")
    def service_bandwidth(self) -> _builtins.int:
        """
        The instance's business bandwidth.
        """
        return pulumi.get(self, "service_bandwidth")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.int:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDdosCooPortsPortResult(dict):
    def __init__(__self__, *,
                 backend_port: _builtins.str,
                 frontend_port: _builtins.str,
                 frontend_protocol: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 real_servers: Sequence[_builtins.str]):
        """
        :param _builtins.str backend_port: The source station port.
        :param _builtins.str frontend_port: The forwarding port.
        :param _builtins.str frontend_protocol: The forwarding protocol. Valid values `tcp` and `udp`.
        :param _builtins.str id: The ID of the Port.
        :param _builtins.str instance_id: The DdosCoo instance ID.
        :param Sequence[_builtins.str] real_servers: List of source IP addresses.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "frontend_protocol", frontend_protocol)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "real_servers", real_servers)

    @_builtins.property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> _builtins.str:
        """
        The source station port.
        """
        return pulumi.get(self, "backend_port")

    @_builtins.property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> _builtins.str:
        """
        The forwarding port.
        """
        return pulumi.get(self, "frontend_port")

    @_builtins.property
    @pulumi.getter(name="frontendProtocol")
    def frontend_protocol(self) -> _builtins.str:
        """
        The forwarding protocol. Valid values `tcp` and `udp`.
        """
        return pulumi.get(self, "frontend_protocol")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Port.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The DdosCoo instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="realServers")
    def real_servers(self) -> Sequence[_builtins.str]:
        """
        List of source IP addresses.
        """
        return pulumi.get(self, "real_servers")


