# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AirflowArgs', 'Airflow']

@pulumi.input_type
class AirflowArgs:
    def __init__(__self__, *,
                 airflow_name: pulumi.Input[_builtins.str],
                 app_spec: pulumi.Input[_builtins.str],
                 description: pulumi.Input[_builtins.str],
                 oss_bucket_name: pulumi.Input[_builtins.str],
                 oss_path: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 worker_serverless_replicas: pulumi.Input[_builtins.int],
                 workspace_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 dags_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 requirement_file: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Airflow resource.
        :param pulumi.Input[_builtins.str] airflow_name: Name of the Airflow instance
        :param pulumi.Input[_builtins.str] app_spec: Airflow instance specifications
        :param pulumi.Input[_builtins.str] description: Description of the airflow instance
        :param pulumi.Input[_builtins.str] oss_bucket_name: OSS bucket name
        :param pulumi.Input[_builtins.str] oss_path: OSS path
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID
        :param pulumi.Input[_builtins.int] worker_serverless_replicas: Worker Node extension
        :param pulumi.Input[_builtins.str] workspace_id: DMS workspace ID
        :param pulumi.Input[_builtins.str] zone_id: Zone ID in the region
        :param pulumi.Input[_builtins.str] dags_dir: Dag scan path
        :param pulumi.Input[_builtins.str] plugins_dir: The path of the plugin scanned by the airflow instance.
        :param pulumi.Input[_builtins.str] requirement_file: Path to installable package
        :param pulumi.Input[_builtins.str] startup_file: Launch script for the airflow container
        """
        pulumi.set(__self__, "airflow_name", airflow_name)
        pulumi.set(__self__, "app_spec", app_spec)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        pulumi.set(__self__, "oss_path", oss_path)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "worker_serverless_replicas", worker_serverless_replicas)
        pulumi.set(__self__, "workspace_id", workspace_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if dags_dir is not None:
            pulumi.set(__self__, "dags_dir", dags_dir)
        if plugins_dir is not None:
            pulumi.set(__self__, "plugins_dir", plugins_dir)
        if requirement_file is not None:
            pulumi.set(__self__, "requirement_file", requirement_file)
        if startup_file is not None:
            pulumi.set(__self__, "startup_file", startup_file)

    @_builtins.property
    @pulumi.getter(name="airflowName")
    def airflow_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Airflow instance
        """
        return pulumi.get(self, "airflow_name")

    @airflow_name.setter
    def airflow_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "airflow_name", value)

    @_builtins.property
    @pulumi.getter(name="appSpec")
    def app_spec(self) -> pulumi.Input[_builtins.str]:
        """
        Airflow instance specifications
        """
        return pulumi.get(self, "app_spec")

    @app_spec.setter
    def app_spec(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_spec", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the airflow instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        OSS bucket name
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossPath")
    def oss_path(self) -> pulumi.Input[_builtins.str]:
        """
        OSS path
        """
        return pulumi.get(self, "oss_path")

    @oss_path.setter
    def oss_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "oss_path", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        Switch ID
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="workerServerlessReplicas")
    def worker_serverless_replicas(self) -> pulumi.Input[_builtins.int]:
        """
        Worker Node extension
        """
        return pulumi.get(self, "worker_serverless_replicas")

    @worker_serverless_replicas.setter
    def worker_serverless_replicas(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "worker_serverless_replicas", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        DMS workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Zone ID in the region
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="dagsDir")
    def dags_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dag scan path
        """
        return pulumi.get(self, "dags_dir")

    @dags_dir.setter
    def dags_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dags_dir", value)

    @_builtins.property
    @pulumi.getter(name="pluginsDir")
    def plugins_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the plugin scanned by the airflow instance.
        """
        return pulumi.get(self, "plugins_dir")

    @plugins_dir.setter
    def plugins_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugins_dir", value)

    @_builtins.property
    @pulumi.getter(name="requirementFile")
    def requirement_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to installable package
        """
        return pulumi.get(self, "requirement_file")

    @requirement_file.setter
    def requirement_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requirement_file", value)

    @_builtins.property
    @pulumi.getter(name="startupFile")
    def startup_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Launch script for the airflow container
        """
        return pulumi.get(self, "startup_file")

    @startup_file.setter
    def startup_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "startup_file", value)


@pulumi.input_type
class _AirflowState:
    def __init__(__self__, *,
                 airflow_id: Optional[pulumi.Input[_builtins.str]] = None,
                 airflow_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 dags_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 requirement_file: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_file: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_serverless_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Airflow resources.
        :param pulumi.Input[_builtins.str] airflow_id: AirflowId
        :param pulumi.Input[_builtins.str] airflow_name: Name of the Airflow instance
        :param pulumi.Input[_builtins.str] app_spec: Airflow instance specifications
        :param pulumi.Input[_builtins.str] dags_dir: Dag scan path
        :param pulumi.Input[_builtins.str] description: Description of the airflow instance
        :param pulumi.Input[_builtins.str] oss_bucket_name: OSS bucket name
        :param pulumi.Input[_builtins.str] oss_path: OSS path
        :param pulumi.Input[_builtins.str] plugins_dir: The path of the plugin scanned by the airflow instance.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] requirement_file: Path to installable package
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] startup_file: Launch script for the airflow container
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID
        :param pulumi.Input[_builtins.int] worker_serverless_replicas: Worker Node extension
        :param pulumi.Input[_builtins.str] workspace_id: DMS workspace ID
        :param pulumi.Input[_builtins.str] zone_id: Zone ID in the region
        """
        if airflow_id is not None:
            pulumi.set(__self__, "airflow_id", airflow_id)
        if airflow_name is not None:
            pulumi.set(__self__, "airflow_name", airflow_name)
        if app_spec is not None:
            pulumi.set(__self__, "app_spec", app_spec)
        if dags_dir is not None:
            pulumi.set(__self__, "dags_dir", dags_dir)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if oss_path is not None:
            pulumi.set(__self__, "oss_path", oss_path)
        if plugins_dir is not None:
            pulumi.set(__self__, "plugins_dir", plugins_dir)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if requirement_file is not None:
            pulumi.set(__self__, "requirement_file", requirement_file)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if startup_file is not None:
            pulumi.set(__self__, "startup_file", startup_file)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if worker_serverless_replicas is not None:
            pulumi.set(__self__, "worker_serverless_replicas", worker_serverless_replicas)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="airflowId")
    def airflow_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AirflowId
        """
        return pulumi.get(self, "airflow_id")

    @airflow_id.setter
    def airflow_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "airflow_id", value)

    @_builtins.property
    @pulumi.getter(name="airflowName")
    def airflow_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Airflow instance
        """
        return pulumi.get(self, "airflow_name")

    @airflow_name.setter
    def airflow_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "airflow_name", value)

    @_builtins.property
    @pulumi.getter(name="appSpec")
    def app_spec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Airflow instance specifications
        """
        return pulumi.get(self, "app_spec")

    @app_spec.setter
    def app_spec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_spec", value)

    @_builtins.property
    @pulumi.getter(name="dagsDir")
    def dags_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dag scan path
        """
        return pulumi.get(self, "dags_dir")

    @dags_dir.setter
    def dags_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dags_dir", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the airflow instance
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS bucket name
        """
        return pulumi.get(self, "oss_bucket_name")

    @oss_bucket_name.setter
    def oss_bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_bucket_name", value)

    @_builtins.property
    @pulumi.getter(name="ossPath")
    def oss_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OSS path
        """
        return pulumi.get(self, "oss_path")

    @oss_path.setter
    def oss_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oss_path", value)

    @_builtins.property
    @pulumi.getter(name="pluginsDir")
    def plugins_dir(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the plugin scanned by the airflow instance.
        """
        return pulumi.get(self, "plugins_dir")

    @plugins_dir.setter
    def plugins_dir(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plugins_dir", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="requirementFile")
    def requirement_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path to installable package
        """
        return pulumi.get(self, "requirement_file")

    @requirement_file.setter
    def requirement_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "requirement_file", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="startupFile")
    def startup_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Launch script for the airflow container
        """
        return pulumi.get(self, "startup_file")

    @startup_file.setter
    def startup_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "startup_file", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Switch ID
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="workerServerlessReplicas")
    def worker_serverless_replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Worker Node extension
        """
        return pulumi.get(self, "worker_serverless_replicas")

    @worker_serverless_replicas.setter
    def worker_serverless_replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "worker_serverless_replicas", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        DMS workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zone ID in the region
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:dms/airflow:Airflow")
class Airflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 dags_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 requirement_file: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_file: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_serverless_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Dms Airflow resource.

        Airflow instance, used to schedule jobs.

        For information about Dms Airflow and how to use it, see [What is Airflow](https://next.api.alibabacloud.com/document/Dms/2025-04-14/CreateAirflow).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0],
            zone_id="cn-hangzhou-h")
        security_group = alicloud.ecs.SecurityGroup("security_group",
            description="terraform_example_group",
            security_group_name="terraform_example_group",
            vpc_id=default.ids[0],
            security_group_type="normal",
            inner_access_policy="Accept")
        workspace = alicloud.dms.EnterpriseWorkspace("workspace",
            description="terraform-example",
            vpc_id=default.ids[0],
            workspace_name="terraform-example")
        default_airflow = alicloud.dms.Airflow("default",
            vpc_id=default.ids[0],
            oss_path="/",
            dags_dir="default/dags",
            zone_id="cn-hangzhou-h",
            worker_serverless_replicas=0,
            description="terraform-example",
            security_group_id=security_group.id,
            requirement_file="default/requirements.txt",
            airflow_name="tfaccdms6513",
            plugins_dir="default/plugins",
            startup_file="default/startup.sh",
            app_spec="SMALL",
            oss_bucket_name="hansheng",
            vswitch_id=default_get_switches.ids[0],
            workspace_id=workspace.id)
        ```

        ## Import

        Dms Airflow can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/airflow:Airflow example <workspace_id>:<airflow_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] airflow_name: Name of the Airflow instance
        :param pulumi.Input[_builtins.str] app_spec: Airflow instance specifications
        :param pulumi.Input[_builtins.str] dags_dir: Dag scan path
        :param pulumi.Input[_builtins.str] description: Description of the airflow instance
        :param pulumi.Input[_builtins.str] oss_bucket_name: OSS bucket name
        :param pulumi.Input[_builtins.str] oss_path: OSS path
        :param pulumi.Input[_builtins.str] plugins_dir: The path of the plugin scanned by the airflow instance.
        :param pulumi.Input[_builtins.str] requirement_file: Path to installable package
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] startup_file: Launch script for the airflow container
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID
        :param pulumi.Input[_builtins.int] worker_serverless_replicas: Worker Node extension
        :param pulumi.Input[_builtins.str] workspace_id: DMS workspace ID
        :param pulumi.Input[_builtins.str] zone_id: Zone ID in the region
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AirflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Dms Airflow resource.

        Airflow instance, used to schedule jobs.

        For information about Dms Airflow and how to use it, see [What is Airflow](https://next.api.alibabacloud.com/document/Dms/2025-04-14/CreateAirflow).

        > **NOTE:** Available since v1.260.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0],
            zone_id="cn-hangzhou-h")
        security_group = alicloud.ecs.SecurityGroup("security_group",
            description="terraform_example_group",
            security_group_name="terraform_example_group",
            vpc_id=default.ids[0],
            security_group_type="normal",
            inner_access_policy="Accept")
        workspace = alicloud.dms.EnterpriseWorkspace("workspace",
            description="terraform-example",
            vpc_id=default.ids[0],
            workspace_name="terraform-example")
        default_airflow = alicloud.dms.Airflow("default",
            vpc_id=default.ids[0],
            oss_path="/",
            dags_dir="default/dags",
            zone_id="cn-hangzhou-h",
            worker_serverless_replicas=0,
            description="terraform-example",
            security_group_id=security_group.id,
            requirement_file="default/requirements.txt",
            airflow_name="tfaccdms6513",
            plugins_dir="default/plugins",
            startup_file="default/startup.sh",
            app_spec="SMALL",
            oss_bucket_name="hansheng",
            vswitch_id=default_get_switches.ids[0],
            workspace_id=workspace.id)
        ```

        ## Import

        Dms Airflow can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:dms/airflow:Airflow example <workspace_id>:<airflow_id>
        ```

        :param str resource_name: The name of the resource.
        :param AirflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AirflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 airflow_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_spec: Optional[pulumi.Input[_builtins.str]] = None,
                 dags_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 oss_path: Optional[pulumi.Input[_builtins.str]] = None,
                 plugins_dir: Optional[pulumi.Input[_builtins.str]] = None,
                 requirement_file: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_file: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 worker_serverless_replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AirflowArgs.__new__(AirflowArgs)

            if airflow_name is None and not opts.urn:
                raise TypeError("Missing required property 'airflow_name'")
            __props__.__dict__["airflow_name"] = airflow_name
            if app_spec is None and not opts.urn:
                raise TypeError("Missing required property 'app_spec'")
            __props__.__dict__["app_spec"] = app_spec
            __props__.__dict__["dags_dir"] = dags_dir
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if oss_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'oss_bucket_name'")
            __props__.__dict__["oss_bucket_name"] = oss_bucket_name
            if oss_path is None and not opts.urn:
                raise TypeError("Missing required property 'oss_path'")
            __props__.__dict__["oss_path"] = oss_path
            __props__.__dict__["plugins_dir"] = plugins_dir
            __props__.__dict__["requirement_file"] = requirement_file
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["startup_file"] = startup_file
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if worker_serverless_replicas is None and not opts.urn:
                raise TypeError("Missing required property 'worker_serverless_replicas'")
            __props__.__dict__["worker_serverless_replicas"] = worker_serverless_replicas
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["airflow_id"] = None
            __props__.__dict__["region_id"] = None
        super(Airflow, __self__).__init__(
            'alicloud:dms/airflow:Airflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            airflow_id: Optional[pulumi.Input[_builtins.str]] = None,
            airflow_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_spec: Optional[pulumi.Input[_builtins.str]] = None,
            dags_dir: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            oss_bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            oss_path: Optional[pulumi.Input[_builtins.str]] = None,
            plugins_dir: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            requirement_file: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            startup_file: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            worker_serverless_replicas: Optional[pulumi.Input[_builtins.int]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Airflow':
        """
        Get an existing Airflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] airflow_id: AirflowId
        :param pulumi.Input[_builtins.str] airflow_name: Name of the Airflow instance
        :param pulumi.Input[_builtins.str] app_spec: Airflow instance specifications
        :param pulumi.Input[_builtins.str] dags_dir: Dag scan path
        :param pulumi.Input[_builtins.str] description: Description of the airflow instance
        :param pulumi.Input[_builtins.str] oss_bucket_name: OSS bucket name
        :param pulumi.Input[_builtins.str] oss_path: OSS path
        :param pulumi.Input[_builtins.str] plugins_dir: The path of the plugin scanned by the airflow instance.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] requirement_file: Path to installable package
        :param pulumi.Input[_builtins.str] security_group_id: Security group ID
        :param pulumi.Input[_builtins.str] startup_file: Launch script for the airflow container
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: Switch ID
        :param pulumi.Input[_builtins.int] worker_serverless_replicas: Worker Node extension
        :param pulumi.Input[_builtins.str] workspace_id: DMS workspace ID
        :param pulumi.Input[_builtins.str] zone_id: Zone ID in the region
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AirflowState.__new__(_AirflowState)

        __props__.__dict__["airflow_id"] = airflow_id
        __props__.__dict__["airflow_name"] = airflow_name
        __props__.__dict__["app_spec"] = app_spec
        __props__.__dict__["dags_dir"] = dags_dir
        __props__.__dict__["description"] = description
        __props__.__dict__["oss_bucket_name"] = oss_bucket_name
        __props__.__dict__["oss_path"] = oss_path
        __props__.__dict__["plugins_dir"] = plugins_dir
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["requirement_file"] = requirement_file
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["startup_file"] = startup_file
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["worker_serverless_replicas"] = worker_serverless_replicas
        __props__.__dict__["workspace_id"] = workspace_id
        __props__.__dict__["zone_id"] = zone_id
        return Airflow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="airflowId")
    def airflow_id(self) -> pulumi.Output[_builtins.str]:
        """
        AirflowId
        """
        return pulumi.get(self, "airflow_id")

    @_builtins.property
    @pulumi.getter(name="airflowName")
    def airflow_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Airflow instance
        """
        return pulumi.get(self, "airflow_name")

    @_builtins.property
    @pulumi.getter(name="appSpec")
    def app_spec(self) -> pulumi.Output[_builtins.str]:
        """
        Airflow instance specifications
        """
        return pulumi.get(self, "app_spec")

    @_builtins.property
    @pulumi.getter(name="dagsDir")
    def dags_dir(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Dag scan path
        """
        return pulumi.get(self, "dags_dir")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the airflow instance
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        OSS bucket name
        """
        return pulumi.get(self, "oss_bucket_name")

    @_builtins.property
    @pulumi.getter(name="ossPath")
    def oss_path(self) -> pulumi.Output[_builtins.str]:
        """
        OSS path
        """
        return pulumi.get(self, "oss_path")

    @_builtins.property
    @pulumi.getter(name="pluginsDir")
    def plugins_dir(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The path of the plugin scanned by the airflow instance.
        """
        return pulumi.get(self, "plugins_dir")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="requirementFile")
    def requirement_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path to installable package
        """
        return pulumi.get(self, "requirement_file")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Security group ID
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="startupFile")
    def startup_file(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Launch script for the airflow container
        """
        return pulumi.get(self, "startup_file")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        Switch ID
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="workerServerlessReplicas")
    def worker_serverless_replicas(self) -> pulumi.Output[_builtins.int]:
        """
        Worker Node extension
        """
        return pulumi.get(self, "worker_serverless_replicas")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        DMS workspace ID
        """
        return pulumi.get(self, "workspace_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Zone ID in the region
        """
        return pulumi.get(self, "zone_id")

