# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 instance_series: pulumi.Input[_builtins.str],
                 specification: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 zone_id: pulumi.Input[_builtins.str],
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] description: Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] instance_series: The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
               - `drds.sn2.4c16g` Starter Edition.
               - `drds.sn2.8c32g` Standard Edition.
               - `drds.sn2.16c64g` Enterprise Edition.
        :param pulumi.Input[_builtins.str] specification: User-defined DRDS instance specification. Value range:
               - `drds.sn1.4c8g` for DRDS instance Starter version;
               - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
               - `drds.sn1.8c16g` for DRDS instance Standard edition;
               - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
               - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
               - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
               - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
               - value range : `drds.sn1.32c64g.128c256g`
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitch ID to launch in.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DRDS instance.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.int] mysql_version: The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "instance_series", instance_series)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceSeries")
    def instance_series(self) -> pulumi.Input[_builtins.str]:
        """
        The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
        - `drds.sn2.4c16g` Starter Edition.
        - `drds.sn2.8c32g` Standard Edition.
        - `drds.sn2.16c64g` Enterprise Edition.
        """
        return pulumi.get(self, "instance_series")

    @instance_series.setter
    def instance_series(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_series", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Input[_builtins.str]:
        """
        User-defined DRDS instance specification. Value range:
        - `drds.sn1.4c8g` for DRDS instance Starter version;
        - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
        - `drds.sn1.8c16g` for DRDS instance Standard edition;
        - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
        - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
        - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
        - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
        - value range : `drds.sn1.32c64g.128c256g`
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VSwitch ID to launch in.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Zone to launch the DRDS instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_version", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_series: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] connection_string: (Available since v1.196.0) The connection string of the DRDS instance.
        :param pulumi.Input[_builtins.str] description: Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] instance_series: The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
               - `drds.sn2.4c16g` Starter Edition.
               - `drds.sn2.8c32g` Standard Edition.
               - `drds.sn2.16c64g` Enterprise Edition.
        :param pulumi.Input[_builtins.int] mysql_version: The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the DRDS instance.
        :param pulumi.Input[_builtins.str] specification: User-defined DRDS instance specification. Value range:
               - `drds.sn1.4c8g` for DRDS instance Starter version;
               - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
               - `drds.sn1.8c16g` for DRDS instance Standard edition;
               - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
               - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
               - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
               - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
               - value range : `drds.sn1.32c64g.128c256g`
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitch ID to launch in.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DRDS instance.
        """
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_series is not None:
            pulumi.set(__self__, "instance_series", instance_series)
        if mysql_version is not None:
            pulumi.set(__self__, "mysql_version", mysql_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.196.0) The connection string of the DRDS instance.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceSeries")
    def instance_series(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
        - `drds.sn2.4c16g` Starter Edition.
        - `drds.sn2.8c32g` Standard Edition.
        - `drds.sn2.16c64g` Enterprise Edition.
        """
        return pulumi.get(self, "instance_series")

    @instance_series.setter
    def instance_series(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_series", value)

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        """
        return pulumi.get(self, "mysql_version")

    @mysql_version.setter
    def mysql_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mysql_version", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.196.0) The connection port of the DRDS instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined DRDS instance specification. Value range:
        - `drds.sn1.4c8g` for DRDS instance Starter version;
        - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
        - `drds.sn1.8c16g` for DRDS instance Standard edition;
        - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
        - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
        - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
        - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
        - value range : `drds.sn1.32c64g.128c256g`
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VSwitch ID to launch in.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Zone to launch the DRDS instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.type_token("alicloud:drds/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_series: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.int]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Distributed Relational Database Service (DRDS) is a lightweight (stateless), flexible, stable, and efficient middleware product independently developed by Alibaba Group to resolve scalability issues with single-host relational databases.
        With its compatibility with MySQL protocols and syntaxes, DRDS enables database/table sharding, smooth scaling, configuration upgrade/downgrade,
        transparent read/write splitting, and distributed transactions, providing O&M capabilities for distributed databases throughout their entire lifecycle.

        For information about DRDS and how to use it, see [What is DRDS](https://www.alibabacloud.com/help/product/29657.htm).

        > **NOTE:** Available since v1.24.0.

        > **NOTE:** At present, DRDS instance only can be supported in the regions: cn-shenzhen, cn-beijing, cn-hangzhou, cn-hongkong, cn-qingdao, ap-southeast-1.

        > **NOTE:** Currently, this resource only support `Domestic Site Account`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        instance_series = config.get("instanceSeries")
        if instance_series is None:
            instance_series = "drds.sn1.4c8g"
        default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.drds.Instance("default",
            description="drds instance",
            instance_charge_type="PostPaid",
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id,
            instance_series=instance_series,
            specification="drds.sn1.4c8g.8C16G")
        ```

        ## Import

        Distributed Relational Database Service (DRDS) can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:drds/instance:Instance example drds-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] instance_series: The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
               - `drds.sn2.4c16g` Starter Edition.
               - `drds.sn2.8c32g` Standard Edition.
               - `drds.sn2.16c64g` Enterprise Edition.
        :param pulumi.Input[_builtins.int] mysql_version: The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        :param pulumi.Input[_builtins.str] specification: User-defined DRDS instance specification. Value range:
               - `drds.sn1.4c8g` for DRDS instance Starter version;
               - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
               - `drds.sn1.8c16g` for DRDS instance Standard edition;
               - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
               - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
               - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
               - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
               - value range : `drds.sn1.32c64g.128c256g`
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitch ID to launch in.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DRDS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Distributed Relational Database Service (DRDS) is a lightweight (stateless), flexible, stable, and efficient middleware product independently developed by Alibaba Group to resolve scalability issues with single-host relational databases.
        With its compatibility with MySQL protocols and syntaxes, DRDS enables database/table sharding, smooth scaling, configuration upgrade/downgrade,
        transparent read/write splitting, and distributed transactions, providing O&M capabilities for distributed databases throughout their entire lifecycle.

        For information about DRDS and how to use it, see [What is DRDS](https://www.alibabacloud.com/help/product/29657.htm).

        > **NOTE:** Available since v1.24.0.

        > **NOTE:** At present, DRDS instance only can be supported in the regions: cn-shenzhen, cn-beijing, cn-hangzhou, cn-hongkong, cn-qingdao, ap-southeast-1.

        > **NOTE:** Currently, this resource only support `Domestic Site Account`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.get_zones(available_resource_creation="VSwitch")
        config = pulumi.Config()
        instance_series = config.get("instanceSeries")
        if instance_series is None:
            instance_series = "drds.sn1.4c8g"
        default_get_networks = alicloud.vpc.get_networks(name_regex="default-NODELETING")
        default_get_switches = alicloud.vpc.get_switches(vpc_id=default_get_networks.ids[0])
        default_instance = alicloud.drds.Instance("default",
            description="drds instance",
            instance_charge_type="PostPaid",
            zone_id=default_get_switches.vswitches[0].zone_id,
            vswitch_id=default_get_switches.vswitches[0].id,
            instance_series=instance_series,
            specification="drds.sn1.4c8g.8C16G")
        ```

        ## Import

        Distributed Relational Database Service (DRDS) can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:drds/instance:Instance example drds-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_series: Optional[pulumi.Input[_builtins.str]] = None,
                 mysql_version: Optional[pulumi.Input[_builtins.int]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            if instance_series is None and not opts.urn:
                raise TypeError("Missing required property 'instance_series'")
            __props__.__dict__["instance_series"] = instance_series
            __props__.__dict__["mysql_version"] = mysql_version
            if specification is None and not opts.urn:
                raise TypeError("Missing required property 'specification'")
            __props__.__dict__["specification"] = specification
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["connection_string"] = None
            __props__.__dict__["port"] = None
        super(Instance, __self__).__init__(
            'alicloud:drds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_series: Optional[pulumi.Input[_builtins.str]] = None,
            mysql_version: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
            zone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] connection_string: (Available since v1.196.0) The connection string of the DRDS instance.
        :param pulumi.Input[_builtins.str] description: Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        :param pulumi.Input[_builtins.str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        :param pulumi.Input[_builtins.str] instance_series: The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
               - `drds.sn2.4c16g` Starter Edition.
               - `drds.sn2.8c32g` Standard Edition.
               - `drds.sn2.16c64g` Enterprise Edition.
        :param pulumi.Input[_builtins.int] mysql_version: The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        :param pulumi.Input[_builtins.str] port: (Available since v1.196.0) The connection port of the DRDS instance.
        :param pulumi.Input[_builtins.str] specification: User-defined DRDS instance specification. Value range:
               - `drds.sn1.4c8g` for DRDS instance Starter version;
               - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
               - `drds.sn1.8c16g` for DRDS instance Standard edition;
               - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
               - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
               - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
               - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
               - value range : `drds.sn1.32c64g.128c256g`
        :param pulumi.Input[_builtins.str] vpc_id: The id of the VPC.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitch ID to launch in.
        :param pulumi.Input[_builtins.str] zone_id: The Zone to launch the DRDS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_series"] = instance_series
        __props__.__dict__["mysql_version"] = mysql_version
        __props__.__dict__["port"] = port
        __props__.__dict__["specification"] = specification
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.196.0) The connection string of the DRDS instance.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the DRDS instance, This description can have a string of 2 to 256 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values are `PrePaid`, `PostPaid`, Default to `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="instanceSeries")
    def instance_series(self) -> pulumi.Output[_builtins.str]:
        """
        The parameter of the instance series. **NOTE:**  `drds.sn1.4c8g`,`drds.sn1.8c16g`,`drds.sn1.16c32g`,`drds.sn1.32c64g` are no longer supported. Valid values:
        - `drds.sn2.4c16g` Starter Edition.
        - `drds.sn2.8c32g` Standard Edition.
        - `drds.sn2.16c64g` Enterprise Edition.
        """
        return pulumi.get(self, "instance_series")

    @_builtins.property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> pulumi.Output[_builtins.int]:
        """
        The MySQL version supported by the instance, with the following range of values. `5`: Fully compatible with MySQL 5.x (default) `8`: Fully compatible with MySQL 8.0. This parameter takes effect when the primary instance is created, and the read-only instance has the same MySQL version as the primary instance by default.
        """
        return pulumi.get(self, "mysql_version")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.196.0) The connection port of the DRDS instance.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[_builtins.str]:
        """
        User-defined DRDS instance specification. Value range:
        - `drds.sn1.4c8g` for DRDS instance Starter version;
        - value range : `drds.sn1.4c8g.8c16g`, `drds.sn1.4c8g.16c32g`, `drds.sn1.4c8g.32c64g`, `drds.sn1.4c8g.64c128g`
        - `drds.sn1.8c16g` for DRDS instance Standard edition;
        - value range : `drds.sn1.8c16g.16c32g`, `drds.sn1.8c16g.32c64g`, `drds.sn1.8c16g.64c128g`
        - `drds.sn1.16c32g` for DRDS instance Enterprise Edition;
        - value range : `drds.sn1.16c32g.32c64g`, `drds.sn1.16c32g.64c128g`
        - `drds.sn1.32c64g` for DRDS instance Extreme Edition;
        - value range : `drds.sn1.32c64g.128c256g`
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VSwitch ID to launch in.
        """
        return pulumi.get(self, "vswitch_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Zone to launch the DRDS instance.
        """
        return pulumi.get(self, "zone_id")

