# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsDeploymentSetsResult',
    'AwaitableGetEcsDeploymentSetsResult',
    'get_ecs_deployment_sets',
    'get_ecs_deployment_sets_output',
]

@pulumi.output_type
class GetEcsDeploymentSetsResult:
    """
    A collection of values returned by getEcsDeploymentSets.
    """
    def __init__(__self__, deployment_set_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, sets=None, strategy=None):
        if deployment_set_name and not isinstance(deployment_set_name, str):
            raise TypeError("Expected argument 'deployment_set_name' to be a str")
        pulumi.set(__self__, "deployment_set_name", deployment_set_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if sets and not isinstance(sets, list):
            raise TypeError("Expected argument 'sets' to be a list")
        pulumi.set(__self__, "sets", sets)
        if strategy and not isinstance(strategy, str):
            raise TypeError("Expected argument 'strategy' to be a str")
        pulumi.set(__self__, "strategy", strategy)

    @_builtins.property
    @pulumi.getter(name="deploymentSetName")
    def deployment_set_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "deployment_set_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")

    @_builtins.property
    @pulumi.getter
    def sets(self) -> Sequence['outputs.GetEcsDeploymentSetsSetResult']:
        return pulumi.get(self, "sets")

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "strategy")


class AwaitableGetEcsDeploymentSetsResult(GetEcsDeploymentSetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsDeploymentSetsResult(
            deployment_set_name=self.deployment_set_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            sets=self.sets,
            strategy=self.strategy)


def get_ecs_deployment_sets(deployment_set_name: Optional[_builtins.str] = None,
                            ids: Optional[Sequence[_builtins.str]] = None,
                            name_regex: Optional[_builtins.str] = None,
                            output_file: Optional[_builtins.str] = None,
                            strategy: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsDeploymentSetsResult:
    """
    This data source provides the Ecs Deployment Sets of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.140.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ecs.get_ecs_deployment_sets(ids=["example_id"])
    pulumi.export("ecsDeploymentSetId1", ids.sets[0].id)
    name_regex = alicloud.ecs.get_ecs_deployment_sets(name_regex="^my-DeploymentSet")
    pulumi.export("ecsDeploymentSetId2", name_regex.sets[0].id)
    ```


    :param _builtins.str deployment_set_name: The name of the deployment set.
    :param Sequence[_builtins.str] ids: A list of Deployment Set IDs.
    :param _builtins.str name_regex: A regex string to filter results by Deployment Set name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str strategy: The deployment strategy. Valid values: `Availability`.
    """
    __args__ = dict()
    __args__['deploymentSetName'] = deployment_set_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['strategy'] = strategy
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsDeploymentSets:getEcsDeploymentSets', __args__, opts=opts, typ=GetEcsDeploymentSetsResult).value

    return AwaitableGetEcsDeploymentSetsResult(
        deployment_set_name=pulumi.get(__ret__, 'deployment_set_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        sets=pulumi.get(__ret__, 'sets'),
        strategy=pulumi.get(__ret__, 'strategy'))
def get_ecs_deployment_sets_output(deployment_set_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                   name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   strategy: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEcsDeploymentSetsResult]:
    """
    This data source provides the Ecs Deployment Sets of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.140.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ecs.get_ecs_deployment_sets(ids=["example_id"])
    pulumi.export("ecsDeploymentSetId1", ids.sets[0].id)
    name_regex = alicloud.ecs.get_ecs_deployment_sets(name_regex="^my-DeploymentSet")
    pulumi.export("ecsDeploymentSetId2", name_regex.sets[0].id)
    ```


    :param _builtins.str deployment_set_name: The name of the deployment set.
    :param Sequence[_builtins.str] ids: A list of Deployment Set IDs.
    :param _builtins.str name_regex: A regex string to filter results by Deployment Set name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    :param _builtins.str strategy: The deployment strategy. Valid values: `Availability`.
    """
    __args__ = dict()
    __args__['deploymentSetName'] = deployment_set_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['strategy'] = strategy
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getEcsDeploymentSets:getEcsDeploymentSets', __args__, opts=opts, typ=GetEcsDeploymentSetsResult)
    return __ret__.apply(lambda __response__: GetEcsDeploymentSetsResult(
        deployment_set_name=pulumi.get(__response__, 'deployment_set_name'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file'),
        sets=pulumi.get(__response__, 'sets'),
        strategy=pulumi.get(__response__, 'strategy')))
