# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHpcClustersResult',
    'AwaitableGetHpcClustersResult',
    'get_hpc_clusters',
    'get_hpc_clusters_output',
]

@pulumi.output_type
class GetHpcClustersResult:
    """
    A collection of values returned by getHpcClusters.
    """
    def __init__(__self__, clusters=None, id=None, ids=None, name_regex=None, names=None, output_file=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)

    @_builtins.property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.GetHpcClustersClusterResult']:
        return pulumi.get(self, "clusters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_regex")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output_file")


class AwaitableGetHpcClustersResult(GetHpcClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHpcClustersResult(
            clusters=self.clusters,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file)


def get_hpc_clusters(ids: Optional[Sequence[_builtins.str]] = None,
                     name_regex: Optional[_builtins.str] = None,
                     output_file: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHpcClustersResult:
    """
    This data source provides the Ecs Hpc Clusters of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.116.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_hpc_clusters(ids=["hpc-bp1i09xxxxxxxx"],
        name_regex="tf-testAcc")
    pulumi.export("firstEcsHpcClusterId", example.clusters[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Hpc Cluster IDs.
    :param _builtins.str name_regex: A regex string to filter results by Hpc Cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getHpcClusters:getHpcClusters', __args__, opts=opts, typ=GetHpcClustersResult).value

    return AwaitableGetHpcClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'))
def get_hpc_clusters_output(ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHpcClustersResult]:
    """
    This data source provides the Ecs Hpc Clusters of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.116.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_hpc_clusters(ids=["hpc-bp1i09xxxxxxxx"],
        name_regex="tf-testAcc")
    pulumi.export("firstEcsHpcClusterId", example.clusters[0].id)
    ```


    :param Sequence[_builtins.str] ids: A list of Hpc Cluster IDs.
    :param _builtins.str name_regex: A regex string to filter results by Hpc Cluster name.
    :param _builtins.str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('alicloud:ecs/getHpcClusters:getHpcClusters', __args__, opts=opts, typ=GetHpcClustersResult)
    return __ret__.apply(lambda __response__: GetHpcClustersResult(
        clusters=pulumi.get(__response__, 'clusters'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        name_regex=pulumi.get(__response__, 'name_regex'),
        names=pulumi.get(__response__, 'names'),
        output_file=pulumi.get(__response__, 'output_file')))
