# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sSlbAttachmentArgs', 'K8sSlbAttachment']

@pulumi.input_type
class K8sSlbAttachmentArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 slb_configs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]] = None):
        """
        The set of arguments for constructing a K8sSlbAttachment resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the EDAS k8s application to which you want to bind SLB instances.
        :param pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]] slb_configs: The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        pulumi.set(__self__, "app_id", app_id)
        if slb_configs is not None:
            pulumi.set(__self__, "slb_configs", slb_configs)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the EDAS k8s application to which you want to bind SLB instances.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="slbConfigs")
    def slb_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]]:
        """
        The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        return pulumi.get(self, "slb_configs")

    @slb_configs.setter
    def slb_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]]):
        pulumi.set(self, "slb_configs", value)


@pulumi.input_type
class _K8sSlbAttachmentState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_configs: Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering K8sSlbAttachment resources.
        :param pulumi.Input[_builtins.str] app_id: The ID of the EDAS k8s application to which you want to bind SLB instances.
        :param pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]] slb_configs: The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if slb_configs is not None:
            pulumi.set(__self__, "slb_configs", slb_configs)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EDAS k8s application to which you want to bind SLB instances.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="slbConfigs")
    def slb_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]]:
        """
        The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        return pulumi.get(self, "slb_configs")

    @slb_configs.setter
    def slb_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sSlbAttachmentSlbConfigArgs']]]]):
        pulumi.set(self, "slb_configs", value)


@pulumi.type_token("alicloud:edas/k8sSlbAttachment:K8sSlbAttachment")
class K8sSlbAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sSlbAttachmentSlbConfigArgs', 'K8sSlbAttachmentSlbConfigArgsDict']]]]] = None,
                 __props__=None):
        """
        Binds SLBs to an EDAS k8s application.

        For information about EDAS k8s slb attachment and how to use it, see [What is k8s slb attachment](https://www.alibabacloud.com/help/en/enterprise-distributed-application-service/latest/bindk8sslb).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name_prefix=name,
            cluster_spec="ack.pro.small",
            worker_vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True)
        default_node_pool = alicloud.cs.NodePool("default",
            name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[default_get_instance_types.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            desired_size="2")
        default_k8s_cluster = alicloud.edas.K8sCluster("default", cs_cluster_id=default_node_pool.cluster_id)
        default_k8s_application = alicloud.edas.K8sApplication("default",
            application_name=name,
            cluster_id=default_k8s_cluster.id,
            package_type="FatJar",
            package_url="http://edas-bj.oss-cn-beijing.aliyuncs.com/prod/demo/SPRING_CLOUD_PROVIDER.jar",
            jdk="Open JDK 8",
            replicas=2,
            readiness="{\\"failureThreshold\\": 3,\\"initialDelaySeconds\\": 5,\\"successThreshold\\": 1,\\"timeoutSeconds\\": 1,\\"tcpSocket\\":{\\"port\\":18081}}",
            liveness="{\\"failureThreshold\\": 3,\\"initialDelaySeconds\\": 5,\\"successThreshold\\": 1,\\"timeoutSeconds\\": 1,\\"tcpSocket\\":{\\"port\\":18081}}",
            application_descriotion=name)
        default_k8s_slb_attachment = alicloud.edas.K8sSlbAttachment("default",
            app_id=default_k8s_application.id,
            slb_configs=[{
                "type": "internet",
                "scheduler": "rr",
                "port_mappings": [{
                    "loadbalancer_protocol": "TCP",
                    "service_port": {
                        "port": 80,
                        "protocol": "TCP",
                        "target_port": 8080,
                    },
                }],
            }])
        ```

        ## Import

        Slb information of EDAS k8s application can be imported using the ID of an EDAS k8s application. e.g.

        ```sh
        $ pulumi import alicloud:edas/k8sSlbAttachment:K8sSlbAttachment example <EDAS k8s app id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the EDAS k8s application to which you want to bind SLB instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sSlbAttachmentSlbConfigArgs', 'K8sSlbAttachmentSlbConfigArgsDict']]]] slb_configs: The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sSlbAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Binds SLBs to an EDAS k8s application.

        For information about EDAS k8s slb attachment and how to use it, see [What is k8s slb attachment](https://www.alibabacloud.com/help/en/enterprise-distributed-application-service/latest/bindk8sslb).

        > **NOTE:** Available since v1.194.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_std as std

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_zones(available_resource_creation="VSwitch")
        default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
            cpu_core_count=4,
            memory_size=8,
            kubernetes_node_role="Worker")
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default.zones[0].id)
        default_managed_kubernetes = alicloud.cs.ManagedKubernetes("default",
            name_prefix=name,
            cluster_spec="ack.pro.small",
            worker_vswitch_ids=[default_switch.id],
            new_nat_gateway=True,
            pod_cidr=std.cidrsubnet(input="10.0.0.0/8",
                newbits=8,
                netnum=36).result,
            service_cidr=std.cidrsubnet(input="172.16.0.0/16",
                newbits=4,
                netnum=7).result,
            slb_internet_enabled=True)
        default_node_pool = alicloud.cs.NodePool("default",
            name=name,
            cluster_id=default_managed_kubernetes.id,
            vswitch_ids=[default_switch.id],
            instance_types=[default_get_instance_types.instance_types[0].id],
            system_disk_category="cloud_efficiency",
            system_disk_size=40,
            desired_size="2")
        default_k8s_cluster = alicloud.edas.K8sCluster("default", cs_cluster_id=default_node_pool.cluster_id)
        default_k8s_application = alicloud.edas.K8sApplication("default",
            application_name=name,
            cluster_id=default_k8s_cluster.id,
            package_type="FatJar",
            package_url="http://edas-bj.oss-cn-beijing.aliyuncs.com/prod/demo/SPRING_CLOUD_PROVIDER.jar",
            jdk="Open JDK 8",
            replicas=2,
            readiness="{\\"failureThreshold\\": 3,\\"initialDelaySeconds\\": 5,\\"successThreshold\\": 1,\\"timeoutSeconds\\": 1,\\"tcpSocket\\":{\\"port\\":18081}}",
            liveness="{\\"failureThreshold\\": 3,\\"initialDelaySeconds\\": 5,\\"successThreshold\\": 1,\\"timeoutSeconds\\": 1,\\"tcpSocket\\":{\\"port\\":18081}}",
            application_descriotion=name)
        default_k8s_slb_attachment = alicloud.edas.K8sSlbAttachment("default",
            app_id=default_k8s_application.id,
            slb_configs=[{
                "type": "internet",
                "scheduler": "rr",
                "port_mappings": [{
                    "loadbalancer_protocol": "TCP",
                    "service_port": {
                        "port": 80,
                        "protocol": "TCP",
                        "target_port": 8080,
                    },
                }],
            }])
        ```

        ## Import

        Slb information of EDAS k8s application can be imported using the ID of an EDAS k8s application. e.g.

        ```sh
        $ pulumi import alicloud:edas/k8sSlbAttachment:K8sSlbAttachment example <EDAS k8s app id>
        ```

        :param str resource_name: The name of the resource.
        :param K8sSlbAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sSlbAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slb_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sSlbAttachmentSlbConfigArgs', 'K8sSlbAttachmentSlbConfigArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sSlbAttachmentArgs.__new__(K8sSlbAttachmentArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["slb_configs"] = slb_configs
        super(K8sSlbAttachment, __self__).__init__(
            'alicloud:edas/k8sSlbAttachment:K8sSlbAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            slb_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['K8sSlbAttachmentSlbConfigArgs', 'K8sSlbAttachmentSlbConfigArgsDict']]]]] = None) -> 'K8sSlbAttachment':
        """
        Get an existing K8sSlbAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_id: The ID of the EDAS k8s application to which you want to bind SLB instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['K8sSlbAttachmentSlbConfigArgs', 'K8sSlbAttachmentSlbConfigArgsDict']]]] slb_configs: The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sSlbAttachmentState.__new__(_K8sSlbAttachmentState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["slb_configs"] = slb_configs
        return K8sSlbAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the EDAS k8s application to which you want to bind SLB instances.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="slbConfigs")
    def slb_configs(self) -> pulumi.Output[Sequence['outputs.K8sSlbAttachmentSlbConfig']]:
        """
        The configurations of SLB attachment, which is supported for multiple configurations. See `slb_configs` below.
        """
        return pulumi.get(self, "slb_configs")

