# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EcdPolicyGroupArgs', 'EcdPolicyGroup']

@pulumi.input_type
class EcdPolicyGroupArgs:
    def __init__(__self__, *,
                 authorize_access_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]] = None,
                 authorize_security_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_list: Optional[pulumi.Input[_builtins.str]] = None,
                 html_access: Optional[pulumi.Input[_builtins.str]] = None,
                 html_file_transfer: Optional[pulumi.Input[_builtins.str]] = None,
                 local_drive: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_expires: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_fps: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 usb_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 visual_quality: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_transparency: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EcdPolicyGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]] authorize_access_policy_rules: The rule of authorize access rule. See `authorize_access_policy_rules` below.
        :param pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]] authorize_security_policy_rules: The policy rule. See `authorize_security_policy_rules` below.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to enable local camera redirection. Valid values: `on`, `off`.
        :param pulumi.Input[_builtins.str] clipboard: The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        :param pulumi.Input[_builtins.str] domain_list: The list of domain.
        :param pulumi.Input[_builtins.str] html_access: The access of html5. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] html_file_transfer: The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        :param pulumi.Input[_builtins.str] local_drive: Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        :param pulumi.Input[_builtins.str] policy_group_name: The name of policy group.
        :param pulumi.Input[_builtins.str] recording: Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        :param pulumi.Input[_builtins.str] recording_end_time: The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.int] recording_expires: The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        :param pulumi.Input[_builtins.int] recording_fps: The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        :param pulumi.Input[_builtins.str] recording_start_time: The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.str] usb_redirect: The usb redirect policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] visual_quality: The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        :param pulumi.Input[_builtins.str] watermark: The watermark policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] watermark_transparency: The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        :param pulumi.Input[_builtins.str] watermark_type: The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        if authorize_access_policy_rules is not None:
            pulumi.set(__self__, "authorize_access_policy_rules", authorize_access_policy_rules)
        if authorize_security_policy_rules is not None:
            pulumi.set(__self__, "authorize_security_policy_rules", authorize_security_policy_rules)
        if camera_redirect is not None:
            pulumi.set(__self__, "camera_redirect", camera_redirect)
        if clipboard is not None:
            pulumi.set(__self__, "clipboard", clipboard)
        if domain_list is not None:
            pulumi.set(__self__, "domain_list", domain_list)
        if html_access is not None:
            pulumi.set(__self__, "html_access", html_access)
        if html_file_transfer is not None:
            pulumi.set(__self__, "html_file_transfer", html_file_transfer)
        if local_drive is not None:
            pulumi.set(__self__, "local_drive", local_drive)
        if policy_group_name is not None:
            pulumi.set(__self__, "policy_group_name", policy_group_name)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)
        if recording_end_time is not None:
            pulumi.set(__self__, "recording_end_time", recording_end_time)
        if recording_expires is not None:
            pulumi.set(__self__, "recording_expires", recording_expires)
        if recording_fps is not None:
            pulumi.set(__self__, "recording_fps", recording_fps)
        if recording_start_time is not None:
            pulumi.set(__self__, "recording_start_time", recording_start_time)
        if usb_redirect is not None:
            pulumi.set(__self__, "usb_redirect", usb_redirect)
        if visual_quality is not None:
            pulumi.set(__self__, "visual_quality", visual_quality)
        if watermark is not None:
            pulumi.set(__self__, "watermark", watermark)
        if watermark_transparency is not None:
            pulumi.set(__self__, "watermark_transparency", watermark_transparency)
        if watermark_type is not None:
            pulumi.set(__self__, "watermark_type", watermark_type)

    @_builtins.property
    @pulumi.getter(name="authorizeAccessPolicyRules")
    def authorize_access_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]]:
        """
        The rule of authorize access rule. See `authorize_access_policy_rules` below.
        """
        return pulumi.get(self, "authorize_access_policy_rules")

    @authorize_access_policy_rules.setter
    def authorize_access_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]]):
        pulumi.set(self, "authorize_access_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="authorizeSecurityPolicyRules")
    def authorize_security_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]]:
        """
        The policy rule. See `authorize_security_policy_rules` below.
        """
        return pulumi.get(self, "authorize_security_policy_rules")

    @authorize_security_policy_rules.setter
    def authorize_security_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "authorize_security_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable local camera redirection. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "camera_redirect")

    @camera_redirect.setter
    def camera_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "camera_redirect", value)

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        """
        return pulumi.get(self, "clipboard")

    @clipboard.setter
    def clipboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clipboard", value)

    @_builtins.property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of domain.
        """
        return pulumi.get(self, "domain_list")

    @domain_list.setter
    def domain_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_list", value)

    @_builtins.property
    @pulumi.getter(name="htmlAccess")
    def html_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access of html5. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "html_access")

    @html_access.setter
    def html_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_access", value)

    @_builtins.property
    @pulumi.getter(name="htmlFileTransfer")
    def html_file_transfer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        """
        return pulumi.get(self, "html_file_transfer")

    @html_file_transfer.setter
    def html_file_transfer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_file_transfer", value)

    @_builtins.property
    @pulumi.getter(name="localDrive")
    def local_drive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        """
        return pulumi.get(self, "local_drive")

    @local_drive.setter
    def local_drive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_drive", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of policy group.
        """
        return pulumi.get(self, "policy_group_name")

    @policy_group_name.setter
    def policy_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_name", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording", value)

    @_builtins.property
    @pulumi.getter(name="recordingEndTime")
    def recording_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_end_time")

    @recording_end_time.setter
    def recording_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording_end_time", value)

    @_builtins.property
    @pulumi.getter(name="recordingExpires")
    def recording_expires(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        """
        return pulumi.get(self, "recording_expires")

    @recording_expires.setter
    def recording_expires(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recording_expires", value)

    @_builtins.property
    @pulumi.getter(name="recordingFps")
    def recording_fps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        """
        return pulumi.get(self, "recording_fps")

    @recording_fps.setter
    def recording_fps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recording_fps", value)

    @_builtins.property
    @pulumi.getter(name="recordingStartTime")
    def recording_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_start_time")

    @recording_start_time.setter
    def recording_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording_start_time", value)

    @_builtins.property
    @pulumi.getter(name="usbRedirect")
    def usb_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usb redirect policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "usb_redirect")

    @usb_redirect.setter
    def usb_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usb_redirect", value)

    @_builtins.property
    @pulumi.getter(name="visualQuality")
    def visual_quality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        """
        return pulumi.get(self, "visual_quality")

    @visual_quality.setter
    def visual_quality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visual_quality", value)

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The watermark policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "watermark")

    @watermark.setter
    def watermark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark", value)

    @_builtins.property
    @pulumi.getter(name="watermarkTransparency")
    def watermark_transparency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        """
        return pulumi.get(self, "watermark_transparency")

    @watermark_transparency.setter
    def watermark_transparency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark_transparency", value)

    @_builtins.property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        return pulumi.get(self, "watermark_type")

    @watermark_type.setter
    def watermark_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark_type", value)


@pulumi.input_type
class _EcdPolicyGroupState:
    def __init__(__self__, *,
                 authorize_access_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]] = None,
                 authorize_security_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_list: Optional[pulumi.Input[_builtins.str]] = None,
                 html_access: Optional[pulumi.Input[_builtins.str]] = None,
                 html_file_transfer: Optional[pulumi.Input[_builtins.str]] = None,
                 local_drive: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_expires: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_fps: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 usb_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 visual_quality: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_transparency: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EcdPolicyGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]] authorize_access_policy_rules: The rule of authorize access rule. See `authorize_access_policy_rules` below.
        :param pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]] authorize_security_policy_rules: The policy rule. See `authorize_security_policy_rules` below.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to enable local camera redirection. Valid values: `on`, `off`.
        :param pulumi.Input[_builtins.str] clipboard: The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        :param pulumi.Input[_builtins.str] domain_list: The list of domain.
        :param pulumi.Input[_builtins.str] html_access: The access of html5. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] html_file_transfer: The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        :param pulumi.Input[_builtins.str] local_drive: Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        :param pulumi.Input[_builtins.str] policy_group_name: The name of policy group.
        :param pulumi.Input[_builtins.str] recording: Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        :param pulumi.Input[_builtins.str] recording_end_time: The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.int] recording_expires: The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        :param pulumi.Input[_builtins.int] recording_fps: The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        :param pulumi.Input[_builtins.str] recording_start_time: The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.str] status: The status of policy.
        :param pulumi.Input[_builtins.str] usb_redirect: The usb redirect policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] visual_quality: The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        :param pulumi.Input[_builtins.str] watermark: The watermark policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] watermark_transparency: The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        :param pulumi.Input[_builtins.str] watermark_type: The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        if authorize_access_policy_rules is not None:
            pulumi.set(__self__, "authorize_access_policy_rules", authorize_access_policy_rules)
        if authorize_security_policy_rules is not None:
            pulumi.set(__self__, "authorize_security_policy_rules", authorize_security_policy_rules)
        if camera_redirect is not None:
            pulumi.set(__self__, "camera_redirect", camera_redirect)
        if clipboard is not None:
            pulumi.set(__self__, "clipboard", clipboard)
        if domain_list is not None:
            pulumi.set(__self__, "domain_list", domain_list)
        if html_access is not None:
            pulumi.set(__self__, "html_access", html_access)
        if html_file_transfer is not None:
            pulumi.set(__self__, "html_file_transfer", html_file_transfer)
        if local_drive is not None:
            pulumi.set(__self__, "local_drive", local_drive)
        if policy_group_name is not None:
            pulumi.set(__self__, "policy_group_name", policy_group_name)
        if recording is not None:
            pulumi.set(__self__, "recording", recording)
        if recording_end_time is not None:
            pulumi.set(__self__, "recording_end_time", recording_end_time)
        if recording_expires is not None:
            pulumi.set(__self__, "recording_expires", recording_expires)
        if recording_fps is not None:
            pulumi.set(__self__, "recording_fps", recording_fps)
        if recording_start_time is not None:
            pulumi.set(__self__, "recording_start_time", recording_start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if usb_redirect is not None:
            pulumi.set(__self__, "usb_redirect", usb_redirect)
        if visual_quality is not None:
            pulumi.set(__self__, "visual_quality", visual_quality)
        if watermark is not None:
            pulumi.set(__self__, "watermark", watermark)
        if watermark_transparency is not None:
            pulumi.set(__self__, "watermark_transparency", watermark_transparency)
        if watermark_type is not None:
            pulumi.set(__self__, "watermark_type", watermark_type)

    @_builtins.property
    @pulumi.getter(name="authorizeAccessPolicyRules")
    def authorize_access_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]]:
        """
        The rule of authorize access rule. See `authorize_access_policy_rules` below.
        """
        return pulumi.get(self, "authorize_access_policy_rules")

    @authorize_access_policy_rules.setter
    def authorize_access_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs']]]]):
        pulumi.set(self, "authorize_access_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="authorizeSecurityPolicyRules")
    def authorize_security_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]]:
        """
        The policy rule. See `authorize_security_policy_rules` below.
        """
        return pulumi.get(self, "authorize_security_policy_rules")

    @authorize_security_policy_rules.setter
    def authorize_security_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs']]]]):
        pulumi.set(self, "authorize_security_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable local camera redirection. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "camera_redirect")

    @camera_redirect.setter
    def camera_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "camera_redirect", value)

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        """
        return pulumi.get(self, "clipboard")

    @clipboard.setter
    def clipboard(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "clipboard", value)

    @_builtins.property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The list of domain.
        """
        return pulumi.get(self, "domain_list")

    @domain_list.setter
    def domain_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_list", value)

    @_builtins.property
    @pulumi.getter(name="htmlAccess")
    def html_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access of html5. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "html_access")

    @html_access.setter
    def html_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_access", value)

    @_builtins.property
    @pulumi.getter(name="htmlFileTransfer")
    def html_file_transfer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        """
        return pulumi.get(self, "html_file_transfer")

    @html_file_transfer.setter
    def html_file_transfer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "html_file_transfer", value)

    @_builtins.property
    @pulumi.getter(name="localDrive")
    def local_drive(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        """
        return pulumi.get(self, "local_drive")

    @local_drive.setter
    def local_drive(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_drive", value)

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of policy group.
        """
        return pulumi.get(self, "policy_group_name")

    @policy_group_name.setter
    def policy_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_group_name", value)

    @_builtins.property
    @pulumi.getter
    def recording(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        """
        return pulumi.get(self, "recording")

    @recording.setter
    def recording(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording", value)

    @_builtins.property
    @pulumi.getter(name="recordingEndTime")
    def recording_end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_end_time")

    @recording_end_time.setter
    def recording_end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording_end_time", value)

    @_builtins.property
    @pulumi.getter(name="recordingExpires")
    def recording_expires(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        """
        return pulumi.get(self, "recording_expires")

    @recording_expires.setter
    def recording_expires(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recording_expires", value)

    @_builtins.property
    @pulumi.getter(name="recordingFps")
    def recording_fps(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        """
        return pulumi.get(self, "recording_fps")

    @recording_fps.setter
    def recording_fps(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recording_fps", value)

    @_builtins.property
    @pulumi.getter(name="recordingStartTime")
    def recording_start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_start_time")

    @recording_start_time.setter
    def recording_start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recording_start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of policy.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="usbRedirect")
    def usb_redirect(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The usb redirect policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "usb_redirect")

    @usb_redirect.setter
    def usb_redirect(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usb_redirect", value)

    @_builtins.property
    @pulumi.getter(name="visualQuality")
    def visual_quality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        """
        return pulumi.get(self, "visual_quality")

    @visual_quality.setter
    def visual_quality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visual_quality", value)

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The watermark policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "watermark")

    @watermark.setter
    def watermark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark", value)

    @_builtins.property
    @pulumi.getter(name="watermarkTransparency")
    def watermark_transparency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        """
        return pulumi.get(self, "watermark_transparency")

    @watermark_transparency.setter
    def watermark_transparency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark_transparency", value)

    @_builtins.property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        return pulumi.get(self, "watermark_type")

    @watermark_type.setter
    def watermark_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "watermark_type", value)


@pulumi.type_token("alicloud:eds/ecdPolicyGroup:EcdPolicyGroup")
class EcdPolicyGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorize_access_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs', 'EcdPolicyGroupAuthorizeAccessPolicyRuleArgsDict']]]]] = None,
                 authorize_security_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs', 'EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsDict']]]]] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_list: Optional[pulumi.Input[_builtins.str]] = None,
                 html_access: Optional[pulumi.Input[_builtins.str]] = None,
                 html_file_transfer: Optional[pulumi.Input[_builtins.str]] = None,
                 local_drive: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_expires: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_fps: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 usb_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 visual_quality: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_transparency: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Elastic Desktop Service (ECD) Policy Group resource.

        For information about Elastic Desktop Service (ECD) Policy Group and how to use it, see [What is Policy Group](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createpolicygroup).

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.eds.EcdPolicyGroup("default",
            policy_group_name="terraform-example",
            clipboard="read",
            local_drive="read",
            usb_redirect="off",
            watermark="off",
            authorize_access_policy_rules=[{
                "description": "terraform-example",
                "cidr_ip": "1.2.3.45/24",
            }],
            authorize_security_policy_rules=[{
                "type": "inflow",
                "policy": "accept",
                "description": "terraform-example",
                "port_range": "80/80",
                "ip_protocol": "TCP",
                "priority": "1",
                "cidr_ip": "1.2.3.4/24",
            }])
        ```

        ## Import

        Elastic Desktop Service (ECD) Policy Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/ecdPolicyGroup:EcdPolicyGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs', 'EcdPolicyGroupAuthorizeAccessPolicyRuleArgsDict']]]] authorize_access_policy_rules: The rule of authorize access rule. See `authorize_access_policy_rules` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs', 'EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsDict']]]] authorize_security_policy_rules: The policy rule. See `authorize_security_policy_rules` below.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to enable local camera redirection. Valid values: `on`, `off`.
        :param pulumi.Input[_builtins.str] clipboard: The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        :param pulumi.Input[_builtins.str] domain_list: The list of domain.
        :param pulumi.Input[_builtins.str] html_access: The access of html5. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] html_file_transfer: The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        :param pulumi.Input[_builtins.str] local_drive: Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        :param pulumi.Input[_builtins.str] policy_group_name: The name of policy group.
        :param pulumi.Input[_builtins.str] recording: Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        :param pulumi.Input[_builtins.str] recording_end_time: The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.int] recording_expires: The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        :param pulumi.Input[_builtins.int] recording_fps: The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        :param pulumi.Input[_builtins.str] recording_start_time: The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.str] usb_redirect: The usb redirect policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] visual_quality: The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        :param pulumi.Input[_builtins.str] watermark: The watermark policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] watermark_transparency: The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        :param pulumi.Input[_builtins.str] watermark_type: The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EcdPolicyGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Elastic Desktop Service (ECD) Policy Group resource.

        For information about Elastic Desktop Service (ECD) Policy Group and how to use it, see [What is Policy Group](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createpolicygroup).

        > **NOTE:** Available since v1.130.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.eds.EcdPolicyGroup("default",
            policy_group_name="terraform-example",
            clipboard="read",
            local_drive="read",
            usb_redirect="off",
            watermark="off",
            authorize_access_policy_rules=[{
                "description": "terraform-example",
                "cidr_ip": "1.2.3.45/24",
            }],
            authorize_security_policy_rules=[{
                "type": "inflow",
                "policy": "accept",
                "description": "terraform-example",
                "port_range": "80/80",
                "ip_protocol": "TCP",
                "priority": "1",
                "cidr_ip": "1.2.3.4/24",
            }])
        ```

        ## Import

        Elastic Desktop Service (ECD) Policy Group can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eds/ecdPolicyGroup:EcdPolicyGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcdPolicyGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcdPolicyGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorize_access_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs', 'EcdPolicyGroupAuthorizeAccessPolicyRuleArgsDict']]]]] = None,
                 authorize_security_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs', 'EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsDict']]]]] = None,
                 camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 clipboard: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_list: Optional[pulumi.Input[_builtins.str]] = None,
                 html_access: Optional[pulumi.Input[_builtins.str]] = None,
                 html_file_transfer: Optional[pulumi.Input[_builtins.str]] = None,
                 local_drive: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recording: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 recording_expires: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_fps: Optional[pulumi.Input[_builtins.int]] = None,
                 recording_start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 usb_redirect: Optional[pulumi.Input[_builtins.str]] = None,
                 visual_quality: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_transparency: Optional[pulumi.Input[_builtins.str]] = None,
                 watermark_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcdPolicyGroupArgs.__new__(EcdPolicyGroupArgs)

            __props__.__dict__["authorize_access_policy_rules"] = authorize_access_policy_rules
            __props__.__dict__["authorize_security_policy_rules"] = authorize_security_policy_rules
            __props__.__dict__["camera_redirect"] = camera_redirect
            __props__.__dict__["clipboard"] = clipboard
            __props__.__dict__["domain_list"] = domain_list
            __props__.__dict__["html_access"] = html_access
            __props__.__dict__["html_file_transfer"] = html_file_transfer
            __props__.__dict__["local_drive"] = local_drive
            __props__.__dict__["policy_group_name"] = policy_group_name
            __props__.__dict__["recording"] = recording
            __props__.__dict__["recording_end_time"] = recording_end_time
            __props__.__dict__["recording_expires"] = recording_expires
            __props__.__dict__["recording_fps"] = recording_fps
            __props__.__dict__["recording_start_time"] = recording_start_time
            __props__.__dict__["usb_redirect"] = usb_redirect
            __props__.__dict__["visual_quality"] = visual_quality
            __props__.__dict__["watermark"] = watermark
            __props__.__dict__["watermark_transparency"] = watermark_transparency
            __props__.__dict__["watermark_type"] = watermark_type
            __props__.__dict__["status"] = None
        super(EcdPolicyGroup, __self__).__init__(
            'alicloud:eds/ecdPolicyGroup:EcdPolicyGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorize_access_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs', 'EcdPolicyGroupAuthorizeAccessPolicyRuleArgsDict']]]]] = None,
            authorize_security_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs', 'EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsDict']]]]] = None,
            camera_redirect: Optional[pulumi.Input[_builtins.str]] = None,
            clipboard: Optional[pulumi.Input[_builtins.str]] = None,
            domain_list: Optional[pulumi.Input[_builtins.str]] = None,
            html_access: Optional[pulumi.Input[_builtins.str]] = None,
            html_file_transfer: Optional[pulumi.Input[_builtins.str]] = None,
            local_drive: Optional[pulumi.Input[_builtins.str]] = None,
            policy_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            recording: Optional[pulumi.Input[_builtins.str]] = None,
            recording_end_time: Optional[pulumi.Input[_builtins.str]] = None,
            recording_expires: Optional[pulumi.Input[_builtins.int]] = None,
            recording_fps: Optional[pulumi.Input[_builtins.int]] = None,
            recording_start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            usb_redirect: Optional[pulumi.Input[_builtins.str]] = None,
            visual_quality: Optional[pulumi.Input[_builtins.str]] = None,
            watermark: Optional[pulumi.Input[_builtins.str]] = None,
            watermark_transparency: Optional[pulumi.Input[_builtins.str]] = None,
            watermark_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'EcdPolicyGroup':
        """
        Get an existing EcdPolicyGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeAccessPolicyRuleArgs', 'EcdPolicyGroupAuthorizeAccessPolicyRuleArgsDict']]]] authorize_access_policy_rules: The rule of authorize access rule. See `authorize_access_policy_rules` below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs', 'EcdPolicyGroupAuthorizeSecurityPolicyRuleArgsDict']]]] authorize_security_policy_rules: The policy rule. See `authorize_security_policy_rules` below.
        :param pulumi.Input[_builtins.str] camera_redirect: Whether to enable local camera redirection. Valid values: `on`, `off`.
        :param pulumi.Input[_builtins.str] clipboard: The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        :param pulumi.Input[_builtins.str] domain_list: The list of domain.
        :param pulumi.Input[_builtins.str] html_access: The access of html5. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] html_file_transfer: The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        :param pulumi.Input[_builtins.str] local_drive: Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        :param pulumi.Input[_builtins.str] policy_group_name: The name of policy group.
        :param pulumi.Input[_builtins.str] recording: Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        :param pulumi.Input[_builtins.str] recording_end_time: The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.int] recording_expires: The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        :param pulumi.Input[_builtins.int] recording_fps: The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        :param pulumi.Input[_builtins.str] recording_start_time: The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        :param pulumi.Input[_builtins.str] status: The status of policy.
        :param pulumi.Input[_builtins.str] usb_redirect: The usb redirect policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] visual_quality: The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        :param pulumi.Input[_builtins.str] watermark: The watermark policy. Valid values: `off`, `on`.
        :param pulumi.Input[_builtins.str] watermark_transparency: The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        :param pulumi.Input[_builtins.str] watermark_type: The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcdPolicyGroupState.__new__(_EcdPolicyGroupState)

        __props__.__dict__["authorize_access_policy_rules"] = authorize_access_policy_rules
        __props__.__dict__["authorize_security_policy_rules"] = authorize_security_policy_rules
        __props__.__dict__["camera_redirect"] = camera_redirect
        __props__.__dict__["clipboard"] = clipboard
        __props__.__dict__["domain_list"] = domain_list
        __props__.__dict__["html_access"] = html_access
        __props__.__dict__["html_file_transfer"] = html_file_transfer
        __props__.__dict__["local_drive"] = local_drive
        __props__.__dict__["policy_group_name"] = policy_group_name
        __props__.__dict__["recording"] = recording
        __props__.__dict__["recording_end_time"] = recording_end_time
        __props__.__dict__["recording_expires"] = recording_expires
        __props__.__dict__["recording_fps"] = recording_fps
        __props__.__dict__["recording_start_time"] = recording_start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["usb_redirect"] = usb_redirect
        __props__.__dict__["visual_quality"] = visual_quality
        __props__.__dict__["watermark"] = watermark
        __props__.__dict__["watermark_transparency"] = watermark_transparency
        __props__.__dict__["watermark_type"] = watermark_type
        return EcdPolicyGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizeAccessPolicyRules")
    def authorize_access_policy_rules(self) -> pulumi.Output[Optional[Sequence['outputs.EcdPolicyGroupAuthorizeAccessPolicyRule']]]:
        """
        The rule of authorize access rule. See `authorize_access_policy_rules` below.
        """
        return pulumi.get(self, "authorize_access_policy_rules")

    @_builtins.property
    @pulumi.getter(name="authorizeSecurityPolicyRules")
    def authorize_security_policy_rules(self) -> pulumi.Output[Optional[Sequence['outputs.EcdPolicyGroupAuthorizeSecurityPolicyRule']]]:
        """
        The policy rule. See `authorize_security_policy_rules` below.
        """
        return pulumi.get(self, "authorize_security_policy_rules")

    @_builtins.property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable local camera redirection. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "camera_redirect")

    @_builtins.property
    @pulumi.getter
    def clipboard(self) -> pulumi.Output[_builtins.str]:
        """
        The clipboard policy. Valid values: `off`, `read`, `readwrite`.
        """
        return pulumi.get(self, "clipboard")

    @_builtins.property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The list of domain.
        """
        return pulumi.get(self, "domain_list")

    @_builtins.property
    @pulumi.getter(name="htmlAccess")
    def html_access(self) -> pulumi.Output[_builtins.str]:
        """
        The access of html5. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "html_access")

    @_builtins.property
    @pulumi.getter(name="htmlFileTransfer")
    def html_file_transfer(self) -> pulumi.Output[_builtins.str]:
        """
        The html5 file transfer. Valid values: `all`, `download`, `off`, `upload`.
        """
        return pulumi.get(self, "html_file_transfer")

    @_builtins.property
    @pulumi.getter(name="localDrive")
    def local_drive(self) -> pulumi.Output[_builtins.str]:
        """
        Local drive redirect policy. Valid values: ` readwrite`, `off`, `read`.
        """
        return pulumi.get(self, "local_drive")

    @_builtins.property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of policy group.
        """
        return pulumi.get(self, "policy_group_name")

    @_builtins.property
    @pulumi.getter
    def recording(self) -> pulumi.Output[_builtins.str]:
        """
        Whether to enable screen recording. Valid values: `off`, `all-time`, `period`.
        """
        return pulumi.get(self, "recording")

    @_builtins.property
    @pulumi.getter(name="recordingEndTime")
    def recording_end_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_end_time")

    @_builtins.property
    @pulumi.getter(name="recordingExpires")
    def recording_expires(self) -> pulumi.Output[_builtins.int]:
        """
        The screen recording video retention. Valid values between 30 and 180. This return value is meaningful only when the value of `recording` is `period` or `all-time`.
        """
        return pulumi.get(self, "recording_expires")

    @_builtins.property
    @pulumi.getter(name="recordingFps")
    def recording_fps(self) -> pulumi.Output[_builtins.int]:
        """
        The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        """
        return pulumi.get(self, "recording_fps")

    @_builtins.property
    @pulumi.getter(name="recordingStartTime")
    def recording_start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The start time of recording, value: `HH:MM:SS`. This return value is meaningful only when the value of `recording` is `period`.
        """
        return pulumi.get(self, "recording_start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of policy.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="usbRedirect")
    def usb_redirect(self) -> pulumi.Output[_builtins.str]:
        """
        The usb redirect policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "usb_redirect")

    @_builtins.property
    @pulumi.getter(name="visualQuality")
    def visual_quality(self) -> pulumi.Output[_builtins.str]:
        """
        The quality of visual. Valid values: `high`, `lossless`, `low`, `medium`.
        """
        return pulumi.get(self, "visual_quality")

    @_builtins.property
    @pulumi.getter
    def watermark(self) -> pulumi.Output[_builtins.str]:
        """
        The watermark policy. Valid values: `off`, `on`.
        """
        return pulumi.get(self, "watermark")

    @_builtins.property
    @pulumi.getter(name="watermarkTransparency")
    def watermark_transparency(self) -> pulumi.Output[_builtins.str]:
        """
        The watermark transparency. Valid values: `DARK`, `LIGHT`, `MIDDLE`.
        """
        return pulumi.get(self, "watermark_transparency")

    @_builtins.property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of watemark. Valid values: `EndUserId`, `HostName`.
        """
        return pulumi.get(self, "watermark_type")

