# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]] = None,
                 hpn_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 networks: Optional[pulumi.Input['ClusterNetworksArgs']] = None,
                 nimiz_vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]] = None,
                 open_eni_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] cluster_description: cluster description
        :param pulumi.Input[_builtins.str] cluster_name: ClusterName
        :param pulumi.Input[_builtins.str] cluster_type: cluster type
        :param pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]] components: Component (software instance) See `components` below.
        :param pulumi.Input[_builtins.str] hpn_zone: Cluster Number
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input['ClusterNetworksArgs'] networks: Network Information See `networks` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nimiz_vswitches: Node virtual switch
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Node Group List See `node_groups` below.
        :param pulumi.Input[_builtins.bool] open_eni_jumbo_frame: Whether the network interface supports jumbo frames
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: tag
        """
        if cluster_description is not None:
            pulumi.set(__self__, "cluster_description", cluster_description)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if hpn_zone is not None:
            pulumi.set(__self__, "hpn_zone", hpn_zone)
        if ignore_failed_node_tasks is not None:
            pulumi.set(__self__, "ignore_failed_node_tasks", ignore_failed_node_tasks)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if nimiz_vswitches is not None:
            pulumi.set(__self__, "nimiz_vswitches", nimiz_vswitches)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if open_eni_jumbo_frame is not None:
            pulumi.set(__self__, "open_eni_jumbo_frame", open_eni_jumbo_frame)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterDescription")
    def cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster description
        """
        return pulumi.get(self, "cluster_description")

    @cluster_description.setter
    def cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ClusterName
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster type
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]]:
        """
        Component (software instance) See `components` below.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @_builtins.property
    @pulumi.getter(name="hpnZone")
    def hpn_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster Number
        """
        return pulumi.get(self, "hpn_zone")

    @hpn_zone.setter
    def hpn_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hpn_zone", value)

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @ignore_failed_node_tasks.setter
    def ignore_failed_node_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_failed_node_tasks", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input['ClusterNetworksArgs']]:
        """
        Network Information See `networks` below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input['ClusterNetworksArgs']]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="nimizVswitches")
    def nimiz_vswitches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Node virtual switch
        """
        return pulumi.get(self, "nimiz_vswitches")

    @nimiz_vswitches.setter
    def nimiz_vswitches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nimiz_vswitches", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]:
        """
        Node Group List See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]):
        pulumi.set(self, "node_groups", value)

    @_builtins.property
    @pulumi.getter(name="openEniJumboFrame")
    def open_eni_jumbo_frame(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the network interface supports jumbo frames
        """
        return pulumi.get(self, "open_eni_jumbo_frame")

    @open_eni_jumbo_frame.setter
    def open_eni_jumbo_frame(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_eni_jumbo_frame", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 hpn_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 networks: Optional[pulumi.Input['ClusterNetworksArgs']] = None,
                 nimiz_vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]] = None,
                 open_eni_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] cluster_description: cluster description
        :param pulumi.Input[_builtins.str] cluster_name: ClusterName
        :param pulumi.Input[_builtins.str] cluster_type: cluster type
        :param pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]] components: Component (software instance) See `components` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] hpn_zone: Cluster Number
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input['ClusterNetworksArgs'] networks: Network Information See `networks` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nimiz_vswitches: Node virtual switch
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Node Group List See `node_groups` below.
        :param pulumi.Input[_builtins.bool] open_eni_jumbo_frame: Whether the network interface supports jumbo frames
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: tag
        """
        if cluster_description is not None:
            pulumi.set(__self__, "cluster_description", cluster_description)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if hpn_zone is not None:
            pulumi.set(__self__, "hpn_zone", hpn_zone)
        if ignore_failed_node_tasks is not None:
            pulumi.set(__self__, "ignore_failed_node_tasks", ignore_failed_node_tasks)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if nimiz_vswitches is not None:
            pulumi.set(__self__, "nimiz_vswitches", nimiz_vswitches)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if open_eni_jumbo_frame is not None:
            pulumi.set(__self__, "open_eni_jumbo_frame", open_eni_jumbo_frame)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterDescription")
    def cluster_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster description
        """
        return pulumi.get(self, "cluster_description")

    @cluster_description.setter
    def cluster_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_description", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ClusterName
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        cluster type
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_type", value)

    @_builtins.property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]]:
        """
        Component (software instance) See `components` below.
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="hpnZone")
    def hpn_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster Number
        """
        return pulumi.get(self, "hpn_zone")

    @hpn_zone.setter
    def hpn_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hpn_zone", value)

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @ignore_failed_node_tasks.setter
    def ignore_failed_node_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_failed_node_tasks", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input['ClusterNetworksArgs']]:
        """
        Network Information See `networks` below.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input['ClusterNetworksArgs']]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="nimizVswitches")
    def nimiz_vswitches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Node virtual switch
        """
        return pulumi.get(self, "nimiz_vswitches")

    @nimiz_vswitches.setter
    def nimiz_vswitches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "nimiz_vswitches", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]:
        """
        Node Group List See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]):
        pulumi.set(self, "node_groups", value)

    @_builtins.property
    @pulumi.getter(name="openEniJumboFrame")
    def open_eni_jumbo_frame(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the network interface supports jumbo frames
        """
        return pulumi.get(self, "open_eni_jumbo_frame")

    @open_eni_jumbo_frame.setter
    def open_eni_jumbo_frame(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_eni_jumbo_frame", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        tag
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:eflo/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentArgs', 'ClusterComponentArgsDict']]]]] = None,
                 hpn_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 networks: Optional[pulumi.Input[Union['ClusterNetworksArgs', 'ClusterNetworksArgsDict']]] = None,
                 nimiz_vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
                 open_eni_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Eflo Cluster resource.

        Large computing cluster.

        For information about Eflo Cluster and how to use it, see [What is Cluster](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/CreateCluster).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name="cluster-resoure-example")
        create_vswitch = alicloud.vpc.Switch("create_vswitch",
            vpc_id=create_vpc.id,
            zone_id="cn-hangzhou-b",
            cidr_block="192.168.0.0/24",
            vswitch_name="cluster-resoure-example")
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            description="sg",
            security_group_name="cluster-resoure-example",
            security_group_type="normal",
            vpc_id=create_vpc.id)
        default_cluster = alicloud.eflo.Cluster("default",
            cluster_description="cluster-resource-example",
            open_eni_jumbo_frame=False,
            hpn_zone="B1",
            nimiz_vswitches=["1111"],
            ignore_failed_node_tasks=True,
            resource_group_id=default.ids[1],
            node_groups=[{
                "image_id": "i198448731735114628708",
                "zone_id": "cn-hangzhou-b",
                "node_group_name": "cluster-resource-example",
                "node_group_description": "cluster-resource-example",
                "machine_type": "efg2.C48cA3sen",
            }],
            networks={
                "tail_ip_version": "ipv4",
                "new_vpd_info": {
                    "monitor_vpc_id": create_vpc.id,
                    "monitor_vswitch_id": create_vswitch.id,
                    "cen_id": "11111",
                    "cloud_link_id": "1111",
                    "vpd_cidr": "111",
                    "vpd_subnets": [{
                        "zone_id": "1111",
                        "subnet_cidr": "111",
                        "subnet_type": "111",
                    }],
                    "cloud_link_cidr": "169.254.128.0/23",
                },
                "security_group_id": create_security_group.id,
                "vswitch_zone_id": "cn-hangzhou-b",
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "vpd_info": {
                    "vpd_id": "111",
                    "vpd_subnets": ["111"],
                },
                "ip_allocation_policies": [{
                    "bond_policy": {
                        "bond_default_subnet": "111",
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                    },
                    "machine_type_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "machine_type": "111",
                    }],
                    "node_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "node_id": "111",
                    }],
                }],
            },
            cluster_name="tfacceflo7165",
            cluster_type="Lite")
        ```

        ## Import

        Eflo Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/cluster:Cluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_description: cluster description
        :param pulumi.Input[_builtins.str] cluster_name: ClusterName
        :param pulumi.Input[_builtins.str] cluster_type: cluster type
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentArgs', 'ClusterComponentArgsDict']]]] components: Component (software instance) See `components` below.
        :param pulumi.Input[_builtins.str] hpn_zone: Cluster Number
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[Union['ClusterNetworksArgs', 'ClusterNetworksArgsDict']] networks: Network Information See `networks` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nimiz_vswitches: Node virtual switch
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]] node_groups: Node Group List See `node_groups` below.
        :param pulumi.Input[_builtins.bool] open_eni_jumbo_frame: Whether the network interface supports jumbo frames
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: tag
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ClusterArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Cluster resource.

        Large computing cluster.

        For information about Eflo Cluster and how to use it, see [What is Cluster](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/CreateCluster).

        > **NOTE:** Available since v1.246.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        create_vpc = alicloud.vpc.Network("create_vpc",
            cidr_block="192.168.0.0/16",
            vpc_name="cluster-resoure-example")
        create_vswitch = alicloud.vpc.Switch("create_vswitch",
            vpc_id=create_vpc.id,
            zone_id="cn-hangzhou-b",
            cidr_block="192.168.0.0/24",
            vswitch_name="cluster-resoure-example")
        create_security_group = alicloud.ecs.SecurityGroup("create_security_group",
            description="sg",
            security_group_name="cluster-resoure-example",
            security_group_type="normal",
            vpc_id=create_vpc.id)
        default_cluster = alicloud.eflo.Cluster("default",
            cluster_description="cluster-resource-example",
            open_eni_jumbo_frame=False,
            hpn_zone="B1",
            nimiz_vswitches=["1111"],
            ignore_failed_node_tasks=True,
            resource_group_id=default.ids[1],
            node_groups=[{
                "image_id": "i198448731735114628708",
                "zone_id": "cn-hangzhou-b",
                "node_group_name": "cluster-resource-example",
                "node_group_description": "cluster-resource-example",
                "machine_type": "efg2.C48cA3sen",
            }],
            networks={
                "tail_ip_version": "ipv4",
                "new_vpd_info": {
                    "monitor_vpc_id": create_vpc.id,
                    "monitor_vswitch_id": create_vswitch.id,
                    "cen_id": "11111",
                    "cloud_link_id": "1111",
                    "vpd_cidr": "111",
                    "vpd_subnets": [{
                        "zone_id": "1111",
                        "subnet_cidr": "111",
                        "subnet_type": "111",
                    }],
                    "cloud_link_cidr": "169.254.128.0/23",
                },
                "security_group_id": create_security_group.id,
                "vswitch_zone_id": "cn-hangzhou-b",
                "vpc_id": create_vpc.id,
                "vswitch_id": create_vswitch.id,
                "vpd_info": {
                    "vpd_id": "111",
                    "vpd_subnets": ["111"],
                },
                "ip_allocation_policies": [{
                    "bond_policy": {
                        "bond_default_subnet": "111",
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                    },
                    "machine_type_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "machine_type": "111",
                    }],
                    "node_policies": [{
                        "bonds": [{
                            "name": "111",
                            "subnet": "111",
                        }],
                        "node_id": "111",
                    }],
                }],
            },
            cluster_name="tfacceflo7165",
            cluster_type="Lite")
        ```

        ## Import

        Eflo Cluster can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/cluster:Cluster example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentArgs', 'ClusterComponentArgsDict']]]]] = None,
                 hpn_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
                 networks: Optional[pulumi.Input[Union['ClusterNetworksArgs', 'ClusterNetworksArgsDict']]] = None,
                 nimiz_vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
                 open_eni_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["cluster_description"] = cluster_description
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["components"] = components
            __props__.__dict__["hpn_zone"] = hpn_zone
            __props__.__dict__["ignore_failed_node_tasks"] = ignore_failed_node_tasks
            __props__.__dict__["networks"] = networks
            __props__.__dict__["nimiz_vswitches"] = nimiz_vswitches
            __props__.__dict__["node_groups"] = node_groups
            __props__.__dict__["open_eni_jumbo_frame"] = open_eni_jumbo_frame
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Cluster, __self__).__init__(
            'alicloud:eflo/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_description: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_type: Optional[pulumi.Input[_builtins.str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentArgs', 'ClusterComponentArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            hpn_zone: Optional[pulumi.Input[_builtins.str]] = None,
            ignore_failed_node_tasks: Optional[pulumi.Input[_builtins.bool]] = None,
            networks: Optional[pulumi.Input[Union['ClusterNetworksArgs', 'ClusterNetworksArgsDict']]] = None,
            nimiz_vswitches: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]]] = None,
            open_eni_jumbo_frame: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_description: cluster description
        :param pulumi.Input[_builtins.str] cluster_name: ClusterName
        :param pulumi.Input[_builtins.str] cluster_type: cluster type
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterComponentArgs', 'ClusterComponentArgsDict']]]] components: Component (software instance) See `components` below.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] hpn_zone: Cluster Number
        :param pulumi.Input[_builtins.bool] ignore_failed_node_tasks: Whether to allow skipping failed nodes. Default value: False
        :param pulumi.Input[Union['ClusterNetworksArgs', 'ClusterNetworksArgsDict']] networks: Network Information See `networks` below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] nimiz_vswitches: Node virtual switch
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeGroupArgs', 'ClusterNodeGroupArgsDict']]]] node_groups: Node Group List See `node_groups` below.
        :param pulumi.Input[_builtins.bool] open_eni_jumbo_frame: Whether the network interface supports jumbo frames
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: tag
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["cluster_description"] = cluster_description
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["components"] = components
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["hpn_zone"] = hpn_zone
        __props__.__dict__["ignore_failed_node_tasks"] = ignore_failed_node_tasks
        __props__.__dict__["networks"] = networks
        __props__.__dict__["nimiz_vswitches"] = nimiz_vswitches
        __props__.__dict__["node_groups"] = node_groups
        __props__.__dict__["open_eni_jumbo_frame"] = open_eni_jumbo_frame
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterDescription")
    def cluster_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        cluster description
        """
        return pulumi.get(self, "cluster_description")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ClusterName
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        cluster type
        """
        return pulumi.get(self, "cluster_type")

    @_builtins.property
    @pulumi.getter
    def components(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterComponent']]]:
        """
        Component (software instance) See `components` below.
        """
        return pulumi.get(self, "components")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="hpnZone")
    def hpn_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Cluster Number
        """
        return pulumi.get(self, "hpn_zone")

    @_builtins.property
    @pulumi.getter(name="ignoreFailedNodeTasks")
    def ignore_failed_node_tasks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to allow skipping failed nodes. Default value: False
        """
        return pulumi.get(self, "ignore_failed_node_tasks")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Optional['outputs.ClusterNetworks']]:
        """
        Network Information See `networks` below.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="nimizVswitches")
    def nimiz_vswitches(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Node virtual switch
        """
        return pulumi.get(self, "nimiz_vswitches")

    @_builtins.property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterNodeGroup']]]:
        """
        Node Group List See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @_builtins.property
    @pulumi.getter(name="openEniJumboFrame")
    def open_eni_jumbo_frame(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the network interface supports jumbo frames
        """
        return pulumi.get(self, "open_eni_jumbo_frame")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        tag
        """
        return pulumi.get(self, "tags")

