# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ErArgs', 'Er']

@pulumi.input_type
class ErArgs:
    def __init__(__self__, *,
                 er_name: pulumi.Input[_builtins.str],
                 master_zone_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Er resource.
        :param pulumi.Input[_builtins.str] er_name: Lingjun HUB name
        :param pulumi.Input[_builtins.str] master_zone_id: Primary zone
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label List
        """
        pulumi.set(__self__, "er_name", er_name)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="erName")
    def er_name(self) -> pulumi.Input[_builtins.str]:
        """
        Lingjun HUB name
        """
        return pulumi.get(self, "er_name")

    @er_name.setter
    def er_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "er_name", value)

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> pulumi.Input[_builtins.str]:
        """
        Primary zone
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "master_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group instance.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label List
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ErState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 er_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Er resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] er_name: Lingjun HUB name
        :param pulumi.Input[_builtins.str] master_zone_id: Primary zone
        :param pulumi.Input[_builtins.str] region_id: region information
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group instance.
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label List
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if er_name is not None:
            pulumi.set(__self__, "er_name", er_name)
        if master_zone_id is not None:
            pulumi.set(__self__, "master_zone_id", master_zone_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="erName")
    def er_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lingjun HUB name
        """
        return pulumi.get(self, "er_name")

    @er_name.setter
    def er_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "er_name", value)

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Primary zone
        """
        return pulumi.get(self, "master_zone_id")

    @master_zone_id.setter
    def master_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "master_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        region information
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group instance.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label List
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:eflo/er:Er")
class Er(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 er_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Eflo Er resource.

        For information about Eflo Er and how to use it, see [What is Er](https://next.api.alibabacloud.com/document/eflo/2022-05-30/CreateEr).

        > **NOTE:** Available since v1.258.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_er = alicloud.eflo.Er("default",
            er_name="er-example-tf",
            master_zone_id="cn-hangzhou-a",
            description="example")
        ```

        ## Import

        Eflo Er can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/er:Er example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] er_name: Lingjun HUB name
        :param pulumi.Input[_builtins.str] master_zone_id: Primary zone
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label List
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ErArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Er resource.

        For information about Eflo Er and how to use it, see [What is Er](https://next.api.alibabacloud.com/document/eflo/2022-05-30/CreateEr).

        > **NOTE:** Available since v1.258.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_er = alicloud.eflo.Er("default",
            er_name="er-example-tf",
            master_zone_id="cn-hangzhou-a",
            description="example")
        ```

        ## Import

        Eflo Er can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/er:Er example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ErArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ErArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 er_name: Optional[pulumi.Input[_builtins.str]] = None,
                 master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ErArgs.__new__(ErArgs)

            __props__.__dict__["description"] = description
            if er_name is None and not opts.urn:
                raise TypeError("Missing required property 'er_name'")
            __props__.__dict__["er_name"] = er_name
            if master_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'master_zone_id'")
            __props__.__dict__["master_zone_id"] = master_zone_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(Er, __self__).__init__(
            'alicloud:eflo/er:Er',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            er_name: Optional[pulumi.Input[_builtins.str]] = None,
            master_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Er':
        """
        Get an existing Er resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource
        :param pulumi.Input[_builtins.str] description: Description.
        :param pulumi.Input[_builtins.str] er_name: Lingjun HUB name
        :param pulumi.Input[_builtins.str] master_zone_id: Primary zone
        :param pulumi.Input[_builtins.str] region_id: region information
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group instance.
        :param pulumi.Input[_builtins.str] status: Status
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label List
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ErState.__new__(_ErState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["er_name"] = er_name
        __props__.__dict__["master_zone_id"] = master_zone_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Er(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="erName")
    def er_name(self) -> pulumi.Output[_builtins.str]:
        """
        Lingjun HUB name
        """
        return pulumi.get(self, "er_name")

    @_builtins.property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Primary zone
        """
        return pulumi.get(self, "master_zone_id")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        region information
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group instance.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Label List
        """
        return pulumi.get(self, "tags")

