# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExperimentPlanArgs', 'ExperimentPlan']

@pulumi.input_type
class ExperimentPlanArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.int],
                 template_id: pulumi.Input[_builtins.int],
                 external_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ExperimentPlan resource.
        :param pulumi.Input[_builtins.int] resource_id: The ID of the resource.
        :param pulumi.Input[_builtins.int] template_id: The ID of the template.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] external_params: Additional operating parameters. You can include information about the specified node.
        :param pulumi.Input[_builtins.str] plan_name: Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "template_id", template_id)
        if external_params is not None:
            pulumi.set(__self__, "external_params", external_params)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "template_id", value)

    @_builtins.property
    @pulumi.getter(name="externalParams")
    def external_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional operating parameters. You can include information about the specified node.
        """
        return pulumi.get(self, "external_params")

    @external_params.setter
    def external_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_params", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ExperimentPlanState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 external_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ExperimentPlan resources.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] external_params: Additional operating parameters. You can include information about the specified node.
        :param pulumi.Input[_builtins.str] plan_name: Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] resource_id: The ID of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.int] template_id: The ID of the template.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if external_params is not None:
            pulumi.set(__self__, "external_params", external_params)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="externalParams")
    def external_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional operating parameters. You can include information about the specified node.
        """
        return pulumi.get(self, "external_params")

    @external_params.setter
    def external_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_params", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("alicloud:eflo/experimentPlan:ExperimentPlan")
class ExperimentPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Eflo Experiment Plan resource.

        For information about Eflo Experiment Plan and how to use it, see [What is Experiment Plan](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eflo-cnp-2023-08-28-createexperimentplan).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        defaultp_szn7t = alicloud.eflo.ExperimentPlanTemplate("defaultpSZN7t",
            template_pipelines=[{
                "workload_id": 2,
                "workload_name": "MatMul",
                "env_params": {
                    "cpu_per_worker": 90,
                    "gpu_per_worker": 8,
                    "memory_per_worker": 500,
                    "share_memory": 500,
                    "worker_num": 1,
                    "py_torch_version": "1",
                    "gpu_driver_version": "1",
                    "cuda_version": "1",
                    "nccl_version": "1",
                },
                "pipeline_order": 1,
                "scene": "baseline",
            }],
            privacy_level="private",
            template_name=name,
            template_description=name)
        default_resource = alicloud.eflo.Resource("default",
            user_access_param={
                "access_id": "your_access_id",
                "access_key": "your_access_key",
                "workspace_id": "your_workspace_id",
                "endpoint": "your_endpoint",
            },
            cluster_id=f"terraform-{default['result']}",
            machine_types={
                "memory_info": "32x 64GB DDR4 4800 Memory",
                "type": "Private",
                "bond_num": 5,
                "node_count": 1,
                "cpu_info": "2x Intel Saphhire Rapid 8469C 48C CPU",
                "network_info": "1x 200Gbps Dual Port BF3 DPU for VPC 4x 200Gbps Dual Port EIC",
                "gpu_info": "8x OAM 810 GPU",
                "disk_info": "2x 480GB SATA SSD 4x 3.84TB NVMe SSD",
                "network_mode": "net",
                "name": "lingjun",
            },
            cluster_name=name,
            cluster_desc=name)
        default_experiment_plan = alicloud.eflo.ExperimentPlan("default",
            resource_id=default_resource.resource_id,
            plan_name=name,
            template_id=defaultp_szn7t.id)
        ```

        ## Import

        Eflo Experiment Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/experimentPlan:ExperimentPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] external_params: Additional operating parameters. You can include information about the specified node.
        :param pulumi.Input[_builtins.str] plan_name: Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] resource_id: The ID of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.int] template_id: The ID of the template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExperimentPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Experiment Plan resource.

        For information about Eflo Experiment Plan and how to use it, see [What is Experiment Plan](https://www.alibabacloud.com/help/en/pai/developer-reference/api-eflo-cnp-2023-08-28-createexperimentplan).

        > **NOTE:** Available since v1.248.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = random.index.Integer("default",
            min=10000,
            max=99999)
        defaultp_szn7t = alicloud.eflo.ExperimentPlanTemplate("defaultpSZN7t",
            template_pipelines=[{
                "workload_id": 2,
                "workload_name": "MatMul",
                "env_params": {
                    "cpu_per_worker": 90,
                    "gpu_per_worker": 8,
                    "memory_per_worker": 500,
                    "share_memory": 500,
                    "worker_num": 1,
                    "py_torch_version": "1",
                    "gpu_driver_version": "1",
                    "cuda_version": "1",
                    "nccl_version": "1",
                },
                "pipeline_order": 1,
                "scene": "baseline",
            }],
            privacy_level="private",
            template_name=name,
            template_description=name)
        default_resource = alicloud.eflo.Resource("default",
            user_access_param={
                "access_id": "your_access_id",
                "access_key": "your_access_key",
                "workspace_id": "your_workspace_id",
                "endpoint": "your_endpoint",
            },
            cluster_id=f"terraform-{default['result']}",
            machine_types={
                "memory_info": "32x 64GB DDR4 4800 Memory",
                "type": "Private",
                "bond_num": 5,
                "node_count": 1,
                "cpu_info": "2x Intel Saphhire Rapid 8469C 48C CPU",
                "network_info": "1x 200Gbps Dual Port BF3 DPU for VPC 4x 200Gbps Dual Port EIC",
                "gpu_info": "8x OAM 810 GPU",
                "disk_info": "2x 480GB SATA SSD 4x 3.84TB NVMe SSD",
                "network_mode": "net",
                "name": "lingjun",
            },
            cluster_name=name,
            cluster_desc=name)
        default_experiment_plan = alicloud.eflo.ExperimentPlan("default",
            resource_id=default_resource.resource_id,
            plan_name=name,
            template_id=defaultp_szn7t.id)
        ```

        ## Import

        Eflo Experiment Plan can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/experimentPlan:ExperimentPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ExperimentPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExperimentPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExperimentPlanArgs.__new__(ExperimentPlanArgs)

            __props__.__dict__["external_params"] = external_params
            __props__.__dict__["plan_name"] = plan_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["tags"] = tags
            if template_id is None and not opts.urn:
                raise TypeError("Missing required property 'template_id'")
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["create_time"] = None
        super(ExperimentPlan, __self__).__init__(
            'alicloud:eflo/experimentPlan:ExperimentPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            external_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            template_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'ExperimentPlan':
        """
        Get an existing ExperimentPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] external_params: Additional operating parameters. You can include information about the specified node.
        :param pulumi.Input[_builtins.str] plan_name: Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[_builtins.int] resource_id: The ID of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag of the resource.
        :param pulumi.Input[_builtins.int] template_id: The ID of the template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExperimentPlanState.__new__(_ExperimentPlanState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["external_params"] = external_params
        __props__.__dict__["plan_name"] = plan_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_id"] = template_id
        return ExperimentPlan(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="externalParams")
    def external_params(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Additional operating parameters. You can include information about the specified node.
        """
        return pulumi.get(self, "external_params")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the name of the experiment plan, which is used to distinguish different experiment plans.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the template.
        """
        return pulumi.get(self, "template_id")

