# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodeGroupAttachmentArgs', 'NodeGroupAttachment']

@pulumi.input_type
class NodeGroupAttachmentArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 vswitch_id: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NodeGroupAttachment resource.
        :param pulumi.Input[_builtins.str] hostname: Node hostname
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: vswitch id
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]] data_disks: The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        :param pulumi.Input[_builtins.str] login_password: Node login password
        :param pulumi.Input[_builtins.str] node_group_id: Node group ID
        :param pulumi.Input[_builtins.str] node_id: Node ID
        :param pulumi.Input[_builtins.str] user_data: User-defined data
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[_builtins.str]:
        """
        Node hostname
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        vswitch id
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]]:
        """
        The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node login password
        """
        return pulumi.get(self, "login_password")

    @login_password.setter
    def login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_password", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group ID
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node ID
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _NodeGroupAttachmentState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NodeGroupAttachment resources.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]] data_disks: The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        :param pulumi.Input[_builtins.str] hostname: Node hostname
        :param pulumi.Input[_builtins.str] login_password: Node login password
        :param pulumi.Input[_builtins.str] node_group_id: Node group ID
        :param pulumi.Input[_builtins.str] node_id: Node ID
        :param pulumi.Input[_builtins.str] user_data: User-defined data
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: vswitch id
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if login_password is not None:
            pulumi.set(__self__, "login_password", login_password)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]]:
        """
        The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodeGroupAttachmentDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node hostname
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node login password
        """
        return pulumi.get(self, "login_password")

    @login_password.setter
    def login_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_password", value)

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node group ID
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_group_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node ID
        """
        return pulumi.get(self, "node_id")

    @node_id.setter
    def node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_id", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        vswitch id
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:eflo/nodeGroupAttachment:NodeGroupAttachment")
class NodeGroupAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupAttachmentDataDiskArgs', 'NodeGroupAttachmentDataDiskArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Eflo Node Group Attachment resource.

        Node Association Node Group Resources.

        For information about Eflo Node Group Attachment and how to use it, see [What is Node Group Attachment](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/ExtendCluster).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.eflo.NodeGroupAttachment("default",
            vswitch_id="vsw-uf63gbmvwgreao66opmie",
            hostname="attachment-example-e01-cn-smw4d1bzd0a",
            login_password="G7f$2kL9@vQx3Zp5*",
            cluster_id="i118976621753269898628",
            node_group_id="i127582271753269898630",
            node_id="e01-cn-smw4d1bzd0a",
            vpc_id="vpc-uf6t73bb01dfprb2qvpqa")
        ```

        ## Import

        Eflo Node Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/nodeGroupAttachment:NodeGroupAttachment example <cluster_id>:<node_group_id>:<node_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupAttachmentDataDiskArgs', 'NodeGroupAttachmentDataDiskArgsDict']]]] data_disks: The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        :param pulumi.Input[_builtins.str] hostname: Node hostname
        :param pulumi.Input[_builtins.str] login_password: Node login password
        :param pulumi.Input[_builtins.str] node_group_id: Node group ID
        :param pulumi.Input[_builtins.str] node_id: Node ID
        :param pulumi.Input[_builtins.str] user_data: User-defined data
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: vswitch id
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodeGroupAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eflo Node Group Attachment resource.

        Node Association Node Group Resources.

        For information about Eflo Node Group Attachment and how to use it, see [What is Node Group Attachment](https://next.api.alibabacloud.com/document/eflo-controller/2022-12-15/ExtendCluster).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.eflo.NodeGroupAttachment("default",
            vswitch_id="vsw-uf63gbmvwgreao66opmie",
            hostname="attachment-example-e01-cn-smw4d1bzd0a",
            login_password="G7f$2kL9@vQx3Zp5*",
            cluster_id="i118976621753269898628",
            node_group_id="i127582271753269898630",
            node_id="e01-cn-smw4d1bzd0a",
            vpc_id="vpc-uf6t73bb01dfprb2qvpqa")
        ```

        ## Import

        Eflo Node Group Attachment can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:eflo/nodeGroupAttachment:NodeGroupAttachment example <cluster_id>:<node_group_id>:<node_id>
        ```

        :param str resource_name: The name of the resource.
        :param NodeGroupAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodeGroupAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupAttachmentDataDiskArgs', 'NodeGroupAttachmentDataDiskArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 login_password: Optional[pulumi.Input[_builtins.str]] = None,
                 node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodeGroupAttachmentArgs.__new__(NodeGroupAttachmentArgs)

            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["data_disks"] = data_disks
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["login_password"] = login_password
            __props__.__dict__["node_group_id"] = node_group_id
            __props__.__dict__["node_id"] = node_id
            __props__.__dict__["user_data"] = user_data
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
        super(NodeGroupAttachment, __self__).__init__(
            'alicloud:eflo/nodeGroupAttachment:NodeGroupAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupAttachmentDataDiskArgs', 'NodeGroupAttachmentDataDiskArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            login_password: Optional[pulumi.Input[_builtins.str]] = None,
            node_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NodeGroupAttachment':
        """
        Get an existing NodeGroupAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: Cluster ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodeGroupAttachmentDataDiskArgs', 'NodeGroupAttachmentDataDiskArgsDict']]]] data_disks: The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        :param pulumi.Input[_builtins.str] hostname: Node hostname
        :param pulumi.Input[_builtins.str] login_password: Node login password
        :param pulumi.Input[_builtins.str] node_group_id: Node group ID
        :param pulumi.Input[_builtins.str] node_id: Node ID
        :param pulumi.Input[_builtins.str] user_data: User-defined data
        :param pulumi.Input[_builtins.str] vpc_id: Vpc id
        :param pulumi.Input[_builtins.str] vswitch_id: vswitch id
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodeGroupAttachmentState.__new__(_NodeGroupAttachmentState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["login_password"] = login_password
        __props__.__dict__["node_group_id"] = node_group_id
        __props__.__dict__["node_id"] = node_id
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return NodeGroupAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster ID
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.NodeGroupAttachmentDataDisk']]]:
        """
        The data disk of the cloud disk to be attached to the node. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        """
        Node hostname
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="loginPassword")
    def login_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Node login password
        """
        return pulumi.get(self, "login_password")

    @_builtins.property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Node group ID
        """
        return pulumi.get(self, "node_group_id")

    @_builtins.property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[_builtins.str]:
        """
        Node ID
        """
        return pulumi.get(self, "node_id")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined data
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Vpc id
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        vswitch id
        """
        return pulumi.get(self, "vswitch_id")

