# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[_builtins.str],
                 payment_type: pulumi.Input[_builtins.str],
                 schedule_area_level: pulumi.Input[_builtins.str],
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 carrier: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_district_code: Optional[pulumi.Input[_builtins.str]] = None,
                 net_work_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['InstanceSystemDiskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] instance_type: The specification of the instance. Example value: ens.sn1.small
        :param pulumi.Input[_builtins.str] payment_type: Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
               - Subscription: prepaid, annual and monthly
               - PayAsYouGo: Pay by volume
        :param pulumi.Input[_builtins.str] schedule_area_level: Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
               - Node-level scheduling: Region
               - Regional scheduling: Big (region),Middle (province),Small (city)
        :param pulumi.Input[_builtins.int] amount: The number of instances created, with a minimum of 1 and a maximum of 100
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
               - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
               - The minimum release time is one hour after the current time.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        :param pulumi.Input[_builtins.str] auto_use_coupon: Whether to use vouchers. The default is to use. Value:
               - true (used)
               - false (not used)
        :param pulumi.Input[_builtins.str] billing_cycle: The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
               - Hour: hourly billing
               - Day: Daily billing
               - Month: monthly billing
        :param pulumi.Input[_builtins.str] carrier: Operator, required for regional scheduling. Optional values:
               - cmcc (mobile)
               - unicom
               - telecom
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Data disk specifications See `data_disk` below.
        :param pulumi.Input[_builtins.str] ens_region_id: The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        :param pulumi.Input[_builtins.str] force_stop: Whether to force the identity when operating the instance. Optional values:
               - true: Force
               - false (default): non-mandatory
        :param pulumi.Input[_builtins.str] host_name: The host name of the instance. Example value: test-HostName
        :param pulumi.Input[_builtins.str] image_id: The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether the Payment type of the disk created with the instance is converted.
        :param pulumi.Input[_builtins.str] instance_charge_strategy: The instance billing policy. Optional values:
               - instance: instance granularity (the subscription method does not support instance)
               - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        :param pulumi.Input[_builtins.str] instance_name: The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)
               
               The default value is the InstanceId of the instance.
        :param pulumi.Input[_builtins.str] internet_charge_type: Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
               - BandwidthByDay: Daily peak bandwidth
               - 95bandwidthbymonth: 95 peak bandwidth
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        :param pulumi.Input[_builtins.str] ip_type: The IP type. Value:
               - ipv4 (default):IPv4
               - ipv6:IPv6
               - ipv4Andipv6:IPv4 and IPv6
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name.
               
               > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        :param pulumi.Input[_builtins.str] net_district_code: The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        :param pulumi.Input[_builtins.str] net_work_id: The network ID of the instance. Can only be used in node-level scheduling
        :param pulumi.Input[_builtins.str] password: The instance password. At least one of Password, KeyPairName, and PasswordInherit
        :param pulumi.Input[_builtins.bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. Value method:
               - If PeriodUnit is set to Day, Period can only be set to 3.
               - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources. Value:
               - Month (default): purchase by Month
               - Day: buy by Day
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        :param pulumi.Input[_builtins.bool] public_ip_identification: Whether to assign a public IP identifier. Value:
               - true (default): Assign
               - false: do not assign
        :param pulumi.Input[_builtins.str] scheduling_price_strategy: Scheduling price policy. If it is not filled in, the default priority is low price. Value:
               - PriceLowPriority
               - PriceLowPriority (priority low price)
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling policy. Optional values:
               - Concentrate for node-level scheduling
               - For regional scheduling, Concentrate, Disperse
        :param pulumi.Input[_builtins.str] security_id: ID of the security group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
               - NoSpot: normal pay-as-you-go instance (default)
               - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        :param pulumi.Input[_builtins.str] status: Status of the instance
        :param pulumi.Input['InstanceSystemDiskArgs'] system_disk: System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag bound to the instance
        :param pulumi.Input[_builtins.bool] unique_suffix: Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        :param pulumi.Input[_builtins.str] user_data: User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "schedule_area_level", schedule_area_level)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if carrier is not None:
            pulumi.set(__self__, "carrier", carrier)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if include_data_disks is not None:
            pulumi.set(__self__, "include_data_disks", include_data_disks)
        if instance_charge_strategy is not None:
            pulumi.set(__self__, "instance_charge_strategy", instance_charge_strategy)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if ip_type is not None:
            pulumi.set(__self__, "ip_type", ip_type)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if net_district_code is not None:
            pulumi.set(__self__, "net_district_code", net_district_code)
        if net_work_id is not None:
            pulumi.set(__self__, "net_work_id", net_work_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_identification is not None:
            pulumi.set(__self__, "public_ip_identification", public_ip_identification)
        if scheduling_price_strategy is not None:
            pulumi.set(__self__, "scheduling_price_strategy", scheduling_price_strategy)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if security_id is not None:
            pulumi.set(__self__, "security_id", security_id)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The specification of the instance. Example value: ens.sn1.small
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
        - Subscription: prepaid, annual and monthly
        - PayAsYouGo: Pay by volume
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> pulumi.Input[_builtins.str]:
        """
        Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
        - Node-level scheduling: Region
        - Regional scheduling: Big (region),Middle (province),Small (city)
        """
        return pulumi.get(self, "schedule_area_level")

    @schedule_area_level.setter
    def schedule_area_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schedule_area_level", value)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances created, with a minimum of 1 and a maximum of 100
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
        - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
        - The minimum release time is one hour after the current time.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use vouchers. The default is to use. Value:
        - true (used)
        - false (not used)
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
        - Hour: hourly billing
        - Day: Daily billing
        - Month: monthly billing
        """
        return pulumi.get(self, "billing_cycle")

    @billing_cycle.setter
    def billing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_cycle", value)

    @_builtins.property
    @pulumi.getter
    def carrier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operator, required for regional scheduling. Optional values:
        - cmcc (mobile)
        - unicom
        - telecom
        """
        return pulumi.get(self, "carrier")

    @carrier.setter
    def carrier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "carrier", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Data disk specifications See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to force the identity when operating the instance. Optional values:
        - true: Force
        - false (default): non-mandatory
        """
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_stop", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name of the instance. Example value: test-HostName
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Payment type of the disk created with the instance is converted.
        """
        return pulumi.get(self, "include_data_disks")

    @include_data_disks.setter
    def include_data_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance billing policy. Optional values:
        - instance: instance granularity (the subscription method does not support instance)
        - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        """
        return pulumi.get(self, "instance_charge_strategy")

    @instance_charge_strategy.setter
    def instance_charge_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_strategy", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)

        The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
        - BandwidthByDay: Daily peak bandwidth
        - 95bandwidthbymonth: 95 peak bandwidth
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP type. Value:
        - ipv4 (default):IPv4
        - ipv6:IPv6
        - ipv4Andipv6:IPv4 and IPv6
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_type", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair name.

        > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        """
        return pulumi.get(self, "net_district_code")

    @net_district_code.setter
    def net_district_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_district_code", value)

    @_builtins.property
    @pulumi.getter(name="netWorkId")
    def net_work_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID of the instance. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "net_work_id")

    @net_work_id.setter
    def net_work_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_work_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance password. At least one of Password, KeyPairName, and PasswordInherit
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the resource purchase. Value method:
        - If PeriodUnit is set to Day, Period can only be set to 3.
        - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of time for purchasing resources. Value:
        - Month (default): purchase by Month
        - Day: buy by Day
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to assign a public IP identifier. Value:
        - true (default): Assign
        - false: do not assign
        """
        return pulumi.get(self, "public_ip_identification")

    @public_ip_identification.setter
    def public_ip_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_ip_identification", value)

    @_builtins.property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling price policy. If it is not filled in, the default priority is low price. Value:
        - PriceLowPriority
        - PriceLowPriority (priority low price)
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @scheduling_price_strategy.setter
    def scheduling_price_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_price_strategy", value)

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling policy. Optional values:
        - Concentrate for node-level scheduling
        - For regional scheduling, Concentrate, Disperse
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityId")
    def security_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group to which the instance belongs.
        """
        return pulumi.get(self, "security_id")

    @security_id.setter
    def security_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_id", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
        - NoSpot: normal pay-as-you-go instance (default)
        - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['InstanceSystemDiskArgs']]:
        """
        System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['InstanceSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag bound to the instance
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unique_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 carrier: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_district_code: Optional[pulumi.Input[_builtins.str]] = None,
                 net_work_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_area_level: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input['InstanceSystemDiskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.int] amount: The number of instances created, with a minimum of 1 and a maximum of 100
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
               - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
               - The minimum release time is one hour after the current time.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        :param pulumi.Input[_builtins.str] auto_use_coupon: Whether to use vouchers. The default is to use. Value:
               - true (used)
               - false (not used)
        :param pulumi.Input[_builtins.str] billing_cycle: The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
               - Hour: hourly billing
               - Day: Daily billing
               - Month: monthly billing
        :param pulumi.Input[_builtins.str] carrier: Operator, required for regional scheduling. Optional values:
               - cmcc (mobile)
               - unicom
               - telecom
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Data disk specifications See `data_disk` below.
        :param pulumi.Input[_builtins.str] ens_region_id: The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        :param pulumi.Input[_builtins.str] force_stop: Whether to force the identity when operating the instance. Optional values:
               - true: Force
               - false (default): non-mandatory
        :param pulumi.Input[_builtins.str] host_name: The host name of the instance. Example value: test-HostName
        :param pulumi.Input[_builtins.str] image_id: The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether the Payment type of the disk created with the instance is converted.
        :param pulumi.Input[_builtins.str] instance_charge_strategy: The instance billing policy. Optional values:
               - instance: instance granularity (the subscription method does not support instance)
               - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        :param pulumi.Input[_builtins.str] instance_name: The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)
               
               The default value is the InstanceId of the instance.
        :param pulumi.Input[_builtins.str] instance_type: The specification of the instance. Example value: ens.sn1.small
        :param pulumi.Input[_builtins.str] internet_charge_type: Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
               - BandwidthByDay: Daily peak bandwidth
               - 95bandwidthbymonth: 95 peak bandwidth
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        :param pulumi.Input[_builtins.str] ip_type: The IP type. Value:
               - ipv4 (default):IPv4
               - ipv6:IPv6
               - ipv4Andipv6:IPv4 and IPv6
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name.
               
               > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        :param pulumi.Input[_builtins.str] net_district_code: The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        :param pulumi.Input[_builtins.str] net_work_id: The network ID of the instance. Can only be used in node-level scheduling
        :param pulumi.Input[_builtins.str] password: The instance password. At least one of Password, KeyPairName, and PasswordInherit
        :param pulumi.Input[_builtins.bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        :param pulumi.Input[_builtins.str] payment_type: Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
               - Subscription: prepaid, annual and monthly
               - PayAsYouGo: Pay by volume
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. Value method:
               - If PeriodUnit is set to Day, Period can only be set to 3.
               - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources. Value:
               - Month (default): purchase by Month
               - Day: buy by Day
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        :param pulumi.Input[_builtins.bool] public_ip_identification: Whether to assign a public IP identifier. Value:
               - true (default): Assign
               - false: do not assign
        :param pulumi.Input[_builtins.str] schedule_area_level: Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
               - Node-level scheduling: Region
               - Regional scheduling: Big (region),Middle (province),Small (city)
        :param pulumi.Input[_builtins.str] scheduling_price_strategy: Scheduling price policy. If it is not filled in, the default priority is low price. Value:
               - PriceLowPriority
               - PriceLowPriority (priority low price)
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling policy. Optional values:
               - Concentrate for node-level scheduling
               - For regional scheduling, Concentrate, Disperse
        :param pulumi.Input[_builtins.str] security_id: ID of the security group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
               - NoSpot: normal pay-as-you-go instance (default)
               - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        :param pulumi.Input[_builtins.str] status: Status of the instance
        :param pulumi.Input['InstanceSystemDiskArgs'] system_disk: System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag bound to the instance
        :param pulumi.Input[_builtins.bool] unique_suffix: Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        :param pulumi.Input[_builtins.str] user_data: User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_use_coupon is not None:
            pulumi.set(__self__, "auto_use_coupon", auto_use_coupon)
        if billing_cycle is not None:
            pulumi.set(__self__, "billing_cycle", billing_cycle)
        if carrier is not None:
            pulumi.set(__self__, "carrier", carrier)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if force_stop is not None:
            pulumi.set(__self__, "force_stop", force_stop)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if include_data_disks is not None:
            pulumi.set(__self__, "include_data_disks", include_data_disks)
        if instance_charge_strategy is not None:
            pulumi.set(__self__, "instance_charge_strategy", instance_charge_strategy)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if ip_type is not None:
            pulumi.set(__self__, "ip_type", ip_type)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if net_district_code is not None:
            pulumi.set(__self__, "net_district_code", net_district_code)
        if net_work_id is not None:
            pulumi.set(__self__, "net_work_id", net_work_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if public_ip_identification is not None:
            pulumi.set(__self__, "public_ip_identification", public_ip_identification)
        if schedule_area_level is not None:
            pulumi.set(__self__, "schedule_area_level", schedule_area_level)
        if scheduling_price_strategy is not None:
            pulumi.set(__self__, "scheduling_price_strategy", scheduling_price_strategy)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if security_id is not None:
            pulumi.set(__self__, "security_id", security_id)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances created, with a minimum of 1 and a maximum of 100
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "amount", value)

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
        - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
        - The minimum release time is one hour after the current time.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_release_time", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to use vouchers. The default is to use. Value:
        - true (used)
        - false (not used)
        """
        return pulumi.get(self, "auto_use_coupon")

    @auto_use_coupon.setter
    def auto_use_coupon(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_use_coupon", value)

    @_builtins.property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
        - Hour: hourly billing
        - Day: Daily billing
        - Month: monthly billing
        """
        return pulumi.get(self, "billing_cycle")

    @billing_cycle.setter
    def billing_cycle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_cycle", value)

    @_builtins.property
    @pulumi.getter
    def carrier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Operator, required for regional scheduling. Optional values:
        - cmcc (mobile)
        - unicom
        - telecom
        """
        return pulumi.get(self, "carrier")

    @carrier.setter
    def carrier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "carrier", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Data disk specifications See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ens_region_id", value)

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to force the identity when operating the instance. Optional values:
        - true: Force
        - false (default): non-mandatory
        """
        return pulumi.get(self, "force_stop")

    @force_stop.setter
    def force_stop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "force_stop", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host name of the instance. Example value: test-HostName
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Payment type of the disk created with the instance is converted.
        """
        return pulumi.get(self, "include_data_disks")

    @include_data_disks.setter
    def include_data_disks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance billing policy. Optional values:
        - instance: instance granularity (the subscription method does not support instance)
        - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        """
        return pulumi.get(self, "instance_charge_strategy")

    @instance_charge_strategy.setter
    def instance_charge_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_strategy", value)

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)

        The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the instance. Example value: ens.sn1.small
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
        - BandwidthByDay: Daily peak bandwidth
        - 95bandwidthbymonth: 95 peak bandwidth
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP type. Value:
        - ipv4 (default):IPv4
        - ipv6:IPv6
        - ipv4Andipv6:IPv4 and IPv6
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_type", value)

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair name.

        > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair_name", value)

    @_builtins.property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        """
        return pulumi.get(self, "net_district_code")

    @net_district_code.setter
    def net_district_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_district_code", value)

    @_builtins.property
    @pulumi.getter(name="netWorkId")
    def net_work_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network ID of the instance. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "net_work_id")

    @net_work_id.setter
    def net_work_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_work_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance password. At least one of Password, KeyPairName, and PasswordInherit
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "password_inherit", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
        - Subscription: prepaid, annual and monthly
        - PayAsYouGo: Pay by volume
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration of the resource purchase. Value method:
        - If PeriodUnit is set to Day, Period can only be set to 3.
        - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unit of time for purchasing resources. Value:
        - Month (default): purchase by Month
        - Day: buy by Day
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to assign a public IP identifier. Value:
        - true (default): Assign
        - false: do not assign
        """
        return pulumi.get(self, "public_ip_identification")

    @public_ip_identification.setter
    def public_ip_identification(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_ip_identification", value)

    @_builtins.property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
        - Node-level scheduling: Region
        - Regional scheduling: Big (region),Middle (province),Small (city)
        """
        return pulumi.get(self, "schedule_area_level")

    @schedule_area_level.setter
    def schedule_area_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schedule_area_level", value)

    @_builtins.property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling price policy. If it is not filled in, the default priority is low price. Value:
        - PriceLowPriority
        - PriceLowPriority (priority low price)
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @scheduling_price_strategy.setter
    def scheduling_price_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_price_strategy", value)

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduling policy. Optional values:
        - Concentrate for node-level scheduling
        - For regional scheduling, Concentrate, Disperse
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @_builtins.property
    @pulumi.getter(name="securityId")
    def security_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the security group to which the instance belongs.
        """
        return pulumi.get(self, "security_id")

    @security_id.setter
    def security_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_id", value)

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
        - NoSpot: normal pay-as-you-go instance (default)
        - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_strategy", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the instance
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['InstanceSystemDiskArgs']]:
        """
        System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['InstanceSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tag bound to the instance
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "unique_suffix", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:ens/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 carrier: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_district_code: Optional[pulumi.Input[_builtins.str]] = None,
                 net_work_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_area_level: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['InstanceSystemDiskArgs', 'InstanceSystemDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Ens Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: The number of instances created, with a minimum of 1 and a maximum of 100
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
               - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
               - The minimum release time is one hour after the current time.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        :param pulumi.Input[_builtins.str] auto_use_coupon: Whether to use vouchers. The default is to use. Value:
               - true (used)
               - false (not used)
        :param pulumi.Input[_builtins.str] billing_cycle: The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
               - Hour: hourly billing
               - Day: Daily billing
               - Month: monthly billing
        :param pulumi.Input[_builtins.str] carrier: Operator, required for regional scheduling. Optional values:
               - cmcc (mobile)
               - unicom
               - telecom
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: Data disk specifications See `data_disk` below.
        :param pulumi.Input[_builtins.str] ens_region_id: The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        :param pulumi.Input[_builtins.str] force_stop: Whether to force the identity when operating the instance. Optional values:
               - true: Force
               - false (default): non-mandatory
        :param pulumi.Input[_builtins.str] host_name: The host name of the instance. Example value: test-HostName
        :param pulumi.Input[_builtins.str] image_id: The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether the Payment type of the disk created with the instance is converted.
        :param pulumi.Input[_builtins.str] instance_charge_strategy: The instance billing policy. Optional values:
               - instance: instance granularity (the subscription method does not support instance)
               - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        :param pulumi.Input[_builtins.str] instance_name: The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)
               
               The default value is the InstanceId of the instance.
        :param pulumi.Input[_builtins.str] instance_type: The specification of the instance. Example value: ens.sn1.small
        :param pulumi.Input[_builtins.str] internet_charge_type: Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
               - BandwidthByDay: Daily peak bandwidth
               - 95bandwidthbymonth: 95 peak bandwidth
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        :param pulumi.Input[_builtins.str] ip_type: The IP type. Value:
               - ipv4 (default):IPv4
               - ipv6:IPv6
               - ipv4Andipv6:IPv4 and IPv6
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name.
               
               > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        :param pulumi.Input[_builtins.str] net_district_code: The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        :param pulumi.Input[_builtins.str] net_work_id: The network ID of the instance. Can only be used in node-level scheduling
        :param pulumi.Input[_builtins.str] password: The instance password. At least one of Password, KeyPairName, and PasswordInherit
        :param pulumi.Input[_builtins.bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        :param pulumi.Input[_builtins.str] payment_type: Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
               - Subscription: prepaid, annual and monthly
               - PayAsYouGo: Pay by volume
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. Value method:
               - If PeriodUnit is set to Day, Period can only be set to 3.
               - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources. Value:
               - Month (default): purchase by Month
               - Day: buy by Day
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        :param pulumi.Input[_builtins.bool] public_ip_identification: Whether to assign a public IP identifier. Value:
               - true (default): Assign
               - false: do not assign
        :param pulumi.Input[_builtins.str] schedule_area_level: Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
               - Node-level scheduling: Region
               - Regional scheduling: Big (region),Middle (province),Small (city)
        :param pulumi.Input[_builtins.str] scheduling_price_strategy: Scheduling price policy. If it is not filled in, the default priority is low price. Value:
               - PriceLowPriority
               - PriceLowPriority (priority low price)
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling policy. Optional values:
               - Concentrate for node-level scheduling
               - For regional scheduling, Concentrate, Disperse
        :param pulumi.Input[_builtins.str] security_id: ID of the security group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
               - NoSpot: normal pay-as-you-go instance (default)
               - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        :param pulumi.Input[_builtins.str] status: Status of the instance
        :param pulumi.Input[Union['InstanceSystemDiskArgs', 'InstanceSystemDiskArgsDict']] system_disk: System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag bound to the instance
        :param pulumi.Input[_builtins.bool] unique_suffix: Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        :param pulumi.Input[_builtins.str] user_data: User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Ens Instance can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:ens/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_use_coupon: Optional[pulumi.Input[_builtins.str]] = None,
                 billing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
                 carrier: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_stop: Optional[pulumi.Input[_builtins.str]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_district_code: Optional[pulumi.Input[_builtins.str]] = None,
                 net_work_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_identification: Optional[pulumi.Input[_builtins.bool]] = None,
                 schedule_area_level: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_id: Optional[pulumi.Input[_builtins.str]] = None,
                 spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk: Optional[pulumi.Input[Union['InstanceSystemDiskArgs', 'InstanceSystemDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["amount"] = amount
            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_use_coupon"] = auto_use_coupon
            __props__.__dict__["billing_cycle"] = billing_cycle
            __props__.__dict__["carrier"] = carrier
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["ens_region_id"] = ens_region_id
            __props__.__dict__["force_stop"] = force_stop
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["include_data_disks"] = include_data_disks
            __props__.__dict__["instance_charge_strategy"] = instance_charge_strategy
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["ip_type"] = ip_type
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["net_district_code"] = net_district_code
            __props__.__dict__["net_work_id"] = net_work_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_inherit"] = password_inherit
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["public_ip_identification"] = public_ip_identification
            if schedule_area_level is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_area_level'")
            __props__.__dict__["schedule_area_level"] = schedule_area_level
            __props__.__dict__["scheduling_price_strategy"] = scheduling_price_strategy
            __props__.__dict__["scheduling_strategy"] = scheduling_strategy
            __props__.__dict__["security_id"] = security_id
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["status"] = status
            __props__.__dict__["system_disk"] = system_disk
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unique_suffix"] = unique_suffix
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["vswitch_id"] = vswitch_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:ens/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[_builtins.int]] = None,
            auto_release_time: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_use_coupon: Optional[pulumi.Input[_builtins.str]] = None,
            billing_cycle: Optional[pulumi.Input[_builtins.str]] = None,
            carrier: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
            ens_region_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_stop: Optional[pulumi.Input[_builtins.str]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            include_data_disks: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[_builtins.int]] = None,
            ip_type: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair_name: Optional[pulumi.Input[_builtins.str]] = None,
            net_district_code: Optional[pulumi.Input[_builtins.str]] = None,
            net_work_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            password_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_identification: Optional[pulumi.Input[_builtins.bool]] = None,
            schedule_area_level: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling_price_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            scheduling_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            security_id: Optional[pulumi.Input[_builtins.str]] = None,
            spot_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk: Optional[pulumi.Input[Union['InstanceSystemDiskArgs', 'InstanceSystemDiskArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            unique_suffix: Optional[pulumi.Input[_builtins.bool]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] amount: The number of instances created, with a minimum of 1 and a maximum of 100
        :param pulumi.Input[_builtins.str] auto_release_time: The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
               - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
               - The minimum release time is one hour after the current time.
        :param pulumi.Input[_builtins.bool] auto_renew: Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        :param pulumi.Input[_builtins.str] auto_use_coupon: Whether to use vouchers. The default is to use. Value:
               - true (used)
               - false (not used)
        :param pulumi.Input[_builtins.str] billing_cycle: The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
               - Hour: hourly billing
               - Day: Daily billing
               - Month: monthly billing
        :param pulumi.Input[_builtins.str] carrier: Operator, required for regional scheduling. Optional values:
               - cmcc (mobile)
               - unicom
               - telecom
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: Data disk specifications See `data_disk` below.
        :param pulumi.Input[_builtins.str] ens_region_id: The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        :param pulumi.Input[_builtins.str] force_stop: Whether to force the identity when operating the instance. Optional values:
               - true: Force
               - false (default): non-mandatory
        :param pulumi.Input[_builtins.str] host_name: The host name of the instance. Example value: test-HostName
        :param pulumi.Input[_builtins.str] image_id: The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        :param pulumi.Input[_builtins.bool] include_data_disks: Whether the Payment type of the disk created with the instance is converted.
        :param pulumi.Input[_builtins.str] instance_charge_strategy: The instance billing policy. Optional values:
               - instance: instance granularity (the subscription method does not support instance)
               - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        :param pulumi.Input[_builtins.str] instance_name: The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)
               
               The default value is the InstanceId of the instance.
        :param pulumi.Input[_builtins.str] instance_type: The specification of the instance. Example value: ens.sn1.small
        :param pulumi.Input[_builtins.str] internet_charge_type: Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
               - BandwidthByDay: Daily peak bandwidth
               - 95bandwidthbymonth: 95 peak bandwidth
        :param pulumi.Input[_builtins.int] internet_max_bandwidth_out: Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        :param pulumi.Input[_builtins.str] ip_type: The IP type. Value:
               - ipv4 (default):IPv4
               - ipv6:IPv6
               - ipv4Andipv6:IPv4 and IPv6
        :param pulumi.Input[_builtins.str] key_pair_name: The key pair name.
               
               > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        :param pulumi.Input[_builtins.str] net_district_code: The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        :param pulumi.Input[_builtins.str] net_work_id: The network ID of the instance. Can only be used in node-level scheduling
        :param pulumi.Input[_builtins.str] password: The instance password. At least one of Password, KeyPairName, and PasswordInherit
        :param pulumi.Input[_builtins.bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        :param pulumi.Input[_builtins.str] payment_type: Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
               - Subscription: prepaid, annual and monthly
               - PayAsYouGo: Pay by volume
        :param pulumi.Input[_builtins.int] period: The duration of the resource purchase. Value method:
               - If PeriodUnit is set to Day, Period can only be set to 3.
               - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        :param pulumi.Input[_builtins.str] period_unit: The unit of time for purchasing resources. Value:
               - Month (default): purchase by Month
               - Day: buy by Day
        :param pulumi.Input[_builtins.str] private_ip_address: The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        :param pulumi.Input[_builtins.bool] public_ip_identification: Whether to assign a public IP identifier. Value:
               - true (default): Assign
               - false: do not assign
        :param pulumi.Input[_builtins.str] schedule_area_level: Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
               - Node-level scheduling: Region
               - Regional scheduling: Big (region),Middle (province),Small (city)
        :param pulumi.Input[_builtins.str] scheduling_price_strategy: Scheduling price policy. If it is not filled in, the default priority is low price. Value:
               - PriceLowPriority
               - PriceLowPriority (priority low price)
        :param pulumi.Input[_builtins.str] scheduling_strategy: Scheduling policy. Optional values:
               - Concentrate for node-level scheduling
               - For regional scheduling, Concentrate, Disperse
        :param pulumi.Input[_builtins.str] security_id: ID of the security group to which the instance belongs.
        :param pulumi.Input[_builtins.str] spot_strategy: The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
               - NoSpot: normal pay-as-you-go instance (default)
               - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        :param pulumi.Input[_builtins.str] status: Status of the instance
        :param pulumi.Input[Union['InstanceSystemDiskArgs', 'InstanceSystemDiskArgsDict']] system_disk: System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tag bound to the instance
        :param pulumi.Input[_builtins.bool] unique_suffix: Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        :param pulumi.Input[_builtins.str] user_data: User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        :param pulumi.Input[_builtins.str] vswitch_id: The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_use_coupon"] = auto_use_coupon
        __props__.__dict__["billing_cycle"] = billing_cycle
        __props__.__dict__["carrier"] = carrier
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["force_stop"] = force_stop
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["include_data_disks"] = include_data_disks
        __props__.__dict__["instance_charge_strategy"] = instance_charge_strategy
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["ip_type"] = ip_type
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["net_district_code"] = net_district_code
        __props__.__dict__["net_work_id"] = net_work_id
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["public_ip_identification"] = public_ip_identification
        __props__.__dict__["schedule_area_level"] = schedule_area_level
        __props__.__dict__["scheduling_price_strategy"] = scheduling_price_strategy
        __props__.__dict__["scheduling_strategy"] = scheduling_strategy
        __props__.__dict__["security_id"] = security_id
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["status"] = status
        __props__.__dict__["system_disk"] = system_disk
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unique_suffix"] = unique_suffix
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def amount(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of instances created, with a minimum of 1 and a maximum of 100
        """
        return pulumi.get(self, "amount")

    @_builtins.property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The automatic release time of the pay-as-you-go instance. According to the [ISO 8601] standard, UTC +0 time is used. The format is: 'yyyy-MM-ddTHH:mm:ssZ '.
        - If the second ('ss') value is not '00', it is automatically taken as the start of the current minute ('mm').
        - The minimum release time is one hour after the current time.
        """
        return pulumi.get(self, "auto_release_time")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoUseCoupon")
    def auto_use_coupon(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to use vouchers. The default is to use. Value:
        - true (used)
        - false (not used)
        """
        return pulumi.get(self, "auto_use_coupon")

    @_builtins.property
    @pulumi.getter(name="billingCycle")
    def billing_cycle(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
        - Hour: hourly billing
        - Day: Daily billing
        - Month: monthly billing
        """
        return pulumi.get(self, "billing_cycle")

    @_builtins.property
    @pulumi.getter
    def carrier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Operator, required for regional scheduling. Optional values:
        - cmcc (mobile)
        - unicom
        - telecom
        """
        return pulumi.get(self, "carrier")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Sequence['outputs.InstanceDataDisk']]:
        """
        Data disk specifications See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
        """
        return pulumi.get(self, "ens_region_id")

    @_builtins.property
    @pulumi.getter(name="forceStop")
    def force_stop(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether to force the identity when operating the instance. Optional values:
        - true: Force
        - false (default): non-mandatory
        """
        return pulumi.get(self, "force_stop")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[_builtins.str]:
        """
        The host name of the instance. Example value: test-HostName
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="includeDataDisks")
    def include_data_disks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Payment type of the disk created with the instance is converted.
        """
        return pulumi.get(self, "include_data_disks")

    @_builtins.property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance billing policy. Optional values:
        - instance: instance granularity (the subscription method does not support instance)
        - user: user Dimension (user is not transmitted or supported in the prepaid mode)
        """
        return pulumi.get(self, "instance_charge_strategy")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-)

        The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the instance. Example value: ens.sn1.small
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
        - BandwidthByDay: Daily peak bandwidth
        - 95bandwidthbymonth: 95 peak bandwidth
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @_builtins.property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IP type. Value:
        - ipv4 (default):IPv4
        - ipv6:IPv6
        - ipv4Andipv6:IPv4 and IPv6
        """
        return pulumi.get(self, "ip_type")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key pair name.

        > **NOTE:**  At least one of `Password`, `KeyPairName`, and **PasswordInherit.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling
        """
        return pulumi.get(self, "net_district_code")

    @_builtins.property
    @pulumi.getter(name="netWorkId")
    def net_work_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network ID of the instance. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "net_work_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance password. At least one of Password, KeyPairName, and PasswordInherit
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed
        """
        return pulumi.get(self, "password_inherit")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance payment method. Since v1.230.0, you can modify payment_type. Optional values:
        - Subscription: prepaid, annual and monthly
        - PayAsYouGo: Pay by volume
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration of the resource purchase. Value method:
        - If PeriodUnit is set to Day, Period can only be set to 3.
        - If PeriodUnit is set to Month, Period can be set to 1-9,12.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unit of time for purchasing resources. Value:
        - Month (default): purchase by Month
        - Day: buy by Day
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to assign a public IP identifier. Value:
        - true (default): Assign
        - false: do not assign
        """
        return pulumi.get(self, "public_ip_identification")

    @_builtins.property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> pulumi.Output[_builtins.str]:
        """
        Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
        - Node-level scheduling: Region
        - Regional scheduling: Big (region),Middle (province),Small (city)
        """
        return pulumi.get(self, "schedule_area_level")

    @_builtins.property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scheduling price policy. If it is not filled in, the default priority is low price. Value:
        - PriceLowPriority
        - PriceLowPriority (priority low price)
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @_builtins.property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scheduling policy. Optional values:
        - Concentrate for node-level scheduling
        - For regional scheduling, Concentrate, Disperse
        """
        return pulumi.get(self, "scheduling_strategy")

    @_builtins.property
    @pulumi.getter(name="securityId")
    def security_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the security group to which the instance belongs.
        """
        return pulumi.get(self, "security_id")

    @_builtins.property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The bidding strategy for pay-as-you-go instances. It takes effect when the value of the 'InstanceChargeType' parameter is set to 'PostPaid. Value range:
        - NoSpot: normal pay-as-you-go instance (default)
        - SpotAsPriceGo: The system automatically bids, following the actual price in the current market.
        """
        return pulumi.get(self, "spot_strategy")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the instance
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Output[Optional['outputs.InstanceSystemDisk']]:
        """
        System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tag bound to the instance
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
        """
        return pulumi.get(self, "unique_suffix")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling
        """
        return pulumi.get(self, "vswitch_id")

