# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceDataDisk',
    'InstanceSystemDisk',
    'LoadBalancerBackendServer',
    'GetKeyPairsPairResult',
]

@pulumi.output_type
class InstanceDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskId":
            suggest = "disk_id"
        elif key == "encryptKeyId":
            suggest = "encrypt_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[_builtins.str] = None,
                 disk_id: Optional[_builtins.str] = None,
                 encrypt_key_id: Optional[_builtins.str] = None,
                 encrypted: Optional[_builtins.bool] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str category: Data disk type. Optional values:
               - cloud_efficiency: Ultra cloud disk
               - cloud_ssd: Full Flash cloud disk
               - local_hdd: local hdd disk
               - local_ssd: local disk ssd.
        :param _builtins.str disk_id: Cloud Disk ID.
        :param _builtins.str encrypt_key_id: The ID of the KMS key used by the cloud disk.
        :param _builtins.bool encrypted: Whether to encrypt the cloud disk. Value range:  true: Yes  false (default): No.
        :param _builtins.int size: Data disk size, unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if encrypt_key_id is not None:
            pulumi.set(__self__, "encrypt_key_id", encrypt_key_id)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        Data disk type. Optional values:
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[_builtins.str]:
        """
        Cloud Disk ID.
        """
        return pulumi.get(self, "disk_id")

    @_builtins.property
    @pulumi.getter(name="encryptKeyId")
    def encrypt_key_id(self) -> Optional[_builtins.str]:
        """
        The ID of the KMS key used by the cloud disk.
        """
        return pulumi.get(self, "encrypt_key_id")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether to encrypt the cloud disk. Value range:  true: Yes  false (default): No.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Data disk size, unit: GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class InstanceSystemDisk(dict):
    def __init__(__self__, *,
                 category: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str category: System disk type. Value
               - cloud_efficiency: Ultra cloud disk
               - cloud_ssd: Full Flash cloud disk
               - local_hdd: local hdd disk
               - local_ssd: local disk ssd.
        :param _builtins.int size: System disk size, unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[_builtins.str]:
        """
        System disk type. Value
        - cloud_efficiency: Ultra cloud disk
        - cloud_ssd: Full Flash cloud disk
        - local_hdd: local hdd disk
        - local_ssd: local disk ssd.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        System disk size, unit: GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class LoadBalancerBackendServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerBackendServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerBackendServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerBackendServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_id: _builtins.str,
                 ip: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str server_id: Backend server instance ID  Example value: i-5vb5h5njxiuhn48a * * * *.
        :param _builtins.str ip: IP address of the backend server  Example value: 192.168.0.5.
        :param _builtins.int port: Port used by the backend server.
        :param _builtins.str type: Backend server type  Example value: ens.
        :param _builtins.int weight: Weight of the backend server  Example value: 100.
        """
        pulumi.set(__self__, "server_id", server_id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> _builtins.str:
        """
        Backend server instance ID  Example value: i-5vb5h5njxiuhn48a * * * *.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP address of the backend server  Example value: 192.168.0.5.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port used by the backend server.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Backend server type  Example value: ens.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight of the backend server  Example value: 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetKeyPairsPairResult(dict):
    def __init__(__self__, *,
                 create_time: _builtins.str,
                 id: _builtins.str,
                 key_pair_finger_print: _builtins.str,
                 key_pair_name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str create_time: The creation time of the key pair. The date format is in accordance with ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param _builtins.str id: The ID of the Key Pair.
        :param _builtins.str key_pair_finger_print: Fingerprint of the key pair.
        :param _builtins.str key_pair_name: The name of the key pair.
        :param _builtins.str version: The version number.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_pair_finger_print", key_pair_finger_print)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        The creation time of the key pair. The date format is in accordance with ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Key Pair.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyPairFingerPrint")
    def key_pair_finger_print(self) -> _builtins.str:
        """
        Fingerprint of the key pair.
        """
        return pulumi.get(self, "key_pair_finger_print")

    @_builtins.property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> _builtins.str:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version number.
        """
        return pulumi.get(self, "version")


