# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OriginClientCertificateArgs', 'OriginClientCertificate']

@pulumi.input_type
class OriginClientCertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 site_id: pulumi.Input[_builtins.int],
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_client_certificate_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OriginClientCertificate resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate content.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: The domain names to associate.
        :param pulumi.Input[_builtins.str] origin_client_certificate_name: The certificate name.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "site_id", site_id)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if origin_client_certificate_name is not None:
            pulumi.set(__self__, "origin_client_certificate_name", origin_client_certificate_name)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The domain names to associate.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter(name="originClientCertificateName")
    def origin_client_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "origin_client_certificate_name")

    @origin_client_certificate_name.setter
    def origin_client_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_client_certificate_name", value)


@pulumi.input_type
class _OriginClientCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_client_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_client_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OriginClientCertificate resources.
        :param pulumi.Input[_builtins.str] certificate: The certificate content.
        :param pulumi.Input[_builtins.str] create_time: The time when the certificate was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: The domain names to associate.
        :param pulumi.Input[_builtins.str] origin_client_certificate_id: The certificate ID.
        :param pulumi.Input[_builtins.str] origin_client_certificate_name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] status: The status of the certificate.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if origin_client_certificate_id is not None:
            pulumi.set(__self__, "origin_client_certificate_id", origin_client_certificate_id)
        if origin_client_certificate_name is not None:
            pulumi.set(__self__, "origin_client_certificate_name", origin_client_certificate_name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The domain names to associate.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hostnames", value)

    @_builtins.property
    @pulumi.getter(name="originClientCertificateId")
    def origin_client_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate ID.
        """
        return pulumi.get(self, "origin_client_certificate_id")

    @origin_client_certificate_id.setter
    def origin_client_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_client_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="originClientCertificateName")
    def origin_client_certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "origin_client_certificate_name")

    @origin_client_certificate_name.setter
    def origin_client_certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_client_certificate_name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "site_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("alicloud:esa/originClientCertificate:OriginClientCertificate")
class OriginClientCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_client_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a ESA Origin Client Certificate resource.

        For information about ESA Origin Client Certificate and how to use it, see [What is Origin Client Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/UploadOriginClientCertificate).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        resource_site_origin_client_certificate_example = alicloud.esa.Site("resource_Site_OriginClientCertificate_example",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_client_certificate = alicloud.esa.OriginClientCertificate("default",
            site_id=resource_site_origin_client_certificate_example.id,
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQC+7dgpkQifIqzOU6KNkFRjZtMZOoN7/ihNf/BrYcPhLQSkcPOf
        UsTP/qvH0u965GnYFiAoK3uWGQo9aCBuoawRFKNBa9ZpJVyVbamBWTBQ/Fxsforq
        9jJNR7OWA3fxvDxgwyEkv0qsnh1zaOkjyUlxFYwDiFxZ1/RHAj/SABCubQIDAQAB
        AoGADiobBUprN1MdOtldj98LQ6yXMKH0qzg5yTYaofzIyWXLmF+A02sSitO77sEp
        Xxae+5b4n8JKEuKcrd2RumNoHmN47iLQ0M2eodjUQ96kzm5Esq6nln62/NF5KLuK
        JDw63nTsg6K0O+gQZv4SYjZAL3cswSmeQmvmcoNgArfcaoECQQDgYy6S91ZIUsLx
        6BB3tW+x7APYnvKysYbcKUEP8AutZSo4hdMfPQkOD0LwP5dWsrNippDWjNDiPZmt
        VKuZDoDdAkEA2dPxy1eQeJsRYTZmTWIuh3UY9xlL3G9skcSOM4LbFidroHWW9UDJ
        JDSSEMH2+/4quYTdPr28cj7RCjqL0brC0QJABXDCL1QJ5oUDLwRWaeCfTawQR89K
        ySRexbXGWxGR5uleBbLQ9J/xOUMLd3HDRJnemZS6TElrwyCFOlukMXjVjQJBALr5
        QC0opmu/vzVQepOl2QaQrrM7VXCLfAfLTbxNcD0d7TY4eTFfQMgBD/euZpB65LWF
        pFs8hcsSvGApTObjhmECQEydB1zzjU6kH171XlXCtRFnbORu2IB7rMsDP2CBPHyR
        tYBjBNVHIUGcmrMVFX4LeMuvvmUyzwfgLmLchHxbDP8=
        -----END RSA PRIVATE KEY-----
        \"\"\",
            hostnames=[
                "www.example1.com",
                "www.example2.com",
                "www.example3.com",
            ],
            origin_client_certificate_name="exampleCertificate",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIICQTCCAaoCCQCFfdyqahygLzANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJj
        bjEQMA4GA1UECAwHYmVpamluZzEQMA4GA1UEBwwHYmVpamluZzERMA8GA1UECgwI
        YWxpY2xvdWQxEDAOBgNVBAsMB2FsaWJhYmExDTALBgNVBAMMBHRlc3QwHhcNMjAw
        ODA2MTAwMDAyWhcNMzAwODA0MTAwMDAyWjBlMQswCQYDVQQGEwJjbjEQMA4GA1UE
        CAwHYmVpamluZzEQMA4GA1UEBwwHYmVpamluZzERMA8GA1UECgwIYWxpY2xvdWQx
        EDAOBgNVBAsMB2FsaWJhYmExDTALBgNVBAMMBHRlc3QwgZ8wDQYJKoZIhvcNAQEB
        BQADgY0AMIGJAoGBAL7t2CmRCJ8irM5Too2QVGNm0xk6g3v+KE1/8Gthw+EtBKRw
        859SxM/+q8fS73rkadgWICgre5YZCj1oIG6hrBEUo0Fr1mklXJVtqYFZMFD8XGx+
        iur2Mk1Hs5YDd/G8PGDDISS/SqyeHXNo6SPJSXEVjAOIXFnX9EcCP9IAEK5tAgMB
        AAEwDQYJKoZIhvcNAQEFBQADgYEAavYdM9s5jLFP9/ZPCrsRuRsjSJpe5y9VZL+1
        +Ebbw16V0xMYaqODyFH1meLRW/A4xUs15Ny2vLYOW15Mriif7Sixty3HUedBFa4l
        y6/gQ+mBEeZYzMaTTFgyzEZDMsfZxwV9GKfhOzAmK3jZ2LDpHIhnlJN4WwVf0lME
        pCPDN7g=
        -----END CERTIFICATE-----
        \"\"\")
        ```

        ## Import

        ESA Origin Client Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originClientCertificate:OriginClientCertificate example <site_id>:<origin_client_certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate content.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: The domain names to associate.
        :param pulumi.Input[_builtins.str] origin_client_certificate_name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OriginClientCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESA Origin Client Certificate resource.

        For information about ESA Origin Client Certificate and how to use it, see [What is Origin Client Certificate](https://next.api.alibabacloud.com/document/ESA/2024-09-10/UploadOriginClientCertificate).

        > **NOTE:** Available since v1.255.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.esa.get_sites(plan_subscribe_type="enterpriseplan")
        resource_site_origin_client_certificate_example = alicloud.esa.Site("resource_Site_OriginClientCertificate_example",
            site_name="chenxin0116.site",
            instance_id=default.sites[0].instance_id,
            coverage="overseas",
            access_type="NS")
        default_origin_client_certificate = alicloud.esa.OriginClientCertificate("default",
            site_id=resource_site_origin_client_certificate_example.id,
            private_key=\"\"\"-----BEGIN RSA PRIVATE KEY-----
        MIICXAIBAAKBgQC+7dgpkQifIqzOU6KNkFRjZtMZOoN7/ihNf/BrYcPhLQSkcPOf
        UsTP/qvH0u965GnYFiAoK3uWGQo9aCBuoawRFKNBa9ZpJVyVbamBWTBQ/Fxsforq
        9jJNR7OWA3fxvDxgwyEkv0qsnh1zaOkjyUlxFYwDiFxZ1/RHAj/SABCubQIDAQAB
        AoGADiobBUprN1MdOtldj98LQ6yXMKH0qzg5yTYaofzIyWXLmF+A02sSitO77sEp
        Xxae+5b4n8JKEuKcrd2RumNoHmN47iLQ0M2eodjUQ96kzm5Esq6nln62/NF5KLuK
        JDw63nTsg6K0O+gQZv4SYjZAL3cswSmeQmvmcoNgArfcaoECQQDgYy6S91ZIUsLx
        6BB3tW+x7APYnvKysYbcKUEP8AutZSo4hdMfPQkOD0LwP5dWsrNippDWjNDiPZmt
        VKuZDoDdAkEA2dPxy1eQeJsRYTZmTWIuh3UY9xlL3G9skcSOM4LbFidroHWW9UDJ
        JDSSEMH2+/4quYTdPr28cj7RCjqL0brC0QJABXDCL1QJ5oUDLwRWaeCfTawQR89K
        ySRexbXGWxGR5uleBbLQ9J/xOUMLd3HDRJnemZS6TElrwyCFOlukMXjVjQJBALr5
        QC0opmu/vzVQepOl2QaQrrM7VXCLfAfLTbxNcD0d7TY4eTFfQMgBD/euZpB65LWF
        pFs8hcsSvGApTObjhmECQEydB1zzjU6kH171XlXCtRFnbORu2IB7rMsDP2CBPHyR
        tYBjBNVHIUGcmrMVFX4LeMuvvmUyzwfgLmLchHxbDP8=
        -----END RSA PRIVATE KEY-----
        \"\"\",
            hostnames=[
                "www.example1.com",
                "www.example2.com",
                "www.example3.com",
            ],
            origin_client_certificate_name="exampleCertificate",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIICQTCCAaoCCQCFfdyqahygLzANBgkqhkiG9w0BAQUFADBlMQswCQYDVQQGEwJj
        bjEQMA4GA1UECAwHYmVpamluZzEQMA4GA1UEBwwHYmVpamluZzERMA8GA1UECgwI
        YWxpY2xvdWQxEDAOBgNVBAsMB2FsaWJhYmExDTALBgNVBAMMBHRlc3QwHhcNMjAw
        ODA2MTAwMDAyWhcNMzAwODA0MTAwMDAyWjBlMQswCQYDVQQGEwJjbjEQMA4GA1UE
        CAwHYmVpamluZzEQMA4GA1UEBwwHYmVpamluZzERMA8GA1UECgwIYWxpY2xvdWQx
        EDAOBgNVBAsMB2FsaWJhYmExDTALBgNVBAMMBHRlc3QwgZ8wDQYJKoZIhvcNAQEB
        BQADgY0AMIGJAoGBAL7t2CmRCJ8irM5Too2QVGNm0xk6g3v+KE1/8Gthw+EtBKRw
        859SxM/+q8fS73rkadgWICgre5YZCj1oIG6hrBEUo0Fr1mklXJVtqYFZMFD8XGx+
        iur2Mk1Hs5YDd/G8PGDDISS/SqyeHXNo6SPJSXEVjAOIXFnX9EcCP9IAEK5tAgMB
        AAEwDQYJKoZIhvcNAQEFBQADgYEAavYdM9s5jLFP9/ZPCrsRuRsjSJpe5y9VZL+1
        +Ebbw16V0xMYaqODyFH1meLRW/A4xUs15Ny2vLYOW15Mriif7Sixty3HUedBFa4l
        y6/gQ+mBEeZYzMaTTFgyzEZDMsfZxwV9GKfhOzAmK3jZ2LDpHIhnlJN4WwVf0lME
        pCPDN7g=
        -----END CERTIFICATE-----
        \"\"\")
        ```

        ## Import

        ESA Origin Client Certificate can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:esa/originClientCertificate:OriginClientCertificate example <site_id>:<origin_client_certificate_id>
        ```

        :param str resource_name: The name of the resource.
        :param OriginClientCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OriginClientCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 origin_client_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OriginClientCertificateArgs.__new__(OriginClientCertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["hostnames"] = hostnames
            __props__.__dict__["origin_client_certificate_name"] = origin_client_certificate_name
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["origin_client_certificate_id"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(OriginClientCertificate, __self__).__init__(
            'alicloud:esa/originClientCertificate:OriginClientCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            origin_client_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            origin_client_certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            site_id: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'OriginClientCertificate':
        """
        Get an existing OriginClientCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate content.
        :param pulumi.Input[_builtins.str] create_time: The time when the certificate was created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hostnames: The domain names to associate.
        :param pulumi.Input[_builtins.str] origin_client_certificate_id: The certificate ID.
        :param pulumi.Input[_builtins.str] origin_client_certificate_name: The certificate name.
        :param pulumi.Input[_builtins.str] private_key: The private key of the certificate.
        :param pulumi.Input[_builtins.int] site_id: Site ID.
        :param pulumi.Input[_builtins.str] status: The status of the certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OriginClientCertificateState.__new__(_OriginClientCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["origin_client_certificate_id"] = origin_client_certificate_id
        __props__.__dict__["origin_client_certificate_name"] = origin_client_certificate_name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["status"] = status
        return OriginClientCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate content.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The domain names to associate.
        """
        return pulumi.get(self, "hostnames")

    @_builtins.property
    @pulumi.getter(name="originClientCertificateId")
    def origin_client_certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate ID.
        """
        return pulumi.get(self, "origin_client_certificate_id")

    @_builtins.property
    @pulumi.getter(name="originClientCertificateName")
    def origin_client_certificate_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The certificate name.
        """
        return pulumi.get(self, "origin_client_certificate_name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The private key of the certificate.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[_builtins.int]:
        """
        Site ID.
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the certificate.
        """
        return pulumi.get(self, "status")

