# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'HttpRequestHeaderModificationRuleRequestHeaderModification',
    'HttpResponseHeaderModificationRuleResponseHeaderModification',
    'OriginPoolOrigin',
    'OriginPoolOriginAuthConf',
    'RecordAuthConf',
    'RecordData',
    'SiteDeliveryTaskHttpDelivery',
    'SiteDeliveryTaskHttpDeliveryStandardAuthParam',
    'SiteDeliveryTaskKafkaDelivery',
    'SiteDeliveryTaskOssDelivery',
    'SiteDeliveryTaskS3Delivery',
    'SiteDeliveryTaskSlsDelivery',
    'TransportLayerApplicationRule',
    'WaitingRoomHostNameAndPath',
    'GetSitesSiteResult',
]

@pulumi.output_type
class HttpRequestHeaderModificationRuleRequestHeaderModification(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operation: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Request Header Name.
        :param _builtins.str operation: Mode of operation. Value range:
        :param _builtins.str value: Request header value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation", operation)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Request Header Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        Mode of operation. Value range:
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Request header value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HttpResponseHeaderModificationRuleResponseHeaderModification(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operation: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The response header name.
        :param _builtins.str operation: Operation method. Possible values:
        :param _builtins.str value: The response header value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation", operation)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The response header name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        Operation method. Possible values:
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The response header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class OriginPoolOrigin(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authConf":
            suggest = "auth_conf"
        elif key == "originId":
            suggest = "origin_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginPoolOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginPoolOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginPoolOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 auth_conf: Optional['outputs.OriginPoolOriginAuthConf'] = None,
                 enabled: Optional[_builtins.bool] = None,
                 header: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 origin_id: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str address: Origin Address.
        :param 'OriginPoolOriginAuthConfArgs' auth_conf: The authentication information. When the source Station is an OSS or S3 and other source stations need to be authenticated, the authentication-related configuration information needs to be transmitted. See `auth_conf` below.
        :param _builtins.bool enabled: Whether the source station is enabled:
        :param _builtins.str header: The request header that is sent when returning to the source. Only Host is supported.
        :param _builtins.str name: Origin Name.
        :param _builtins.int origin_id: Origin ID.
        :param _builtins.str type: Source station type:
               ip_domain: ip or domain name type origin station;
               - `OSS`:OSS address source station;
               - `S3`:AWS S3 Source station.
        :param _builtins.int weight: Weight, 0-100.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_conf is not None:
            pulumi.set(__self__, "auth_conf", auth_conf)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        Origin Address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="authConf")
    def auth_conf(self) -> Optional['outputs.OriginPoolOriginAuthConf']:
        """
        The authentication information. When the source Station is an OSS or S3 and other source stations need to be authenticated, the authentication-related configuration information needs to be transmitted. See `auth_conf` below.
        """
        return pulumi.get(self, "auth_conf")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the source station is enabled:
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def header(self) -> Optional[_builtins.str]:
        """
        The request header that is sent when returning to the source. Only Host is supported.
        """
        return pulumi.get(self, "header")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Origin Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[_builtins.int]:
        """
        Origin ID.
        """
        return pulumi.get(self, "origin_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Source station type:
        ip_domain: ip or domain name type origin station;
        - `OSS`:OSS address source station;
        - `S3`:AWS S3 Source station.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight, 0-100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class OriginPoolOriginAuthConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginPoolOriginAuthConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginPoolOriginAuthConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginPoolOriginAuthConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: The AccessKey to be passed when AuthType is set to private_cross_account or private.
        :param _builtins.str auth_type: Authentication type.
        :param _builtins.str region: The Region of the source station to be transmitted when the source station is AWS S3.
        :param _builtins.str secret_key: The SecretKey to be passed when AuthType is set to private_cross_account or private.
        :param _builtins.str version: The signature version to be transmitted when the source station is AWS S3.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The AccessKey to be passed when AuthType is set to private_cross_account or private.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        Authentication type.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The Region of the source station to be transmitted when the source station is AWS S3.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The SecretKey to be passed when AuthType is set to private_cross_account or private.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The signature version to be transmitted when the source station is AWS S3.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecordAuthConf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "authType":
            suggest = "auth_type"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordAuthConf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordAuthConf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordAuthConf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 auth_type: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 secret_key: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str access_key: The access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        :param _builtins.str auth_type: The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, you must specify the authentication type of the origin. Valid values:
        :param _builtins.str region: The region of the origin. If the origin type is S3, you must specify this value. You can get the region information from the official website of S3.
        :param _builtins.str secret_key: The secret access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        :param _builtins.str version: The version of the signature algorithm. This parameter is required when the origin type is S3 and AuthType is private. The following two types are supported:
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        """
        The access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[_builtins.str]:
        """
        The authentication type of the origin server. Different origins support different authentication types. The type of origin refers to the SourceType parameter in this operation. If the type of origin is OSS or S3, you must specify the authentication type of the origin. Valid values:
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region of the origin. If the origin type is S3, you must specify this value. You can get the region information from the official website of S3.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        """
        The secret access key of the account to which the origin server belongs. This parameter is required when the SourceType is OSS, and AuthType is private_same_account, or when the SourceType is S3 and AuthType is private.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The version of the signature algorithm. This parameter is required when the origin type is S3 and AuthType is private. The following two types are supported:
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RecordData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyTag":
            suggest = "key_tag"
        elif key == "matchingType":
            suggest = "matching_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecordData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecordData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecordData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: Optional[_builtins.int] = None,
                 certificate: Optional[_builtins.str] = None,
                 fingerprint: Optional[_builtins.str] = None,
                 flag: Optional[_builtins.int] = None,
                 key_tag: Optional[_builtins.int] = None,
                 matching_type: Optional[_builtins.int] = None,
                 port: Optional[_builtins.int] = None,
                 priority: Optional[_builtins.int] = None,
                 selector: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None,
                 type: Optional[_builtins.int] = None,
                 usage: Optional[_builtins.int] = None,
                 value: Optional[_builtins.str] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.int algorithm: The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        :param _builtins.str certificate: The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        :param _builtins.str fingerprint: The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        :param _builtins.int flag: The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        :param _builtins.int key_tag: The public key identification for the record, specified within the range of 0 to 65,535. This parameter is required when you add a CAA record.
        :param _builtins.int matching_type: The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.int port: The port of the record, specified within the range of 0 to 65,535. This parameter is required when you add an SRV record.
        :param _builtins.int priority: The priority of the record, specified within the range of 0 to 65,535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        :param _builtins.int selector: The type of certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.str tag: The label of the record. The Tag of a CAA record indicate its specific type and usage. This parameter is required when you add a CAA record.
        :param _builtins.int type: The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        :param _builtins.int usage: The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        :param _builtins.str value: The record value or part of the record content. This parameter is required when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on different types of records:
               
               - **A/AAAA**: the IP address(es). Separate multiple IPs with commas (,). You must have at least one IPv4 address.
               - `CNAME`: the target domain name.
               - `NS`: the name servers for the domain name.
               - `MX`: a valid domain name of the target mail server.
               - `TXT`: a valid text string.
               - `CAA`: a valid domain name of the certificate authority.
               - `SRV`: a valid domain name of the target host.
               - `URI`: a valid URI string.
        :param _builtins.int weight: The weight of the record, specified within the range of 0 to 65,535. This parameter is required when you add SRV or URI records.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if flag is not None:
            pulumi.set(__self__, "flag", flag)
        if key_tag is not None:
            pulumi.set(__self__, "key_tag", key_tag)
        if matching_type is not None:
            pulumi.set(__self__, "matching_type", matching_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> Optional[_builtins.int]:
        """
        The encryption algorithm used for the record, specified within the range from 0 to 255. This parameter is required when you add CERT or SSHFP records.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[_builtins.str]:
        """
        The public key of the certificate. This parameter is required when you add CERT, SMIMEA, or TLSA records.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[_builtins.str]:
        """
        The public key fingerprint of the record. This parameter is required when you add a SSHFP record.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def flag(self) -> Optional[_builtins.int]:
        """
        The flag bit of the record. The Flag for a CAA record indicates its priority and how it is processed, specified within the range of 0 to 255. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "flag")

    @_builtins.property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> Optional[_builtins.int]:
        """
        The public key identification for the record, specified within the range of 0 to 65,535. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "key_tag")

    @_builtins.property
    @pulumi.getter(name="matchingType")
    def matching_type(self) -> Optional[_builtins.int]:
        """
        The algorithm policy used to match or validate the certificate, specified within the range 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "matching_type")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port of the record, specified within the range of 0 to 65,535. This parameter is required when you add an SRV record.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority of the record, specified within the range of 0 to 65,535. A smaller value indicates a higher priority. This parameter is required when you add MX, SRV, and URI records.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def selector(self) -> Optional[_builtins.int]:
        """
        The type of certificate or public key, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "selector")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        The label of the record. The Tag of a CAA record indicate its specific type and usage. This parameter is required when you add a CAA record.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.int]:
        """
        The certificate type of the record (in CERT records), or the public key type (in SSHFP records). This parameter is required when you add CERT or SSHFP records.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[_builtins.int]:
        """
        The usage identifier of the record, specified within the range of 0 to 255. This parameter is required when you add SMIMEA or TLSA records.
        """
        return pulumi.get(self, "usage")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The record value or part of the record content. This parameter is required when you add A/AAAA, CNAME, NS, MX, TXT, CAA, SRV, and URI records. It has different meanings based on different types of records:

        - **A/AAAA**: the IP address(es). Separate multiple IPs with commas (,). You must have at least one IPv4 address.
        - `CNAME`: the target domain name.
        - `NS`: the name servers for the domain name.
        - `MX`: a valid domain name of the target mail server.
        - `TXT`: a valid text string.
        - `CAA`: a valid domain name of the certificate authority.
        - `SRV`: a valid domain name of the target host.
        - `URI`: a valid URI string.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight of the record, specified within the range of 0 to 65,535. This parameter is required when you add SRV or URI records.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class SiteDeliveryTaskHttpDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destUrl":
            suggest = "dest_url"
        elif key == "headerParam":
            suggest = "header_param"
        elif key == "logBodyPrefix":
            suggest = "log_body_prefix"
        elif key == "logBodySuffix":
            suggest = "log_body_suffix"
        elif key == "maxBatchMb":
            suggest = "max_batch_mb"
        elif key == "maxBatchSize":
            suggest = "max_batch_size"
        elif key == "maxRetry":
            suggest = "max_retry"
        elif key == "queryParam":
            suggest = "query_param"
        elif key == "standardAuthOn":
            suggest = "standard_auth_on"
        elif key == "standardAuthParam":
            suggest = "standard_auth_param"
        elif key == "transformTimeout":
            suggest = "transform_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskHttpDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskHttpDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskHttpDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compress: Optional[_builtins.str] = None,
                 dest_url: Optional[_builtins.str] = None,
                 header_param: Optional[Mapping[str, _builtins.str]] = None,
                 log_body_prefix: Optional[_builtins.str] = None,
                 log_body_suffix: Optional[_builtins.str] = None,
                 max_batch_mb: Optional[_builtins.int] = None,
                 max_batch_size: Optional[_builtins.int] = None,
                 max_retry: Optional[_builtins.int] = None,
                 query_param: Optional[Mapping[str, _builtins.str]] = None,
                 standard_auth_on: Optional[_builtins.bool] = None,
                 standard_auth_param: Optional['outputs.SiteDeliveryTaskHttpDeliveryStandardAuthParam'] = None,
                 transform_timeout: Optional[_builtins.int] = None):
        """
        :param 'SiteDeliveryTaskHttpDeliveryStandardAuthParamArgs' standard_auth_param: See `standard_auth_param` below.
        """
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if dest_url is not None:
            pulumi.set(__self__, "dest_url", dest_url)
        if header_param is not None:
            pulumi.set(__self__, "header_param", header_param)
        if log_body_prefix is not None:
            pulumi.set(__self__, "log_body_prefix", log_body_prefix)
        if log_body_suffix is not None:
            pulumi.set(__self__, "log_body_suffix", log_body_suffix)
        if max_batch_mb is not None:
            pulumi.set(__self__, "max_batch_mb", max_batch_mb)
        if max_batch_size is not None:
            pulumi.set(__self__, "max_batch_size", max_batch_size)
        if max_retry is not None:
            pulumi.set(__self__, "max_retry", max_retry)
        if query_param is not None:
            pulumi.set(__self__, "query_param", query_param)
        if standard_auth_on is not None:
            pulumi.set(__self__, "standard_auth_on", standard_auth_on)
        if standard_auth_param is not None:
            pulumi.set(__self__, "standard_auth_param", standard_auth_param)
        if transform_timeout is not None:
            pulumi.set(__self__, "transform_timeout", transform_timeout)

    @_builtins.property
    @pulumi.getter
    def compress(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter(name="destUrl")
    def dest_url(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dest_url")

    @_builtins.property
    @pulumi.getter(name="headerParam")
    def header_param(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "header_param")

    @_builtins.property
    @pulumi.getter(name="logBodyPrefix")
    def log_body_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_body_prefix")

    @_builtins.property
    @pulumi.getter(name="logBodySuffix")
    def log_body_suffix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_body_suffix")

    @_builtins.property
    @pulumi.getter(name="maxBatchMb")
    def max_batch_mb(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_batch_mb")

    @_builtins.property
    @pulumi.getter(name="maxBatchSize")
    def max_batch_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_batch_size")

    @_builtins.property
    @pulumi.getter(name="maxRetry")
    def max_retry(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "max_retry")

    @_builtins.property
    @pulumi.getter(name="queryParam")
    def query_param(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "query_param")

    @_builtins.property
    @pulumi.getter(name="standardAuthOn")
    def standard_auth_on(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "standard_auth_on")

    @_builtins.property
    @pulumi.getter(name="standardAuthParam")
    def standard_auth_param(self) -> Optional['outputs.SiteDeliveryTaskHttpDeliveryStandardAuthParam']:
        """
        See `standard_auth_param` below.
        """
        return pulumi.get(self, "standard_auth_param")

    @_builtins.property
    @pulumi.getter(name="transformTimeout")
    def transform_timeout(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "transform_timeout")


@pulumi.output_type
class SiteDeliveryTaskHttpDeliveryStandardAuthParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredTime":
            suggest = "expired_time"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "urlPath":
            suggest = "url_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskHttpDeliveryStandardAuthParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskHttpDeliveryStandardAuthParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskHttpDeliveryStandardAuthParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expired_time: Optional[_builtins.int] = None,
                 private_key: Optional[_builtins.str] = None,
                 url_path: Optional[_builtins.str] = None):
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "url_path")


@pulumi.output_type
class SiteDeliveryTaskKafkaDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machanismType":
            suggest = "machanism_type"
        elif key == "userAuth":
            suggest = "user_auth"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskKafkaDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskKafkaDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskKafkaDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 balancer: Optional[_builtins.str] = None,
                 brokers: Optional[Sequence[_builtins.str]] = None,
                 compress: Optional[_builtins.str] = None,
                 machanism_type: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 topic: Optional[_builtins.str] = None,
                 user_auth: Optional[_builtins.bool] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str compress: The compression method. By default, data is not compressed.
        """
        if balancer is not None:
            pulumi.set(__self__, "balancer", balancer)
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if compress is not None:
            pulumi.set(__self__, "compress", compress)
        if machanism_type is not None:
            pulumi.set(__self__, "machanism_type", machanism_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)
        if user_auth is not None:
            pulumi.set(__self__, "user_auth", user_auth)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def balancer(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "balancer")

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter
    def compress(self) -> Optional[_builtins.str]:
        """
        The compression method. By default, data is not compressed.
        """
        return pulumi.get(self, "compress")

    @_builtins.property
    @pulumi.getter(name="machanismType")
    def machanism_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "machanism_type")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "topic")

    @_builtins.property
    @pulumi.getter(name="userAuth")
    def user_auth(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "user_auth")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class SiteDeliveryTaskOssDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "prefixPath":
            suggest = "prefix_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskOssDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskOssDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskOssDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aliuid: Optional[_builtins.str] = None,
                 bucket_name: Optional[_builtins.str] = None,
                 prefix_path: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str region: The region ID of the service.
        """
        if aliuid is not None:
            pulumi.set(__self__, "aliuid", aliuid)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix_path is not None:
            pulumi.set(__self__, "prefix_path", prefix_path)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def aliuid(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "aliuid")

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="prefixPath")
    def prefix_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix_path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region ID of the service.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class SiteDeliveryTaskS3Delivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketPath":
            suggest = "bucket_path"
        elif key == "prefixPath":
            suggest = "prefix_path"
        elif key == "s3Cmpt":
            suggest = "s3_cmpt"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"
        elif key == "vertifyType":
            suggest = "vertify_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskS3Delivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskS3Delivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskS3Delivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[_builtins.str] = None,
                 bucket_path: Optional[_builtins.str] = None,
                 endpoint: Optional[_builtins.str] = None,
                 prefix_path: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 s3_cmpt: Optional[_builtins.bool] = None,
                 secret_key: Optional[_builtins.str] = None,
                 server_side_encryption: Optional[_builtins.bool] = None,
                 vertify_type: Optional[_builtins.str] = None):
        """
        :param _builtins.bool server_side_encryption: Server-side encryption
        :param _builtins.str vertify_type: Authentication Type
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if bucket_path is not None:
            pulumi.set(__self__, "bucket_path", bucket_path)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if prefix_path is not None:
            pulumi.set(__self__, "prefix_path", prefix_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if s3_cmpt is not None:
            pulumi.set(__self__, "s3_cmpt", s3_cmpt)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if vertify_type is not None:
            pulumi.set(__self__, "vertify_type", vertify_type)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="bucketPath")
    def bucket_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "bucket_path")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="prefixPath")
    def prefix_path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "prefix_path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="s3Cmpt")
    def s3_cmpt(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "s3_cmpt")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[_builtins.bool]:
        """
        Server-side encryption
        """
        return pulumi.get(self, "server_side_encryption")

    @_builtins.property
    @pulumi.getter(name="vertifyType")
    def vertify_type(self) -> Optional[_builtins.str]:
        """
        Authentication Type
        """
        return pulumi.get(self, "vertify_type")


@pulumi.output_type
class SiteDeliveryTaskSlsDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slsLogStore":
            suggest = "sls_log_store"
        elif key == "slsProject":
            suggest = "sls_project"
        elif key == "slsRegion":
            suggest = "sls_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SiteDeliveryTaskSlsDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SiteDeliveryTaskSlsDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SiteDeliveryTaskSlsDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sls_log_store: Optional[_builtins.str] = None,
                 sls_project: Optional[_builtins.str] = None,
                 sls_region: Optional[_builtins.str] = None):
        if sls_log_store is not None:
            pulumi.set(__self__, "sls_log_store", sls_log_store)
        if sls_project is not None:
            pulumi.set(__self__, "sls_project", sls_project)
        if sls_region is not None:
            pulumi.set(__self__, "sls_region", sls_region)

    @_builtins.property
    @pulumi.getter(name="slsLogStore")
    def sls_log_store(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_log_store")

    @_builtins.property
    @pulumi.getter(name="slsProject")
    def sls_project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_project")

    @_builtins.property
    @pulumi.getter(name="slsRegion")
    def sls_region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "sls_region")


@pulumi.output_type
class TransportLayerApplicationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientIpPassThroughMode":
            suggest = "client_ip_pass_through_mode"
        elif key == "edgePort":
            suggest = "edge_port"
        elif key == "sourcePort":
            suggest = "source_port"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "ruleId":
            suggest = "rule_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransportLayerApplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransportLayerApplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransportLayerApplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_ip_pass_through_mode: _builtins.str,
                 edge_port: _builtins.str,
                 protocol: _builtins.str,
                 source: _builtins.str,
                 source_port: _builtins.str,
                 source_type: _builtins.str,
                 comment: Optional[_builtins.str] = None,
                 rule_id: Optional[_builtins.int] = None):
        """
        :param _builtins.str client_ip_pass_through_mode: Client IP pass-through protocol, supporting:
        :param _builtins.str edge_port: Edge port. Supports:
               - A single port, such as 80.
               - Port range, such as 81-85, representing ports 81, 82, 83, 84, and 85.
               - Combination of ports and port ranges, separated by commas, such as 80,81-85,90, representing ports 80, 81, 82, 83, 84, 85, and 90.
               
               Edge ports within a single rule and between multiple rules must not overlap.
        :param _builtins.str protocol: Forwarding rule protocol, with values:
               - `TCP`: TCP protocol.
               - `UDP`: UDP protocol.
        :param _builtins.str source: Specific value of the origin, which needs to match the origin type.
        :param _builtins.str source_port: Source Port
        :param _builtins.str source_type: Origin type, supporting:
        :param _builtins.str comment: Comment information for the rule (optional).
        :param _builtins.int rule_id: Rule ID
        """
        pulumi.set(__self__, "client_ip_pass_through_mode", client_ip_pass_through_mode)
        pulumi.set(__self__, "edge_port", edge_port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_port", source_port)
        pulumi.set(__self__, "source_type", source_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="clientIpPassThroughMode")
    def client_ip_pass_through_mode(self) -> _builtins.str:
        """
        Client IP pass-through protocol, supporting:
        """
        return pulumi.get(self, "client_ip_pass_through_mode")

    @_builtins.property
    @pulumi.getter(name="edgePort")
    def edge_port(self) -> _builtins.str:
        """
        Edge port. Supports:
        - A single port, such as 80.
        - Port range, such as 81-85, representing ports 81, 82, 83, 84, and 85.
        - Combination of ports and port ranges, separated by commas, such as 80,81-85,90, representing ports 80, 81, 82, 83, 84, 85, and 90.

        Edge ports within a single rule and between multiple rules must not overlap.
        """
        return pulumi.get(self, "edge_port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Forwarding rule protocol, with values:
        - `TCP`: TCP protocol.
        - `UDP`: UDP protocol.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Specific value of the origin, which needs to match the origin type.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> _builtins.str:
        """
        Source Port
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> _builtins.str:
        """
        Origin type, supporting:
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[_builtins.str]:
        """
        Comment information for the rule (optional).
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[_builtins.int]:
        """
        Rule ID
        """
        return pulumi.get(self, "rule_id")


@pulumi.output_type
class WaitingRoomHostNameAndPath(dict):
    def __init__(__self__, *,
                 domain: _builtins.str,
                 path: _builtins.str,
                 subdomain: _builtins.str):
        """
        :param _builtins.str domain: The domain name.
        :param _builtins.str path: The path.
        :param _builtins.str subdomain: The subdomain.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "subdomain", subdomain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> _builtins.str:
        """
        The subdomain.
        """
        return pulumi.get(self, "subdomain")


@pulumi.output_type
class GetSitesSiteResult(dict):
    def __init__(__self__, *,
                 access_type: _builtins.str,
                 coverage: _builtins.str,
                 create_time: _builtins.str,
                 id: _builtins.int,
                 instance_id: _builtins.str,
                 modify_time: _builtins.str,
                 name_server_list: _builtins.str,
                 resource_group_id: _builtins.str,
                 site_id: _builtins.int,
                 site_name: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str access_type: Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
        :param _builtins.str coverage: Acceleration area
        :param _builtins.str create_time: Creation time
        :param _builtins.int id: The ID of the resource supplied above.
        :param _builtins.str instance_id: The ID of the associated package instance.
        :param _builtins.str modify_time: Modification time
        :param _builtins.str name_server_list: Site Resolution Name Server List
        :param _builtins.str resource_group_id: The ID of the resource group
        :param _builtins.int site_id: Site ID
        :param _builtins.str site_name: Site Name
        :param _builtins.str status: The status of the resource
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "coverage", coverage)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "name_server_list", name_server_list)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "site_name", site_name)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        Access type. Value:-**NS**: Managed access via NS.-**CNAME**: access through CNAME.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter
    def coverage(self) -> _builtins.str:
        """
        Acceleration area
        """
        return pulumi.get(self, "coverage")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation time
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the resource supplied above.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The ID of the associated package instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> _builtins.str:
        """
        Modification time
        """
        return pulumi.get(self, "modify_time")

    @_builtins.property
    @pulumi.getter(name="nameServerList")
    def name_server_list(self) -> _builtins.str:
        """
        Site Resolution Name Server List
        """
        return pulumi.get(self, "name_server_list")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> _builtins.str:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="siteId")
    def site_id(self) -> _builtins.int:
        """
        Site ID
        """
        return pulumi.get(self, "site_id")

    @_builtins.property
    @pulumi.getter(name="siteName")
    def site_name(self) -> _builtins.str:
        """
        Site Name
        """
        return pulumi.get(self, "site_name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


